/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.client;

import com.sap.engine.services.servlets_jsp.server.SBasic;
import java.io.OutputStream;

public class InternalOutputStream
extends OutputStream {
    public static final int BUFFER_SIZE = 4096;
    private byte[] buffer = null;
    private int ptr = 0;

    public void write(int i) {
        this.ensureBufferSize(1);
        this.buffer[this.ptr++] = (byte)i;
    }

    public void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) {
        this.ensureBufferSize(len);
        System.arraycopy(buf, off, this.buffer, this.ptr, len);
        this.ptr += len;
    }

    public byte[] getMessage() {
        return this.buffer;
    }

    public int size() {
        return this.ptr;
    }

    public void reset() {
        this.buffer = null;
        this.ptr = 0;
    }

    private void ensureBufferSize(int size) {
        int newBufferLength;
        byte[] tmp;
        if (this.buffer != null && this.buffer.length > this.ptr + size) {
            return;
        }
        int bufferLength = 4096;
        if (this.buffer != null) {
            bufferLength = this.buffer.length;
        }
        if ((tmp = SBasic.poolContext.get(newBufferLength = this.getNextBufferSize(size, bufferLength))) == null) {
            tmp = new byte[newBufferLength];
        }
        if (this.buffer != null) {
            System.arraycopy(this.buffer, 0, tmp, 0, this.ptr);
            SBasic.poolContext.release(this.buffer);
        }
        this.buffer = tmp;
    }

    private int getNextBufferSize(int size, int oldBuffer) {
        if (this.ptr + size - oldBuffer < 4096) {
            return oldBuffer + 4096;
        }
        return this.getNextBufferSize(size, oldBuffer + 4096);
    }
}

