/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.client;

import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.lib.CookieParser;
import com.sap.engine.services.httpserver.lib.EncodingUtils;
import com.sap.engine.services.httpserver.lib.HttpCookie;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.ResponseCodes;
import com.sap.engine.services.httpserver.lib.Responses;
import com.sap.engine.services.httpserver.lib.WebCookieConfig;
import com.sap.engine.services.httpserver.lib.headers.MimeHeaders;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.server.io.HttpInputStream;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIOException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalStateException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebMalformedURLException;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.engine.services.servlets_jsp.server.runtime.client.GzipResponseStream;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.client.PrintWriterImpl;
import com.sap.engine.services.servlets_jsp.server.runtime.client.SapHttpServletResponse;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ServletOutputStreamImpl;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;

public class HttpServletResponseFacade
implements SapHttpServletResponse {
    public static final String FORCE_ENCODING = "forceEncoding:";
    private HttpServletRequestFacade requestFacade;
    private ServletOutputStreamImpl output = new ServletOutputStreamImpl(this);
    private GzipResponseStream gzipResponseStream = null;
    ArrayObject cookies = null;
    MimeHeaders headers;
    private String characterEncoding;
    int status = 200;
    String statusSrc;
    private PrintWriterImpl printwriter = new PrintWriterImpl((OutputStream)((Object)this.output), this.output.getBufferSize());
    private PrintWriterImpl gzipprintwriter;
    private Locale locale = null;
    private ApplicationContext context;
    private boolean getOutputStream = false;
    private boolean getWriter = false;
    private boolean isIncluded = false;
    private String servletName = null;
    private boolean setSessionCookie = false;
    private boolean isClosed = false;
    private boolean sentError = false;
    private boolean isGZip = false;
    private int contentLength = -1;

    public HttpServletResponseFacade() throws IOException {
        this.createGZipOutputStream();
        this.gzipprintwriter = new PrintWriterImpl((OutputStream)((Object)this.gzipResponseStream), this.output.getBufferSize());
    }

    public HttpServletRequestFacade getServletRequest() {
        return this.requestFacade;
    }

    public HttpParameters getHttpParameters() {
        return this.requestFacade.getHttpParameters();
    }

    public ApplicationContext getServletContext() {
        return this.context;
    }

    public void init(MimeHeaders responseHeaders) {
        this.locale = Locale.getDefault();
        this.headers = responseHeaders;
        this.setStatus(200);
        this.contentLength = -1;
        this.printwriter.setContentLength(-1);
        this.gzipprintwriter.setContentLength(-1);
        if (this.getHttpParameters().getHttpProperties().getUseServerHeader()) {
            this.setHeader(HeaderNames.response_header_server_, SBasic.version);
        }
        if (Log.isTracing()) {
            this.traceDebug("init", "new request initialized");
        }
    }

    public void markClosed() {
        if (this.isGZip) {
            this.gzipResponseStream.markClosed();
        } else {
            this.output.markClosed();
        }
        if (Log.isTracing()) {
            this.traceDebug("markClosed", "");
        }
    }

    public void reset() {
        this.reset(false);
        if (Log.isTracing()) {
            this.trace("reset", "isIncluded = [" + this.isIncluded + "].");
        }
    }

    private void reset(boolean keepHeaders) {
        if (this.isCommitted()) {
            if (Log.isTracing()) {
                this.traceWarning("reset", "isCommitted true - throwing exception", true);
            }
            throw new WebIllegalStateException(WebIllegalStateException.Stream_is_already_commited);
        }
        if (this.isIncluded) {
            return;
        }
        if (!keepHeaders) {
            this.headers.clear();
        }
        this.status = 200;
        this.statusSrc = null;
        this.contentLength = -1;
        this.printwriter.setContentLength(-1);
        this.gzipprintwriter.setContentLength(-1);
        if (this.getWriter) {
            if (this.isGZip) {
                this.gzipprintwriter.reset();
            } else {
                this.printwriter.reset();
            }
        }
        this.output.reset();
        this.isIncluded = false;
        this.setSessionCookie = false;
        if (this.isGZip) {
            try {
                this.gzipResponseStream.clear();
            }
            catch (IOException t) {
                Log.getCategory(5).logError(Log.getLocation(5).getLocation(), "Can't clear the gzip stream.", t, this.getServletContext().getAliasName());
            }
        }
        this.sentError = false;
        this.setStatus(200);
        if (this.getHttpParameters().getHttpProperties().getUseServerHeader()) {
            this.setHeader(HeaderNames.response_header_server_, SBasic.version);
        }
    }

    public void resetInternal() {
        if (Log.isTracing()) {
            this.traceDebug("resetInternal", "response cleared");
        }
        this.requestFacade = null;
        this.cookies = null;
        this.headers = null;
        this.characterEncoding = null;
        this.status = 200;
        this.statusSrc = null;
        this.locale = null;
        this.context = null;
        this.getOutputStream = false;
        this.getWriter = false;
        this.printwriter.resetInternal();
        this.gzipprintwriter.resetInternal();
        this.output.reset();
        this.isIncluded = false;
        this.servletName = null;
        this.setSessionCookie = false;
        this.isClosed = false;
        this.sentError = false;
        this.isGZip = false;
        this.contentLength = -1;
    }

    public void setGZip() {
        this.isGZip = true;
        this.gzipResponseStream.init();
        if (Log.isTracing()) {
            this.tracePath("setGZip", "will use gzip stream");
        }
    }

    public boolean isGZip() {
        return this.isGZip;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public void setRequestContextFacade(HttpServletRequestFacade context) {
        this.requestFacade = context;
        this.output.init();
    }

    public void addCookie(Cookie cookie) {
        if (Log.isTracing()) {
            if (cookie == null) {
                this.trace("addCookie", "cookie = [" + cookie + "], isIncluded = [" + this.isIncluded + "]");
            } else {
                this.trace("addCookie", "cookie name = [" + cookie.getName() + "], cookie value = [" + cookie.getValue() + "], isIncluded = [" + this.isIncluded + "]");
            }
        }
        if (this.isIncluded) {
            return;
        }
        HttpCookie newCookie = new HttpCookie(cookie.getName(), cookie.getValue());
        newCookie.setComment(cookie.getComment());
        newCookie.setDomain(cookie.getDomain());
        newCookie.setMaxAge(cookie.getMaxAge());
        newCookie.setPath(cookie.getPath());
        newCookie.setSecure(cookie.getSecure());
        newCookie.setVersion(cookie.getVersion());
        this.addCookie(newCookie);
    }

    public void addCookie(HttpCookie cookie) {
        if (Log.isTracing()) {
            if (cookie == null) {
                this.trace("addCookie(internal)", "cookie = [" + cookie + "], isIncluded = [" + this.isIncluded + "]");
            } else {
                this.trace("addCookie(internal)", "cookie name = [" + cookie.getName() + "], cookie value = [" + cookie.getValue() + "], isIncluded = [" + this.isIncluded + "]");
            }
        }
        if (this.isIncluded) {
            return;
        }
        if (this.cookies == null) {
            this.cookies = new ArrayObject(4);
        }
        if (this.setSessionCookie) {
            this.cookies.add(this.cookies.size() - 1, (Object)cookie);
        } else {
            this.cookies.addElement((Object)cookie);
        }
    }

    public boolean containsHeader(String s) {
        boolean result = this.headers.containsHeader(s);
        if (Log.isTracing()) {
            this.traceDebug("containsHeader", "name = [" + s + "], result: [" + result + "]");
        }
        return result;
    }

    public String getHeader(String s) {
        return this.headers.getHeader(s);
    }

    public String encodeRedirectURL(String location) {
        return this.encodeURL(location);
    }

    public String encodeRedirectUrl(String location) {
        return this.encodeRedirectURL(location);
    }

    public String encodeURL(String url, String logonGroup) {
        int sepInd;
        if (this.getHttpParameters().getHttpProperties().getZoneSeparator() == null) {
            return url;
        }
        String urlPrefix = null;
        if (url.startsWith("http://")) {
            sepInd = url.indexOf(47, "http://".length());
            if (sepInd != -1) {
                urlPrefix = url.substring(0, sepInd);
                url = url.substring(sepInd);
            }
        } else if (url.startsWith("https://") && (sepInd = url.indexOf(47, "https://".length())) != -1) {
            urlPrefix = url.substring(0, sepInd);
            url = url.substring(sepInd);
        }
        url = ParseUtils.canonicalize((String)url);
        if (("/" + url).startsWith(this.requestFacade.getContextPath() + "/")) {
            url = "/" + url;
        }
        if (!url.startsWith(this.requestFacade.getContextPath() + "/")) {
            try {
                url = this.makeAbsolute(url);
            }
            catch (MalformedURLException me) {
                if (Log.isTracing()) {
                    this.traceError("sendRedirect", "cannot convert url", me);
                }
                throw new WebIllegalArgumentException("servlet_jsp_0003", new Object[]{url}, me);
            }
            if (url.startsWith("http://")) {
                sepInd = url.indexOf(47, "http://".length());
                if (sepInd != -1) {
                    url = url.substring(sepInd);
                }
            } else if (url.startsWith("https://") && (sepInd = url.indexOf(47, "https://".length())) != -1) {
                url = url.substring(sepInd);
            }
            return this.encodeURL(url, logonGroup);
        }
        url = this.requestFacade.getContextPath() + this.getHttpParameters().getHttpProperties().getZoneSeparator() + logonGroup + url.substring(this.requestFacade.getContextPath().length());
        if (urlPrefix != null) {
            return urlPrefix + url;
        }
        return url;
    }

    public String encodeURL(String url) {
        String originalUrl = null;
        if (Log.isTracing() && url != null) {
            originalUrl = new String(url);
        }
        boolean forceEncoding = false;
        if (url != null && url.startsWith(FORCE_ENCODING)) {
            forceEncoding = true;
            url = url.substring(FORCE_ENCODING.length());
        }
        if (forceEncoding || this.context.getWebApplicationConfiguration().isURLSessionTracking()) {
            if (this.requestFacade.getSession(false) != null) {
                String result = this.toEncoded(url, this.requestFacade.getSession(false).getId(), true);
                if (Log.isTracing()) {
                    this.traceDebug("encodeURL", "url = [" + originalUrl + "], forceEncoding, url session tracking, has session, result: [" + result + "]");
                }
                return result;
            }
            String result = this.toEncoded(url, null, false);
            if (Log.isTracing()) {
                this.traceDebug("encodeURL", "url = [" + originalUrl + "], forceEncoding, url session tracking, has not session, result: [" + result + "]");
            }
            return result;
        }
        ArrayObject cookies = this.requestFacade.getHttpParameters().getRequest().getCookies(this.context.getWebApplicationConfiguration().isURLSessionTracking());
        if (cookies != null && cookies.size() > 0) {
            if (Log.isTracing()) {
                this.traceDebug("encodeURL", "url = [" + originalUrl + "], not url session tracking, has cookies, result: [" + url + "]");
            }
            return url;
        }
        if (this.requestFacade.isRequestedSessionIdFromCookie()) {
            if (Log.isTracing()) {
                this.traceDebug("encodeURL", "url = [" + originalUrl + "], not url session tracking, has cookies, result: [" + url + "]");
            }
            return url;
        }
        if (this.requestFacade.getRequestedSessionId() == null) {
            if (this.requestFacade.getSession(false) != null) {
                String result = this.toEncoded(url, this.requestFacade.getSession(false).getId(), true);
                if (Log.isTracing()) {
                    this.traceDebug("encodeURL", "url = [" + originalUrl + "], not url session tracking, has not cookies, has session, result: [" + url + "]");
                }
                return result;
            }
            String result = this.toEncoded(url, null, false);
            if (Log.isTracing()) {
                this.traceDebug("encodeURL", "url = [" + originalUrl + "], not url session tracking, has not cookies, has not session, result: [" + url + "]");
            }
            return result;
        }
        String result = this.toEncoded(url, this.requestFacade.getRequestedSessionId(), true);
        if (Log.isTracing()) {
            this.traceDebug("encodeURL", "url = [" + originalUrl + "], not url session tracking, has not cookies, cookies in url, result: [" + url + "]");
        }
        return result;
    }

    public String encodeUrl(String s) {
        return this.encodeURL(s);
    }

    public String getCharacterEncoding() {
        String contentTypeHeader;
        byte[] contentTypeBytes = this.headers.getHeader(HeaderNames.entity_header_content_type_);
        if (contentTypeBytes != null) {
            char[] contentTypeChars = new char[contentTypeBytes.length];
            int i = 0;
            while (i < contentTypeBytes.length) {
                contentTypeChars[i] = (char)(contentTypeBytes[i] & 0xFF);
                ++i;
            }
            String contentType = new String(contentTypeChars);
            int charsetLocation = ByteArrayUtils.indexOf((byte[])contentTypeBytes, (byte[])Constants.charset);
            int semi = ByteArrayUtils.indexOf((byte[])contentTypeBytes, (byte)59, (int)charsetLocation);
            if (charsetLocation > -1) {
                this.characterEncoding = semi > -1 ? contentType.substring(charsetLocation + 8, semi).trim() : contentType.substring(charsetLocation + 8).trim();
            }
        }
        if (this.characterEncoding == null) {
            if (Log.isTracing()) {
                contentTypeHeader = null;
                if (contentTypeBytes != null) {
                    contentTypeHeader = new String(contentTypeBytes);
                }
                this.traceDebug("getCharacterEncoding", "contentTypeHeader = [" + contentTypeHeader + "], result: [" + "ISO-8859-1" + "]");
            }
            return "ISO-8859-1";
        }
        if (Log.isTracing()) {
            contentTypeHeader = null;
            if (contentTypeBytes != null) {
                contentTypeHeader = new String(contentTypeBytes);
            }
            this.traceDebug("getCharacterEncoding", "contentTypeHeader = [" + contentTypeHeader + "], result: [" + this.characterEncoding + "]");
        }
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.getWriter) {
            if (Log.isTracing()) {
                this.traceWarning("getOutputStream", "getWriter == true, throwing exception", true);
            }
            throw new WebIllegalStateException(WebIllegalStateException.Stream_is_already_taken_with_method, new Object[]{"getWriter()"});
        }
        this.getOutputStream = true;
        if (this.isGZip) {
            return this.gzipResponseStream;
        }
        return this.output;
    }

    public ServletOutputStream getOutStream() {
        if (this.isGZip) {
            return this.gzipResponseStream;
        }
        return this.output;
    }

    public PrintWriter getWriter() {
        if (this.getOutputStream) {
            if (Log.isTracing()) {
                this.traceWarning("getWriter", "getOutputStream == true, throwing exception", true);
            }
            throw new WebIllegalStateException(WebIllegalStateException.Stream_is_already_taken_with_method, new Object[]{"getOutputStream()"});
        }
        if (!this.getWriter) {
            this.getWriter = true;
            if (this.isGZip) {
                this.gzipprintwriter.init(this.getCharacterEncoding(), this.getBufferSize());
                if (this.isClosed) {
                    this.gzipprintwriter.close();
                }
            } else {
                this.printwriter.init(this.getCharacterEncoding(), this.getBufferSize());
                if (this.isClosed) {
                    this.printwriter.close();
                }
            }
        }
        if (this.isGZip) {
            return this.gzipprintwriter;
        }
        return this.printwriter;
    }

    private String convertAlias(String toConvert) {
        if (toConvert == null) {
            return null;
        }
        toConvert = toConvert.trim();
        toConvert = ParseUtils.convertAlias((String)toConvert);
        if ((toConvert = ParseUtils.canonicalize((String)toConvert)).startsWith("/")) {
            toConvert = toConvert.substring(1);
        }
        if (toConvert.endsWith("/")) {
            toConvert = toConvert.substring(0, toConvert.length() - 2);
        }
        return toConvert;
    }

    public void addLoadBalancingCookie(String logonGroup, String alias, int serverId) {
        if (alias == null) {
            alias = "/";
        }
        alias = this.convertAlias(alias);
        if (logonGroup == null && (logonGroup = this.getHttpParameters().getHttpProperties().getLogonTable().getGroup(alias)) == null) {
            logonGroup = "*";
        }
        logonGroup = this.convertAlias(logonGroup);
        logonGroup.replace('/', '*');
        logonGroup.replace('\\', '*');
        String cookieValue = "" + serverId;
        String instanceName = SBasic.getInstanceName(serverId);
        if (instanceName != null) {
            cookieValue = "(" + instanceName + ")" + cookieValue;
        }
        if (alias.equalsIgnoreCase(this.context.getAliasName()) || logonGroup.equalsIgnoreCase(this.getHttpParameters().getHttpProperties().getLogonTable().getGroup(this.context.getAliasName()))) {
            this.getServletRequest().getSession();
        }
        HttpCookie lbCookie = CookieParser.createCookie((String)(CookieParser.app_cookie_prefix + logonGroup), (String)cookieValue, (String)this.getHttpParameters().getRequest().getHost(), (WebCookieConfig)this.context.getWebApplicationConfiguration().getApplicationCookieConfig());
        if (alias.equals("/")) {
            lbCookie.setPath("/");
        } else {
            lbCookie.setPath("/" + alias + "/");
        }
        this.removeLBCookie(lbCookie.getName(), lbCookie.getPath());
        this.addCookie(lbCookie);
        if (logonGroup.equals("*")) {
            return;
        }
        HttpCookie defaultLbCookie = CookieParser.createCookie((String)(CookieParser.app_cookie_prefix + "*"), (String)cookieValue, (String)this.getHttpParameters().getRequest().getHost(), (WebCookieConfig)this.context.getWebApplicationConfiguration().getApplicationCookieConfig());
        if (alias.equals("/")) {
            defaultLbCookie.setPath("/");
        } else {
            defaultLbCookie.setPath("/" + alias + "/");
        }
        this.removeLBCookie(defaultLbCookie.getName(), defaultLbCookie.getPath());
        this.addCookie(defaultLbCookie);
    }

    public void addLoadBalancingCookie(String logonGroup, int serverId) {
        if (logonGroup == null) {
            logonGroup = "*";
        }
        logonGroup = this.convertAlias(logonGroup);
        logonGroup.replace('/', '*');
        logonGroup.replace('\\', '*');
        String cookieValue = "" + serverId;
        String instanceName = SBasic.getInstanceName(serverId);
        if (instanceName != null) {
            cookieValue = "(" + instanceName + ")" + cookieValue;
        }
        HttpCookie lbCookie = CookieParser.createCookie((String)(CookieParser.app_cookie_prefix + logonGroup), (String)cookieValue, (String)this.getHttpParameters().getRequest().getHost(), (WebCookieConfig)this.context.getWebApplicationConfiguration().getApplicationCookieConfig());
        this.addCookie(lbCookie);
    }

    private void removeLBCookie(String name, String path) {
        if (this.cookies == null) {
            return;
        }
        Object[] allCookies = this.cookies.toArray();
        int i = 0;
        while (allCookies != null && i < allCookies.length) {
            HttpCookie nextCookie = (HttpCookie)allCookies[i];
            if (nextCookie.getName().equals(name) && nextCookie.getPath().equals(path)) {
                this.cookies.remove((Object)nextCookie);
            }
            ++i;
        }
    }

    public void addLoadBalancingCookie(String logonGroup, String alias) {
        this.addLoadBalancingCookie(logonGroup, alias, SBasic.serverId);
    }

    public void addLoadBalancingCookie(String logonGroup) {
        this.addLoadBalancingCookie(logonGroup, SBasic.serverId);
    }

    public Cookie getMyLoadBalancingCookie() {
        String cookieValue = null;
        if ("sapj2ee_".equals(this.getServletContext().getHttpProvider().getHttpProperties().getLoadBalancingCookiePrefix())) {
            cookieValue = "" + SBasic.serverId;
        } else {
            String instanceId = SBasic.getInstanceName();
            if (instanceId == null) {
                instanceId = "J2EE" + this.getHttpParameters().getRequest().getDispatcherId();
            }
            cookieValue = "(" + instanceId + ")" + SBasic.serverId;
        }
        String aplicationCookieNameZoneEncoded = this.getServletContext().getSessionServletContext().getApplicationCookieName();
        if (this.getHttpParameters().getRequestPathMappings().getZoneName() != null && this.getHttpParameters().getRequestPathMappings().getZoneName().length() != 0) {
            aplicationCookieNameZoneEncoded = CookieParser.app_cookie_prefix + this.getHttpParameters().getRequestPathMappings().getZoneName();
        }
        HttpCookie httpCookie = CookieParser.createCookie((String)aplicationCookieNameZoneEncoded, (String)cookieValue, (String)this.getHttpParameters().getRequest().getHost(), (WebCookieConfig)this.getServletContext().getWebApplicationConfiguration().getApplicationCookieConfig());
        Cookie cookie = new Cookie(httpCookie.getName(), httpCookie.getValue());
        if (httpCookie.getComment() != null) {
            cookie.setComment(httpCookie.getComment());
        }
        if (httpCookie.getDomain() != null) {
            cookie.setDomain(httpCookie.getDomain());
        }
        cookie.setMaxAge(httpCookie.getMaxAge());
        if (httpCookie.getPath() != null) {
            cookie.setPath(httpCookie.getPath());
        }
        cookie.setSecure(httpCookie.getSecure());
        cookie.setVersion(httpCookie.getVersion());
        return cookie;
    }

    public void sendError(int i) throws IOException {
        this.sendError(i, ResponseCodes.reason((int)i, (String)this.context.getAliasName()));
    }

    public void sendError(int i, String s) throws IOException {
        this.sendError(i, s, null, true);
    }

    public void sendError(int i, String s, boolean checkHtml) throws IOException {
        this.sendError(i, s, null, checkHtml);
    }

    public void sendError(int i, String s, String details, boolean checkHtml) throws IOException {
        if (this.isCommitted() || this.isCommittedError()) {
            if (Log.isTracing()) {
                this.traceWarning("sendError", "code = [" + i + "], message = [" + s + "], details = [" + details + "]: isCommitted || isCommittedError, throwing exception", false);
            }
            throw new WebIllegalStateException(WebIllegalStateException.Stream_is_already_commited);
        }
        if (Log.isTracing()) {
            this.trace("sendError", "code = [" + i + "], message = [" + s + "], details = [" + details + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.clearBuffer();
        this.setStatus(i);
        HttpInputStream requestBody = null;
        try {
            ServletInputStream requestInput = this.requestFacade.getInputStreamNoCheck();
            if (requestInput instanceof HttpInputStream) {
                requestBody = (HttpInputStream)requestInput;
            }
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (OutOfMemoryError t) {
            throw t;
        }
        catch (Throwable t) {
            Log.getCategory(5).logError(Log.getLocation(5).getLocation(), "Cannot get input stream for reading request body.", t, this.getServletContext().getAliasName());
        }
        if (requestBody != null && !requestBody.isEmpty()) {
            this.requestFacade.getHttpParameters().getResponse().setPersistentConnection(false);
        }
        try {
            if (!this.doError(i, s)) {
                this.setHeader("Pragma", "no-cache");
                this.setContentType("text/html;charset=ISO-8859-1");
                byte[] errorBody = null;
                errorBody = details == null ? (checkHtml ? Responses.getErrorResponse((byte[])SBasic.version, (int)i, (String)this.context.getAliasName(), (byte[])s.getBytes()) : Responses.getErrorResponseHtmlAllowed((byte[])SBasic.version, (int)i, (String)this.context.getAliasName(), (byte[])s.getBytes())) : (checkHtml ? Responses.getErrorResponse((byte[])SBasic.version, (int)i, (String)this.context.getAliasName(), (byte[])s.getBytes(), (byte[])details.getBytes()) : Responses.getErrorResponseHtmlAllowed((byte[])SBasic.version, (int)i, (String)this.context.getAliasName(), (byte[])s.getBytes(), (byte[])details.getBytes()));
                this.setContentLength(errorBody.length);
                if (this.isGZip) {
                    if (this.getWriter) {
                        this.gzipprintwriter.println(new String(errorBody));
                    } else {
                        this.getOutputStream().write(errorBody);
                    }
                    this.finish();
                } else {
                    this.setContentLength(errorBody.length);
                    this.sendBodyText(new String(errorBody));
                    this.close();
                }
            }
            this.sentError = true;
        }
        catch (ServletException se) {
            if (Log.isTracing()) {
                this.traceError("sendError", "error occurred in invoking error page", se);
            }
            throw new WebIOException("servlet_jsp_0023", se);
        }
    }

    public void writeError(int i, String s, String details, boolean checkHtml) throws IOException {
        if (Log.isTracing()) {
            this.tracePath("writeError", "code = [" + i + "], message = [" + s + "], details = [" + details + "]");
        }
        this.requestFacade.getHttpParameters().getResponse().setPersistentConnection(false);
        byte[] errorBody = null;
        errorBody = details == null ? (checkHtml ? Responses.getErrorResponse((byte[])SBasic.version, (int)i, (String)this.context.getAliasName(), (byte[])s.getBytes()) : Responses.getErrorResponseHtmlAllowed((byte[])SBasic.version, (int)i, (String)this.context.getAliasName(), (byte[])s.getBytes())) : (checkHtml ? Responses.getErrorResponse((byte[])SBasic.version, (int)i, (String)this.context.getAliasName(), (byte[])s.getBytes(), (byte[])details.getBytes()) : Responses.getErrorResponseHtmlAllowed((byte[])SBasic.version, (int)i, (String)this.context.getAliasName(), (byte[])s.getBytes(), (byte[])details.getBytes()));
        if (this.isGZip) {
            if (this.getWriter) {
                this.gzipprintwriter.println(new String(errorBody));
            } else {
                this.getOutputStream().write(errorBody);
            }
            this.finish();
        } else {
            this.sendBodyText(new String(errorBody));
            this.close();
        }
    }

    private void sendBodyText(String s) throws IOException {
        if (this.isGZip) {
            this.gzipResponseStream.print(s);
        } else {
            this.output.print(s);
        }
    }

    public void close() throws IOException {
        this.isClosed = true;
        if (this.getWriter) {
            if (this.isGZip) {
                this.gzipprintwriter.close();
            } else {
                this.printwriter.close();
            }
            return;
        }
        if (this.isGZip) {
            this.gzipResponseStream.close();
        }
        this.output.close();
    }

    public void sendRedirect(String s) throws IOException, IllegalArgumentException {
        if (this.isCommitted()) {
            if (Log.isTracing()) {
                this.traceWarning("sendRedirect", "url = [" + s + "], isIncluded = [" + this.isIncluded + "], isCommitted: throwing exception", true);
            }
            throw new WebIllegalStateException(WebIllegalStateException.Stream_is_already_commited);
        }
        if (Log.isTracing()) {
            this.tracePath("sendRedirect", "url = [" + s + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        if (s == null) {
            throw new WebIllegalArgumentException("servlet_jsp_0002");
        }
        this.reset(true);
        this.setStatus(302);
        this.setContentType("text/plain");
        try {
            s = this.makeAbsolute(s);
        }
        catch (MalformedURLException me) {
            if (Log.isTracing()) {
                this.traceError("sendRedirect", "cannot convert url", me);
            }
            throw new WebIllegalArgumentException("servlet_jsp_0003", new Object[]{s}, me);
        }
        this.setHeader("Location", s);
        if (this.isGZip) {
            this.finish();
        } else {
            this.close();
        }
    }

    private String makeAbsolute(String s) throws MalformedURLException {
        try {
            if (!this.isRelativeURL(s)) {
                return new URL(s).toString();
            }
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        String s1 = this.getRequestURL();
        URL url = new URL(new URL(s1), s);
        if (!HttpServletResponseFacade.isValidURL(s)) {
            throw new WebMalformedURLException(WebMalformedURLException.Not_valid_URL, new Object[]{s});
        }
        return url.toString();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRelativeURL(String spec) {
        char c;
        int start = 0;
        String newProtocol = null;
        boolean aRef = false;
        int limit = spec.length();
        while (limit > 0 && spec.charAt(limit - 1) <= ' ') {
            --limit;
        }
        while (start < limit && spec.charAt(start) <= ' ') {
            ++start;
        }
        if (spec.regionMatches(true, start, "url:", 0, 4)) {
            start += 4;
        }
        if (start < spec.length() && spec.charAt(start) == '#') {
            aRef = true;
        }
        int i = start;
        while (!aRef && i < limit && (c = spec.charAt(i)) != '/') {
            void var4_7;
            if (var4_7 == 58) {
                String s = spec.substring(start, i).toLowerCase();
                if (!this.isValidProtocol(s)) break;
                newProtocol = s;
                start = i + 1;
                break;
            }
            ++i;
        }
        return newProtocol == null;
    }

    private boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        int i = 1;
        while (i < len) {
            c = protocol.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.requestFacade.getScheme();
        int port = this.requestFacade.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(this.requestFacade.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.requestFacade.getRequestURI());
        return url.toString();
    }

    private static boolean isValidURL(String s) {
        if (s.indexOf(62) != -1) {
            return false;
        }
        if (s.indexOf(60) != -1) {
            return false;
        }
        return s.indexOf(124) == -1;
    }

    public void setContentLength(int i) {
        if (Log.isTracing()) {
            this.trace("setContentLength", "length = [" + i + "], isCommitted = [" + this.isCommitted() + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isIncluded) {
            return;
        }
        if (!this.isGZip) {
            this.headers.putIntHeader(HeaderNames.entity_header_content_length_, i);
            this.contentLength = i;
            this.printwriter.setContentLength(i);
            this.gzipprintwriter.setContentLength(i);
            this.output.useChunking = false;
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String s) {
        if (Log.isTracing()) {
            this.trace("setContentType", "content type = [" + s + "], isCommitted = [" + this.isCommitted() + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isIncluded) {
            return;
        }
        char[] ct = s.toCharArray();
        byte[] ctBytes = new byte[ct.length];
        int i = 0;
        while (i < ct.length) {
            ctBytes[i] = (byte)ct[i];
            ++i;
        }
        this.headers.putHeader(HeaderNames.entity_header_content_type_, ctBytes);
    }

    public void setDateHeader(String headername, long date) {
        if (Log.isTracing()) {
            this.trace("setDateHeader", "name = [" + headername + "], value = [" + date + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.headers.putDateHeader(headername.getBytes(), date);
    }

    public void setHeader(String headername, String s1) {
        if (Log.isTracing()) {
            this.trace("setHeader", "name = [" + headername + "], value = [" + s1 + "], isIncluded = [" + this.isIncluded + "], committed = [" + this.isCommitted() + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.headers.putHeader(headername.getBytes(), s1.getBytes());
    }

    private void setHeader(byte[] headername, byte[] s1) {
        if (Log.isTracing()) {
            String name = null;
            String value = null;
            if (headername != null) {
                name = new String(headername);
            }
            if (s1 != null) {
                value = new String(s1);
            }
            this.trace("setHeader", "name = [" + name + "], value = [" + value + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.headers.putHeader(headername, s1);
    }

    public void setIntHeader(String headername, int i) {
        if (Log.isTracing()) {
            this.trace("setIntHeader", "name = [" + headername + "], value = [" + i + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.headers.putIntHeader(headername.getBytes(), i);
    }

    public void setStatus(int i) {
        if (Log.isTracing()) {
            this.trace("setStatus", "code = [" + i + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.setStatus(i, ResponseCodes.reason((int)i, (String)this.context.getAliasName()));
    }

    public void setStatus(int i, String status) {
        if (Log.isTracing()) {
            this.trace("setStatus", "code = [" + i + "], message = [" + status + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.statusSrc = status;
        this.status = i;
    }

    public void addHeader(String headername, String value) {
        if (Log.isTracing()) {
            this.trace("addHeader", "name = [" + headername + "], value = [" + value + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.headers.addHeader(headername.getBytes(), value.getBytes());
    }

    public void addHeaderContentEncoding(String value) {
        if (Log.isTracing()) {
            this.trace("addHeader", "name = [Content-Encoding], value = [" + value + "], isIncluded = [" + this.isIncluded + "]");
        }
        this.headers.addHeader(HeaderNames.entity_header_content_encoding_, value.getBytes());
    }

    void removeHeader(String headername) {
        if (Log.isTracing()) {
            this.trace("removeHeader", "name = [" + headername + "]");
        }
        this.headers.removeHeader(headername);
    }

    public void addDateHeader(String headername, long date) {
        if (Log.isTracing()) {
            this.trace("addDateHeader", "name = [" + headername + "], value = [" + date + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.headers.addDateHeader(headername.getBytes(), date);
    }

    public void addIntHeader(String headername, int value) {
        if (Log.isTracing()) {
            this.trace("addIntHeader", "name = [" + headername + "], value = [" + value + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isIncluded) {
            return;
        }
        this.headers.addIntHeader(headername.getBytes(), value);
    }

    public void setBufferSize(int size) {
        if (Log.isTracing()) {
            this.trace("setBufferSize", "size = [" + size + "]");
        }
        if (size < 0) {
            throw new WebIllegalStateException("servlet_jsp_0289", new Object[]{"" + size});
        }
        boolean isWritenAnything = false;
        if (this.isGZip) {
            isWritenAnything = this.gzipprintwriter.isWrittenAnything() || this.gzipResponseStream.isWrittenAnything();
        } else {
            boolean bl = isWritenAnything = this.output.isWritenAnything() || this.printwriter.isWrittenAnything();
        }
        if (isWritenAnything) {
            if (Log.isTracing()) {
                this.traceWarning("setBufferSize", "isWritenAnything = [" + isWritenAnything + "], throwing exception", false);
            }
            throw new WebIllegalStateException(WebIllegalStateException.Cannot_use_setBufferSize_if_anything_has_written_in_the_ServletOutputStream);
        }
        if (this.isGZip) {
            this.gzipResponseStream.setBufferSize(size);
        } else {
            this.output.setBufferSize(size);
        }
        if (this.getWriter) {
            if (this.isGZip) {
                this.gzipprintwriter.setBufferSize(size);
            } else {
                this.printwriter.setBufferSize(size);
            }
        }
    }

    public int getBufferSize() {
        if (Log.isTracing()) {
            this.traceDebug("getBufferSize", "size = [" + this.output.getBufferSize() + "]");
        }
        return this.output.getBufferSize();
    }

    public void clearBuffer() throws IOException {
        if (this.output.isClosed()) {
            if (Log.isTracing()) {
                this.traceWarning("clearBuffer", "output is closed", false);
            }
            throw new WebIOException("servlet_jsp_0024");
        }
        if (!this.isGZip) {
            this.output.clear();
        }
        if (this.getWriter) {
            if (this.isGZip) {
                this.gzipprintwriter.reset();
            } else {
                this.printwriter.reset();
            }
        }
    }

    public boolean isCommitted() {
        if (Log.isTracing()) {
            this.traceDebug("isCommitted", "return: [" + this.output.committed + "]");
        }
        return this.output.committed;
    }

    public void flushBuffer() throws IOException {
        if (Log.isTracing()) {
            this.trace("flushBuffer", "getWriter = [" + this.getWriter + "], isGZip = [" + this.isGZip + "]");
        }
        if (this.getWriter) {
            if (this.isGZip) {
                this.gzipprintwriter.flush();
            } else {
                this.printwriter.flush();
            }
        }
        if (this.isGZip) {
            this.gzipResponseStream.flush();
        } else {
            this.output.flush();
        }
    }

    public Locale getLocale() {
        if (Log.isTracing()) {
            this.traceDebug("getLocale", "locale = [" + this.locale + "]");
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (Log.isTracing()) {
            this.trace("setLocale", "locale = [" + locale + "], isCommitted = [" + this.isCommitted() + "], isIncluded = [" + this.isIncluded + "]");
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isIncluded) {
            return;
        }
        this.locale = locale;
        String language = locale.getLanguage();
        if (language != null && language.length() > 0) {
            String country = locale.getCountry();
            if (country != null && country.length() > 0) {
                language = language + "-" + country;
            }
            this.characterEncoding = HttpServletResponseFacade.getCharsetEncoding(locale);
            this.setHeader("Content-Language", language);
            if (this.headers.getHeader(HeaderNames.entity_header_content_type_) != null) {
                String temp = new String(this.headers.getHeader(HeaderNames.entity_header_content_type_));
                if (temp.indexOf("charset=") > -1) {
                    temp = temp.substring(0, temp.indexOf("charset="));
                    temp = temp + "charset=" + this.characterEncoding;
                    this.setContentType(temp);
                } else {
                    temp = temp + ";charset=" + this.characterEncoding;
                    this.setContentType(temp);
                }
            }
        }
    }

    public void finish() throws IOException {
        if (Log.isTracing()) {
            this.tracePath("finish", "");
        }
        this.markClosed();
        this.isClosed = true;
        if (this.isGZip && this.getWriter) {
            this.gzipprintwriter.close();
        } else if (this.getWriter) {
            this.printwriter.flush();
        } else if (this.isGZip) {
            this.gzipResponseStream.close();
        }
        this.output.close();
        this.output.setConnectionType();
    }

    public void setSessionCookie() {
        this.setSessionCookie = true;
    }

    boolean isSessionCookieSet() {
        return this.setSessionCookie;
    }

    private boolean isCommittedError() {
        return this.output.committedForError;
    }

    private String toEncoded(String url, String sessionId, boolean setSessionCookie) {
        String encodedDataBeg;
        if (url == null) {
            return null;
        }
        String query = null;
        String encodedData = null;
        int sep = url.indexOf(63);
        if (sep > -1) {
            query = url.substring(sep);
            url = url.substring(0, sep);
        }
        if ((sep = url.indexOf(59)) > -1) {
            encodedData = url.substring(sep);
            url = url.substring(0, sep);
        }
        if (setSessionCookie) {
            url = url + ";jsessionid=" + sessionId;
        }
        url = url + this.context.getSessionServletContext().getApplicationCookieEncoded(this.getHttpParameters().getRequestPathMappings().getZoneName(), this.getHttpParameters().getHttpProperties().getZoneSeparator(), this.getHttpParameters().getRequest().getDispatcherId());
        if (encodedData != null && (sep = encodedData.indexOf(";jsessionid=")) > -1) {
            if (sep == 0) {
                encodedData = (sep = encodedData.indexOf(59, sep + 1)) > -1 ? encodedData.substring(sep) : null;
            } else {
                encodedDataBeg = encodedData.substring(0, sep - 1);
                encodedData = (sep = encodedData.indexOf(59, sep + 1)) > -1 ? encodedDataBeg + encodedData.substring(sep) : encodedDataBeg;
            }
        }
        if (encodedData != null && (sep = encodedData.indexOf(";" + this.getServletContext().getSessionServletContext().getApplicationCookieName() + "=")) > -1) {
            if (sep == 0) {
                encodedData = (sep = encodedData.indexOf(59, sep + 1)) > -1 ? encodedData.substring(sep) : null;
            } else {
                encodedDataBeg = encodedData.substring(0, sep);
                encodedData = (sep = encodedData.indexOf(59, sep + 1)) > -1 ? encodedDataBeg + encodedData.substring(sep) : encodedDataBeg;
            }
        }
        if (encodedData != null) {
            url = url + encodedData;
        }
        if (query != null) {
            url = url + query;
        }
        return url;
    }

    public void resetBuffer() throws IllegalStateException {
        if (Log.isTracing()) {
            this.trace("resetBuffer", "isCommitted = [" + this.isCommitted() + "]");
        }
        if (this.isCommitted()) {
            throw new WebIllegalStateException(WebIllegalStateException.Stream_is_already_commited);
        }
        try {
            this.clearBuffer();
        }
        catch (IOException io) {
            Log.getCategory(5).logError(Log.getLocation(5).getLocation(), "Error in clearing the buffers of the response.", io, this.getServletContext().getAliasName());
        }
    }

    private static String getCharsetEncoding(Locale locale) {
        String temp = EncodingUtils.getEncoding((String)locale.toString());
        if (temp == null) {
            return EncodingUtils.getEncoding((String)locale.getLanguage());
        }
        return temp;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean getIncluded() {
        return this.isIncluded;
    }

    public void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
    }

    public void setServletName(String servlet) {
        this.servletName = servlet;
    }

    public String getServletName() {
        return this.servletName;
    }

    private boolean doError(int code, String message) throws ServletException, IOException {
        String errPageLocation = this.context.getWebMappings().getErrorCodeErrorPage(code);
        if (errPageLocation != null) {
            if (Log.isTracing()) {
                this.traceDebug("doError", "code = [" + code + "], message = [" + message + "], errPageLocation = [" + errPageLocation + "], request_uri = [" + this.requestFacade.getRequestURI() + "], servlet_name = [" + this.servletName + "]");
            }
            this.requestFacade.setAttribute("javax.servlet.error.status_code", new Integer(code));
            this.requestFacade.setAttribute("javax.servlet.error.message", message);
            this.requestFacade.setAttribute("javax.servlet.error.request_uri", this.requestFacade.getRequestURI());
            this.requestFacade.setAttribute("javax.servlet.error.servlet_name", this.servletName);
            RequestDispatcher requestDispatcher = this.context.getServletContext().getRequestDispatcher(errPageLocation);
            if (this.isCommitted()) {
                requestDispatcher.include((ServletRequest)this.requestFacade, (ServletResponse)this);
            } else {
                requestDispatcher.forward((ServletRequest)this.requestFacade, (ServletResponse)this);
            }
            return true;
        }
        return false;
    }

    public void setIsError(boolean is) {
        if (this.output != null) {
            this.output.setIsError(is);
        }
    }

    public boolean isSentError() {
        return this.sentError;
    }

    private void createGZipOutputStream() throws IOException {
        this.gzipResponseStream = new GzipResponseStream(this, this.output);
    }

    private void trace(String method, String msg) {
        Log.getLocation(5).trace("client [" + this.requestFacade.getHttpParameters().getRequest().getClientId() + "] HttpServletResponseFacade." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg, this.context.getAliasName());
    }

    private void traceError(String method, String msg, Throwable t) {
        Log.getLocation(5).traceError("client [" + this.requestFacade.getHttpParameters().getRequest().getClientId() + "] HttpServletResponseFacade." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg + ". ERROR: " + Log.getExceptionStackTrace(t), this.context.getAliasName());
    }

    private void traceWarning(String method, String msg, boolean logTrace) {
        if (logTrace) {
            msg = Log.getExceptionStackTrace(new Exception(msg));
        }
        Log.getLocation(5).traceWarning("client [" + this.requestFacade.getHttpParameters().getRequest().getClientId() + "] HttpServletResponseFacade." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg, this.context.getAliasName());
    }

    private void traceInfo(String method, String msg) {
        Log.getLocation(5).traceInfo("client [" + this.requestFacade.getHttpParameters().getRequest().getClientId() + "] HttpServletResponseFacade." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg, this.context.getAliasName());
    }

    private void tracePath(String method, String msg) {
        Log.getLocation(5).tracePath("client [" + this.requestFacade.getHttpParameters().getRequest().getClientId() + "] HttpServletResponseFacade." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg, this.context.getAliasName());
    }

    private void traceDebug(String method, String msg) {
        Log.getLocation(5).traceDebug("client [" + this.requestFacade.getHttpParameters().getRequest().getClientId() + "] HttpServletResponseFacade." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg, this.context.getAliasName());
    }

    private String getObjectInstance() {
        String instance = super.toString();
        return instance.substring(instance.indexOf(64) + 1);
    }
}

