/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.client;

import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.lib.util.Stack;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.lib.CookieParser;
import com.sap.engine.services.httpserver.lib.HttpCookie;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.ProtocolParser;
import com.sap.engine.services.httpserver.lib.WebCookieConfig;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.servlets_jsp.lib.multipart.MultipartParseException;
import com.sap.engine.services.servlets_jsp.lib.multipart.MultipartPart;
import com.sap.engine.services.servlets_jsp.lib.multipart.impl.MultipartMessageImpl;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.NewApplicationSessionException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalStateException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebUnsupportedEncodingException;
import com.sap.engine.services.servlets_jsp.server.lib.WebParseUtils;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ApplicationSession;
import com.sap.engine.services.servlets_jsp.server.runtime.client.EmptyServletInputStreamImpl;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletResponseFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.runtime.context.SessionServletContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class HttpServletRequestImpl
implements HttpServletRequest {
    private ApplicationContext context = null;
    private SessionServletContext sessionServletContext = null;
    private HttpParameters httpParameters = null;
    private HttpServletResponseFacade response = null;
    private HashMapObjectObject parameters = new HashMapObjectObject(8);
    private byte[] requestURI = null;
    private byte[] requestURI_internal = null;
    private String queryString = null;
    private String characterEncoding = "ISO-8859-1";
    private boolean characterEncodingSet = false;
    private String realPath = null;
    private Stack paramStack = new Stack();
    private Stack queriesStack = new Stack();
    private boolean getInputStream = false;
    private boolean getReader = false;
    private ServletInputStream inputStream = null;
    private BufferedReader reader = null;
    private String currentServletName = null;
    private boolean sessionAccessed = false;
    public boolean parametersParsed = false;
    private boolean queryStringParsed = false;
    private String jspPrecompile = null;
    private boolean jspFlag = false;
    private ClassLoader threadLoader = null;
    private String servletPathIncluded = null;
    private boolean cookieSet = false;
    private boolean reusedSessionCookie = false;

    public void init(HttpParameters httpParameters, HttpServletResponseFacade response) {
        this.httpParameters = httpParameters;
        this.response = response;
        this.parseEncoding();
        this.jspFlag = false;
    }

    public void reset() {
        ApplicationSession applicationSession;
        if (Log.isTracing()) {
            this.traceDebug("reset", "clearing request object");
        }
        if (!this.sessionAccessed && (applicationSession = (ApplicationSession)this.getSession(false)) != null && applicationSession.isValid()) {
            applicationSession.accessed();
        }
        this.context = null;
        this.sessionServletContext = null;
        this.parameters.clear();
        this.requestURI = null;
        this.requestURI_internal = null;
        this.queryString = null;
        this.characterEncoding = "ISO-8859-1";
        this.characterEncodingSet = false;
        this.httpParameters = null;
        this.realPath = null;
        this.response = null;
        this.paramStack.clear();
        this.queriesStack.clear();
        this.getInputStream = false;
        this.getReader = false;
        this.inputStream = null;
        this.reader = null;
        this.sessionAccessed = false;
        this.parametersParsed = false;
        this.queryStringParsed = false;
        this.jspPrecompile = null;
        this.jspFlag = false;
        this.threadLoader = null;
        this.servletPathIncluded = null;
        this.cookieSet = false;
        this.reusedSessionCookie = false;
    }

    public String getAuthType() {
        SecuritySession ss = ((SecurityContextObject)ApplicationContext.getSecurityContext()).getSession();
        if (ss != null && ss.getAuthenticationConfiguration() != null) {
            if (Log.isTracing()) {
                this.traceDebug("getAuthType", "return: [" + this.sessionServletContext.getAuthType() + "]");
            }
            return this.sessionServletContext.getAuthType();
        }
        return null;
    }

    public String getCharacterEncoding() {
        if (!this.characterEncodingSet) {
            return null;
        }
        return this.characterEncoding;
    }

    public int getContentLength() {
        int result = -1;
        byte[] len = this.httpParameters.getRequest().getHeaders().getHeader(HeaderNames.entity_header_content_length_);
        if (len != null) {
            try {
                result = Ascii.asciiArrToInt((byte[])len, (int)0, (int)len.length);
                if (result < 0) {
                    result = -1;
                }
            }
            catch (NumberFormatException _) {
                Log.getCategory(5).logError(Log.getLocation(5).getLocation(), "Incorrect value of the content-length header " + len + ".", _, this.context.getAliasName(), this.httpParameters.getRequest().getClientIP());
            }
        }
        return result;
    }

    public String getContentType() {
        return this.httpParameters.getRequest().getHeaders().getHeader("Content-Type");
    }

    public Cookie[] getCookies() {
        ArrayObject cookies = this.httpParameters.getRequest().getCookies(this.context.getWebApplicationConfiguration().isURLSessionTracking());
        if (cookies == null || cookies.size() == 0) {
            return null;
        }
        Cookie[] res = new Cookie[cookies.size()];
        int resPtr = 0;
        int i = 0;
        while (i < res.length) {
            HttpCookie httpCookie = (HttpCookie)cookies.elementAt(i);
            try {
                res[resPtr] = httpCookie.toCookie();
            }
            catch (IllegalArgumentException e) {
                --resPtr;
            }
            ++i;
            ++resPtr;
        }
        if (resPtr < res.length) {
            Cookie[] resTmp = new Cookie[resPtr];
            System.arraycopy(res, 0, resTmp, 0, resTmp.length);
            res = resTmp;
        }
        return res;
    }

    public long getDateHeader(String s) throws IllegalArgumentException {
        if (Log.isTracing()) {
            this.traceDebug("getDateHeader", "name = [" + s + "], return: [" + this.httpParameters.getRequest().getHeaders().getDateHeader(s) + "]");
        }
        return this.httpParameters.getRequest().getHeaders().getDateHeader(s);
    }

    public String getHeader(String s) {
        if (Log.isTracing()) {
            this.traceDebug("getHeader", "name = [" + s + "], return: [" + this.httpParameters.getRequest().getHeaders().getHeader(s) + "]");
        }
        return this.httpParameters.getRequest().getHeaders().getHeader(s);
    }

    public Enumeration getHeaderNames() {
        if (Log.isTracing()) {
            String atr = "";
            Enumeration keys = this.httpParameters.getRequest().getHeaders().names();
            while (keys.hasMoreElements()) {
                atr = atr + keys.nextElement() + ", ";
            }
            if (atr.endsWith(", ")) {
                atr = atr.substring(0, atr.length() - 2);
            }
            this.traceDebug("getHeaderNames", "return: [" + atr + "]");
        }
        return this.httpParameters.getRequest().getHeaders().names();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.getReader) {
            if (Log.isTracing()) {
                this.traceWarning("getInputStream", "getReader == true, throwing error", false);
            }
            throw new WebIllegalStateException(WebIllegalStateException.Stream_is_already_taken_with_method, new String[]{"getReader()"});
        }
        this.getInputStream = true;
        if (this.inputStream != null) {
            return this.inputStream;
        }
        this.inputStream = this.httpParameters.getRequest().getBody() != null ? this.httpParameters.getRequest().getBody() : new EmptyServletInputStreamImpl();
        return this.inputStream;
    }

    public ServletInputStream getInputStreamNoCheck() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        this.inputStream = this.httpParameters.getRequest().getBody() != null ? this.httpParameters.getRequest().getBody() : new EmptyServletInputStreamImpl();
        return this.inputStream;
    }

    public int getIntHeader(String s) {
        if (Log.isTracing()) {
            this.traceDebug("getIntHeader", "name = [" + s + "], return: [" + this.httpParameters.getRequest().getHeaders().getIntHeader(s) + "]");
        }
        return this.httpParameters.getRequest().getHeaders().getIntHeader(s);
    }

    public String getMethod() {
        byte[] pib = this.httpParameters.getRequest().getRequestLine().getMethod();
        char[] pic = new char[pib.length];
        int i = 0;
        while (i < pib.length) {
            pic[i] = (char)(pib[i] & 0xFF);
            ++i;
        }
        return new String(pic);
    }

    public String getParameter(String s) {
        String[] as = this.getParameterValues(s);
        if (as != null) {
            if (Log.isTracing()) {
                this.traceDebug("getParameter", "name = [" + s + "], return: [" + as[0] + "]");
            }
            return as[0];
        }
        if (Log.isTracing()) {
            this.traceDebug("getParameter", "name = [" + s + "], return: [null]");
        }
        return null;
    }

    public String getParam(String s) {
        String[] as;
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        if ((as = (String[])this.parameters.get((Object)s)) != null) {
            if (Log.isTracing()) {
                this.traceDebug("getParam", "name = [" + s + "], return: [" + as[0] + "], parameters: [" + this.dumpParameters() + "]");
            }
            return as[0];
        }
        if (Log.isTracing()) {
            this.traceDebug("getParam", "name = [" + s + "], return: [null]");
        }
        return null;
    }

    public String[] getParameterValues(String s) {
        if (this.jspFlag && s.startsWith("jsp_")) {
            return null;
        }
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        String[] result = (String[])this.parameters.get((Object)s);
        if (Log.isTracing()) {
            String atr = "";
            int i = 0;
            while (result != null && i < result.length) {
                atr = atr + result[i] + ", ";
                ++i;
            }
            if (atr.endsWith(", ")) {
                atr = atr.substring(0, atr.length() - 2);
            }
            this.tracePath("getParameterValues", "name = [" + s + "], return: [" + atr + "], parameters: [" + this.dumpParameters() + "]");
        }
        return result;
    }

    public Enumeration getParameterNames() {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        if (Log.isTracing()) {
            String atr = "";
            Enumeration en = this.parameters.keys();
            while (en.hasMoreElements()) {
                atr = atr + en.nextElement() + ", ";
            }
            if (atr.endsWith(", ")) {
                atr = atr.substring(0, atr.length() - 2);
            }
            this.tracePath("getParameterNames", "return: [" + atr + "], parameters: [" + this.dumpParameters() + "]");
        }
        return this.parameters.keys();
    }

    protected String parsePathInfo(boolean pathInfoSet, String pathInfo) {
        String context_path = (this.getContextPath() + this.getServletPath()).trim();
        if (!pathInfoSet) {
            pathInfo = this.httpParameters.getRequestPathMappings().getPathInfo();
        }
        if (pathInfo != null) {
            if ((pathInfo = pathInfo.trim()).startsWith(context_path)) {
                if (context_path.equals(pathInfo)) {
                    pathInfo = null;
                    return pathInfo;
                }
                pathInfo = pathInfo.substring(context_path.length());
            }
            if (!this.getRequestURIinternal().equalsIgnoreCase(context_path + pathInfo)) {
                int csPathIndex = this.getRequestURIinternal().indexOf(context_path);
                pathInfo = csPathIndex != -1 ? this.getRequestURIinternal().substring(csPathIndex + context_path.length()) : null;
            }
        }
        if (pathInfo == null || pathInfo.equals("")) {
            return null;
        }
        if (pathInfo.indexOf("?") > -1) {
            pathInfo = pathInfo.substring(0, pathInfo.indexOf("?"));
        }
        if (pathInfo.indexOf(";") > -1) {
            pathInfo = pathInfo.substring(0, pathInfo.indexOf(";"));
        }
        if (pathInfo.equals("")) {
            return null;
        }
        return pathInfo;
    }

    public String getPathTranslated() {
        String path = this.getPathInfo();
        if (path == null || "".equals(path)) {
            return null;
        }
        return this.getRealPath(path);
    }

    public String getProtocol() {
        return "HTTP/" + this.httpParameters.getRequest().getRequestLine().getHttpMajorVersion() + "." + this.httpParameters.getRequest().getRequestLine().getHttpMinorVersion();
    }

    public String getQueryString() {
        if (!this.queryStringParsed && !this.parametersParsed) {
            if (this.queryString == null && this.httpParameters.getRequest().getRequestLine().getQuery() != null) {
                try {
                    this.queryString = new String(this.httpParameters.getRequest().getRequestLine().getQuery().getBytes(), this.characterEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    Log.getCategory(5).logWarning(Log.getLocation(5).getLocation(), "Can't parse the parameters of the request. Incorrect encoding specified in it: " + this.characterEncoding + ".", e, this.sessionServletContext.getAliasName());
                }
            }
            this.queryStringParsed = true;
        }
        if (Log.isTracing()) {
            this.tracePath("getQueryString", "queryString = [" + this.queryString + "]");
        }
        return this.queryString;
    }

    public String getRemoteUser() {
        SecuritySession ss = ((SecurityContextObject)ApplicationContext.getSecurityContext()).getSession();
        if (ss != null && ss.getAuthenticationConfiguration() != null) {
            if (Log.isTracing()) {
                this.tracePath("getRemoteUser", "user = [" + ss.getPrincipal().getName() + "]");
            }
            return ss.getPrincipal().getName();
        }
        if (Log.isTracing()) {
            this.tracePath("getRemoteUser", "user = [" + null + "]");
        }
        return null;
    }

    public String getScheme() {
        if (Log.isTracing()) {
            this.tracePath("getScheme", "scheme = [" + this.httpParameters.getRequest().getScheme() + "]");
        }
        return this.httpParameters.getRequest().getScheme();
    }

    public String getServerName() {
        return this.httpParameters.getRequest().getHost();
    }

    public int getServerPort() {
        return this.httpParameters.getRequest().getPort();
    }

    public HttpParameters getHttpParameters() {
        return this.httpParameters;
    }

    public HttpSession getSession(boolean flag) {
        ApplicationSession applicationSession;
        block39: {
            applicationSession = (ApplicationSession)this.httpParameters.getApplicationSession();
            HttpCookie cokkk = this.httpParameters.getRequest().getSessionCookie(this.context.getWebApplicationConfiguration().isURLSessionTracking());
            if (cokkk != null) {
                applicationSession = this.context.getSessionServletContext().getSession(this.httpParameters, cokkk.getValue());
                this.httpParameters.setApplicationSession((Object)applicationSession);
            }
            if (Log.isTracing()) {
                this.traceDebug("getSession", "flag = [" + flag + "], applicationSession in request = [" + applicationSession + "]");
            }
            if (applicationSession != null && !applicationSession.isValid()) {
                if (Log.isTracing()) {
                    this.traceDebug("getSession", "session in request is not valid");
                }
                applicationSession = null;
                this.httpParameters.setApplicationSession(null);
            }
            if (flag && applicationSession == null) {
                Object object;
                if (this.sessionServletContext.isForbiddenNewApplicationSession()) {
                    if (Log.isTracing()) {
                        this.traceWarning("getSession", "isForbiddenNewApplicationSession", false);
                    }
                    throw new NewApplicationSessionException(NewApplicationSessionException.CANNOT_CREATE_A_NEW_APPLICATIO_SESSION_BECAUSE_MAX_NUMBER_OF_SESSIONS_HAS_BEEN_REACHED);
                }
                String sessionId = this.getSessionID(this.httpParameters);
                if (Log.isTracing()) {
                    this.traceDebug("getSession", "sessionId = [" + sessionId + "], reusedSessionCookie = [" + this.reusedSessionCookie + "]");
                }
                if (this.reusedSessionCookie) {
                    this.sessionServletContext.invalidateRemoteSession(this.httpParameters, sessionId);
                }
                boolean createSession = true;
                if (this.reusedSessionCookie) {
                    Object object2 = this.sessionServletContext.sessionIdSynchObject;
                    synchronized (object2) {
                        boolean bl = createSession = this.sessionServletContext.sessionIDlocks.get((Object)sessionId) == null;
                        if (createSession) {
                            if (this.sessionServletContext.getSession().get(sessionId) != null) {
                                createSession = false;
                            } else {
                                this.sessionServletContext.sessionIDlocks.put((Object)sessionId, new Object());
                            }
                        } else {
                            boolean sleep = true;
                            while (sleep) {
                                try {
                                    this.sessionServletContext.sessionIdSynchObject.wait(60000L);
                                }
                                catch (Exception e) {
                                    Log.getCategory(2).logError(Log.getLocation(5).getLocation(), "Error in synchronizing the creation of http session " + sessionId + ".", e, this.context.getAliasName(), this.httpParameters.getRequest().getClientIP());
                                }
                                sleep = this.sessionServletContext.sessionIDlocks.contains((Object)sessionId);
                            }
                        }
                    }
                }
                try {
                    if (Log.isTracing()) {
                        this.traceDebug("getSession", "createSession = [" + createSession + "]");
                    }
                    if (createSession) {
                        applicationSession = new ApplicationSession(sessionId, this.sessionServletContext.getSessionTimeout(), this.httpParameters.getRequest().getClientIP(), this.context.getAliasName());
                        this.sessionServletContext.getSession().put(sessionId, applicationSession);
                        this.httpParameters.setDebugRequest(this.context.initializeDebugInfo(this.httpParameters, applicationSession));
                    } else {
                        applicationSession = (ApplicationSession)this.sessionServletContext.getSession().get(sessionId);
                    }
                    this.sessionAccessed = true;
                    this.httpParameters.setApplicationSession((Object)applicationSession);
                    Object var11_11 = null;
                    if (!this.reusedSessionCookie || !createSession) break block39;
                    object = this.sessionServletContext.sessionIdSynchObject;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (this.reusedSessionCookie && createSession) {
                        Object object3 = this.sessionServletContext.sessionIdSynchObject;
                        synchronized (object3) {
                            try {
                                this.sessionServletContext.sessionIDlocks.remove((Object)sessionId);
                                this.sessionServletContext.sessionIdSynchObject.notifyAll();
                            }
                            catch (Exception e) {
                                Log.getCategory(2).logError(Log.getLocation(5).getLocation(), "Error in synchronizing the creation of http session " + sessionId + ".", e, this.context.getAliasName(), this.httpParameters.getRequest().getClientIP());
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (object) {
                    try {
                        this.sessionServletContext.sessionIDlocks.remove((Object)sessionId);
                        this.sessionServletContext.sessionIdSynchObject.notifyAll();
                    }
                    catch (Exception e) {
                        Log.getCategory(2).logError(Log.getLocation(5).getLocation(), "Error in synchronizing the creation of http session " + sessionId + ".", e, this.context.getAliasName(), this.httpParameters.getRequest().getClientIP());
                    }
                }
            }
            if (applicationSession != null) {
                HttpCookie sCookie;
                if (!this.cookieSet && !this.context.getWebApplicationConfiguration().isURLSessionTracking() && (sCookie = this.httpParameters.getRequest().getSessionCookie(this.context.getWebApplicationConfiguration().isURLSessionTracking())) != null && sCookie.getName().equals("jsessionid")) {
                    this.response.addCookie(CookieParser.createSessionCookie((String)applicationSession.getId(), (String)this.httpParameters.getRequest().getHost(), (WebCookieConfig)this.context.getWebApplicationConfiguration().getSessionCookieConfig()));
                    this.response.setSessionCookie();
                }
                if (!this.sessionAccessed) {
                    applicationSession.accessed();
                    this.sessionAccessed = true;
                }
            }
        }
        if (!this.cookieSet) {
            this.sessionServletContext.addApplicationCookie(this.httpParameters);
            this.cookieSet = true;
        }
        if (Log.isTracing()) {
            this.tracePath("getSession", "return: [" + applicationSession + "]");
        }
        return applicationSession;
    }

    private String getSessionID(HttpParameters httpParameters) {
        HttpCookie sCookie = httpParameters.getRequest().getSessionCookie(this.context.getWebApplicationConfiguration().isURLSessionTracking());
        if (sCookie != null) {
            if (Log.isTracing()) {
                this.traceDebug("getSessionID", "request cookie: name = [" + sCookie.getName() + "], value = [" + sCookie.getValue() + "], cookie compatible: [" + SessionServletContext.isSessionCompatible(httpParameters, sCookie.getValue()) + "]");
            }
            if (SessionServletContext.isSessionCompatible(httpParameters, sCookie.getValue())) {
                this.reusedSessionCookie = true;
                if (sCookie.getName().charAt(0) == 'j' && !this.context.getWebApplicationConfiguration().isURLSessionTracking()) {
                    this.response.addCookie(CookieParser.createSessionCookie((String)sCookie.getValue(), (String)httpParameters.getRequest().getHost(), (WebCookieConfig)this.context.getWebApplicationConfiguration().getSessionCookieConfig()));
                    this.response.setSessionCookie();
                }
                if (Log.isTracing()) {
                    this.traceDebug("getSessionID", "return: [" + sCookie.getValue() + "]");
                }
                return sCookie.getValue();
            }
        }
        if (Log.isTracing()) {
            this.traceDebug("getSessionID", "response.isSessionCookieSet() = [" + this.response.isSessionCookieSet() + "]");
        }
        if (this.response.isSessionCookieSet()) {
            Object[] respCookies = this.response.cookies.toArray();
            int i = 0;
            while (i < respCookies.length) {
                HttpCookie httpCookie = (HttpCookie)respCookies[i];
                if (httpCookie.getName().equals("JSESSIONID")) {
                    if (SessionServletContext.isSessionCompatible(httpParameters, httpCookie.getValue())) {
                        if (Log.isTracing()) {
                            this.traceDebug("getSessionID", "return: [" + httpCookie.getValue() + "]");
                        }
                        return httpCookie.getValue();
                    }
                }
                ++i;
            }
        }
        String sessionId = this.sessionServletContext.generateSessionID(httpParameters);
        if (!this.context.getWebApplicationConfiguration().isURLSessionTracking() && !httpParameters.isSetSessionCookie()) {
            this.response.addCookie(CookieParser.createSessionCookie((String)sessionId, (String)httpParameters.getRequest().getHost(), (WebCookieConfig)this.context.getWebApplicationConfiguration().getSessionCookieConfig()));
            this.response.setSessionCookie();
            httpParameters.setSessionCookie(true);
        }
        if (Log.isTracing()) {
            this.traceDebug("getSessionID", "new cookie generated, return: [" + sessionId + "]");
        }
        return sessionId;
    }

    public BufferedReader getReader() throws IOException {
        if (this.getInputStream) {
            if (Log.isTracing()) {
                this.traceWarning("getReader", "getInputStream == true, throwing exception", false);
            }
            throw new WebIllegalStateException(WebIllegalStateException.Stream_is_already_taken_with_method, new Object[]{"getInputStream()"});
        }
        this.getReader = true;
        if (this.reader != null) {
            return this.reader;
        }
        if (this.httpParameters.getRequest().getBody() != null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.httpParameters.getRequest().getBody(), this.characterEncoding));
            return this.reader;
        }
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), this.characterEncoding));
        return this.reader;
    }

    public String getRemoteAddr() {
        byte[] b = ParseUtils.inetAddressByteToString((byte[])this.httpParameters.getRequest().getClientIP());
        char[] ch = new char[b.length];
        int i = 0;
        while (i < b.length) {
            ch[i] = (char)(b[i] & 0xFF);
            ++i;
        }
        return new String(ch);
    }

    public String getRemoteHost() {
        if (SBasic.webContainerProperties.resolveHostName()) {
            try {
                return InetAddress.getByName(this.getRemoteAddr()).getHostName();
            }
            catch (Exception ex) {
                return this.getRemoteAddr();
            }
        }
        return this.getRemoteAddr();
    }

    public String getRequestedSessionId() {
        HttpCookie cookie = this.httpParameters.getRequest().getSessionCookie(this.context.getWebApplicationConfiguration().isURLSessionTracking());
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            try {
                this.requestURI = this.httpParameters.getRequest().getRequestLine().getUrlNotDecoded().getBytes();
            }
            catch (ParseException e) {
                Log.getCategory(5).logError(Log.getLocation(5).getLocation(), "Error in parsing request URI.", e, this.sessionServletContext.getAliasName());
            }
        }
        char[] ch = new char[this.requestURI.length];
        int i = 0;
        while (i < ch.length) {
            ch[i] = (char)(this.requestURI[i] & 0xFF);
            ++i;
        }
        return new String(ch);
    }

    public abstract String getRequestURIinternal();

    protected void setRequestURI(String newURI) {
        this.requestURI = newURI.getBytes();
        this.requestURI_internal = newURI.getBytes();
    }

    protected String parseRequestURIinternal() {
        if (this.requestURI_internal == null) {
            this.requestURI_internal = this.httpParameters.getRequest().getRequestLine().getUrlDecoded().getBytes();
        }
        char[] ch = new char[this.requestURI_internal.length];
        int i = 0;
        while (i < ch.length) {
            ch[i] = (char)(this.requestURI_internal[i] & 0xFF);
            ++i;
        }
        return new String(ch);
    }

    protected String getClientRequestURIinternal() {
        byte[] url = this.httpParameters.getRequest().getRequestLine().getUrlDecoded().getBytes();
        char[] ch = new char[url.length];
        int i = 0;
        while (i < ch.length) {
            ch[i] = (char)(url[i] & 0xFF);
            ++i;
        }
        return new String(ch);
    }

    public String getServletPath() {
        if (this.servletPathIncluded != null) {
            return this.servletPathIncluded;
        }
        if (Log.isTracing()) {
            this.tracePath("getServletPath", "return: [" + this.httpParameters.getRequestPathMappings().getServletPath() + "]");
        }
        return this.httpParameters.getRequestPathMappings().getServletPath();
    }

    public void setServletPath(String servletPath) {
        this.servletPathIncluded = servletPath;
    }

    public String getRealPath(String path) {
        if (this.realPath == null) {
            this.realPath = new String(this.httpParameters.getRequestPathMappings().getRealPath());
        }
        if (!path.startsWith("/")) {
            String tempPath = (String)this.getAttribute("javax.servlet.include.realpath_path");
            if (tempPath != null) {
                if (Log.isTracing()) {
                    this.tracePath("getRealPath", "path = [" + path + "], return: [" + (tempPath + path).replace('/', File.separatorChar) + "]");
                }
                return (tempPath + path).replace('/', File.separatorChar);
            }
            if (Log.isTracing()) {
                this.tracePath("getRealPath", "path = [" + path + "], return: [" + (this.realPath + path).replace('/', File.separatorChar) + "]");
            }
            return (this.realPath + path).replace('/', File.separatorChar);
        }
        String temp = this.context.getServletContext().getRealPath(path);
        if (temp != null) {
            if (Log.isTracing()) {
                this.tracePath("getRealPath", "path = [" + path + "], return: [" + temp.replace('/', File.separatorChar) + "]");
            }
            return temp.replace('/', File.separatorChar);
        }
        if (Log.isTracing()) {
            this.tracePath("getRealPath", "path = [" + path + "], return: [null]");
        }
        return null;
    }

    public String getRealPathLocal(String path) {
        if (this.realPath == null) {
            byte[] data = this.httpParameters.getRequestPathMappings().getRealPath();
            char[] qch = new char[data.length];
            int i = 0;
            while (i < data.length) {
                qch[i] = (char)(data[i] & 0xFF);
                if (qch[i] == '/' || qch[i] == '\\') {
                    qch[i] = 47;
                }
                ++i;
            }
            this.realPath = new String(qch);
        }
        if (!path.startsWith("/")) {
            String tempPath = (String)this.getAttribute("javax.servlet.include.realpath_path");
            if (tempPath != null) {
                return ParseUtils.canonicalize((String)(tempPath + path).replace('/', '/').replace('\\', '/'));
            }
            return ParseUtils.canonicalize((String)(this.realPath + path).replace('/', '/').replace('\\', '/'));
        }
        return ParseUtils.canonicalize((String)this.context.getRealPathLocal(path, this.httpParameters.getRequestPathMappings().getAliasName().toString(), this.httpParameters.getRequestPathMappings().getAliasValue().toString()));
    }

    public boolean isRequestedSessionIdValid() {
        boolean result;
        boolean bl = result = this.getSession(false) != null;
        if (Log.isTracing()) {
            this.tracePath("isRequestedSessionIdValid", "return: [" + result + "]");
        }
        return result;
    }

    public boolean isRequestedSessionIdFromCookie() {
        HttpCookie sCookie = this.httpParameters.getRequest().getSessionCookie(this.context.getWebApplicationConfiguration().isURLSessionTracking());
        if (Log.isTracing()) {
            this.tracePath("isRequestedSessionIdFromCookie", "return: [" + (sCookie != null && "JSESSIONID".equals(sCookie.getName())) + "]");
        }
        return sCookie != null && "JSESSIONID".equals(sCookie.getName());
    }

    public boolean isRequestedSessionIdFromURL() {
        HttpCookie sCookie = this.httpParameters.getRequest().getSessionCookie(this.context.getWebApplicationConfiguration().isURLSessionTracking());
        if (Log.isTracing()) {
            this.tracePath("isRequestedSessionIdFromURL", "return: [" + (sCookie != null && "jsessionid".equals(sCookie.getName())) + "]");
        }
        return sCookie != null && "jsessionid".equals(sCookie.getName());
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
        this.sessionServletContext = context.getSessionServletContext();
        this.contextReplaced();
        if (Log.isTracing()) {
            // empty if block
        }
    }

    protected abstract void contextReplaced();

    protected Vector getLocalesVector() {
        return ProtocolParser.getLocalesVector((byte[])this.httpParameters.getRequest().getHeaders().getHeader(HeaderNames.request_header_accpet_lenguage_));
    }

    public boolean isSecure() {
        return this.httpParameters.getRequest().getRequestLine().isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        int indSep;
        if (path == null) {
            if (Log.isTracing()) {
                this.tracePath("getRequestDispatcher", "path = [" + path + "], return: [null]");
            }
            return null;
        }
        if (path.startsWith("/")) {
            RequestDispatcher requestDispatcher = this.context.getServletContext().getRequestDispatcher(path);
            if (Log.isTracing()) {
                this.tracePath("getRequestDispatcher", "path = [" + path + "], return: [" + requestDispatcher + "]");
            }
            return requestDispatcher;
        }
        String req = this.getRequestURIinternal();
        String alias = this.getContextPath();
        if (!alias.equals("")) {
            req = req.substring(req.indexOf(alias) + alias.length());
        }
        req = (indSep = req.lastIndexOf(47)) > 0 ? req.substring(0, indSep + 1) + path : "/" + path;
        RequestDispatcher requestDispatcher = this.context.getServletContext().getRequestDispatcher(req);
        if (Log.isTracing()) {
            this.tracePath("getRequestDispatcher", "path = [" + path + "], return: [" + requestDispatcher + "]");
        }
        return requestDispatcher;
    }

    public Enumeration getHeaders(String name) {
        String[] str = this.httpParameters.getRequest().getHeaders().getHeaders(name);
        if (str == null || str.length == 0) {
            return new Vector().elements();
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < str.length) {
            v.addElement(str[i]);
            ++i;
        }
        if (Log.isTracing()) {
            String atr = "";
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                atr = atr + en.nextElement() + ", ";
            }
            if (atr.endsWith(", ")) {
                atr = atr.substring(0, atr.length() - 2);
            }
            this.tracePath("getHeaders", "name = [" + name + "], return: [" + atr + "]");
        }
        return v.elements();
    }

    public String getContextPath() {
        String res = null;
        res = this.context.isDefault() ? "" : "/".concat(this.context.getAliasName());
        if (this.httpParameters.getRequestPathMappings().getZoneName() != null && !this.httpParameters.getRequestPathMappings().isZoneExactAlias()) {
            res = res + this.httpParameters.getHttpProperties().getZoneSeparator() + this.httpParameters.getRequestPathMappings().getZoneName();
        }
        return res;
    }

    public boolean isUserInRole(String role) {
        SecurityRoles[] secRole = this.sessionServletContext.getSecurityRoles();
        if (secRole == null) {
            if (Log.isTracing()) {
                this.tracePath("isUserInRole", "role = [" + role + "], return: [" + false + "]");
            }
            return false;
        }
        if (this.sessionServletContext.chekRoleToPid(role)) {
            if (Log.isTracing()) {
                this.tracePath("isUserInRole", "role = [" + role + "], return: [" + true + "]");
            }
            return true;
        }
        HashMapObjectObject links = this.context.getWebApplicationConfiguration().getServletRoles(this.currentServletName);
        if (links != null && links.containsKey((Object)role)) {
            boolean result = this.sessionServletContext.chekRoleToPid(((SecurityRoles)links.get((Object)role)).getRoleName());
            if (Log.isTracing()) {
                this.tracePath("isUserInRole", "role = [" + role + "], linked role = [" + links.get((Object)role) + "], return: [" + result + "]");
            }
            return result;
        }
        return false;
    }

    public Principal getUserPrincipal() {
        SecuritySession ss = ((SecurityContextObject)ApplicationContext.getSecurityContext()).getSession();
        if (ss != null && ss.getAuthenticationConfiguration() != null) {
            if (Log.isTracing()) {
                this.tracePath("getUserPrincipal", "return: [" + ss.getPrincipal() + "]");
            }
            return ss.getPrincipal();
        }
        if (Log.isTracing()) {
            this.tracePath("getUserPrincipal", "return: [" + null + "]");
        }
        return null;
    }

    public void setParam(String query) {
        if (!this.response.getIncluded()) {
            this.queryString = query;
        }
        this.queriesStack.push((Object)query);
        this.paramStack.push((Object)this.parameters);
        this.parameters = (HashMapObjectObject)this.parameters.clone();
        try {
            WebParseUtils.parseQueryString(this.parameters, query.getBytes(), this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            Log.getCategory(5).logWarning(Log.getLocation(5).getLocation(), "Unsupported character encoding found. Cannot parse the request parameters.", e, this.sessionServletContext.getAliasName());
        }
    }

    public void removeParam() {
        this.queriesStack.pop();
        this.parameters = (HashMapObjectObject)this.paramStack.pop();
        if (Log.isTracing()) {
            this.tracePath("removeParam", "parameters: [" + this.dumpParameters() + "]");
        }
        if (this.parameters == null) {
            this.parameters = new HashMapObjectObject();
            this.parametersParsed = false;
            this.queryStringParsed = false;
            this.queryString = null;
        }
    }

    public void setThreadClassLoader(ClassLoader threadLoader) {
        this.threadLoader = threadLoader;
    }

    public ClassLoader getThreadClassLoader() {
        return this.threadLoader;
    }

    public void setCurrentServletName(String servletName) {
        this.currentServletName = servletName;
        this.checkMappedSlashStar();
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (Log.isTracing()) {
            this.tracePath("setCharacterEncoding", "enc = [" + enc + "]");
        }
        if (enc == null || enc.equals("")) {
            throw new WebUnsupportedEncodingException(WebUnsupportedEncodingException.Trying_to_set_empty_encoding);
        }
        byte[] buffer = new byte[]{97};
        new String(buffer, enc);
        this.characterEncoding = enc;
        this.characterEncodingSet = true;
        this.parametersParsed = false;
        this.queryStringParsed = false;
        this.queryString = null;
        this.paramStack.clear();
    }

    protected String parseRequestURL() {
        if (this.context.getWebApplicationConfiguration().getRequestURLClientMode()) {
            return this.getScheme() + "://" + this.getServerName() + ":" + this.getServerPort() + this.getClientRequestURIinternal();
        }
        return this.getScheme() + "://" + this.getServerName() + ":" + this.getServerPort() + this.getRequestURIinternal();
    }

    public Map getParameterMap() {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        HashMap hash = new HashMap();
        Enumeration en = this.parameters.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            hash.put(key, this.parameters.get(key));
        }
        if (Log.isTracing()) {
            String atr = "";
            Enumeration params = this.parameters.keys();
            while (params.hasMoreElements()) {
                atr = atr + params.nextElement() + ", ";
            }
            if (atr.endsWith(", ")) {
                atr = atr.substring(0, atr.length() - 2);
            }
            this.tracePath("getParameterMap", "return: [" + atr + "], parameters: [" + this.dumpParameters() + "]");
        }
        return hash;
    }

    public String getJspPrecompile() {
        if (this.jspPrecompile == null && !this.parametersParsed) {
            String[] ar;
            if (this.getQueryString() != null) {
                try {
                    WebParseUtils.parseQueryString(this.parameters, this.getQueryString().getBytes(), this.characterEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    Log.getCategory(5).logWarning(Log.getLocation(5).getLocation(), "Unsupported character encoding found. Cannot parse the request parameters.", e, this.sessionServletContext.getAliasName());
                }
            }
            if ((ar = (String[])this.parameters.get((Object)"jsp_precompile")) != null) {
                this.jspPrecompile = ar[0];
            }
            this.parameters.clear();
            if (Log.isTracing()) {
                this.tracePath("getJspPrecompile", "parameters.clear");
            }
        }
        return this.jspPrecompile;
    }

    public void setJspFlag(boolean isJsp) {
        this.jspFlag = isJsp;
    }

    private void checkMappedSlashStar() {
        if (this.context.getWebMappings().getServletMappedSlashStar().equals(this.currentServletName)) {
            this.servletPathIncluded = "";
        }
    }

    private void parseEncoding() {
        this.characterEncoding = WebParseUtils.parseEncoding(this.httpParameters);
        if (this.characterEncoding == null || this.characterEncoding.equals("")) {
            this.characterEncoding = "ISO-8859-1";
        } else {
            this.characterEncodingSet = true;
        }
    }

    private void parseParameters() {
        this.parametersParsed = true;
        this.queryStringParsed = true;
        try {
            String[] ar;
            MultipartMessageImpl multipartMessage;
            if (this.queryString == null && this.httpParameters.getRequest().getRequestLine().getQuery() != null) {
                this.queryString = new String(this.httpParameters.getRequest().getRequestLine().getQuery().getBytes(), this.characterEncoding);
            }
            MessageBytes totalQuery = null;
            if (!this.queriesStack.isEmpty()) {
                totalQuery = new MessageBytes();
                Object[] queries = this.queriesStack.toArray();
                int i = 0;
                while (i < queries.length) {
                    if (totalQuery.length() == 0) {
                        totalQuery.appendAfter(((String)queries[i]).getBytes());
                    } else {
                        totalQuery.appendAfter(("&" + (String)queries[i]).getBytes());
                    }
                    ++i;
                }
            }
            if (this.httpParameters.getRequest().getRequestLine().getQuery() != null) {
                if (totalQuery == null || totalQuery.length() == 0) {
                    totalQuery = this.httpParameters.getRequest().getRequestLine().getQuery();
                } else {
                    totalQuery.appendAfter("&".getBytes());
                    totalQuery.appendAfter(this.httpParameters.getRequest().getRequestLine().getQuery().getBytes());
                }
            }
            this.parameters.clear();
            if (Log.isTracing()) {
                this.tracePath("parseParameters", "parameters.clear");
            }
            if (totalQuery == null) {
                WebParseUtils.parseParameters(this.parameters, this.httpParameters, null, this.characterEncoding);
            } else {
                WebParseUtils.parseParameters(this.parameters, this.httpParameters, totalQuery.getBytes(), this.characterEncoding);
            }
            if (Log.isTracing()) {
                this.tracePath("parseParameters", "parameters: [" + this.dumpParameters() + "]");
            }
            if (SBasic.webContainerProperties.getMultipartBodyParameterName() != null && (multipartMessage = (MultipartMessageImpl)this.getAttribute(SBasic.webContainerProperties.getMultipartBodyParameterName())) != null && multipartMessage.isFormParametersToRequest()) {
                String content_type = this.getContentType();
                int scInd = content_type.indexOf(59);
                if (scInd > -1) {
                    content_type = content_type.substring(0, scInd);
                }
                if ((scInd = content_type.indexOf(47)) > -1 && scInd < content_type.length() - 1) {
                    content_type = content_type.substring(scInd + 1);
                }
                if ("form-data".equalsIgnoreCase(content_type)) {
                    try {
                        Enumeration en = multipartMessage.getBodyParts();
                        while (en.hasMoreElements()) {
                            MultipartPart nextPart = (MultipartPart)en.nextElement();
                            if (!nextPart.isFormParameter()) continue;
                            String[] ar2 = (String[])this.parameters.get((Object)nextPart.getName());
                            if (ar2 == null) {
                                this.parameters.put((Object)nextPart.getName(), (Object)new String[]{new String(nextPart.getBody(), this.characterEncoding)});
                                continue;
                            }
                            String[] arTmp = new String[ar2.length + 1];
                            System.arraycopy(ar2, 0, arTmp, 0, ar2.length);
                            arTmp[ar2.length] = new String(nextPart.getBody(), this.characterEncoding);
                            this.parameters.put((Object)nextPart.getName(), (Object)arTmp);
                        }
                    }
                    catch (IOException e) {
                        Log.getCategory(5).logError(Log.getLocation(5).getLocation(), "Cannot parse form based parameters from multipart request.", e, this.context.getAliasName(), this.httpParameters.getRequest().getClientIP());
                    }
                    catch (MultipartParseException e) {
                        Log.getCategory(5).logError(Log.getLocation(5).getLocation(), "Cannot parse form based parameters from multipart request.", e, this.context.getAliasName(), this.httpParameters.getRequest().getClientIP());
                    }
                }
            }
            if ((ar = (String[])this.parameters.get((Object)"jsp_precompile")) != null) {
                this.jspPrecompile = ar[0];
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.getCategory(5).logWarning(Log.getLocation(5).getLocation(), "Can't parse the parameters of the request. Incorrect encoding specified in it: " + this.characterEncoding + ".", e, this.sessionServletContext.getAliasName());
        }
    }

    private String dumpParameters() {
        String res = "";
        if (this.parameters == null) {
            return res;
        }
        Object[] keys = this.parameters.getAllKeys();
        int i = 0;
        while (keys != null && i < keys.length) {
            res = res + "[" + keys[i] + " = ";
            String[] values = (String[])this.parameters.get(keys[i]);
            int j = 0;
            while (j < values.length) {
                res = res + values[j] + ", ";
                ++j;
            }
            if (res.endsWith(", ")) {
                res = res.substring(0, res.length() - 2);
            }
            res = res + "], ";
            ++i;
        }
        if (res.endsWith(", ")) {
            res = res.substring(0, res.length() - 2);
        }
        return res;
    }

    protected void trace(String method, String msg) {
        Log.getLocation(6).trace("client [" + this.httpParameters.getRequest().getClientId() + "] HttpServletRequest." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg, this.context.getAliasName());
    }

    protected void traceError(String method, String msg, Throwable t) {
        Log.getLocation(6).traceError("client [" + this.httpParameters.getRequest().getClientId() + "] HttpServletRequest." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg + ". ERROR: " + Log.getExceptionStackTrace(t), this.context.getAliasName());
    }

    protected void traceWarning(String method, String msg, boolean logTrace) {
        if (logTrace) {
            msg = Log.getExceptionStackTrace(new Exception(msg));
        }
        Log.getLocation(6).traceWarning("client [" + this.httpParameters.getRequest().getClientId() + "] HttpServletRequest." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg, this.context.getAliasName());
    }

    protected void traceInfo(String method, String msg) {
        Log.getLocation(6).traceInfo("client [" + this.httpParameters.getRequest().getClientId() + "] HttpServletRequest." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg, this.context.getAliasName());
    }

    protected void tracePath(String method, String msg) {
        Log.getLocation(6).tracePath("client [" + this.httpParameters.getRequest().getClientId() + "] HttpServletRequest." + method + " [" + this.getObjectInstance() + "] in application [" + this.context.getAliasName() + "]: " + msg, this.context.getAliasName());
    }

    protected void traceDebug(String method, String msg) {
        this.trace(method, msg);
    }

    private String getObjectInstance() {
        String instance = super.toString();
        return instance.substring(instance.indexOf(64) + 1);
    }

    public abstract boolean isRequestedSessionIdFromUrl();

    public abstract HttpSession getSession();

    public abstract StringBuffer getRequestURL();

    public abstract String getPathInfo();

    public abstract Enumeration getLocales();

    public abstract Locale getLocale();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public abstract Enumeration getAttributeNames();

    public abstract Object getAttribute(String var1);
}

