/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.client;

import com.sap.engine.lib.util.ConcurrentReadHashMap;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.interfaces.client.SslAttributes;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.servlets_jsp.lib.multipart.impl.MultipartMessageImpl;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.engine.services.servlets_jsp.server.lib.DefaultLocaleEnumeration;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestImpl;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletResponseFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class HttpServletRequestFacade
extends HttpServletRequestImpl {
    private static final byte[] multipart_sl = "multipart/".getBytes();
    public static final String ZONE_SEPARATOR = "com.sap.servlet.separator.zone";
    public static final String REQUEST_ALIAS = "com.sap.servlet.request.alias";
    public static final String REQUEST_ZONE = "com.sap.servlet.request.zone";
    private ConcurrentReadHashMap attributes = new ConcurrentReadHashMap(16);
    private int contentLength = -1;
    private boolean contentLengthParsed = false;
    private String contentType = null;
    private boolean contentTypeParsed = false;
    private String protocol = null;
    private boolean protocolParsed = false;
    private String serverName = null;
    private boolean serverNameParsed = false;
    private int serverPort = -1;
    private boolean serverPortParsed = false;
    private String remoteAddr = null;
    private boolean remoteAddrParsed = false;
    private String remoteHost = null;
    private boolean remoteHostParsed = false;
    private Locale locale = null;
    private boolean localeParsed = false;
    private Vector locales = null;
    private boolean localesParsed = false;
    private boolean isSecure = false;
    private boolean isSecureParsed = false;
    private Cookie[] cookies = null;
    private boolean cookiesParsed = false;
    private String method = null;
    private boolean methodParsed = false;
    private String pathInfo = null;
    private boolean pathInfoParsed = false;
    private boolean pathInfoSet = false;
    private String pathTranslated = null;
    private boolean pathTranslatedParsed = false;
    private String contextPath = null;
    private boolean contextPathParsed = false;
    private String requestedSessionId = null;
    private boolean requestedSessionIdParsed = false;
    private String requestURI = null;
    private boolean requestURIParsed = false;
    private String requestURIinternal = null;
    private boolean requestURIinternalParsed = false;
    private String requestURL = null;
    private boolean requestURLParsed = false;
    private boolean isRequestedSessionIdFromCookie = false;
    private boolean isRequestedSessionIdFromCookieParsed = false;
    private boolean isRequestedSessionIdFromURL = false;
    private boolean isRequestedSessionIdFromURLParsed = false;

    public void setContext(ApplicationContext context) {
        super.setContext(context);
    }

    public void init(HttpParameters httpParameters, HttpServletResponseFacade response) {
        SslAttributes sslAttributes;
        super.init(httpParameters, response);
        if (SBasic.webContainerProperties.getMultipartBodyParameterName() != null) {
            byte[] contentType = httpParameters.getRequest().getHeaders().getHeader(HeaderNames.entity_header_content_type_);
            if (ByteArrayUtils.startsWith((byte[])(contentType = ByteArrayUtils.trim((byte[])contentType)), (byte[])multipart_sl)) {
                try {
                    this.attributes.put((Object)SBasic.webContainerProperties.getMultipartBodyParameterName(), (Object)new MultipartMessageImpl((InputStream)this.getInputStreamNoCheck(), new String(contentType), this));
                }
                catch (IOException io) {
                    Log.getCategory(5).logError(Log.getLocation(6).getLocation(), "Error initializing Http Servlet request object. Cannot read multipart request body", io, response.getServletContext().getAliasName(), httpParameters.getRequest().getClientIP());
                }
            }
        }
        if (httpParameters.getRequestAttributes() != null) {
            Enumeration en = httpParameters.getRequestAttributes().keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                this.attributes.put((Object)key, httpParameters.getRequestAttributes().get(key));
            }
        }
        if (httpParameters.getHttpProperties().getZoneSeparator() != null) {
            this.attributes.put((Object)ZONE_SEPARATOR, (Object)httpParameters.getHttpProperties().getZoneSeparator());
        }
        if (httpParameters.getRequestPathMappings().getZoneName() != null) {
            this.attributes.put((Object)REQUEST_ALIAS, (Object)httpParameters.getRequestPathMappings().getAliasName());
            this.attributes.put((Object)REQUEST_ZONE, (Object)httpParameters.getRequestPathMappings().getZoneName());
        }
        if ((sslAttributes = httpParameters.getRequest().getSslAttributes()) == null || sslAttributes.getCertificates() == null) {
            if (Log.isTracing()) {
                String atr = "";
                Object[] keys = this.attributes.getAllKeys();
                int i = 0;
                while (keys != null && i < keys.length) {
                    atr = atr + keys[i] + " = " + this.attributes.get(keys[i]) + ", ";
                    ++i;
                }
                if (atr.endsWith(", ")) {
                    atr = atr.substring(0, atr.length() - 2);
                }
                this.tracePath("init", "new request initialized, attributes: [" + atr + "], url: [" + httpParameters.getRequest().getRequestLine().getRequestLine() + "]");
            }
            return;
        }
        if (sslAttributes.getCertificates().length > 0) {
            this.attributes.put((Object)"javax.servlet.request.X509Certificate", (Object)sslAttributes.getCertificates());
        }
        int keySize = sslAttributes.getKeySize();
        String cipherSuite = sslAttributes.getCipherSuite();
        if (cipherSuite != null) {
            this.attributes.put((Object)"javax.servlet.request.cipher_suite", (Object)cipherSuite);
            if (keySize <= 0) {
                int c = 0;
                while (c < Constants.cipherPhrase.length) {
                    if (cipherSuite.indexOf(Constants.cipherPhrase[c]) != -1) {
                        keySize = Constants.cipherSize[c];
                    }
                    ++c;
                }
            }
        }
        if (keySize > -1) {
            this.attributes.put((Object)"javax.servlet.request.key_size", (Object)new Integer(keySize));
        }
        if (Log.isTracing()) {
            String atr = "";
            Object[] keys = this.attributes.getAllKeys();
            int i = 0;
            while (keys != null && i < keys.length) {
                atr = atr + keys[i] + " = " + this.attributes.get(keys[i]) + ", ";
                ++i;
            }
            if (atr.endsWith(", ")) {
                atr = atr.substring(0, atr.length() - 2);
            }
            this.tracePath("init", "new request initialized, attributes: [" + atr + "], url: [" + httpParameters.getRequest().getRequestLine().getRequestLine() + "]");
        }
    }

    public void reset() {
        super.reset();
        this.attributes.clear();
        this.contentLength = -1;
        this.contentLengthParsed = false;
        this.contentType = null;
        this.contentTypeParsed = false;
        this.protocol = null;
        this.protocolParsed = false;
        this.serverName = null;
        this.serverNameParsed = false;
        this.serverPort = -1;
        this.serverPortParsed = false;
        this.remoteAddr = null;
        this.remoteAddrParsed = false;
        this.remoteHost = null;
        this.remoteHostParsed = false;
        this.locale = null;
        this.localeParsed = false;
        this.locales = null;
        this.localesParsed = false;
        this.isSecure = false;
        this.isSecureParsed = false;
        this.cookies = null;
        this.cookiesParsed = false;
        this.method = null;
        this.methodParsed = false;
        this.pathInfo = null;
        this.pathInfoParsed = false;
        this.pathInfoSet = false;
        this.pathTranslated = null;
        this.pathTranslatedParsed = false;
        this.contextPath = null;
        this.contextPathParsed = false;
        this.requestedSessionId = null;
        this.requestedSessionIdParsed = false;
        this.requestURI = null;
        this.requestURIParsed = false;
        this.requestURIinternal = null;
        this.requestURIinternalParsed = false;
        this.requestURL = null;
        this.requestURLParsed = false;
        this.isRequestedSessionIdFromCookie = false;
        this.isRequestedSessionIdFromCookieParsed = false;
        this.isRequestedSessionIdFromURL = false;
        this.isRequestedSessionIdFromURLParsed = false;
    }

    protected void contextReplaced() {
        this.cookiesParsed = false;
        this.requestedSessionIdParsed = false;
        this.pathTranslatedParsed = false;
        this.isRequestedSessionIdFromCookieParsed = false;
        this.isRequestedSessionIdFromURLParsed = false;
        this.contextPathParsed = false;
    }

    public Object getAttribute(String s) {
        Object result = this.attributes.get((Object)s);
        if (Log.isTracing()) {
            this.traceDebug("getAttribute", "name = [" + s + "], result = [" + result + "]");
        }
        return result;
    }

    public Enumeration getAttributeNames() {
        if (Log.isTracing()) {
            String atr = "";
            Object[] keys = this.attributes.getAllKeys();
            int i = 0;
            while (keys != null && i < keys.length) {
                atr = atr + keys[i] + ", ";
                ++i;
            }
            if (atr.endsWith(", ")) {
                atr = atr.substring(0, atr.length() - 2);
            }
            this.tracePath("getAttributeNames", "result: [" + atr + "]");
        }
        return this.attributes.keys();
    }

    public void setAttribute(String s, Object obj) {
        if (Log.isTracing()) {
            this.traceDebug("setAttribute", "name = [" + s + "], value = [" + obj + "]");
        }
        if (obj == null) {
            this.removeAttribute(s);
            return;
        }
        this.attributes.put((Object)s, obj);
    }

    public void removeAttribute(String s) {
        if (Log.isTracing()) {
            this.traceDebug("removeAttribute", "name = [" + s + "]");
        }
        this.attributes.remove((Object)s);
    }

    public int getContentLength() {
        if (!this.contentLengthParsed) {
            this.contentLength = super.getContentLength();
            this.contentLengthParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getContentLength", "contentLength = [" + this.contentLength + "]");
        }
        return this.contentLength;
    }

    public String getContentType() {
        if (!this.contentTypeParsed) {
            this.contentType = super.getContentType();
            this.contentTypeParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getContentType", "contentType = [" + this.contentType + "]");
        }
        return this.contentType;
    }

    public String getProtocol() {
        if (!this.protocolParsed) {
            this.protocol = super.getProtocol();
            this.protocolParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getProtocol", "protocol = [" + this.protocol + "]");
        }
        return this.protocol;
    }

    public String getServerName() {
        if (!this.serverNameParsed) {
            this.serverName = super.getServerName();
            this.serverNameParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getServerName", "serverName = [" + this.serverName + "]");
        }
        return this.serverName;
    }

    public int getServerPort() {
        if (!this.serverPortParsed) {
            this.serverPort = super.getServerPort();
            this.serverPortParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getServerPort", "serverPort = [" + this.serverPort + "]");
        }
        return this.serverPort;
    }

    public String getRemoteAddr() {
        if (!this.remoteAddrParsed) {
            this.remoteAddr = super.getRemoteAddr();
            this.remoteAddrParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getRemoteAddr", "remoteAddr = [" + this.remoteAddr + "]");
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (!this.remoteHostParsed) {
            this.remoteHost = super.getRemoteHost();
            this.remoteHostParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getRemoteHost", "remoteHost = [" + this.remoteHost + "]");
        }
        return this.remoteHost;
    }

    public Locale getLocale() {
        if (!this.localeParsed) {
            this.locales = super.getLocalesVector();
            this.localesParsed = true;
            this.localeParsed = true;
            this.locale = this.locales == null ? Locale.getDefault() : (Locale)this.getLocales().nextElement();
        }
        if (Log.isTracing()) {
            this.traceDebug("getLocale", "locale = [" + this.locale + "]");
        }
        return this.locale;
    }

    public Enumeration getLocales() {
        if (!this.localesParsed) {
            this.locales = super.getLocalesVector();
            this.localesParsed = true;
        }
        if (this.locales == null) {
            return new DefaultLocaleEnumeration();
        }
        if (Log.isTracing()) {
            String res = "";
            Object[] keys = this.attributes.getAllKeys();
            int i = 0;
            while (keys != null && i < keys.length) {
                res = res + keys[i] + ", ";
                ++i;
            }
            if (res.endsWith(", ")) {
                res = res.substring(0, res.length() - 2);
            }
            this.traceDebug("getLocales", "return: [" + res + "]");
        }
        return this.locales.elements();
    }

    public boolean isSecure() {
        if (!this.isSecureParsed) {
            this.isSecure = super.isSecure();
            this.isSecureParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("isSecure", "isSecure = [" + this.isSecure + "]");
        }
        return this.isSecure;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.cookies = super.getCookies();
            this.cookiesParsed = true;
        }
        if (Log.isTracing()) {
            String res = "";
            int i = 0;
            while (this.cookies != null && i < this.cookies.length) {
                res = this.cookies[i] == null ? res + this.cookies[i] + ", " : res + this.cookies[i].getName() + " = " + this.cookies[i].getValue() + ", ";
                ++i;
            }
            if (res.endsWith(", ")) {
                res = res.substring(0, res.length() - 2);
            }
            this.traceDebug("getCookies", "return: [" + this.isSecure + "]");
        }
        return this.cookies;
    }

    public String getMethod() {
        if (!this.methodParsed) {
            this.method = super.getMethod();
            this.methodParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getMethod", "method = [" + this.method + "]");
        }
        return this.method;
    }

    public String getPathInfo() {
        if (!this.pathInfoParsed) {
            this.pathInfo = super.parsePathInfo(this.pathInfoSet, this.pathInfo);
            this.pathInfoParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getPathInfo", "pathInfo = [" + this.pathInfo + "]");
        }
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfoSet = true;
        this.pathInfo = pathInfo;
        this.pathInfoParsed = false;
    }

    public String getPathTranslated() {
        if (!this.pathTranslatedParsed || !this.pathInfoParsed) {
            this.pathTranslated = super.getPathTranslated();
            this.pathTranslatedParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getPathTranslated", "pathTranslated = [" + this.pathTranslated + "]");
        }
        return this.pathTranslated;
    }

    public String getContextPath() {
        if (!this.contextPathParsed) {
            this.contextPath = super.getContextPath();
            this.contextPathParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getContextPath", "contextPath = [" + this.contextPath + "]");
        }
        return this.contextPath;
    }

    public String getRequestedSessionId() {
        if (!this.requestedSessionIdParsed) {
            this.requestedSessionId = super.getRequestedSessionId();
            this.requestedSessionIdParsed = false;
        }
        if (Log.isTracing()) {
            this.traceDebug("getRequestedSessionId", "requestedSessionId = [" + this.requestedSessionId + "]");
        }
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        if (!this.requestURIParsed) {
            this.requestURI = super.getRequestURI();
            this.requestURIParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getRequestURI", "requestURI = [" + this.requestURI + "]");
        }
        return this.requestURI;
    }

    public String getRequestURIinternal() {
        if (!this.requestURIinternalParsed) {
            this.requestURIinternal = super.parseRequestURIinternal();
            this.requestURIinternalParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getRequestURIinternal", "requestURIinternal = [" + this.requestURIinternal + "]");
        }
        return this.requestURIinternal;
    }

    public void setRequestURI(String newURI) {
        this.requestURIParsed = false;
        this.requestURIinternalParsed = false;
        super.setRequestURI(newURI);
    }

    public StringBuffer getRequestURL() {
        if (!this.requestURLParsed || !this.requestURIinternalParsed) {
            this.requestURL = super.parseRequestURL();
            this.requestURLParsed = true;
        }
        if (Log.isTracing()) {
            this.traceDebug("getRequestURL", "requestURL = [" + this.requestURL + "]");
        }
        return new StringBuffer(this.requestURL);
    }

    public HttpSession getSession() {
        HttpSession httpSession = this.getSession(true);
        if (Log.isTracing()) {
            this.traceDebug("getSession", "httpSession = [" + httpSession + "]");
        }
        return httpSession;
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (!this.isRequestedSessionIdFromCookieParsed) {
            this.isRequestedSessionIdFromCookie = super.isRequestedSessionIdFromCookie();
            this.isRequestedSessionIdFromCookieParsed = true;
        }
        return this.isRequestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (!this.isRequestedSessionIdFromURLParsed) {
            this.isRequestedSessionIdFromURL = super.isRequestedSessionIdFromURL();
            this.isRequestedSessionIdFromURLParsed = true;
        }
        return this.isRequestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }
}

