/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.client;

import com.sap.engine.lib.io.GZIPMultiOutputStream;
import com.sap.engine.services.httpserver.server.properties.HttpCompressedProperties;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIOException;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletResponseFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ServletOutputStreamImpl;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class GzipResponseStream
extends ServletOutputStream {
    private GZIPMultiOutputStream gzipmultistream = new GZIPMultiOutputStream();
    private ServletOutputStreamImpl servletoutput = null;
    private boolean markedClosed = false;
    private boolean closed = false;
    private int count = 0;
    private byte[] buf = null;
    private HttpServletResponseFacade response = null;
    private HttpCompressedProperties gzipProperties = null;
    private boolean gzipStreamInitialized = false;
    private boolean bufferFlushed = false;
    private boolean gzipMode = true;
    private boolean gzipHeaderFound = false;

    public GzipResponseStream(HttpServletResponseFacade response, ServletOutputStreamImpl output) throws IOException {
        this.servletoutput = output;
        this.response = response;
        this.buf = new byte[0];
        this.gzipHeaderFound = false;
    }

    public void init() {
        this.gzipProperties = this.response.getHttpParameters().getCommpressedProperties();
        if (this.gzipProperties.getMinGZipLength() <= 0) {
            this.buf = new byte[0];
        } else if (this.buf.length != this.gzipProperties.getMinGZipLength()) {
            this.buf = new byte[this.gzipProperties.getMinGZipLength()];
        }
        this.gzipStreamInitialized = false;
        this.markedClosed = false;
        this.closed = false;
        this.count = 0;
        this.bufferFlushed = false;
        this.gzipMode = true;
        this.gzipHeaderFound = false;
        this.servletoutput.clear();
    }

    public boolean isWrittenAnything() {
        return this.count > 0;
    }

    public void setBufferSize(int bufSize) {
        this.servletoutput.setBufferSize(bufSize);
    }

    public void clear() throws IOException {
        if (this.closed) {
            throw new WebIOException("servlet_jsp_0022");
        }
        if (!this.bufferFlushed) {
            this.count = 0;
            return;
        }
        if (this.gzipMode && this.gzipStreamInitialized) {
            this.gzipmultistream.addStream((OutputStream)((Object)this.servletoutput), this.gzipProperties.getGZipDeflaterConstructor(), this.gzipProperties.getGZipCRC32Constructor());
        } else {
            this.servletoutput.clear();
        }
        this.count = 0;
    }

    public void close() throws IOException {
        this.closed = true;
        this.setLength();
        this.flushNotZippedBuffer();
        if (this.gzipMode) {
            if (this.count > 0) {
                this.ensureGzipStreamInitialized();
                this.gzipmultistream.close((OutputStream)((Object)this.servletoutput));
            }
        } else {
            this.servletoutput.close();
        }
    }

    protected void markClosed() {
        this.markedClosed = true;
    }

    public void flush() throws IOException {
        if (this.markedClosed) {
            if (this.count == 0) {
                this.response.removeHeader("Content-Encoding");
            }
        } else {
            this.flushNotZippedBuffer();
            if (this.gzipMode) {
                if (this.count > 0) {
                    this.ensureGzipStreamInitialized();
                    this.gzipmultistream.flush((OutputStream)((Object)this.servletoutput));
                }
            } else {
                this.servletoutput.flush();
            }
        }
    }

    private void setLength() {
        this.servletoutput.setContentLengthInFlush();
        if (this.count == 0) {
            this.servletoutput.setEmpty();
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new WebIOException("servlet_jsp_0022");
        }
        if (!this.bufferFlushed && this.count < this.buf.length) {
            this.buf[this.count++] = (byte)(b & 0xFF);
            return;
        }
        this.flushNotZippedBuffer();
        if (this.gzipMode) {
            this.ensureGzipStreamInitialized();
            this.gzipmultistream.write((OutputStream)((Object)this.servletoutput), b);
        } else {
            this.servletoutput.write(b);
        }
        ++this.count;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new WebIOException("servlet_jsp_0022");
        }
        if (len <= 0) {
            return;
        }
        if (!this.bufferFlushed && this.count + len <= this.buf.length) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
            return;
        }
        this.flushNotZippedBuffer();
        if (this.gzipMode) {
            this.ensureGzipStreamInitialized();
            this.gzipmultistream.write((OutputStream)((Object)this.servletoutput), b, off, len);
        } else {
            this.servletoutput.write(b, off, len);
        }
        this.count += len;
    }

    public void setContentLength(int len) {
    }

    private void flushNotZippedBuffer() throws IOException {
        if (this.bufferFlushed) {
            return;
        }
        this.bufferFlushed = true;
        this.initWillGzip();
        if (!this.gzipHeaderFound && this.gzipProperties.getMinGZipLength() > 0 && this.gzipMode && this.closed && this.count < this.gzipProperties.getMinGZipLength()) {
            this.gzipMode = false;
        }
        if (this.gzipMode) {
            this.response.removeHeader("Content-Length");
            this.response.addHeaderContentEncoding("gzip");
        } else {
            this.servletoutput.clear();
        }
        if (this.count != 0) {
            if (this.gzipMode) {
                this.ensureGzipStreamInitialized();
                this.gzipmultistream.write((OutputStream)((Object)this.servletoutput), this.buf, 0, this.count);
            } else {
                this.servletoutput.write(this.buf, 0, this.count);
            }
        }
    }

    private void initWillGzip() {
        if (SBasic.webContainerProperties.headerForNoCompression() != null && SBasic.webContainerProperties.headerForNoCompression().length() > 0 && this.response.containsHeader(SBasic.webContainerProperties.headerForNoCompression())) {
            this.gzipMode = false;
        } else if (SBasic.webContainerProperties.headerForCompression() != null && SBasic.webContainerProperties.headerForCompression().length() > 0 && this.response.containsHeader(SBasic.webContainerProperties.headerForCompression())) {
            this.gzipMode = true;
            this.gzipHeaderFound = true;
        } else {
            this.gzipMode = this.gzipProperties.isGzip(null, this.response.getHeader("Content-Type"));
        }
    }

    private void ensureGzipStreamInitialized() throws IOException {
        if (!this.gzipStreamInitialized) {
            this.gzipStreamInitialized = true;
            this.gzipmultistream.addStream((OutputStream)((Object)this.servletoutput), this.gzipProperties.getGZipDeflaterConstructor(), this.gzipProperties.getGZipCRC32Constructor());
        }
    }
}

