/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.client;

import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.interfaces.security.SessionListener;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.lib.util.ConcurrentReadHashMap;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.InvalidSessionException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalStateException;
import com.sap.engine.services.servlets_jsp.server.lib.EmptyEnumeration;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.io.Serializable;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class ApplicationSession
implements HttpSession,
SessionListener,
Serializable,
Cloneable {
    static final long serialVersionUID = 4555053332739791302L;
    private ConcurrentHashMapObjectObject values = new ConcurrentHashMapObjectObject();
    private String id = null;
    private long creationTime = -1L;
    private long thisAccessTime = -1L;
    private long lastAccessed = -1L;
    private int inactiveInterval = -1;
    private boolean valid = false;
    private ConcurrentHashMapObjectObject secValues = new ConcurrentHashMapObjectObject();
    private String contextName = null;
    private boolean isFirst = true;
    private boolean formLoginBodyParameters = false;
    private boolean invalidatedByApplication = false;
    private String debugParameterValue = null;

    public ApplicationSession(String s, int timeOut, byte[] clientIP, String contextName) {
        this.thisAccessTime = this.creationTime = System.currentTimeMillis();
        this.lastAccessed = this.creationTime;
        this.inactiveInterval = timeOut;
        this.valid = true;
        this.id = s;
        this.secValues.put((Object)"clientIP", (Object)clientIP);
        this.contextName = contextName;
        if (this.getServletContextFacade() != null) {
            this.getServletContextFacade().getWebEvents().sessionCreated(this);
        }
        if (Log.isTracing()) {
            this.trace(7, "<new>", "inactiveInterval = [" + this.inactiveInterval + "].");
        }
    }

    public void sessionDeserialized() {
        if (Log.isTracing()) {
            this.traceInfo(7, "sessionDeserialized", "");
        }
    }

    void accessed() {
        if (Log.isTracing()) {
            this.trace(7, "accessed", "lastAccessed = [" + this.lastAccessed + "], thisAccessTime = [" + this.thisAccessTime + "].");
        }
        this.lastAccessed = this.thisAccessTime;
        this.thisAccessTime = System.currentTimeMillis();
        this.validate();
    }

    private void validate() {
        long currenttime;
        double i;
        if (!this.valid) {
            return;
        }
        if (this.inactiveInterval != -1 && (i = (double)((currenttime = System.currentTimeMillis()) - this.lastAccessed) / 1000.0) > (double)this.inactiveInterval) {
            this.invalidateSession();
        }
    }

    public boolean isValidSession() {
        long i;
        if (this.valid && (i = (System.currentTimeMillis() - this.lastAccessed) / 1000L) > (long)this.inactiveInterval && this.inactiveInterval != -1) {
            this.invalidateSession();
        }
        return this.valid;
    }

    public String getId() {
        if (Log.isTracing()) {
            this.traceDebug(7, "getId", "");
        }
        return this.id;
    }

    public long getCreationTime() {
        if (Log.isTracing()) {
            this.traceDebug(7, "getCreationTime", "creationTime = [" + this.creationTime + "], valid = [" + this.valid + "].");
        }
        if (this.valid) {
            return this.creationTime;
        }
        throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"getCreationTime()"});
    }

    public HttpSessionContext getSessionContext() {
        if (Log.isTracing()) {
            this.traceDebug(7, "getSessionContext<deprecated>", "result: [null].");
        }
        return null;
    }

    public long getLastAccessedTime() {
        if (Log.isTracing()) {
            this.traceDebug(7, "getLastAccessedTime", "lastAccessed = [" + this.lastAccessed + "]");
        }
        return this.lastAccessed;
    }

    public void invalidate() {
        if (!this.valid) {
            if (Log.isTracing()) {
                this.traceDebug(7, "invalidate", "session is not valid!");
            }
            throw new InvalidSessionException(WebIllegalStateException.Session_already_invalidated);
        }
        this.invalidatedByApplication = true;
        this.invalidateSession();
    }

    public void passivate() {
        ApplicationContext scf;
        if (Log.isTracing()) {
            this.trace(7, "invalidateSession", "invalidatedByApplication = [" + this.invalidatedByApplication + "].");
        }
        if ((scf = (ApplicationContext)SBasic.startedWebApplications.get(new MessageBytes(this.contextName.getBytes()))) == null) {
            this.traceWarning(7, "invalidateSession", "session's application [" + this.contextName + "] not started.");
            return;
        }
        scf.getSessionServletContext().getSession().remove(this.id);
        this.valid = false;
        if (scf.getSessionServletContext().getPolicyDomain().removeMe(this)) {
            if (Log.isTracing()) {
                this.tracePath(7, "invalidateSession", "invalidating security session.");
            }
            if (scf.getWebMonitoring().isMonitoringStarted()) {
                scf.getWebMonitoring().securitySessionInvalidated(this.invalidatedByApplication);
            }
        }
    }

    private void invalidateSession() {
        ApplicationContext scf;
        if (Log.isTracing()) {
            this.trace(7, "invalidateSession", "invalidatedByApplication = [" + this.invalidatedByApplication + "].");
        }
        if ((scf = (ApplicationContext)SBasic.startedWebApplications.get(new MessageBytes(this.contextName.getBytes()))) == null) {
            this.traceWarning(7, "invalidateSession", "session's application [" + this.contextName + "] not started.");
            return;
        }
        ResourceContext resourceContext = scf.enterResourceContext();
        scf.getSessionServletContext().getSession().remove(this.id);
        if (scf.getWebMonitoring().isMonitoringStarted()) {
            scf.getWebMonitoring().sessionInvalidated(this.invalidatedByApplication);
        }
        try {
            if (0 != this.getServletContextFacade().getWebApplicationConfiguration().getFailOverEnableInt()) {
                if (Log.isTracing()) {
                    this.tracePath(7, "invalidateSession", "deleting the session from failover.");
                }
                if (SBasic.failoverPersistentStorage != null) {
                    SBasic.failoverPersistentStorage.deleteSession(this.contextName, this.id);
                } else {
                    Log.getCategory(4).logError(Log.getLocation(7).getLocation(), "Cannot delete session from the failover storage when the session is invalidated, because the failover service is not currently available.", this.contextName);
                }
            }
        }
        catch (Exception ex) {
            Log.getCategory(4).logError(Log.getLocation(7).getLocation(), "Exception occured while deleting session.", ex, scf.getAliasName());
        }
        scf.getSessionServletContext().getPolicyDomain().joinSession(this);
        Enumeration en = this.values.keys();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            Object obj = this.values.get((Object)name);
            scf.getWebEvents().sessionValueUnbound(name, obj, this);
            scf.getWebEvents().sessionAttributeRemoved(name, obj, this);
        }
        this.valid = false;
        scf.getWebEvents().sessionDestroyed(this);
        if (scf.getSessionServletContext().getPolicyDomain().removeMe(this)) {
            if (Log.isTracing()) {
                this.tracePath(7, "invalidateSession", "invalidating security session.");
            }
            if (scf.getWebMonitoring().isMonitoringStarted()) {
                scf.getWebMonitoring().securitySessionInvalidated(this.invalidatedByApplication);
            }
        }
        scf.exitResourceContext(resourceContext);
        if (SBasic.httpSessionDebugListener != null && SBasic.debugRequestParameterName != null && SBasic.debugRequestParameterName.length() != 0 && this.debugParameterValue != null) {
            SBasic.httpSessionDebugListener.endSession(this.id);
        }
    }

    public boolean isNew() {
        this.validate();
        if (!this.valid) {
            if (Log.isTracing()) {
                this.traceDebug(7, "isNew", "session is not valid!");
            }
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"isNew()"});
        }
        if (Log.isTracing()) {
            this.traceDebug(7, "isNew", "" + (this.thisAccessTime == this.creationTime));
        }
        return this.thisAccessTime == this.creationTime;
    }

    public boolean isValid() {
        this.validate();
        return this.valid;
    }

    public void putValue(String name, Object attribute) {
        this.validate();
        if (Log.isTracing()) {
            this.trace(8, "putValue", "name = [" + name + "], value = [" + attribute + "], valid = [" + this.valid + "].");
        }
        if (!this.valid) {
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"putValue()"});
        }
        if (name == null) {
            throw new WebIllegalArgumentException("servlet_jsp_0001", new Object[]{"putValue()"});
        }
        if (attribute == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldObj = this.values.get((Object)name);
        if (Log.isTracing()) {
            this.traceDebug(8, "putValue", "old value = [" + oldObj + "].");
        }
        this.values.put((Object)name, attribute);
        ApplicationContext scf = this.getServletContextFacade();
        if (scf != null) {
            scf.getWebEvents().sessionValueBound(name, attribute, this);
            if (oldObj != null) {
                scf.getWebEvents().sessionAttributeReplaced(name, oldObj, this);
            } else {
                scf.getWebEvents().sessionAttributeAdded(name, attribute, this);
            }
        }
        try {
            this.serializeSession();
        }
        catch (PersistentStorageException ex) {
            Log.getCategory(2).logWarning(Log.getLocation(7).getLocation(), "Attribute of session <" + this.id + "> cannot be serialized.", ex, scf.getAliasName());
        }
    }

    public Object getValue(String name) {
        this.validate();
        if (!this.valid) {
            if (Log.isTracing()) {
                this.traceDebug(8, "getValue", "name = [" + name + "], session is not valid!");
            }
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"getValue()"});
        }
        if (name == null) {
            if (Log.isTracing()) {
                this.traceDebug(8, "getValue", "name = [" + name + "], return: [null].");
            }
            return null;
        }
        Object result = this.values.get((Object)name);
        if (Log.isTracing()) {
            this.traceDebug(8, "getValue", "name = [" + name + "], return: [" + result + "].");
        }
        return result;
    }

    public String[] getValueNames() {
        if (!this.valid) {
            if (Log.isTracing()) {
                this.traceDebug(8, "getValueNames", "session is not valid!");
            }
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"getValueNames()"});
        }
        String[] as = new String[this.values.size()];
        int i = 0;
        Enumeration enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            as[i++] = (String)enumeration.nextElement();
        }
        if (Log.isTracing()) {
            String result = "";
            int j = 0;
            while (j < as.length) {
                result = result + as[j] + ", ";
                ++j;
            }
            if (result.endsWith(", ")) {
                result = result.substring(0, result.length() - 2);
            }
            this.traceDebug(8, "getValueNames", "return: [" + result + "]");
        }
        return as;
    }

    public void removeValue(String name) {
        ApplicationContext scf;
        if (Log.isTracing()) {
            this.trace(8, "removeValue", "name = [" + name + "], valid = [" + this.valid + "].");
        }
        this.validate();
        if (!this.valid) {
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"removeValue()"});
        }
        if (name == null) {
            throw new WebIllegalArgumentException("servlet_jsp_0001", new Object[]{"removeValue()"});
        }
        Object obj = this.values.remove((Object)name);
        if (Log.isTracing()) {
            this.traceDebug(8, "removeValue", "value = [" + obj + "]");
        }
        if ((scf = this.getServletContextFacade()) != null) {
            scf.getWebEvents().sessionValueUnbound(name, obj, this);
            scf.getWebEvents().sessionAttributeRemoved(name, obj, this);
        }
        try {
            this.serializeSession();
        }
        catch (PersistentStorageException ex) {
            Log.getCategory(2).logWarning(Log.getLocation(7).getLocation(), "Attribute of session <" + this.id + "> can not be serialized.", ex, scf.getAliasName());
        }
    }

    public void setMaxInactiveInterval(int i) {
        if (Log.isTracing()) {
            this.trace(7, "setMaxInactiveInterval", "inactive Interval = [" + i + "], valid = [" + this.valid + "].");
        }
        if (!this.valid) {
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"setMaxInactiveInterval()"});
        }
        this.inactiveInterval = i;
    }

    public int getMaxInactiveInterval() {
        this.validate();
        if (Log.isTracing()) {
            this.traceDebug(7, "getMaxInactiveInterval", "inactiveInterval = [" + this.inactiveInterval + "], valid = [" + this.valid + "]");
        }
        if (!this.valid) {
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"getMaxInactiveInterval()"});
        }
        return this.inactiveInterval;
    }

    public Object getAttribute(String name) {
        this.validate();
        if (!this.valid) {
            if (Log.isTracing()) {
                this.traceDebug(8, "getAttribute", "name = [" + name + "], session is not valid!.");
            }
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"getAttribute()"});
        }
        if (name == null) {
            if (Log.isTracing()) {
                this.traceDebug(8, "getAttribute", "name = [" + name + "], return: [null].");
            }
            return null;
        }
        Object result = this.values.get((Object)name);
        if (Log.isTracing()) {
            this.traceDebug(8, "getAttribute", "name = [" + name + "], return: [" + result + "].");
        }
        return result;
    }

    public Enumeration getAttributeNames() {
        Object[] keysArray;
        this.validate();
        if (!this.valid) {
            if (Log.isTracing()) {
                this.traceDebug(8, "getAttributeNames", "session is not valid!.");
            }
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"getAttributeNames()"});
        }
        if (Log.isTracing()) {
            String result = "";
            Enumeration en = this.values.keys();
            while (en.hasMoreElements()) {
                result = result + en.nextElement() + ", ";
            }
            if (result.endsWith(", ")) {
                result = result.substring(0, result.length() - 2);
            }
            this.traceDebug(8, "getAttributeNames", "result = [" + result + "].");
        }
        if ((keysArray = this.values.getAllKeys()) == null || keysArray.length == 0) {
            return new EmptyEnumeration();
        }
        ConcurrentReadHashMap carrier = new ConcurrentReadHashMap(16);
        int i = 0;
        while (i < keysArray.length) {
            carrier.put(keysArray[i], (Object)"");
            ++i;
        }
        return carrier.keys();
    }

    public void setAttribute(String name, Object attribute) {
        if (Log.isTracing()) {
            this.trace(8, "setAttribute", "name = [" + name + "], attribute = [" + attribute + "].");
        }
        this.validate();
        if (!this.valid) {
            if (Log.isTracing()) {
                this.traceDebug(8, "setAttribute", "session is not valid!.");
            }
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"setAttribute()"});
        }
        if (name == null) {
            throw new WebIllegalArgumentException("servlet_jsp_0001", new Object[]{"setAttribute()"});
        }
        if (attribute == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldObj = null;
        oldObj = this.values.get((Object)name);
        if (Log.isTracing()) {
            this.traceDebug(8, "setAttribute", "old value = [" + oldObj + "].");
        }
        this.values.put((Object)name, attribute);
        ApplicationContext scf = this.getServletContextFacade();
        if (scf != null) {
            scf.getWebEvents().sessionValueBound(name, attribute, this);
            if (oldObj != null) {
                scf.getWebEvents().sessionAttributeReplaced(name, oldObj, this);
            } else {
                scf.getWebEvents().sessionAttributeAdded(name, attribute, this);
            }
        }
        try {
            this.serializeSession();
        }
        catch (PersistentStorageException ex) {
            Log.getCategory(2).logWarning(Log.getLocation(7).getLocation(), "Attribute of session <" + this.id + "> can not be serialized.", ex, scf.getAliasName());
        }
    }

    public void removeAttribute(String name) {
        ApplicationContext scf;
        if (Log.isTracing()) {
            this.trace(8, "removeAttribute", "name = [" + name + "], valid = [" + this.valid + "].");
        }
        this.validate();
        if (!this.valid) {
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"removeAttribute()"});
        }
        if (name == null) {
            throw new WebIllegalArgumentException("servlet_jsp_0001", new Object[]{"removeAttribute()"});
        }
        Object obj = this.values.remove((Object)name);
        if (Log.isTracing()) {
            this.traceDebug(8, "removeAttribute", "value = [" + obj + "]");
        }
        if ((scf = this.getServletContextFacade()) != null) {
            scf.getWebEvents().sessionValueUnbound(name, obj, this);
            scf.getWebEvents().sessionAttributeRemoved(name, obj, this);
        }
        try {
            this.serializeSession();
        }
        catch (PersistentStorageException ex) {
            Log.getCategory(2).logWarning(Log.getLocation(7).getLocation(), "Attribute of session <" + this.id + "> can not be serialized.", ex, scf.getAliasName());
        }
    }

    public void putSecurityValue(String s, Object obj) {
        if (Log.isTracing()) {
            this.traceInfo(8, "putSecurityValue", "name = [" + s + "], value = [" + obj + "].");
        }
        this.secValues.put((Object)s, obj);
    }

    public Object removeSecurityValue(String s) {
        if (Log.isTracing()) {
            this.traceInfo(8, "removeSecurityValue", "name = [" + s + "], valid = [" + this.valid + "].");
        }
        this.validate();
        if (!this.valid) {
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"removeSecurityValue()"});
        }
        if (s == null) {
            throw new WebIllegalArgumentException("servlet_jsp_0001", new Object[]{"removeSecurityValue()"});
        }
        return this.secValues.remove((Object)s);
    }

    public Object getSecurityValue(String s) {
        this.validate();
        if (Log.isTracing()) {
            this.traceInfo(8, "getSecurityValue", "name = [" + s + "], valid = [" + this.valid + "].");
        }
        if (!this.valid) {
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"getSecurityValue()"});
        }
        if (s == null) {
            throw new WebIllegalArgumentException("servlet_jsp_0001", new Object[]{"getSecurityValue()"});
        }
        if (s.equals("userId")) {
            return this.secValues.get((Object)s);
        }
        if (s.equals("clientIP")) {
            return new String(ParseUtils.inetAddressByteToString((byte[])((byte[])this.secValues.get((Object)s))));
        }
        return this.secValues.get((Object)s);
    }

    public String getSecurityValueNoAccess(String s) {
        if (Log.isTracing()) {
            this.traceInfo(8, "getSecurityValueNoAccess", "name = [" + s + "], valid = [" + this.valid + "].");
        }
        if (!this.valid) {
            throw new InvalidSessionException(WebIllegalStateException.Method_called_on_invalid_session, new Object[]{"getSecurityValueNoAccess()"});
        }
        if (s == null) {
            throw new WebIllegalArgumentException("servlet_jsp_0001", new Object[]{"getSecurityValueNoAccess()"});
        }
        if (s.equals("clientIP")) {
            return new String(ParseUtils.inetAddressByteToString((byte[])((byte[])this.secValues.get((Object)s))));
        }
        return (String)this.secValues.get((Object)s);
    }

    public void setFormLoginBodyParameters(boolean formLoginBodyParameters) {
        this.formLoginBodyParameters = formLoginBodyParameters;
    }

    public boolean isFormLoginBodyParameters() {
        return this.formLoginBodyParameters;
    }

    public void setDebugParameterValue(String debugParameterValue) {
        this.debugParameterValue = debugParameterValue;
    }

    public String getDebugParameterValue() {
        return this.debugParameterValue;
    }

    public ServletContext getServletContext() {
        ServletContext result = this.getServletContextFacade().getServletContext();
        if (Log.isTracing()) {
            this.traceDebug(7, "getServletContext", "result: [" + result + "].");
        }
        return result;
    }

    private ApplicationContext getServletContextFacade() {
        MessageBytes contextNameMB = null;
        char[] ch = this.contextName.toCharArray();
        byte[] b = new byte[ch.length];
        int i = 0;
        while (i < ch.length) {
            b[i] = (byte)ch[i];
            ++i;
        }
        contextNameMB = new MessageBytes(b);
        return (ApplicationContext)SBasic.startedWebApplications.get(contextNameMB);
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void setFirst() {
        this.isFirst = false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ApplicationSession[id=");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    public void onUserLogOut() {
        if (Log.isTracing()) {
            this.traceInfo(7, "onUserLogOut", "");
        }
        if (this.valid) {
            this.invalidateSession();
        }
    }

    public void onSessionLocallyRemoved() {
    }

    private void serializeSession() throws PersistentStorageException {
        if (2 == this.getServletContextFacade().getWebApplicationConfiguration().getFailOverEnableInt()) {
            if (SBasic.failoverPersistentStorage != null) {
                if (Log.isTracing()) {
                    this.traceInfo(7, "serializeSession", "");
                }
                SBasic.failoverPersistentStorage.serializeSession(this.contextName, this.id, (Object)this, (long)(this.getMaxInactiveInterval() * 1000));
            } else {
                Log.getCategory(4).logError(Log.getLocation(7).getLocation(), "Cannot serialize the session. Failover service is currently not available.", this.contextName);
            }
        }
    }

    private void trace(int location, String method, String msg) {
        Log.getLocation(location).trace("ApplicationSession." + method + " [" + this.id + "], application [" + this.contextName + "]: " + msg, this.contextName);
    }

    private void traceWarning(int location, String method, String msg) {
        Log.getLocation(location).traceWarning("ApplicationSession." + method + " [" + this.id + "], application [" + this.contextName + "]: " + msg, this.contextName);
    }

    private void traceInfo(int location, String method, String msg) {
        Log.getLocation(location).traceInfo("ApplicationSession." + method + " [" + this.id + "], application [" + this.contextName + "]: " + msg, this.contextName);
    }

    private void traceDebug(int location, String method, String msg) {
        Log.getLocation(location).traceDebug("ApplicationSession." + method + " [" + this.id + "], application [" + this.contextName + "]: " + msg, this.contextName);
    }

    private void tracePath(int location, String method, String msg) {
        Log.getLocation(location).tracePath("ApplicationSession." + method + " [" + this.id + "], application [" + this.contextName + "]: " + msg, this.contextName);
    }
}

