/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.monitor.session;

import com.sap.engine.services.servlets_jsp.server.monitor.session.HttpSessionObjectNode;

public class HttpSessionsTopList {
    private static final String NAME = "Http Sessions";
    protected boolean modified = false;
    protected boolean isSent = false;
    private HttpSessionObjectNode[] nodeLists = new HttpSessionObjectNode[0];

    public void addList(String attributeName, int reportedCount) {
        int i = 0;
        while (i < this.nodeLists.length) {
            if (this.nodeLists[i].getSortingAttribute().equals(attributeName)) {
                if (this.nodeLists[i].getReportedSubnodesCount() >= reportedCount) break;
                this.nodeLists[i].setReportedSubnodesCount(reportedCount);
                break;
            }
            ++i;
        }
        if (i == this.nodeLists.length) {
            HttpSessionObjectNode[] newLists = new HttpSessionObjectNode[this.nodeLists.length + 1];
            System.arraycopy(this.nodeLists, 0, newLists, 0, i);
            newLists[i] = new HttpSessionObjectNode();
            newLists[i].setSortingAttribute(attributeName);
            newLists[i].setReportedSubnodesCount(reportedCount);
            this.nodeLists = newLists;
            this.modified = true;
            this.isSent = false;
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" Top List : ");
        buffer.append(this.nodeLists.length);
        buffer.append("\n");
        int i = 0;
        while (i < this.nodeLists.length) {
            buffer.append("   list ");
            buffer.append(i + 1);
            buffer.append(" : ");
            buffer.append(this.nodeLists[i]);
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    protected void setSent(boolean flag) {
        if (flag == this.isSent) {
            this.modified = false;
        } else {
            this.isSent = true;
            this.modified = true;
        }
    }
}

