/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.lib;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.protocol.Methods;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.engine.services.servlets_jsp.server.lib.StringUtils;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ApplicationSession;
import java.io.UnsupportedEncodingException;

public class WebParseUtils {
    public static String parseEncoding(HttpParameters httpParameters) {
        int charsetLocation;
        byte[] contentType = httpParameters.getRequest().getHeaders().getHeader(HeaderNames.entity_header_content_type_);
        if (contentType != null && (charsetLocation = ByteArrayUtils.indexOf((byte[])contentType, (byte[])Constants.charset)) != -1) {
            int end = ByteArrayUtils.indexOf((byte[])contentType, (byte)59, (int)charsetLocation);
            if (end == -1) {
                end = contentType.length;
            }
            return StringUtils.unquote(contentType, charsetLocation + 8, end - (charsetLocation + 8));
        }
        return null;
    }

    public static void parseQueryString(HashMapObjectObject parameters, byte[] data, String characterEncoding) throws UnsupportedEncodingException {
        if (data == null || data.length == 0) {
            return;
        }
        int ix = 0;
        int ox = 0;
        HashMapObjectObject newParameters = new HashMapObjectObject(8);
        String key = null;
        while (ix < data.length) {
            byte c = data[ix++];
            switch (c) {
                case 38: {
                    if (key != null) {
                        WebParseUtils.putMapEntry(newParameters, key, new String(data, 0, ox, characterEncoding));
                        key = null;
                    } else {
                        WebParseUtils.putMapEntry(newParameters, new String(data, 0, ox, characterEncoding), "");
                    }
                    ox = 0;
                    break;
                }
                case 61: {
                    if (key == null) {
                        key = new String(data, 0, ox, characterEncoding);
                        ox = 0;
                        break;
                    }
                    data[ox++] = c;
                    break;
                }
                case 43: {
                    data[ox++] = 32;
                    break;
                }
                case 37: {
                    if (ix < data.length - 1) {
                        data[ox++] = (byte)((WebParseUtils.convertHexDigit(data[ix++]) << 4) + WebParseUtils.convertHexDigit(data[ix++]));
                        break;
                    }
                    data[ox++] = c;
                    break;
                }
                default: {
                    data[ox++] = c;
                }
            }
        }
        if (key != null) {
            WebParseUtils.putMapEntry(newParameters, key, new String(data, 0, ox, characterEncoding));
        } else {
            WebParseUtils.putMapEntry(newParameters, new String(data, 0, ox, characterEncoding), "");
        }
        WebParseUtils.mergeParameters(parameters, newParameters);
    }

    public static void parseParameters(HashMapObjectObject parameters, HttpParameters httpParameters, String characterEncoding) throws UnsupportedEncodingException {
        ApplicationSession app;
        if (Log.isTracing()) {
            WebParseUtils.tracePath("parseParameters", "request method: [" + new String(httpParameters.getRequest().getRequestLine().getMethod()) + "]", httpParameters.getRequest().getClientId());
        }
        if (ByteArrayUtils.equalsBytes((byte[])httpParameters.getRequest().getRequestLine().getMethod(), (byte[])Methods._POST)) {
            int ind;
            byte[] contentType = httpParameters.getRequest().getHeaders().getHeader(HeaderNames.entity_header_content_type_);
            if (Log.isTracing()) {
                WebParseUtils.tracePath("parseParameters", "request content type: [" + new String(contentType) + "]", httpParameters.getRequest().getClientId());
            }
            if (!((ind = ByteArrayUtils.indexOf((byte[])contentType, (byte[])Constants.application_x_www_form_urlencoded)) != 0 && ind != 1 || contentType.length > ind + Constants.application_x_www_form_urlencoded.length && contentType[Constants.application_x_www_form_urlencoded.length] != 32 && contentType[Constants.application_x_www_form_urlencoded.length] != 9 && contentType[Constants.application_x_www_form_urlencoded.length] != 59)) {
                if (Log.isTracing()) {
                    WebParseUtils.tracePath("parseParameters", "request content length: [" + httpParameters.getRequest().getHeaders().getIntHeader(HeaderNames.entity_header_content_length_) + "]", httpParameters.getRequest().getClientId());
                }
                if (httpParameters.getRequestParametersBody() != null) {
                    WebParseUtils.parseQueryString(parameters, httpParameters.getRequestParametersBody().getBytes(), characterEncoding);
                }
            }
        }
        if ((app = (ApplicationSession)httpParameters.getApplicationSession()) != null && app.isFormLoginBodyParameters()) {
            app.setFormLoginBodyParameters(false);
            String url = (String)app.removeSecurityValue("j_request_url");
            if (url != null && url.equals(httpParameters.getRequest().getRequestLine().getUrlDecoded().toString())) {
                HashMapObjectObject params = (HashMapObjectObject)app.removeSecurityValue("j_request_parameters");
                WebParseUtils.mergeParameters(parameters, params);
            }
        }
        if (httpParameters.getRequest().getRequestLine().getQuery() != null) {
            WebParseUtils.parseQueryString(parameters, httpParameters.getRequest().getRequestLine().getQuery().getBytes(), characterEncoding);
        }
    }

    public static void parseParameters(HashMapObjectObject parameters, HttpParameters httpParameters, byte[] query, String characterEncoding) throws UnsupportedEncodingException {
        if (Log.isTracing()) {
            WebParseUtils.tracePath("parseParameters", "request method: [" + new String(httpParameters.getRequest().getRequestLine().getMethod()) + "]", httpParameters.getRequest().getClientId());
        }
        if (ByteArrayUtils.equalsBytes((byte[])httpParameters.getRequest().getRequestLine().getMethod(), (byte[])Methods._POST)) {
            int ind;
            byte[] contentType = httpParameters.getRequest().getHeaders().getHeader(HeaderNames.entity_header_content_type_);
            if (Log.isTracing()) {
                if (contentType == null) {
                    WebParseUtils.tracePath("parseParameters", "request content type: [" + contentType + "]", httpParameters.getRequest().getClientId());
                } else {
                    WebParseUtils.tracePath("parseParameters", "request content type: [" + new String(contentType) + "]", httpParameters.getRequest().getClientId());
                }
            }
            if (!((ind = ByteArrayUtils.indexOf((byte[])contentType, (byte[])Constants.application_x_www_form_urlencoded)) != 0 && ind != 1 || contentType.length > ind + Constants.application_x_www_form_urlencoded.length && contentType[Constants.application_x_www_form_urlencoded.length] != 32 && contentType[Constants.application_x_www_form_urlencoded.length] != 9 && contentType[Constants.application_x_www_form_urlencoded.length] != 59)) {
                if (Log.isTracing()) {
                    WebParseUtils.tracePath("parseParameters", "request content length: [" + httpParameters.getRequest().getHeaders().getIntHeader(HeaderNames.entity_header_content_length_) + "]", httpParameters.getRequest().getClientId());
                }
                if (httpParameters.getRequestParametersBody() != null) {
                    WebParseUtils.parseQueryString(parameters, httpParameters.getRequestParametersBody().getBytes(), characterEncoding);
                }
            }
        }
        if (query != null && query.length > 0) {
            WebParseUtils.parseQueryString(parameters, query, characterEncoding);
        }
    }

    private static void putMapEntry(HashMapObjectObject parameters, String name, String value) {
        String[] oldValues = (String[])parameters.get((Object)name);
        if (oldValues == null) {
            oldValues = new String[1];
        } else {
            String[] tmp = oldValues;
            oldValues = new String[tmp.length + 1];
            System.arraycopy(tmp, 0, oldValues, 0, tmp.length);
        }
        oldValues[oldValues.length - 1] = value;
        parameters.put((Object)name, (Object)oldValues);
    }

    private static void mergeParameters(HashMapObjectObject dest, HashMapObjectObject src) {
        if (src == null) {
            return;
        }
        if (dest == null) {
            dest = src;
            return;
        }
        Object[] key = src.getAllKeys();
        int i = 0;
        while (i < key.length) {
            String[] srcValue = (String[])src.get(key[i]);
            String[] destValue = (String[])dest.get(key[i]);
            if (destValue == null) {
                dest.put(key[i], (Object)srcValue);
            } else {
                String[] temp = new String[srcValue.length + destValue.length];
                System.arraycopy(srcValue, 0, temp, 0, srcValue.length);
                System.arraycopy(destValue, 0, temp, srcValue.length, destValue.length);
                dest.put(key[i], (Object)temp);
            }
            ++i;
        }
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    private static void tracePath(String method, String msg, int clientId) {
        Log.getLocation(6).tracePath("client [" + clientId + "] WebParseUtils." + method + " " + msg, "");
    }
}

