/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebResourceAccessor;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.ResourceAccessor;
import java.rmi.RemoteException;
import java.util.Vector;

public class RemoveAction
extends ActionBase {
    public RemoveAction(ContainerInfo containerInfo, WebContainerHelper servletsAndJsp, ServletAndJspRuntimeInterface runtimeInterface) {
        super(containerInfo, servletsAndJsp, runtimeInterface);
    }

    public void remove(String applicationName, boolean isUpdate) throws DeploymentException, WarningException {
        Vector<LocalizableTextFormatter> warnings = new Vector<LocalizableTextFormatter>();
        if (applicationName == null) {
            return;
        }
        String[] aliases = this.getAliases(applicationName);
        if (aliases != null) {
            int i = 0;
            while (i < aliases.length) {
                String alias = ParseUtils.convertAlias((String)aliases[i]);
                this.servletsAndJsp.remove(applicationName, aliases[i], isUpdate);
                String[] deployedApplications = SBasic.deployCommunicator.getMyApplications();
                boolean removeAlias = true;
                boolean aliasFoundInDeployedApps = false;
                int j = 0;
                while (deployedApplications != null && j < deployedApplications.length) {
                    String[] deployedAliases = SBasic.deployCommunicator.getAliases(deployedApplications[j]);
                    int k = 0;
                    while (deployedAliases != null && k < deployedAliases.length) {
                        if (alias.equals(deployedAliases[k])) {
                            aliasFoundInDeployedApps = true;
                            if (applicationName.equals(deployedApplications[j])) {
                                removeAlias = true;
                                ApplicationContext scf = (ApplicationContext)SBasic.startedWebApplications.remove(new MessageBytes(alias.getBytes()));
                                if (scf != null) {
                                    scf.destroy();
                                }
                                try {
                                    if (SBasic.failoverPersistentStorage != null) {
                                        SBasic.failoverPersistentStorage.deleteAllSessions(aliases[i]);
                                        break;
                                    }
                                    Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot remove serialized sessions of " + aliases[i] + " web application of " + applicationName + " application, while removing the application. Failover service is not available.", aliases[i]);
                                }
                                catch (PersistentStorageException pe) {
                                    Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot delete failover backup file for " + aliases[i] + " web application.", pe, alias);
                                }
                                break;
                            }
                            removeAlias = false;
                            break;
                        }
                        ++k;
                    }
                    ++j;
                }
                if (removeAlias || !aliasFoundInDeployedApps) {
                    try {
                        this.servletsAndJsp.getHttpProvider().removeApplicationAlias(alias);
                    }
                    catch (OutOfMemoryError e) {
                        throw e;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Log.getCategory(1).logError(ActionBase.currentLocation, "Error occured in removing application alias.", e, alias);
                        warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.CANNOT_REMOVE_ALIAS_FROM_HTTP_WHILE_REMOVING_APPLICATION, new Object[]{alias, applicationName}));
                    }
                }
                try {
                    this.servletsAndJsp.getHttpProvider().clearCacheByAlias(alias);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Error in clearing the http cache.", e, alias);
                }
                ++i;
            }
        }
        SBasic.persistentStorage.removeAllClasses(applicationName);
        try {
            this.runtimeInterface.removeApp(applicationName);
        }
        catch (RemoteException re) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for removing " + applicationName + " application. " + re, applicationName);
        }
        catch (RuntimeException runtimeEx) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for removing " + applicationName + " application. " + runtimeEx, applicationName);
        }
        this.makeWarningException(warnings);
    }
}

