/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server;

import com.sap.engine.services.servlets_jsp.Monitoring;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.util.Enumeration;

public class WebMonitoring
implements Monitoring {
    private boolean isMonitoringStarted = false;
    private long httpSessionsInvalidatedByApplication = 0L;
    private long timedOutHttpSessions = 0L;
    private long securitySessionsInvalidatedByApplication = 0L;
    private long timedOutSecuritySessions = 0L;
    private long allRequestsCount = 0L;
    private long allResponsesCount = 0L;
    private long totalResponseTime = 0L;

    public void monitoringStarted(boolean isStarted) {
        this.isMonitoringStarted = isStarted;
    }

    public boolean isMonitoringStarted() {
        return this.isMonitoringStarted;
    }

    public int getCurrentHttpSessions() {
        int sessionsCount = 0;
        Enumeration en = SBasic.startedWebApplications.elements();
        while (en.hasMoreElements()) {
            ApplicationContext application = (ApplicationContext)en.nextElement();
            sessionsCount += application.getSessionServletContext().getSession().size();
        }
        return sessionsCount;
    }

    public long getHttpSessionsInvalidatedByApplication() {
        return this.httpSessionsInvalidatedByApplication;
    }

    public long getTimedOutHttpSessions() {
        return this.timedOutHttpSessions;
    }

    public int getCurrentSecuritySessions() {
        int sessionsCount = 0;
        Enumeration en = SBasic.startedWebApplications.elements();
        while (en.hasMoreElements()) {
            ApplicationContext application = (ApplicationContext)en.nextElement();
            sessionsCount += application.getSessionServletContext().getPolicyDomain().getSecuritySessions().size();
        }
        return sessionsCount;
    }

    public long getSecuritySessionsInvalidatedByApplication() {
        return this.securitySessionsInvalidatedByApplication;
    }

    public long getTimedOutSecuritySessions() {
        return this.timedOutSecuritySessions;
    }

    public long getAllRequestsCount() {
        return this.allRequestsCount;
    }

    public long getAllResponsesCount() {
        return this.allResponsesCount;
    }

    public long getTotalResponseTime() {
        return this.totalResponseTime;
    }

    public synchronized void sessionInvalidated(boolean byApplication) {
        if (byApplication) {
            ++this.httpSessionsInvalidatedByApplication;
        } else {
            ++this.timedOutHttpSessions;
        }
    }

    public synchronized void securitySessionInvalidated(boolean byApplication) {
        if (byApplication) {
            ++this.securitySessionsInvalidatedByApplication;
        } else {
            ++this.timedOutSecuritySessions;
        }
    }

    public synchronized void newRequest() {
        ++this.allRequestsCount;
    }

    public synchronized void newResponse(long responseTime) {
        ++this.allResponsesCount;
        this.totalResponseTime += responseTime;
    }
}

