/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server;

import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebContainerProperties {
    private static final String COMPILE_ON_STARTUP = "CompileOnStartUp";
    private static final String INTERNAL_COMPILER = "InternalCompiler";
    private static final String EXTERNAL_COMPILER = "ExternalCompiler";
    private static final String DESTROY_TIME_OUT = "DestroyTimeOut";
    private static final String COMPILER_DEBUGGING_INFO = "CompilerDebuggingInfo";
    private static final String ENABLE_CHUNKED_RESPONSE = "EnableChunkedResponse";
    private static final String ECLIPSE_JSP_DEBUG_SUPPORT = "EclipseJspDebugSupport";
    private static final String DELAY_AUTHENTICATION = "DelayAuthentication";
    private static final String VALIDATE_DESCRIPTORS = "ValidateDescriptors";
    private static final String HEADER_FOR_NO_COMPRESSION = "HeaderForNoCompression";
    private static final String HEADER_FOR_COMPRESSION = "HeaderForCompression";
    private static final String MULTIPART_BODY_PARAMETER_NAME_KEY = "MultipartBodyParameterName";
    private static final String TRACE_LEVEL = "TraceLevel";
    private static final String RESOLVE_HOST_NAME = "ResolveHostName";
    private static final String APPLICATION_STOPPED_FILE = "ApplicationStoppedFile";
    private static final String APPLICATION_STOPPED_ALIASES = "ApplicationStoppedAliases";
    private boolean internalCompiler = false;
    private String compiler = "javac";
    private long destroyTimeout = 5000L;
    private boolean compileOnStartUp = false;
    private boolean eclipseJspDebugSupport = true;
    private boolean enable_chunked_response = true;
    private boolean compilerDebuggingInfo = false;
    private boolean delay_authentication = false;
    private boolean validateDescriptors = false;
    private String headerForNoCompression = "No-Compress";
    private String headerForCompression = null;
    private String multipartBodyParameterName = "com.sap.servlet.multipart.body";
    private int traceLevel = -1;
    private boolean resolveHostName = false;
    private String appStoppedFile = null;
    private String[] appStoppedAliases = null;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$WebContainerProperties == null ? (class$com$sap$engine$services$servlets_jsp$server$WebContainerProperties = WebContainerProperties.class$("com.sap.engine.services.servlets_jsp.server.WebContainerProperties")) : class$com$sap$engine$services$servlets_jsp$server$WebContainerProperties));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$WebContainerProperties;

    public boolean internalCompiler() {
        return this.internalCompiler;
    }

    public String getExternalCompiler() {
        return this.compiler;
    }

    public long getDestroyTimeout() {
        return this.destroyTimeout;
    }

    public boolean compileOnStartup() {
        return this.compileOnStartUp;
    }

    public boolean eclipseSupport() {
        return this.eclipseJspDebugSupport;
    }

    public boolean chunkResponseEnabled() {
        return this.enable_chunked_response;
    }

    public boolean compileWithDebugInfo() {
        return this.compilerDebuggingInfo;
    }

    public boolean delayAuthentication() {
        return this.delay_authentication;
    }

    public boolean validateDescriptors() {
        return this.validateDescriptors;
    }

    public String headerForNoCompression() {
        return this.headerForNoCompression;
    }

    public String headerForCompression() {
        return this.headerForCompression;
    }

    public String getMultipartBodyParameterName() {
        return this.multipartBodyParameterName;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public boolean resolveHostName() {
        return this.resolveHostName;
    }

    public String appStoppedFile() {
        return this.appStoppedFile;
    }

    public String[] appStoppedAliases() {
        return this.appStoppedAliases;
    }

    public void setServiceProperties(Properties sp) {
        Enumeration propKeys = ((Hashtable)sp).keys();
        while (propKeys.hasMoreElements()) {
            String propName = (String)propKeys.nextElement();
            this.setServiceProperty(propName, sp.getProperty(propName));
        }
    }

    public void setServiceProperty(String name, String value) {
        if (name != null) {
            name = name.trim();
        }
        if (value != null) {
            value = value.trim();
        }
        if (INTERNAL_COMPILER.equals(name)) {
            this.internalCompiler = new Boolean(value);
        } else if (EXTERNAL_COMPILER.equals(name)) {
            this.compiler = value;
        } else if (DESTROY_TIME_OUT.equals(name)) {
            try {
                this.destroyTimeout = Integer.parseInt(value);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(4).logWarning(this.currentLocation, "Incorrect value " + value + " for the property " + DESTROY_TIME_OUT + ". Will use the default 5000.", "");
                this.destroyTimeout = 5000L;
            }
        } else if (COMPILE_ON_STARTUP.equals(name)) {
            this.compileOnStartUp = new Boolean(value);
        } else if (ECLIPSE_JSP_DEBUG_SUPPORT.equals(name)) {
            this.eclipseJspDebugSupport = new Boolean(value);
        } else if (ENABLE_CHUNKED_RESPONSE.equals(name)) {
            this.enable_chunked_response = new Boolean(value);
        } else if (COMPILER_DEBUGGING_INFO.equals(name)) {
            this.compilerDebuggingInfo = new Boolean(value);
        } else if (DELAY_AUTHENTICATION.equals(name)) {
            this.delay_authentication = new Boolean(value);
        } else if (VALIDATE_DESCRIPTORS.equals(name)) {
            this.validateDescriptors = new Boolean(value);
        } else if (HEADER_FOR_NO_COMPRESSION.equals(name)) {
            this.headerForNoCompression = value;
        } else if (HEADER_FOR_COMPRESSION.equals(name)) {
            this.headerForCompression = value;
        } else if (MULTIPART_BODY_PARAMETER_NAME_KEY.equals(name)) {
            if (value != null && (value = value.trim()).length() == 0) {
                value = null;
            }
            this.multipartBodyParameterName = value;
        } else if (TRACE_LEVEL.equals(name)) {
            try {
                this.traceLevel = new Integer(value);
            }
            catch (Exception e) {
                this.traceLevel = -1;
                Log.getCategory(4).logError(this.currentLocation, "Incorrect value of TraceLevel property found. Tracing is switched off.", e, "");
            }
        } else if (RESOLVE_HOST_NAME.equals(name)) {
            this.resolveHostName = new Boolean(value);
        } else if (APPLICATION_STOPPED_FILE.equals(name)) {
            if (value != null && (value = value.trim()).length() == 0) {
                value = null;
            }
            this.appStoppedFile = value;
        } else if (APPLICATION_STOPPED_ALIASES.equals(name)) {
            if (value != null) {
                if ((value = value.trim()).length() == 0) {
                    this.appStoppedAliases = null;
                } else {
                    Vector<String> vAliases = new Vector<String>();
                    StringTokenizer alias = new StringTokenizer(value, ",");
                    while (alias.hasMoreElements()) {
                        vAliases.add(((String)alias.nextElement()).trim());
                    }
                    if (vAliases.size() > 0) {
                        Object[] aliases = new String[vAliases.size()];
                        vAliases.copyInto(aliases);
                        this.appStoppedAliases = aliases;
                    } else {
                        this.appStoppedAliases = null;
                    }
                }
            } else {
                this.appStoppedAliases = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

