/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.multipart.impl;

import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.servlets_jsp.lib.multipart.MultipartMessage;
import com.sap.engine.services.servlets_jsp.lib.multipart.MultipartParseException;
import com.sap.engine.services.servlets_jsp.lib.multipart.impl.MultipartPartImpl;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultipartMessageImpl
extends MultipartMessage {
    private static final String BOUNDARY_DELIMITER = "--";
    private static final String boundary_key = "boundary";
    private static final int MAX_HEADER_LENGTH = 4096;
    private InputStream in = null;
    private String boundary = null;
    private byte[] boundary_ = null;
    private String contentTypeHeaderValue = null;
    private boolean finalBoundaryFound = false;
    private HttpServletRequestFacade request = null;

    public MultipartMessageImpl() {
    }

    public MultipartMessageImpl(InputStream in, String contentTypeHeaderValue, HttpServletRequestFacade request) {
        this();
        this.in = in;
        this.contentTypeHeaderValue = contentTypeHeaderValue;
        this.request = request;
    }

    public void writeTo(OutputStream outputstream) throws IOException {
    }

    public void addFormParametersToRequest() {
        this.addFormParameters = true;
        this.request.parametersParsed = false;
    }

    protected void parse() throws IOException, MultipartParseException {
        if (this.in == null) {
            return;
        }
        this.parseBoundary(this.contentTypeHeaderValue);
        this.findFirstBoundary();
        while (!this.finalBoundaryFound) {
            Hashtable headers = this.parseHeaders();
            ByteArrayInputStream body = this.parseBody();
            this.addBodyPart(new MultipartPartImpl(headers, body, body.available()));
        }
    }

    private void parseBoundary(String contentTypeHeaderValue) throws MultipartParseException {
        if (contentTypeHeaderValue == null) {
            throw new MultipartParseException("servlet_jsp_0259");
        }
        int semiColonInd = contentTypeHeaderValue.indexOf(59);
        if (semiColonInd == -1 || semiColonInd == contentTypeHeaderValue.length() - 1) {
            throw new MultipartParseException("servlet_jsp_0260");
        }
        this.contentType = contentTypeHeaderValue.substring(0, semiColonInd);
        contentTypeHeaderValue = contentTypeHeaderValue.substring(semiColonInd + 1);
        StringTokenizer params = new StringTokenizer(contentTypeHeaderValue, ";");
        while (params.hasMoreTokens()) {
            String name;
            String param = params.nextToken().trim();
            int eqInd = param.indexOf(61);
            if (eqInd <= -1 || eqInd >= param.length() - 1 || !boundary_key.equals(name = param.substring(0, eqInd))) continue;
            this.boundary = BOUNDARY_DELIMITER + param.substring(eqInd + 1).trim();
            this.boundary_ = this.boundary.getBytes();
            break;
        }
        if (this.boundary == null) {
            throw new MultipartParseException("servlet_jsp_0260");
        }
    }

    private void findFirstBoundary() throws IOException, MultipartParseException {
        byte[] nextLine = this.readLine();
        while (nextLine != null) {
            if (ByteArrayUtils.equalsBytes((byte[])(nextLine = ByteArrayUtils.trim((byte[])nextLine)), (byte[])this.boundary_)) {
                return;
            }
            nextLine = this.readLine();
        }
        throw new MultipartParseException("servlet_jsp_0261");
    }

    private Hashtable parseHeaders() throws IOException, MultipartParseException {
        Vector<byte[]> headerLines = new Vector<byte[]>();
        byte[] nextLine = this.readLine();
        while (nextLine != null) {
            if (nextLine.length == 0) break;
            if (nextLine[0] == 32 || nextLine[0] == 9) {
                byte[] previousHeader = (byte[])headerLines.elementAt(headerLines.size() - 1);
                if (previousHeader == null) {
                    headerLines.addElement(nextLine);
                } else {
                    byte[] compositeHeader = new byte[previousHeader.length + nextLine.length - 1];
                    System.arraycopy(previousHeader, 0, compositeHeader, 0, previousHeader.length);
                    System.arraycopy(nextLine, 1, compositeHeader, previousHeader.length, nextLine.length - 1);
                    headerLines.addElement(compositeHeader);
                }
            } else {
                headerLines.addElement(nextLine);
            }
            nextLine = this.readLine();
        }
        Hashtable<String, String[]> headers = new Hashtable<String, String[]>();
        Enumeration en = headerLines.elements();
        while (en.hasMoreElements()) {
            byte[] next = (byte[])en.nextElement();
            int eqInd = ByteArrayUtils.indexOf((byte[])next, (byte)58);
            if (eqInd < 0 || eqInd >= next.length - 1) {
                throw new MultipartParseException("servlet_jsp_0262", new Object[]{new String(next)});
            }
            String name = new String(next, 0, eqInd).trim();
            String value = new String(next, eqInd + 1, next.length - eqInd - 1).trim();
            String[] oldValues = (String[])headers.get(name);
            if (oldValues == null) {
                headers.put(name, new String[]{value});
                continue;
            }
            String[] newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[newValues.length - 1] = value;
            headers.put(name, newValues);
        }
        return headers;
    }

    private ByteArrayInputStream parseBody() throws IOException, MultipartParseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int nextByte = -1;
        while ((nextByte = this.in.read()) != -1) {
            if (nextByte == 13) {
                this.in.mark(this.boundary_.length + 2);
                if (this.in.read() != 10 || this.in.read() != 45) {
                    this.in.reset();
                    out.write(nextByte);
                    continue;
                }
                int i = 1;
                while (i < this.boundary_.length) {
                    if (this.in.read() != this.boundary_[i]) {
                        this.in.reset();
                        break;
                    }
                    ++i;
                }
                if (i == this.boundary_.length) {
                    this.in.reset();
                    this.in.read();
                    this.in.read();
                    int j = 0;
                    while (j < this.boundary_.length - 1) {
                        this.in.read();
                        ++j;
                    }
                    this.in.mark(3);
                    if (this.in.read() == 45 && this.in.read() == 45) {
                        this.in.reset();
                        this.in.read();
                        this.in.read();
                        this.finalBoundaryFound = true;
                    }
                    this.in.reset();
                    int tmp = this.in.read();
                    while (tmp != -1 && tmp != 10) {
                        tmp = this.in.read();
                    }
                    return new ByteArrayInputStream(out.toByteArray());
                }
                this.in.reset();
            }
            out.write(nextByte);
        }
        throw new MultipartParseException("servlet_jsp_0263");
    }

    private byte[] readLine() throws IOException {
        int nextByte = -1;
        byte[] line = null;
        this.in.mark(4096);
        nextByte = this.in.read();
        if (nextByte != -1) {
            int len = 1;
            int prev = -1;
            while (nextByte != -1 && nextByte != 10) {
                prev = nextByte;
                nextByte = this.in.read();
                ++len;
            }
            this.in.reset();
            line = prev == 13 ? new byte[len - 2] : new byte[len - 1];
            this.in.read(line);
            if (prev == 13) {
                this.in.read();
            }
            this.in.read();
            return line;
        }
        return null;
    }
}

