/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.multipart;

import com.sap.engine.services.servlets_jsp.lib.multipart.MultipartParseException;
import com.sap.engine.services.servlets_jsp.lib.multipart.MultipartPart;
import com.sap.engine.services.servlets_jsp.server.lib.EmptyEnumeration;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class MultipartMessage {
    public static final String MULTIPART_BODY_KEY = "com.sap.servlet.multipart.body";
    public static final String FORM_DATA_TYPE = "form-data";
    private Vector parts = null;
    protected String contentType = null;
    private boolean parsed = false;
    protected boolean addFormParameters = false;

    public String getContentType() throws IOException, MultipartParseException {
        this.ensureParsed();
        return this.contentType;
    }

    public int getCount() throws IOException, MultipartParseException {
        this.ensureParsed();
        if (this.parts == null) {
            return 0;
        }
        return this.parts.size();
    }

    public Enumeration getBodyParts() throws IOException, MultipartParseException {
        this.ensureParsed();
        if (this.parts == null) {
            return new EmptyEnumeration();
        }
        return this.parts.elements();
    }

    public MultipartPart getBodyPart(int i) throws IOException, MultipartParseException {
        this.ensureParsed();
        if (this.parts == null) {
            throw new MultipartParseException("servlet_jsp_0258");
        }
        return (MultipartPart)this.parts.elementAt(i);
    }

    public boolean removeBodyPart(MultipartPart bodypart) throws IOException, MultipartParseException {
        this.ensureParsed();
        if (this.parts == null) {
            throw new MultipartParseException("servlet_jsp_0258");
        }
        return this.parts.removeElement(bodypart);
    }

    public void removeBodyPart(int i) throws IOException, MultipartParseException {
        this.ensureParsed();
        if (this.parts == null) {
            throw new MultipartParseException("servlet_jsp_0258");
        }
        this.parts.removeElementAt(i);
    }

    public void addBodyPart(MultipartPart bodypart) throws IOException, MultipartParseException {
        MultipartMessage multipartMessage = this;
        synchronized (multipartMessage) {
            this.ensureParsed();
            if (this.parts == null) {
                this.parts = new Vector(3, 3);
            }
            this.parts.addElement(bodypart);
        }
    }

    public void addBodyPart(MultipartPart bodypart, int i) throws IOException, MultipartParseException {
        MultipartMessage multipartMessage = this;
        synchronized (multipartMessage) {
            this.ensureParsed();
            if (this.parts == null) {
                this.parts = new Vector();
            }
            this.parts.insertElementAt(bodypart, i);
        }
    }

    public MultipartPart getBodyPart(String s) throws IOException, MultipartParseException {
        MultipartMessage multipartMessage = this;
        synchronized (multipartMessage) {
            this.ensureParsed();
            int i = this.getCount();
            int j = 0;
            while (j < i) {
                MultipartPart mimebodypart = this.getBodyPart(j);
                String s1 = mimebodypart.getName();
                if (s1 != null && s1.equals(s)) {
                    MultipartPart multipartPart = mimebodypart;
                    return multipartPart;
                }
                ++j;
            }
            MultipartPart multipartPart = null;
            return multipartPart;
        }
    }

    public abstract void addFormParametersToRequest();

    public boolean isFormParametersToRequest() {
        return this.addFormParameters;
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    protected abstract void parse() throws IOException, MultipartParseException;

    private void ensureParsed() throws IOException, MultipartParseException {
        if (!this.parsed) {
            this.parsed = true;
            this.parse();
        }
    }
}

