/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.jspparser.taglib;

import com.sap.engine.services.servlets_jsp.lib.jspparser.taglib.TagVariableData;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;

abstract class TagGeneratorBase {
    protected Stack tagHandlerStack = null;
    protected Hashtable tagVarNumbers = null;

    TagGeneratorBase() {
    }

    protected void tagBegin(TagVariableData tvd) {
        this.tagHandlerStack.push(tvd);
    }

    protected TagVariableData tagEnd() {
        return (TagVariableData)this.tagHandlerStack.pop();
    }

    public TagVariableData topTag() {
        if (this.tagHandlerStack.empty()) {
            return null;
        }
        return (TagVariableData)this.tagHandlerStack.peek();
    }

    protected String getTagVarName(String prefix, String shortTagName) {
        Hashtable hashtable = this.tagVarNumbers;
        synchronized (hashtable) {
            String tag = prefix + ":" + shortTagName;
            String varName = this.replaceChars(prefix) + "_" + this.replaceChars(shortTagName) + "_";
            if (this.tagVarNumbers.get(tag) != null) {
                Integer i = (Integer)this.tagVarNumbers.get(tag);
                varName = varName + i;
                this.tagVarNumbers.put(tag, new Integer(i + 1));
                String string = varName;
                return string;
            }
            this.tagVarNumbers.put(tag, new Integer(1));
            String string = varName + "0";
            return string;
        }
    }

    private String replaceChars(String namePart) {
        StringBuffer namePartOK = new StringBuffer();
        int i = 0;
        while (i < namePart.length()) {
            char c = namePart.charAt(i);
            if (!(i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c))) {
                namePartOK.append('_');
                namePartOK.append(Integer.toHexString(c));
                namePartOK.append('_');
            } else {
                namePartOK.append(c);
            }
            ++i;
        }
        return namePartOK.toString();
    }

    protected void declareVariables(StringBuffer writer, VariableInfo[] vi, boolean declare, boolean update, int scope, String ident) {
        if (vi != null) {
            int i = 0;
            while (i < vi.length) {
                if (vi[i].getScope() == scope) {
                    if (vi[i].getDeclare() && declare) {
                        writer.append(ident + new String(vi[i].getClassName() + " " + vi[i].getVarName() + ";" + "\n"));
                    }
                    if (update) {
                        if ("String".equals(vi[i].getClassName()) || "java.lang.String".equals(vi[i].getClassName())) {
                            writer.append(ident + new String(vi[i].getVarName() + " = (" + vi[i].getClassName() + ") pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ");" + "\n"));
                        } else if ("int".equals(vi[i].getClassName())) {
                            writer.append(ident + new String(vi[i].getVarName() + " = " + "Integer.valueOf((String) pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ")).intValue();" + "\n"));
                        } else if ("long".equals(vi[i].getClassName())) {
                            writer.append(ident + new String(vi[i].getVarName() + " = " + "Long.valueOf((String) pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ")).longValue();" + "\n"));
                        } else if ("float".equals(vi[i].getClassName())) {
                            writer.append(ident + new String(vi[i].getVarName() + " = " + "Float.valueOf((String) pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ")).floatValue();" + "\n"));
                        } else if ("double".equals(vi[i].getClassName())) {
                            writer.append(ident + new String(vi[i].getVarName() + " = " + "Double.valueOf((String) pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ")).doubleValue();" + "\n"));
                        } else if ("boolean".equals(vi[i].getClassName())) {
                            writer.append(ident + new String(vi[i].getVarName() + " = " + "Boolean.valueOf((String) pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ")).booleanValue();" + "\n"));
                        } else if ("char".equals(vi[i].getClassName())) {
                            writer.append(ident + new String("if (((String)pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ")).toCharArray().length > 1 ) { \n"));
                            writer.append(ident + new String("throw new JspException(\"Unable to parse attribute to char\");\n"));
                            writer.append(ident + new String("}\n"));
                            writer.append(ident + new String(vi[i].getVarName() + " = " + "((String)pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ")).toCharArray()[0];" + "\n"));
                        } else if ("Character".equals(vi[i].getClassName())) {
                            writer.append(ident + new String("if (((String)pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ")).toCharArray().length > 1 ) { \n"));
                            writer.append(ident + new String("throw new JspException(\"Unable to parse attribute to char\");\n"));
                            writer.append(ident + new String("}\n"));
                            writer.append(ident + new String(vi[i].getVarName() + " = " + "new Character(((String)pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ")).toCharArray()[0]);" + "\n"));
                        } else {
                            writer.append(ident + new String(vi[i].getVarName() + " = " + "(" + vi[i].getClassName() + ")" + "pageContext.getAttribute(" + this.quoteString(vi[i].getVarName()) + ");" + "\n"));
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void declareVariables(StringBuffer writer, TagVariableInfo[] vi, boolean declare, boolean update, int scope, String ident, Hashtable attrs) {
        if (vi != null) {
            int i = 0;
            while (i < vi.length) {
                if (vi[i].getDeclare() && vi[i].getScope() == scope) {
                    String className = vi[i].getClassName();
                    String name = vi[i].getNameGiven();
                    if (name == null) {
                        name = (String)attrs.get(vi[i].getNameFromAttribute());
                    }
                    this.doDeclareVariables(writer, className, name, declare, update, ident);
                }
                ++i;
            }
        }
    }

    protected void doDeclareVariables(StringBuffer writer, String className, String name, boolean declare, boolean update, String ident) {
        if (declare) {
            writer.append(ident + className + " " + name + ";" + "\n");
        }
        if (update) {
            if ("String".equals(className) || "java.lang.String".equals(className)) {
                writer.append(ident + name + " = (" + className + ") pageContext.getAttribute(" + this.quoteString(name) + ");" + "\n");
            } else if ("int".equals(className)) {
                writer.append(ident + name + " = " + "Integer.valueOf((String) pageContext.getAttribute(" + this.quoteString(name) + ")).intValue();" + "\n");
            } else if ("long".equals(className)) {
                writer.append(ident + name + " = " + "Long.valueOf((String) pageContext.getAttribute(" + this.quoteString(name) + ")).longValue();" + "\n");
            } else if ("float".equals(className)) {
                writer.append(ident + name + " = " + "Float.valueOf((String) pageContext.getAttribute(" + this.quoteString(name) + ")).floatValue();" + "\n");
            } else if ("double".equals(className)) {
                writer.append(ident + name + " = " + "Double.valueOf((String) pageContext.getAttribute(" + this.quoteString(name) + ")).doubleValue();" + "\n");
            } else if ("boolean".equals(className)) {
                writer.append(ident + name + " = " + "Boolean.valueOf((String) pageContext.getAttribute(" + this.quoteString(name) + ")).booleanValue();" + "\n");
            } else if ("char".equals(className)) {
                writer.append(ident + "if (((String)pageContext.getAttribute(" + this.quoteString(name) + ")).toCharArray().length > 1 ) { \n");
                writer.append(ident + "throw new JspException(\"Unable to parse attribute to char\");\n");
                writer.append(ident + "}\n");
                writer.append(ident + name + " = " + "((String)pageContext.getAttribute(" + this.quoteString(name) + ")).toCharArray()[0];" + "\n");
            } else if ("Character".equals(className)) {
                writer.append(ident + "if (((String)pageContext.getAttribute(" + this.quoteString(name) + ")).toCharArray().length > 1 ) { \n");
                writer.append(ident + "throw new JspException(\"Unable to parse attribute to char\");\n");
                writer.append(ident + "}\n");
                writer.append(ident + name + " = " + "new Character(((String)pageContext.getAttribute(" + this.quoteString(name) + ")).toCharArray()[0]);" + "\n");
            } else {
                writer.append(ident + name + " = " + "(" + className + ")" + "pageContext.getAttribute(" + this.quoteString(name) + ");" + "\n");
            }
        }
    }

    protected String quoteString(String s) {
        if (s == null) {
            return "null";
        }
        if (s.indexOf(34) < 0 && s.indexOf(92) < 0 && s.indexOf(10) < 0 && s.indexOf(13) < 0) {
            return "\"" + s + "\"";
        }
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '\\' && i + 1 < len) {
                sb.append('\\');
                sb.append('\\');
                sb.append(s.charAt(++i));
            } else if (ch == '\"') {
                sb.append('\\');
                sb.append('\"');
            } else if (ch == '\n') {
                sb.append("\\n");
            } else if (ch == '\r') {
                sb.append("\\r");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }
}

