/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.xmlsyntax;

import com.sap.engine.services.servlets_jsp.lib.jspparser.exceptions.JspParseException;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.DebugInfo;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Element;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.JspTag;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Parser;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Position;

public class TextTag
extends JspTag {
    private static String startTag = "<jsp:text><![CDATA[\n";
    private static String endTag = "\n]]>\n</jsp:text>";
    private char[] START_TAG_INDENT = "<jsp:text>".toCharArray();
    private char[] END_TAG_INDENT = "</jsp:text>".toCharArray();
    private String s = null;

    public TextTag() {
        this.elementType = 9;
        this.tagType = 2;
    }

    public void action() throws JspParseException {
        this.debugInfo.writeStart(this.parser.getScriptletsCode(), true);
        this.parser.getScriptletsCode().append("\t\t\tout.print(\"");
        this.s = this.parser.getChars(this.startIndex + this.START_TAG_INDENT.length, this.endIndex - this.END_TAG_INDENT.length);
        this.removeCDATA();
        this.s = this.parser.replaceTemplateTextQuotes(this.s);
        int i = 0;
        while (i < this.s.length()) {
            char c = this.s.charAt(i);
            switch (c) {
                case '\b': {
                    this.parser.getScriptletsCode().append("\\b");
                    break;
                }
                case '\t': {
                    this.parser.getScriptletsCode().append("\\t");
                    break;
                }
                case '\r': {
                    break;
                }
                case '\n': {
                    this.parser.getScriptletsCode().append("\\r\\n");
                    break;
                }
                case '\f': {
                    this.parser.getScriptletsCode().append("\\f");
                    break;
                }
                case '\'': {
                    this.parser.getScriptletsCode().append("\\'");
                    break;
                }
                case '\"': {
                    this.parser.getScriptletsCode().append("\\\"");
                    break;
                }
                case '\\': {
                    this.parser.getScriptletsCode().append("\\\\");
                    break;
                }
                default: {
                    String s1;
                    if (c > '\u00ff') {
                        s1 = "00" + Integer.toHexString(c);
                        this.parser.getScriptletsCode().append("\\u").append(s1.substring(s1.length() - 4));
                        break;
                    }
                    if (c < ' ' || c >= '\u007f') {
                        s1 = "00" + Integer.toOctalString(c);
                        this.parser.getScriptletsCode().append('\\').append(s1.substring(s1.length() - 3));
                        break;
                    }
                    this.parser.getScriptletsCode().append(c);
                }
            }
            ++i;
        }
        this.parser.getScriptletsCode().append("\");").append("\r\n");
        this.debugInfo.writeEnd(this.parser.getScriptletsCode());
    }

    public char[] indent() {
        return this.START_TAG_INDENT;
    }

    public void verifyAttributes() throws JspParseException {
        if (this.attributes != null) {
            throw new JspParseException("servlet_jsp_0073", new Object[]{"jsp:text"}, this.debugInfo.start, this.parser);
        }
    }

    public Element parse(Parser parser) throws JspParseException {
        this.parser = parser;
        this.startIndex = parser.currentPos();
        Position startDebugPos = parser.currentDebugPos();
        int i = 0;
        while (i < this.START_TAG_INDENT.length) {
            parser.nextChar();
            ++i;
        }
        parser.nextChar();
        parser.parseTo(this.END_TAG_INDENT, false);
        if (parser.currentChar() != '<') {
            throw new JspParseException("servlet_jsp_0074", parser.currentDebugPos(), parser);
        }
        int i2 = 1;
        while (i2 < this.END_TAG_INDENT.length) {
            char chr = parser.nextChar();
            if (this.END_TAG_INDENT[i2] != chr) {
                throw new JspParseException("servlet_jsp_0074", parser.currentDebugPos(), parser);
            }
            ++i2;
        }
        parser.nextChar();
        Position endDebugPos = parser.currentDebugPos();
        this.debugInfo = new DebugInfo(startDebugPos, endDebugPos, parser.currentFileName());
        this.endIndex = parser.currentPos();
        return this;
    }

    private void removeCDATA() {
        int sCdata;
        int eCdata;
        if (this.s.startsWith("<![CDATA[") && this.s.endsWith("]]>")) {
            this.s = this.s.substring(9, this.s.length() - 3);
        } else if (this.s.indexOf("<![CDATA[") > -1 && (eCdata = this.s.indexOf("]]>", sCdata = this.s.indexOf("<![CDATA["))) > -1) {
            StringBuffer buf = new StringBuffer(this.s);
            buf.delete(sCdata, sCdata + 9);
            buf.delete(eCdata - 9, eCdata - 6);
            this.s = buf.toString();
        }
    }

    public String getString() {
        if (this.s.trim().startsWith("<![CDATA[")) {
            return this.s.trim();
        }
        return startTag + this.s.trim() + endTag;
    }
}

