/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.xmlsyntax;

import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.servlets_jsp.lib.jspparser.exceptions.JspParseException;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Element;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Indentifier;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.OutputCommentElement;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.xmlsyntax.JspDirectiveTag;
import com.sap.engine.services.servlets_jsp.server.Log;
import java.io.File;
import java.io.IOException;

public class JspIncludeDirectiveTag
extends JspDirectiveTag {
    private static final char[][] attributeNames = new char[][]{"file".toCharArray()};

    public JspIncludeDirectiveTag() {
        this.elementType = 4;
    }

    public void action() throws JspParseException {
        this.body.action();
    }

    public void verifyAttributes() throws JspParseException {
        String path;
        if (this.attributes == null || this.attributes.length != 1) {
            throw new JspParseException("servlet_jsp_0088", new Object[]{"include"}, this.debugInfo.start, this.parser);
        }
        Indentifier e = this.attributes[0].name;
        if (!this.parser.compare(e.startIndex, e.endIndex, attributeNames[0])) {
            throw new JspParseException("servlet_jsp_0089", new Object[]{"file", "include"}, this.debugInfo.start, this.parser);
        }
        String attributeValue = this.getAttributeValue("file");
        if (attributeValue.startsWith("/")) {
            path = this.parser.getRealPath(attributeValue);
        } else {
            path = this.parser.getPath() + "/" + attributeValue;
            path = new File(path).getAbsolutePath().replace(File.separatorChar, '/');
        }
        path = ParseUtils.canonicalize((String)path);
        try {
            if (!this.isIncludeAllowed(path)) {
                throw new JspParseException("servlet_jsp_0285", new Object[]{attributeValue}, this.debugInfo.start, this.parser);
            }
        }
        catch (IOException io) {
            throw new JspParseException("servlet_jsp_0285", new Object[]{attributeValue}, this.debugInfo.start, this.parser, io);
        }
        File f = new File(path);
        this.body = this.parser.parse(f);
    }

    public String toString() {
        String ret = "";
        ret = this.body != null ? ret + this.body : ret + super.toString();
        return ret;
    }

    public String getString() throws JspParseException {
        Element[] elements = this.body.elements;
        String include = "";
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof OutputCommentElement)) {
                include = include + elements[i].getString() + "\n";
            }
            ++i;
        }
        return include;
    }

    private boolean isIncludeAllowed(String path) throws IOException {
        File f = new File(path);
        if (!f.exists() || !f.getCanonicalPath().replace(File.separatorChar, '/').equals(path)) {
            return false;
        }
        String rootDir = this.parser.getRealPath("");
        if (!path.startsWith(rootDir)) {
            return false;
        }
        String relativeToRootPath = path.substring(rootDir.length()).toLowerCase();
        if (relativeToRootPath.startsWith("web-inf/") || relativeToRootPath.startsWith("/web-inf/") || relativeToRootPath.equals("web-inf") || relativeToRootPath.startsWith("meta-inf/") || relativeToRootPath.startsWith("/meta-inf/") || relativeToRootPath.equals("meta-inf")) {
            Log.getLocation(4).traceWarning("Including a file from [META-INF] or [WEB-INF] directories in include directive. The file is: [" + relativeToRootPath + "].", null);
        }
        return true;
    }
}

