/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.jspparser.syntax;

import com.sap.engine.services.servlets_jsp.lib.jspparser.exceptions.JspParseException;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.DebugInfo;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Parser;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Position;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.TemplateData;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class Element {
    public static final int UNKNOWN = -1;
    public static final int TEMPLATE_DATA = 0;
    public static final int OUTPUT_COMMENT = 1;
    public static final int JSP_COMMENT = 2;
    public static final int PAGE_DIRECTIVE = 3;
    public static final int INCLUDE_DIRECTIVE = 4;
    public static final int TAGLIB_DIRECTIVE = 5;
    public static final int ATTRIBUTE = 6;
    public static final int INDENTIFIER = 7;
    public static final int ACTION = 8;
    public static final int XML_TAG = 9;
    public static final int SCRIPT = 10;
    public static final String WHITE_SPACE_CHARS = "\n\r\t ";
    public LinkedList parsingElements = new LinkedList();
    public char[][] prefixes = new char[0][];
    public Element[] _elements = new Element[0];
    public Hashtable allPrefixes = new Hashtable();
    public int elementType;
    public int startIndex;
    public int endIndex;
    public DebugInfo debugInfo;
    public Element[] elements;
    public Parser parser;

    public abstract void action() throws JspParseException;

    public abstract char[] indent() throws JspParseException;

    public abstract Element parse(Parser var1) throws JspParseException;

    public DebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    public Element[] getElements() {
        return this.elements;
    }

    public void setDebugInfo(DebugInfo debugInfo) {
        this.debugInfo = debugInfo;
    }

    public boolean isWhiteSpace(char c) {
        return WHITE_SPACE_CHARS.indexOf(c) != -1;
    }

    public void dump(String str) {
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public Element parseTo(Parser parser, char[] endIndent) throws JspParseException {
        throw new JspParseException("servlet_jsp_0077");
    }

    public final void registerParsingElement(Element el) throws JspParseException {
        Object o = this.allPrefixes.get(String.copyValueOf(el.indent()));
        if (o == null) {
            this.parsingElements.add(el);
            char[][] newPrefixes = new char[this.prefixes.length + 1][];
            Element[] new_elements = new Element[this._elements.length + 1];
            System.arraycopy(this.prefixes, 0, newPrefixes, 0, this.prefixes.length);
            System.arraycopy(this._elements, 0, new_elements, 0, this._elements.length);
            newPrefixes[this.prefixes.length] = el.indent();
            this.allPrefixes.put(String.copyValueOf(el.indent()), "");
            new_elements[this._elements.length] = el;
            this.prefixes = newPrefixes;
            this._elements = new_elements;
        }
    }

    public final Element getNextElement(Parser parser) throws JspParseException {
        try {
            if (parser.endReached()) {
                return null;
            }
            int whiteStart = parser.currentPos();
            Position whiteStartDebugPos = parser.currentDebugPos();
            parser.skipWhiteSpace();
            int whiteEnd = parser.currentPos();
            if (whiteStart != whiteEnd) {
                Position whiteEndDebugPos = parser.currentDebugPos();
                DebugInfo info = new DebugInfo(whiteStartDebugPos, whiteEndDebugPos, parser.currentFileName());
                return new TemplateData(whiteStart, whiteEnd, info).parse(parser);
            }
            if (parser.endReached()) {
                return null;
            }
            int position = parser.currentPos();
            Element found = null;
            int i = 0;
            while (i < this.prefixes.length) {
                if (parser.compare(position, position + this.prefixes[i].length, this.prefixes[i])) {
                    if (found == null) {
                        found = this._elements[i];
                    } else if (found.indent().length < this._elements[i].indent().length) {
                        found = this._elements[i];
                    }
                }
                ++i;
            }
            if (found != null) {
                return found;
            }
            if (!parser.endReached()) {
                do {
                    parser.nextChar();
                } while (!this.hasElementAsNext(parser));
                Position whiteEndDebugPos = parser.currentDebugPos();
                DebugInfo info = new DebugInfo(whiteStartDebugPos, whiteEndDebugPos, parser.currentFileName());
                return new TemplateData(position, parser.currentPos(), info).parse(parser);
            }
            return null;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new JspParseException("servlet_jsp_0068", parser.currentDebugPos(), parser);
        }
    }

    public final Element getNextElement(Parser parser, char[] endIndent) throws JspParseException {
        Position whiteStartDebugPos = null;
        try {
            if (parser.endReached()) {
                return null;
            }
            int whiteStart = parser.currentPos();
            whiteStartDebugPos = parser.currentDebugPos();
            parser.skipWhiteSpace();
            int whiteEnd = parser.currentPos();
            if (whiteStart != whiteEnd) {
                Position whiteEndDebugPos = parser.currentDebugPos();
                DebugInfo info = new DebugInfo(whiteStartDebugPos, whiteEndDebugPos, parser.currentFileName());
                return new TemplateData(whiteStart, whiteEnd, info).parse(parser);
            }
            if (parser.endReached()) {
                return null;
            }
            int position = parser.currentPos();
            if (parser.compare(position, position + endIndent.length, endIndent)) {
                return null;
            }
            Element found = null;
            int i = 0;
            while (i < this.prefixes.length) {
                if (parser.compare(position, position + this.prefixes[i].length, this.prefixes[i])) {
                    if (found == null) {
                        found = this._elements[i];
                    } else if (found.indent().length < this._elements[i].indent().length) {
                        found = this._elements[i];
                    }
                }
                ++i;
            }
            if (found != null) {
                return found;
            }
            int pos = position;
            do {
                parser.nextChar();
            } while (!parser.compare(++pos, pos + endIndent.length, endIndent) && !this.hasElementAsNext(parser));
            Position whiteEndDebugPos = parser.currentDebugPos();
            DebugInfo info = new DebugInfo(whiteStartDebugPos, whiteEndDebugPos, parser.currentFileName());
            return new TemplateData(position, parser.currentPos(), info).parse(parser);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new JspParseException("servlet_jsp_0069", new Object[]{String.copyValueOf(endIndent)}, whiteStartDebugPos, parser);
        }
    }

    public final boolean hasElementAsNext(Parser parser) throws JspParseException {
        if (parser.endReached()) {
            return true;
        }
        int position = parser.currentPos();
        int i = 0;
        i = 0;
        while (i < this.prefixes.length) {
            if (parser.compare(position, position + this.prefixes[i].length, this.prefixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        if (this.elements == null) {
            return super.toString();
        }
        String ret = "\n{ ";
        int i = 0;
        while (i < this.elements.length) {
            ret = ret + "\n\t" + this.tab("" + this.elements[i].toString()) + "";
            ++i;
        }
        ret = ret + "\n} ";
        return ret;
    }

    protected String tab(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n");
        StringBuffer sb = new StringBuffer();
        sb.append(st.nextToken());
        while (st.hasMoreTokens()) {
            sb.append("\n\t");
            sb.append(st.nextToken());
        }
        return sb.toString();
    }

    protected String formatPosition(Position pos, Parser parser) {
        String s = parser.currentFileName();
        s = s.replace('\\', File.separatorChar);
        return "\r\nError in file:" + s + " at line:" + pos.line + " position:" + pos.linePos;
    }

    protected String escape(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
        }
        return "" + c;
    }

    public abstract String getString() throws JspParseException;
}

