/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.jspparser;

import com.sap.engine.services.servlets_jsp.lib.jspparser.exceptions.JspParseException;
import java.util.Enumeration;
import java.util.Hashtable;

public class PluginGenerator {
    public String IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    public static final String IE_PLUGIN_URL = "http://java.sun.com/products/plugin/1.2.2/jinstall-1_2_2-win.cab#Version=1,2,2,0";
    public static final String NS_PLUGIN_URL = "http://java.sun.com/products/plugin/";
    private String indent = "      ";
    private Hashtable attrs = null;
    private Hashtable param = null;
    private String fallback = null;
    private String ieClassId = null;

    public PluginGenerator(Hashtable attrs, Hashtable param, String fallback) {
        this.attrs = attrs;
        this.param = param;
        this.fallback = fallback;
    }

    public void init(String ieClassId) throws JspParseException {
        this.ieClassId = ieClassId == null ? this.IE_CLASS_ID : ieClassId;
    }

    public void generate(StringBuffer writer) throws JspParseException {
        String type = this.getAttribute("type");
        String code = this.getAttribute("code");
        String codebase = this.getAttribute("codebase");
        String archive = this.getAttribute("archive");
        String jreversion = this.getAttribute("jreversion");
        String nspluginurl = this.getAttribute("nspluginurl");
        String iepluginurl = this.getAttribute("iepluginurl");
        if (type == null) {
            throw new JspParseException("servlet_jsp_0057", new Object[]{"type"});
        }
        if (code == null) {
            throw new JspParseException("servlet_jsp_0057", new Object[]{"code"});
        }
        writer.append(this.indent + "/*Code generated for plugin*/" + "\n");
        writer.append(this.indent + "out.println (\"<OBJECT classid=\\\"");
        writer.append(this.ieClassId);
        writer.append("\\\"");
        this.generateCommon(writer);
        writer.append(" codebase=\\\"");
        if (iepluginurl == null) {
            writer.append(IE_PLUGIN_URL);
        } else {
            writer.append(iepluginurl);
        }
        writer.append("\\\"");
        writer.append(">\");");
        writer.append("\n");
        writer.append(this.indent + "out.println (\"<PARAM name=\\\"java_code\\\"");
        writer.append(" value=\\\"");
        writer.append(code);
        writer.append("\\\"");
        writer.append(">\");");
        writer.append("\n");
        if (codebase != null) {
            writer.append(this.indent + "out.println (\"<PARAM name=\\\"java_codebase\\\"");
            writer.append(" value=\\\"");
            writer.append(codebase);
            writer.append("\\\"");
            writer.append(">\");");
            writer.append("\n");
        }
        if (archive != null) {
            writer.append(this.indent + "out.println (\"<PARAM name=\\\"java_archive\\\"");
            writer.append(" value=\\\"");
            writer.append(archive);
            writer.append("\\\"");
            writer.append(">\");");
            writer.append("\n");
        }
        writer.append(this.indent + "out.println (\"<PARAM name=\\\"type\\\"");
        writer.append(" value=\\\"");
        if (type.equals("applet")) {
            writer.append("application/x-java-applet;");
        } else if (type.equals("bean")) {
            writer.append("application/x-java-bean;");
        }
        if (jreversion != null) {
            writer.append("version=");
            writer.append(jreversion);
        }
        writer.append("\\\"");
        writer.append(">\");");
        writer.append("\n");
        Enumeration e = null;
        String value = null;
        String key = null;
        if (this.param != null) {
            e = this.param.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = (String)this.param.get(key);
                writer.append(this.indent + "out.println (\"<PARAM name=\\\"");
                if (key.equalsIgnoreCase("object")) {
                    writer.append("java_object");
                } else if (key.equalsIgnoreCase("type")) {
                    writer.append("java_type");
                } else {
                    writer.append(key);
                }
                writer.append("\\\"");
                writer.append(" value=");
                writer.append(this.getExpression(value));
                writer.append(">\");");
                writer.append("\n");
            }
        }
        writer.append(this.indent + "out.println (\"<COMMENT>\");\n");
        writer.append(this.indent + "out.print(\"<EMBED type=\\\"");
        if (type.equals("applet")) {
            writer.append("application/x-java-applet;");
        } else if (type.equals("bean")) {
            writer.append("application/x-java-bean;");
        }
        if (jreversion != null) {
            writer.append("version=");
            writer.append(jreversion);
        }
        writer.append("\\\" ");
        this.generateCommon(writer);
        writer.append("pluginspage=\\\"");
        if (nspluginurl == null) {
            writer.append(NS_PLUGIN_URL);
        } else {
            writer.append(nspluginurl);
        }
        writer.append("\\\" ");
        writer.append("java_code=\\\"");
        writer.append(code);
        writer.append("\\\" ");
        if (codebase != null) {
            writer.append("java_codebase=\\\"");
            writer.append(codebase);
            writer.append("\\\" ");
        }
        if (archive != null) {
            writer.append("java_archive=\\\"");
            writer.append(archive);
            writer.append("\\\" ");
        }
        if (this.param != null) {
            e = this.param.keys();
            key = null;
            value = null;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = (String)this.param.get(key);
                if (key.equalsIgnoreCase("object")) {
                    writer.append("java_object");
                } else if (key.equalsIgnoreCase("type")) {
                    writer.append("java_type");
                } else {
                    writer.append(key);
                }
                writer.append("=\\\"");
                writer.append(value);
                writer.append("\\\"");
                writer.append(" ");
            }
        }
        writer.append(">\");");
        writer.append("\n");
        writer.append(this.indent + "out.println (\"<NOEMBED>\");\n");
        writer.append(this.indent + "out.println (\"</COMMENT>\");\n");
        if (this.fallback != null) {
            this.fallback = this.quoteString(this.fallback);
            writer.append(this.indent + "out.println (");
            writer.append(this.fallback);
            writer.append(");");
            writer.append("\n");
        }
        writer.append(this.indent + "out.println (\"</NOEMBED></EMBED>\");\n");
        writer.append(this.indent + "out.println (\"</OBJECT>\");\n");
    }

    public void generateCommon(StringBuffer writer) {
        String align = this.getAttribute("align");
        String width = this.getAttribute("width");
        String height = this.getAttribute("height");
        String hspace = this.getAttribute("hspace");
        String vspace = this.getAttribute("vspace");
        if (width != null) {
            writer.append(" width=");
            writer.append(this.getExpression(width));
        }
        if (height != null) {
            writer.append(" height=");
            writer.append(this.getExpression(height));
        }
        if (hspace != null) {
            writer.append(" hspace=\\\"");
            writer.append(hspace);
            writer.append("\\\" ");
        }
        if (vspace != null) {
            writer.append(" vspace=\\\"");
            writer.append(vspace);
            writer.append("\\\" ");
        }
        if (align != null) {
            writer.append(" align=\\\"");
            writer.append(align);
            writer.append("\\\" ");
        }
    }

    public String quoteString(String s) {
        if (s == null) {
            return "null";
        }
        if (s.indexOf(34) < 0 && s.indexOf(92) < 0 && s.indexOf(10) < 0 && s.indexOf(13) < 0) {
            return "\"" + s + "\"";
        }
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '\\' && i + 1 < len) {
                sb.append('\\');
                sb.append('\\');
                sb.append(s.charAt(++i));
            } else if (ch == '\"') {
                sb.append('\\');
                sb.append('\"');
            } else if (ch == '\n') {
                sb.append("\\n");
            } else if (ch == '\r') {
                sb.append("\\r");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public String getAttribute(String name) {
        return this.attrs != null ? (String)this.attrs.get(name) : null;
    }

    private String getExpression(String expression) {
        if ((expression = expression.trim()).startsWith("<%=")) {
            return "\\\"\" + " + expression.substring(3, expression.length() - 2).trim() + " + \"\\\"";
        }
        if (expression.startsWith("<jsp:expression>")) {
            return "\\\"\" + " + expression.substring(16, expression.length() - 17).trim() + " + \"\\\"";
        }
        return "\\\"" + expression + "\\\"";
    }
}

