/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.gui.tree;

import com.sap.engine.services.deploy.gui.ImageHolder;
import com.sap.engine.services.servlets_jsp.gui.tree.UserObject;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class ServletJspTreeRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    private Icon container;
    private Icon startedEar;
    private Icon stoppedEar;
    private Icon web;
    private Icon servlet;
    private Icon listener;
    private Icon filter;
    private Icon defaultIcon;
    private Icon globalWebXml;
    private Icon jspIcon;

    public ServletJspTreeRenderer() {
        this.initImages();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        DefaultTreeCellRenderer result = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        UserObject compObj = (UserObject)((DefaultMutableTreeNode)value).getUserObject();
        int type = compObj.getType();
        switch (type) {
            case 0: {
                result.setIcon(this.container);
                break;
            }
            case 1: {
                result.setIcon(this.startedEar);
                break;
            }
            case 2: {
                result.setIcon(this.stoppedEar);
                break;
            }
            case 3: {
                result.setIcon(this.web);
                break;
            }
            case 4: {
                result.setIcon(this.servlet);
                break;
            }
            case 5: {
                result.setIcon(this.filter);
                break;
            }
            case 6: {
                result.setIcon(this.listener);
                break;
            }
            case 7: {
                result.setIcon(this.globalWebXml);
                break;
            }
            case 8: {
                result.setIcon(this.jspIcon);
                break;
            }
            default: {
                result.setIcon(this.defaultIcon);
            }
        }
        result.setEnabled(tree.isEnabled());
        result.setText(compObj.getName());
        return result;
    }

    private void initImages() {
        this.container = ImageHolder.serverIcon;
        this.startedEar = ImageHolder.startedIcon;
        this.stoppedEar = ImageHolder.stoppedIcon;
        this.web = ImageHolder.aWarIcon;
        this.servlet = ImageHolder.aWebIcon;
        this.listener = ImageHolder.listenerIcon;
        this.filter = ImageHolder.filterIcon;
        this.globalWebXml = ImageHolder.globalWebXmlIcon;
        this.defaultIcon = ImageHolder.aDefaultIcon;
        this.jspIcon = ImageHolder.servletJspIcon;
    }
}

