/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.xml;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.servlets_jsp.descriptor.AuthConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.ErrorPage;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.FilterMapping;
import com.sap.engine.services.servlets_jsp.descriptor.FormLoginConfig;
import com.sap.engine.services.servlets_jsp.descriptor.LoginConfig;
import com.sap.engine.services.servlets_jsp.descriptor.MIMEMapping;
import com.sap.engine.services.servlets_jsp.descriptor.SecurityConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletMapping;
import com.sap.engine.services.servlets_jsp.descriptor.TagLib;
import com.sap.engine.services.servlets_jsp.descriptor.UserDataConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebResourceCollection;
import com.sap.engine.services.servlets_jsp.descriptor.xml.EnvironmentXmlUtil;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWrongDescriptorException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWrongStructureException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebDescriptorDocument {
    public static final String simpleDTD = "<!DOCTYPE web-app PUBLIC '-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN' 'http://java.sun.com/dtd/web-app_2_3.dtd'>";
    public static final String dtd = "<!DOCTYPE web-app PUBLIC '-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN' 'http://java.sun.com/dtd/web-app_2_3.dtd'>";
    protected Document mainDocument;
    protected Vector securityRoles = new Vector();
    private String illegalArgumentException = null;
    private String rootPath = null;

    public WebDescriptorDocument() {
    }

    public WebDescriptorDocument(WebDeploymentDescriptor descriptor) {
        this.loadSimpleDocumentFromDescriptor(descriptor);
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void setMainDocument(Document doc) {
        this.mainDocument = doc;
    }

    public Document loadSimpleDocumentFromDescriptor(WebDeploymentDescriptor descriptor) {
        this.mainDocument = StandardDOMParser.createDocument();
        this.mainDocument.appendChild(this.loadSimpleElement(descriptor, this.mainDocument));
        return this.mainDocument;
    }

    public Document loadDocumentFromDescriptor(WebDeploymentDescriptor descriptor) {
        return this.loadSimpleDocumentFromDescriptor(descriptor);
    }

    public WebDeploymentDescriptor loadDescriptorFromDocument(Document document) throws WrongStructureException, IllegalArgumentException, WebWrongDescriptorException {
        Element elm = document.getDocumentElement();
        return this.loadDescriptorFromElement(elm);
    }

    public WebDeploymentDescriptor loadDescriptorFromDocument(Document document, String rootPath) throws WrongStructureException, IllegalArgumentException, WebWrongDescriptorException {
        this.rootPath = rootPath;
        Element elm = document.getDocumentElement();
        return this.loadDescriptorFromElement(elm);
    }

    public WebDeploymentDescriptor loadDescriptorFromElement(Element elmnt) throws WrongStructureException, IllegalArgumentException, WebWrongDescriptorException {
        NodeList list = elmnt.getChildNodes();
        WebDeploymentDescriptor webDescriptor = new WebDeploymentDescriptor();
        Element element = null;
        String tag = null;
        webDescriptor.setDistributable(false);
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("description")) {
                    webDescriptor.setDescription(this.getTextValue(element));
                } else if (tag.equals("session-config")) {
                    webDescriptor.setSessionTimeout(this.initTimeOut(element));
                } else if (tag.equals("display-name")) {
                    webDescriptor.setDisplayName(this.getTextValue(element));
                } else if (tag.equals("icon")) {
                    this.initIcons(webDescriptor, element);
                } else if (tag.equals("distributable")) {
                    webDescriptor.setDistributable(true);
                } else if (tag.equals("context-param")) {
                    webDescriptor.addContextParam(this.initParams(element));
                } else if (tag.equals("servlet")) {
                    webDescriptor.addServlet(this.initServlets(element));
                } else if (tag.equals("servlet-mapping")) {
                    webDescriptor.addServletMapping(this.initServletMappings(element));
                } else if (tag.equals("mime-mapping")) {
                    webDescriptor.addMIMEMapping(this.initMIMEMapping(element));
                } else if (tag.equals("welcome-file-list")) {
                    webDescriptor.setWelcomeFileList(this.initWelcomeFiles(element));
                } else if (tag.equals("taglib")) {
                    webDescriptor.addTagLib(this.initTagLibs(element));
                } else if (tag.equals("error-page")) {
                    webDescriptor.addErrorPage(this.initErrorPages(element));
                } else if (tag.equals("resource-ref")) {
                    webDescriptor.addResReference(this.initResourceReferences(element));
                } else if (tag.equals("resource-env-ref")) {
                    webDescriptor.addResEnvReference(this.initResourceEnvReferences(element));
                } else if (tag.equals("ejb-ref")) {
                    webDescriptor.addEjbRef(this.initEJBRefs(element));
                } else if (tag.equals("ejb-local-ref")) {
                    webDescriptor.addEjbLocalRef(this.initEJBLocalRefs(element));
                } else if (tag.equals("env-entry")) {
                    webDescriptor.addEnvEntry(this.initEnvEntries(element));
                } else if (tag.equals("login-config")) {
                    webDescriptor.setLoginConfig(this.initLoginConfig(element));
                } else if (tag.equals("security-role")) {
                    webDescriptor.addSecRole(this.getSecurityRoles(element, "security-role"));
                } else if (tag.equals("security-constraint")) {
                    webDescriptor.addSecConstraint(this.initSecurityConstraints(element));
                } else if (tag.equals("filter")) {
                    webDescriptor.addFilter(this.initFilter(element));
                } else if (tag.equals("filter-mapping")) {
                    webDescriptor.addFilterMapping(this.initFilterMapping(element));
                } else if (tag.equals("listener")) {
                    webDescriptor.addListener(this.initListener(element));
                }
            }
            ++i;
        }
        return webDescriptor;
    }

    public Element loadSimpleElement(WebDeploymentDescriptor descriptor, Document document) {
        Element docElement = null;
        Element tempElement = null;
        String tempName = null;
        this.mainDocument = document;
        EnvironmentXmlUtil xmlUtil = new EnvironmentXmlUtil();
        docElement = document.createElement("web-app");
        if (descriptor.getSmallIcon() != null || descriptor.getLargeIcon() != null) {
            tempElement = document.createElement("icon");
            if (descriptor.getSmallIcon() != null) {
                this.load(tempElement, descriptor.getSmallIcon().getFileName(), "small-icon");
            }
            if (descriptor.getLargeIcon() != null) {
                this.load(tempElement, descriptor.getLargeIcon().getFileName(), "large-icon");
            }
            docElement.appendChild(tempElement);
        }
        if ((tempName = descriptor.getDisplayName()) != null) {
            this.load(docElement, tempName, "display-name");
        }
        if ((tempName = descriptor.getDescription()) != null) {
            this.load(docElement, tempName, "description");
        }
        if (descriptor.getDistributable()) {
            this.load(docElement, null, "distributable");
        }
        this.loadContextParams(docElement, descriptor.getContextParams(), "context-param");
        this.loadFilters(docElement, descriptor.getFilters());
        this.loadFilterMappings(docElement, descriptor.getFilterMappings());
        this.loadListeners(docElement, descriptor.getListeners());
        this.loadServlets(docElement, descriptor.getServlets());
        this.loadServletMapping(docElement, descriptor.getServletMapping());
        this.loadTimeOut(docElement, descriptor.getSessionTimeout());
        this.loadMimeMapping(docElement, descriptor.getMIMEMapping());
        this.loadWelcomeFiles(docElement, descriptor.getWelcomeFileList());
        this.loadErrorPages(docElement, descriptor.getErrorPage());
        this.loadTagLibElement(docElement, descriptor.getTagLib());
        xmlUtil.loadResourceEnvRefs(this.mainDocument, docElement, descriptor.getResEnvReferences());
        xmlUtil.loadResourceRefs(this.mainDocument, docElement, descriptor.getResReferences());
        this.loadSecurityConstraints(docElement, descriptor.getSecConstraints());
        this.loadLoginConfig(docElement, descriptor.getLoginConfig());
        xmlUtil.loadSecurityRoles(this.mainDocument, docElement, descriptor.getSecRoles());
        xmlUtil.addError(this.loadEnvEntr(docElement, descriptor.getEnvEntries()));
        xmlUtil.loadEjbRefs(this.mainDocument, docElement, descriptor.getEjbRefs());
        xmlUtil.loadEjbLocalRefs(this.mainDocument, docElement, descriptor.getEjbLocalRefs());
        this.illegalArgumentException = xmlUtil.getErrors();
        return docElement;
    }

    protected void loadTimeOut(Element el, int value) {
        Element timeEl = null;
        timeEl = this.mainDocument.createElement("session-config");
        this.load(timeEl, String.valueOf(value), "session-timeout");
        el.appendChild(timeEl);
    }

    protected void loadWelcomeFiles(Element el, String[] welcomeFiles) {
        if (welcomeFiles != null && welcomeFiles.length != 0) {
            Element welcomeEl = this.mainDocument.createElement("welcome-file-list");
            int i = 0;
            while (i < welcomeFiles.length) {
                if (welcomeFiles[i] != null) {
                    this.load(welcomeEl, welcomeFiles[i], "welcome-file");
                }
                ++i;
            }
            el.appendChild(welcomeEl);
        }
    }

    protected ResourceReference initResourceReferences(Element elmnt) {
        NodeList refsList = elmnt.getChildNodes();
        if (refsList != null) {
            Element refEl = null;
            ResourceReference resRef = new ResourceReference();
            String nextElTag = null;
            String value = null;
            int i = 0;
            while (i < refsList.getLength()) {
                if (refsList.item(i).getNodeType() == 1) {
                    String link;
                    refEl = (Element)refsList.item(i);
                    nextElTag = refEl.getNodeName();
                    if (nextElTag.equals("description")) {
                        value = this.getTextValue(refEl);
                        resRef.setResourceDescription(value);
                    } else if (nextElTag.equals("res-ref-name")) {
                        value = this.getTextValue(refEl);
                        resRef.setResourceName(value);
                    } else if (nextElTag.equals("res-type")) {
                        value = this.getTextValue(refEl);
                        resRef.setResourceType(value);
                    } else if (nextElTag.equals("res-auth")) {
                        value = this.getTextValue(refEl);
                        if (value == null) {
                            resRef.setResourceAuthorization(2);
                        } else if (value.equals("SERVLET")) {
                            resRef.setResourceAuthorization(3);
                        } else if (value.equalsIgnoreCase("CONTAINER")) {
                            resRef.setResourceAuthorization(2);
                        } else if (value.equals("Application")) {
                            resRef.setResourceAuthorization(3);
                        }
                    } else if (nextElTag.equals("res-sharing-scope")) {
                        value = this.getTextValue(refEl);
                        if (value != null && value.equals("Unshareable")) {
                            resRef.setResourceSharingScope(1);
                        } else {
                            resRef.setResourceSharingScope(0);
                        }
                    } else if (nextElTag.equals("res-link") && (link = this.getTextValue(refEl)) != null && !link.equals("")) {
                        resRef.setResourceLink(link);
                    }
                }
                ++i;
            }
            return resRef;
        }
        return null;
    }

    protected ContextParam initParams(Element el) {
        NodeList paramsList = el.getChildNodes();
        ContextParam cParam = new ContextParam();
        String nextElTag = null;
        String value = null;
        Element paramEl = null;
        if (paramsList == null) {
            return null;
        }
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i) instanceof Element) {
                paramEl = (Element)paramsList.item(i);
                nextElTag = paramEl.getNodeName();
                if (nextElTag.equals("param-name")) {
                    value = this.getTextValue(paramEl);
                    cParam.setParamName(value);
                } else if (nextElTag.equals("param-value")) {
                    value = this.getTextValue(paramEl);
                    cParam.setParamValue(value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(paramEl);
                    cParam.setDescription(value);
                }
            }
            ++i;
        }
        if (cParam != null) {
            return cParam;
        }
        return null;
    }

    protected int initTimeOut(Element el) throws WebWrongDescriptorException {
        NodeList list = el.getChildNodes();
        Element nextEl = null;
        String nextElTag = "";
        String value = "";
        int timeout = 30;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (nextElTag = (nextEl = (Element)list.item(i)).getNodeName()).equals("session-timeout")) {
                value = this.getTextValue(nextEl);
                try {
                    timeout = new Integer(value);
                }
                catch (NumberFormatException nfe) {
                    throw new WebWrongDescriptorException("servlet_jsp_0253", new Object[]{value, "session-timeout"}, nfe);
                }
            }
            ++i;
        }
        return timeout;
    }

    protected SecurityRoles getSecurityRoles(Element el, String tagName) {
        NodeList rolesList = el.getChildNodes();
        Element rolesEl = null;
        SecurityRoles roles = new SecurityRoles();
        String nextElTag = null;
        String value = null;
        int i = 0;
        while (i < rolesList.getLength()) {
            if (rolesList.item(i).getNodeType() == 1) {
                String userGroup;
                rolesEl = (Element)rolesList.item(i);
                nextElTag = rolesEl.getNodeName();
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(rolesEl);
                    roles.setRoleDescription(value);
                } else if (nextElTag.equals("role-name")) {
                    value = this.getTextValue(rolesEl);
                    roles.setRoleName(value);
                } else if (nextElTag.equals("group-id")) {
                    String groupSID = this.getTextValue(rolesEl);
                    if (groupSID != null && !groupSID.equals("")) {
                        roles.setGroupSIDsElement(new Integer(groupSID).intValue());
                    }
                } else if (nextElTag.equals("user-id")) {
                    String userSID = this.getTextValue(rolesEl);
                    if (userSID != null && !userSID.equals("")) {
                        roles.setUserSIDsElement(new Integer(userSID).intValue());
                    }
                } else if (nextElTag.equals("user-name")) {
                    String userName = this.getTextValue(rolesEl);
                    if (userName != null && !userName.equals("")) {
                        roles.setUserName(userName);
                    }
                } else if (nextElTag.equals("group-name") && (userGroup = this.getTextValue(rolesEl)) != null && !userGroup.equals("")) {
                    roles.setUserGroup(userGroup);
                }
            }
            ++i;
        }
        return roles;
    }

    protected SecurityRoleReference getSecurityRoleReference(Element el, String tagName) {
        NodeList rolesList = el.getChildNodes();
        Element rolesEl = null;
        SecurityRoleReference roleRef = new SecurityRoleReference();
        String nextElTag = null;
        String value = null;
        int i = 0;
        while (i < rolesList.getLength()) {
            if (rolesList.item(i).getNodeType() == 1) {
                rolesEl = (Element)rolesList.item(i);
                nextElTag = rolesEl.getNodeName();
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(rolesEl);
                    roleRef.setDescription(value);
                } else if (nextElTag.equals("role-name")) {
                    value = this.getTextValue(rolesEl);
                    roleRef.setRoleName(value);
                } else if (nextElTag.equals("role-link")) {
                    value = this.getTextValue(rolesEl);
                    roleRef.setRoleLink(new SecurityRoles(value));
                }
            }
            ++i;
        }
        return roleRef;
    }

    protected String[] getSecurityRoleNames(Element elmnt) {
        NodeList roleNamesList = elmnt.getChildNodes();
        Vector<String> namesVector = null;
        if (roleNamesList != null) {
            namesVector = new Vector<String>();
            Element roleEl = null;
            String roleElTag = null;
            String name = null;
            int i = 0;
            while (i < roleNamesList.getLength()) {
                if (roleNamesList.item(i).getNodeType() == 1 && (roleElTag = (roleEl = (Element)roleNamesList.item(i)).getNodeName()).equals("role-name")) {
                    name = this.getTextValue(roleEl);
                    namesVector.add(name);
                }
                ++i;
            }
        }
        if (namesVector.size() > 0) {
            Object[] values = new String[namesVector.size()];
            namesVector.copyInto(values);
            return values;
        }
        return null;
    }

    protected void loadLoginConfig(Element loginElement, LoginConfig login) {
        String tempName = "";
        if (login != null) {
            Element lElement = this.mainDocument.createElement("login-config");
            if (login.getAuthMethod() != null) {
                tempName = login.getAuthMethod();
                this.load(lElement, tempName, "auth-method");
            }
            if (login.getRealmName() != null && !login.getRealmName().equals("")) {
                tempName = login.getRealmName();
                this.load(lElement, tempName, "realm-name");
            }
            if (login.getFormLogin() != null) {
                this.loadFormLoginConfig(lElement, login.getFormLogin());
            }
            loginElement.appendChild(lElement);
        }
    }

    protected LoginConfig initLoginConfig(Element el) {
        NodeList paramsList = el.getChildNodes();
        LoginConfig loginConfig = new LoginConfig();
        String nextElTag = null;
        String value = null;
        Element loginEl = null;
        if (paramsList == null) {
            return null;
        }
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                loginEl = (Element)paramsList.item(i);
                nextElTag = loginEl.getNodeName();
                if (nextElTag.equals("form-login-config")) {
                    loginConfig.setFormLogin(this.initFormConfig(loginEl));
                } else if (nextElTag.equals("realm-name")) {
                    value = this.getTextValue(loginEl);
                    loginConfig.setRealmName(value);
                } else if (nextElTag.equals("auth-method")) {
                    value = this.getTextValue(loginEl);
                    loginConfig.setAuthMethod(value);
                }
            }
            ++i;
        }
        if (loginConfig != null) {
            return loginConfig;
        }
        return null;
    }

    protected void loadFormLoginConfig(Element formElement, FormLoginConfig fConfig) {
        if (fConfig != null) {
            Element fEl = this.mainDocument.createElement("form-login-config");
            this.load(fEl, fConfig.getLoginPage(), "form-login-page");
            this.load(fEl, fConfig.getErrorPage(), "form-error-page");
            formElement.appendChild(fEl);
        }
    }

    protected FormLoginConfig initFormConfig(Element el) {
        NodeList paramsList = el.getChildNodes();
        FormLoginConfig fLogin = new FormLoginConfig();
        String nextElTag = null;
        String value = null;
        Element loginEl = null;
        if (paramsList == null) {
            return null;
        }
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i) instanceof Element) {
                loginEl = (Element)paramsList.item(i);
                nextElTag = loginEl.getNodeName();
                if (nextElTag.equals("form-login-page")) {
                    value = this.getTextValue(loginEl);
                    if (value != null) {
                        fLogin.setLoginPage(value);
                    } else {
                        fLogin.setLoginPage("");
                    }
                } else if (nextElTag.equals("form-error-page")) {
                    value = this.getTextValue(loginEl);
                    if (value != null) {
                        fLogin.setErrorPage(value);
                    } else {
                        fLogin.setErrorPage("");
                    }
                }
            }
            ++i;
        }
        if (fLogin != null) {
            return fLogin;
        }
        return null;
    }

    protected void loadServlets(Element servletElement, ServletDescriptor[] servlets) {
        String tempName = "";
        ContextParam[] iniParams = null;
        EnvironmentXmlUtil xmlUtil = new EnvironmentXmlUtil();
        if (servlets != null) {
            Element servletEl = null;
            int i = 0;
            while (i < servlets.length) {
                servletEl = this.mainDocument.createElement("servlet");
                if (servlets[i] != null) {
                    if (servlets[i].getSmallIcon() != null || servlets[i].getLargeIcon() != null) {
                        Element tempElement = this.mainDocument.createElement("icon");
                        if (servlets[i].getSmallIcon() != null) {
                            this.load(tempElement, servlets[i].getSmallIcon().getFileName(), "small-icon");
                        }
                        if (servlets[i].getLargeIcon() != null) {
                            this.load(tempElement, servlets[i].getLargeIcon().getFileName(), "large-icon");
                        }
                        servletEl.appendChild(tempElement);
                    }
                    tempName = servlets[i].getServletName();
                    this.load(servletEl, tempName, "servlet-name");
                    tempName = servlets[i].getDisplayName();
                    if (tempName != null) {
                        this.load(servletEl, tempName, "display-name");
                    }
                    if ((tempName = servlets[i].getDescription()) != null) {
                        this.load(servletEl, tempName, "description");
                    }
                    if ((tempName = servlets[i].getServletClass()) != null) {
                        this.load(servletEl, tempName, "servlet-class");
                    }
                    if ((tempName = servlets[i].getJspFile()) != null) {
                        this.load(servletEl, tempName, "jsp-file");
                    }
                    iniParams = servlets[i].getInitParams();
                    this.loadContextParams(servletEl, iniParams, "init-param");
                    tempName = String.valueOf(servlets[i].getLoadOnStartUp());
                    if (tempName != null) {
                        this.load(servletEl, tempName, "load-on-startup");
                    }
                    this.loadRunAs(servletEl, servlets[i].getRunAs());
                    xmlUtil.loadSecurityRoleRefs(this.mainDocument, servletEl, servlets[i].getRoleReferences());
                    this.illegalArgumentException = xmlUtil.getErrors();
                    servletElement.appendChild(servletEl);
                }
                ++i;
            }
        }
    }

    protected void loadContextParams(Element contEl, ContextParam[] params, String elementName) {
        String tempName = "";
        if (params != null) {
            Element paramEl = null;
            int i = 0;
            while (i < params.length) {
                if (params[i] != null) {
                    paramEl = this.mainDocument.createElement(elementName);
                    this.load(paramEl, params[i].getParamName(), "param-name");
                    this.load(paramEl, params[i].getParamValue(), "param-value");
                    tempName = params[i].getDescription();
                    if (tempName != null) {
                        this.load(paramEl, tempName, "description");
                    }
                    contEl.appendChild(paramEl);
                }
                ++i;
            }
        }
    }

    protected void loadServletMapping(Element servletElement, ServletMapping[] sMappings) {
        if (sMappings != null) {
            Element mappingEl = null;
            int i = 0;
            while (i < sMappings.length) {
                if (sMappings[i] != null) {
                    mappingEl = this.mainDocument.createElement("servlet-mapping");
                    this.load(mappingEl, sMappings[i].getServletName(), "servlet-name");
                    this.load(mappingEl, sMappings[i].getURLPattern(), "url-pattern");
                    servletElement.appendChild(mappingEl);
                }
                ++i;
            }
        }
    }

    public String loadEnvEntr(Element parent, EnvironmentEntry[] envEntr) {
        String errors = "";
        if (envEntr == null || envEntr.length == 0) {
            return null;
        }
        Element envEntryEl = null;
        int i = 0;
        while (i < envEntr.length) {
            if (envEntr[i] != null) {
                if (envEntr[i].getEntryName() == null || envEntr[i].getEntryName().trim().equals("")) {
                    errors = errors + "; " + "ID_016 Obligatory field  env-entry-name is missing." + ":" + (envEntr[i].getEntryName() == null ? "null" : "empty string");
                } else if (envEntr[i].getEntryType() == null || !this.checkEntryType(envEntr[i].getEntryType())) {
                    errors = errors + "; " + "ID_017 Wrong falue for env-entry-type. Type: \"{0}\"" + ":" + envEntr[i].getEntryType();
                } else {
                    envEntryEl = this.mainDocument.createElement("env-entry");
                    if (envEntr[i].getEntryDescription() != null && !envEntr[i].getEntryDescription().trim().equals("")) {
                        this.load(envEntryEl, envEntr[i].getEntryDescription(), "description");
                    }
                    this.load(envEntryEl, envEntr[i].getEntryName(), "env-entry-name");
                    if (envEntr[i].getEntryValue() != null && !envEntr[i].getEntryValue().toString().trim().equals("")) {
                        this.load(envEntryEl, envEntr[i].getEntryValue().toString(), "env-entry-value");
                    }
                    this.load(envEntryEl, envEntr[i].getEntryType(), "env-entry-type");
                    parent.appendChild(envEntryEl);
                }
            }
            ++i;
        }
        return errors;
    }

    private boolean checkEntryType(String type) {
        if (type.equals("java.lang.Double")) {
            return true;
        }
        if (type.equals("java.lang.Integer")) {
            return true;
        }
        if (type.equals("java.lang.Boolean")) {
            return true;
        }
        if (type.equals("java.lang.Float")) {
            return true;
        }
        if (type.equals("java.lang.String")) {
            return true;
        }
        if (type.equals("java.lang.Character")) {
            return true;
        }
        if (type.equals("java.lang.Byte")) {
            return true;
        }
        if (type.equals("java.lang.Short")) {
            return true;
        }
        return type.equals("java.lang.Long");
    }

    protected void loadErrorPages(Element errorElement, ErrorPage[] errorPages) {
        String tempName = "";
        int type = -1;
        if (errorPages != null) {
            Element errorEl = null;
            int i = 0;
            while (i < errorPages.length) {
                if (errorPages[i] != null) {
                    errorEl = this.mainDocument.createElement("error-page");
                    tempName = errorPages[i].getValue().toString();
                    if (tempName != null) {
                        type = errorPages[i].getType();
                        if (type == ErrorPage.exception_type) {
                            this.load(errorEl, tempName, "exception-type");
                        } else {
                            this.load(errorEl, tempName, "error-code");
                        }
                    }
                    this.load(errorEl, errorPages[i].getLocation(), "location");
                    errorElement.appendChild(errorEl);
                }
                ++i;
            }
        }
    }

    protected void loadMimeMapping(Element mimeElement, MIMEMapping[] mappings) {
        if (mappings != null) {
            Element mimeEl = null;
            int i = 0;
            while (i < mappings.length) {
                if (mappings[i] != null) {
                    mimeEl = this.mainDocument.createElement("mime-mapping");
                    this.load(mimeEl, mappings[i].getExtension(), "extension");
                    this.load(mimeEl, mappings[i].getMIMEType(), "mime-type");
                    mimeElement.appendChild(mimeEl);
                }
                ++i;
            }
        }
    }

    protected void loadTagLibElement(Element tagElement, TagLib[] tagLibs) {
        if (tagLibs != null) {
            Element tagEl = null;
            int i = 0;
            while (i < tagLibs.length) {
                if (tagLibs[i] != null) {
                    tagEl = this.mainDocument.createElement("taglib");
                    this.load(tagEl, tagLibs[i].getUri(), "taglib-uri");
                    this.load(tagEl, tagLibs[i].getLocation(), "taglib-location");
                    tagElement.appendChild(tagEl);
                }
                ++i;
            }
        }
    }

    protected void loadWebResourceCollections(Element collectionElement, WebResourceCollection[] webCollections) {
        String tempName = "";
        if (webCollections != null) {
            Element colEl = null;
            int i = 0;
            while (i < webCollections.length) {
                colEl = this.mainDocument.createElement("web-resource-collection");
                if (webCollections[i] != null) {
                    tempName = webCollections[i].getWebResourceName();
                    this.load(colEl, tempName, "web-resource-name");
                    tempName = webCollections[i].getDescription();
                    if (tempName != null) {
                        this.load(colEl, tempName, "description");
                    }
                    this.loadUrlPattern(colEl, webCollections[i].getUrlPattern());
                    this.loadHttpMethod(colEl, webCollections[i].getHttpMethod());
                    collectionElement.appendChild(colEl);
                }
                ++i;
            }
        }
    }

    protected void loadHttpMethod(Element element, String[] methods) {
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                this.load(element, methods[i], "http-method");
                ++i;
            }
        }
    }

    protected void loadUrlPattern(Element element, String[] patterns) {
        if (patterns != null) {
            int i = 0;
            while (i < patterns.length) {
                this.load(element, patterns[i], "url-pattern");
                ++i;
            }
        }
    }

    protected void loadUserDataConstraints(Element userElement, UserDataConstraints userConstraint) {
        String tempName = "";
        if (userConstraint != null) {
            Element uElement = this.mainDocument.createElement("user-data-constraint");
            tempName = userConstraint.getDescription();
            if (tempName != null) {
                this.load(uElement, tempName, "description");
            }
            this.load(uElement, userConstraint.getTransport(), "transport-guarantee");
            userElement.appendChild(uElement);
        }
    }

    protected void loadAuthConstraints(Element authElement, AuthConstraints authConstraint) {
        String tempName = "";
        if (authConstraint != null) {
            Element uElement = this.mainDocument.createElement("auth-constraint");
            tempName = authConstraint.getDescription();
            if (tempName != null) {
                this.load(uElement, tempName, "description");
            }
            this.loadRoleNames(uElement, authConstraint.getRoleNames());
            authElement.appendChild(uElement);
        }
    }

    protected void loadRoleNames(Element roleElement, String[] roleNames) {
        if (roleNames != null) {
            int i = 0;
            while (i < roleNames.length) {
                this.load(roleElement, roleNames[i], "role-name");
                ++i;
            }
        }
    }

    protected void loadSecurityConstraints(Element constraintsElement, SecurityConstraints[] secConstraints) {
        if (secConstraints != null) {
            Element sElement = null;
            int i = 0;
            while (i < secConstraints.length) {
                sElement = this.mainDocument.createElement("security-constraint");
                if (secConstraints[i] != null) {
                    String name = secConstraints[i].getDisplayName();
                    if (name != null) {
                        this.load(sElement, name, "display-name");
                    }
                    this.loadWebResourceCollections(sElement, secConstraints[i].getWebResourceCollections());
                    this.loadAuthConstraints(sElement, secConstraints[i].getAuthConstraints());
                    this.loadUserDataConstraints(sElement, secConstraints[i].getUserConstr());
                    constraintsElement.appendChild(sElement);
                }
                ++i;
            }
        }
    }

    protected void loadRunAs(Element runAsElem, RunAsIdentity runAs) {
        String tempName = "";
        if (runAs != null) {
            Element runAsEl = this.mainDocument.createElement("run-as");
            tempName = runAs.getDescription();
            if (tempName != null) {
                this.load(runAsEl, tempName, "description");
            }
            this.load(runAsEl, runAs.getSecurityRoleName(), "role-name");
            runAsElem.appendChild(runAsEl);
        }
    }

    protected void load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    protected void load(String name, String tagName) {
        this.load(this.mainDocument.getDocumentElement(), name, tagName);
    }

    protected SecurityConstraints initSecurityConstraints(Element el) throws WrongStructureException {
        if (el.getElementsByTagName("web-resource-collection").getLength() == 0) {
            throw new WebWrongStructureException(WebWrongStructureException.AT_LEAST_ONE_ELEMENT_MUST_BE_PRESENT_IN_ELEMENT, new Object[]{"<web-resource-collection>", "<security-constraint>"});
        }
        NodeList paramsList = el.getChildNodes();
        Vector<WebResourceCollection> webCollections = new Vector<WebResourceCollection>();
        Object[] collection = null;
        SecurityConstraints secConstr = new SecurityConstraints();
        String nextElTag = null;
        Element secEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                secEl = (Element)paramsList.item(i);
                nextElTag = secEl.getNodeName();
                if (nextElTag.equals("web-resource-collection")) {
                    webCollections.addElement(this.initWebCollection(secEl));
                } else if (nextElTag.equals("auth-constraint")) {
                    secConstr.setAuthorityConstraints(this.initAuthConstraints(secEl));
                } else if (nextElTag.equals("user-data-constraint")) {
                    secConstr.setUserDataConstraints(this.initUserDataConstraints(secEl));
                } else if (nextElTag.equals("display-name")) {
                    secConstr.setDisplayName(this.getTextValue(secEl));
                }
                collection = new WebResourceCollection[webCollections.size()];
                webCollections.copyInto(collection);
                secConstr.setWebCollections((WebResourceCollection[])collection);
            }
            ++i;
        }
        return secConstr;
    }

    protected WebResourceCollection initWebCollection(Element el) {
        NodeList paramsList = el.getChildNodes();
        WebResourceCollection webCollection = null;
        Object[] urls = null;
        Vector<String> urlPatterns = new Vector<String>();
        Vector<String> httpMethods = new Vector<String>();
        Object[] methods = null;
        Element nextEl = null;
        String nextElTag = null;
        String value = null;
        if (paramsList != null) {
            webCollection = new WebResourceCollection();
            int i = 0;
            while (i < paramsList.getLength()) {
                if (paramsList.item(i).getNodeType() == 1) {
                    nextEl = (Element)paramsList.item(i);
                    nextElTag = nextEl.getNodeName();
                    if (nextElTag.equals("web-resource-name")) {
                        value = this.getTextValue(nextEl);
                        webCollection.setWebResourceName(value);
                    } else if (nextElTag.equals("description")) {
                        value = this.getTextValue(nextEl);
                        webCollection.setDescription(value);
                    } else if (nextElTag.equals("url-pattern")) {
                        value = this.getTextValue(nextEl);
                        urlPatterns.addElement(value);
                    } else if (nextElTag.equals("http-method")) {
                        value = this.getTextValue(nextEl);
                        httpMethods.addElement(value);
                    }
                }
                ++i;
            }
            methods = new String[httpMethods.size()];
            httpMethods.copyInto(methods);
            urls = new String[urlPatterns.size()];
            urlPatterns.copyInto(urls);
            webCollection.setHttpMethod((String[])methods);
            webCollection.setUrlPattern((String[])urls);
        }
        return webCollection;
    }

    protected AuthConstraints initAuthConstraints(Element el) {
        NodeList params = el.getChildNodes();
        AuthConstraints auth = new AuthConstraints();
        Element authEl = null;
        String nextElTag = null;
        String value = "";
        Vector<String> roles = new Vector<String>();
        Object[] roleNames = null;
        int i = 0;
        while (i < params.getLength()) {
            if (params.item(i).getNodeType() == 1) {
                authEl = (Element)params.item(i);
                nextElTag = authEl.getNodeName();
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(authEl);
                    auth.setDescription(value);
                } else if (nextElTag.equals("role-name")) {
                    value = this.getTextValue(authEl);
                    roles.addElement(value);
                }
            }
            ++i;
        }
        if (roles.size() > 0) {
            roleNames = new String[roles.size()];
            roles.copyInto(roleNames);
            auth.setRoleName((String[])roleNames);
        }
        if (auth != null) {
            return auth;
        }
        return null;
    }

    protected UserDataConstraints initUserDataConstraints(Element el) {
        NodeList params = el.getChildNodes();
        UserDataConstraints user = new UserDataConstraints();
        Element nextEl = null;
        String nextElTag = null;
        String value = "";
        int i = 0;
        while (i < params.getLength()) {
            if (params.item(i).getNodeType() == 1) {
                nextEl = (Element)params.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(nextEl);
                    user.setDescription(value);
                } else if (nextElTag.equals("transport-guarantee")) {
                    value = this.getTextValue(nextEl);
                    user.setTransport(value);
                }
            }
            ++i;
        }
        if (user != null) {
            return user;
        }
        return null;
    }

    protected ServletMapping initServletMappings(Element el) {
        ServletMapping mapping = new ServletMapping();
        String nextElTag = null;
        String value = null;
        Element servletEl = null;
        NodeList paramsList = el.getChildNodes();
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                servletEl = (Element)paramsList.item(i);
                nextElTag = servletEl.getNodeName();
                if (nextElTag.equals("servlet-name")) {
                    value = this.getTextValue(servletEl);
                    mapping.setServletName(value);
                } else if (nextElTag.equals("url-pattern")) {
                    value = this.getTextValue(servletEl);
                    mapping.setURLPattern(value);
                }
            }
            ++i;
        }
        return mapping;
    }

    protected ServletDescriptor initServlets(Element el) throws IllegalArgumentException, WebWrongDescriptorException {
        NodeList paramsList = el.getChildNodes();
        Object[] valuesC = null;
        Vector<ContextParam> initParam = new Vector<ContextParam>();
        ServletDescriptor servlet = new ServletDescriptor();
        String nextElTag = null;
        String value = null;
        Element servletEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                servletEl = (Element)paramsList.item(i);
                nextElTag = servletEl.getNodeName();
                if (nextElTag.equals("servlet-name")) {
                    value = this.getTextValue(servletEl);
                    servlet.setServletName(value);
                } else if (nextElTag.equals("display-name")) {
                    value = this.getTextValue(servletEl);
                    servlet.setDisplayName(value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(servletEl);
                    servlet.setDescription(value);
                } else if (nextElTag.equals("servlet-class")) {
                    value = this.getTextValue(servletEl);
                    if (value != null && (value.indexOf(92) > -1 || value.indexOf(47) > -1)) {
                        throw new WebIllegalArgumentException("servlet_jsp_0244", new Object[]{value});
                    }
                    servlet.setServletClass(value);
                } else if (nextElTag.equals("jsp-file")) {
                    value = this.getTextValue(servletEl);
                    servlet.setJspFile(value);
                } else if (nextElTag.equals("icon")) {
                    this.initIcons(servlet, servletEl);
                } else if (nextElTag.equals("init-param")) {
                    initParam.addElement(this.initParams(servletEl));
                } else if (nextElTag.equals("load-on-startup")) {
                    value = this.getTextValue(servletEl);
                    int load_on_startup = -1;
                    try {
                        load_on_startup = new Integer(value);
                    }
                    catch (NumberFormatException e) {
                        load_on_startup = -1;
                    }
                    if (load_on_startup > -1) {
                        servlet.setLoadOnStartUp(load_on_startup);
                    } else {
                        servlet.setLoadOnStartUp(-1);
                    }
                } else if (nextElTag.equals("security-role-ref")) {
                    servlet.setRoleReference(this.getSecurityRoleReference(servletEl, "sec-role-ref"));
                } else if (nextElTag.equals("run-as")) {
                    servlet.setRunAs(this.initRunAs(servletEl, servlet.getServletName()));
                }
            }
            ++i;
        }
        if (initParam.size() > 0) {
            valuesC = new ContextParam[initParam.size()];
            initParam.copyInto(valuesC);
        }
        servlet.setInitParams((ContextParam[])valuesC);
        return servlet;
    }

    protected MIMEMapping initMIMEMapping(Element el) {
        NodeList paramsList = el.getChildNodes();
        MIMEMapping map = new MIMEMapping();
        String nextElTag = null;
        String value = null;
        Element mapEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                mapEl = (Element)paramsList.item(i);
                nextElTag = mapEl.getNodeName();
                if (nextElTag.equals("extension")) {
                    value = this.getTextValue(mapEl);
                    map.setExtension(value);
                } else if (nextElTag.equals("mime-type")) {
                    value = this.getTextValue(mapEl);
                    map.setMIMEType(value);
                }
            }
            ++i;
        }
        return map;
    }

    protected String[] initWelcomeFiles(Element el) throws WrongStructureException {
        NodeList paramsList = el.getElementsByTagName("welcome-file");
        if (paramsList.getLength() == 0) {
            throw new WebWrongStructureException(WebWrongStructureException.AT_LEAST_ONE_ELEMENT_MUST_BE_PRESENT_IN_ELEMENT, new Object[]{"<welcome-file>", "<welcome-file-list>"});
        }
        Vector<String> files = new Vector<String>();
        Object[] file_list = null;
        Element nextEl = null;
        String value = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                nextEl = (Element)paramsList.item(i);
                value = this.getTextValue(nextEl);
                files.addElement(value);
            }
            ++i;
        }
        if (files.size() > 0) {
            file_list = new String[files.size()];
            files.copyInto(file_list);
            return file_list;
        }
        return null;
    }

    protected ErrorPage initErrorPages(Element el) throws IllegalArgumentException {
        Element nextEl = null;
        String nextElTag = null;
        String value = null;
        NodeList list = el.getChildNodes();
        ErrorPage ePage = new ErrorPage();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                nextEl = (Element)list.item(i);
                nextElTag = nextEl.getNodeName();
                try {
                    if (nextElTag.equals("error-code")) {
                        value = this.getTextValue(nextEl);
                        ePage.setValue(new Integer(value));
                        ePage.setType(ErrorPage.errorCode);
                    } else if (nextElTag.equals("exception-type")) {
                        value = this.getTextValue(nextEl);
                        if (value == null) {
                            throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<exception-type>", "<error-page>"});
                        }
                        ePage.setValue(value);
                        ePage.setType(ErrorPage.exception_type);
                    } else if (nextElTag.equals("location")) {
                        value = this.getTextValue(nextEl);
                        if (value == null || !value.startsWith("/")) {
                            throw new WebIllegalArgumentException("servlet_jsp_0245");
                        }
                        ePage.setLocation(value);
                    }
                }
                catch (NumberFormatException exc) {
                    throw new WebIllegalArgumentException("servlet_jsp_0235", new Object[]{value, "<error-code>"}, exc);
                }
            }
            ++i;
        }
        return ePage;
    }

    protected TagLib initTagLibs(Element el) {
        NodeList paramsList = el.getChildNodes();
        TagLib tag = new TagLib();
        String nextElTag = null;
        String value = null;
        Element tagEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                tagEl = (Element)paramsList.item(i);
                nextElTag = tagEl.getNodeName();
                if (nextElTag.equals("taglib-uri")) {
                    value = this.getTextValue(tagEl);
                    tag.setUri(value);
                } else if (nextElTag.equals("taglib-location")) {
                    value = this.getTextValue(tagEl);
                    tag.setLocation(value);
                }
            }
            ++i;
        }
        return tag;
    }

    /*
     * Unable to fully structure code
     */
    protected EnvironmentEntry initEnvEntries(Element el) throws IllegalArgumentException {
        nextEl = null;
        nextElTag = null;
        value = null;
        type = null;
        entry = new EnvironmentEntry();
        list = el.getChildNodes();
        typeNode = el.getElementsByTagName("env-entry-type").item(0);
        if (typeNode.getNodeType() == 1) {
            nextEl = (Element)typeNode;
            type = this.getTextValue(nextEl);
            if (!(type != null && (type.equals("java.lang.Boolean") || type.equals("java.lang.Byte") || type.equals("java.lang.Character") || type.equals("java.lang.Double") || type.equals("java.lang.Float") || type.equals("java.lang.Integer") || type.equals("java.lang.Long") || type.equals("java.lang.Short") || type.equals("java.lang.String")))) {
                throw new WebIllegalArgumentException("servlet_jsp_0246", new Object[]{"<env-entry-type>"});
            }
            entry.setEntryType(type);
        }
        i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                nextEl = (Element)list.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("env-entry-name")) {
                    entry.setEntryName(this.getTextValue(nextEl));
                } else if (nextElTag.equals("env-entry-value")) {
                    value = this.getTextValue(nextEl);
                    if (value != null && type != null) {
                        try {
                            if (value.startsWith("${")) {
                                entry.setEntryValue((Object)value);
                            }
                            if (type.equals("java.lang.Boolean")) {
                                entry.setEntryValue((Object)new Boolean(value));
                            }
                            if (type.equals("java.lang.Byte")) {
                                entry.setEntryValue((Object)new Byte(value));
                            }
                            if (type.equals("java.lang.Character")) {
                                entry.setEntryValue((Object)new Character(value.charAt(0)));
                            }
                            if (type.equals("java.lang.Double")) {
                                entry.setEntryValue((Object)new Double(value));
                            }
                            if (type.equals("java.lang.Float")) {
                                entry.setEntryValue((Object)new Float(value));
                            }
                            if (type.equals("java.lang.Integer")) {
                                entry.setEntryValue((Object)new Integer(value));
                            }
                            if (type.equals("java.lang.Long")) {
                                entry.setEntryValue((Object)new Long(value));
                            }
                            if (type.equals("java.lang.Short")) {
                                entry.setEntryValue((Object)new Short(value));
                            }
                            if (!type.equals("java.lang.String")) ** GOTO lbl61
                            entry.setEntryValue((Object)value);
                        }
                        catch (NumberFormatException nfe) {
                            throw new WebIllegalArgumentException("servlet_jsp_0235", new Object[]{value, "<env-entry-value>"}, nfe);
                        }
                    }
                } else if (nextElTag.equals("description")) {
                    entry.setEntryDescription(this.getTextValue(nextEl));
                }
            }
lbl61:
            // 18 sources

            ++i;
        }
        return entry;
    }

    protected ResourceEnvReference initResourceEnvReferences(Element el) {
        Element nextEl = null;
        String nextElTag = null;
        NodeList list = el.getChildNodes();
        ResourceEnvReference ref = new ResourceEnvReference();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                nextEl = (Element)list.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("resource-env-ref-name")) {
                    ref.setName(this.getTextValue(nextEl));
                } else if (nextElTag.equals("resource-env-ref-type")) {
                    ref.setType(this.getTextValue(nextEl));
                } else if (nextElTag.equals("description")) {
                    ref.setDescription(this.getTextValue(nextEl));
                }
            }
            ++i;
        }
        return ref;
    }

    protected EJBeanReference initEJBRefs(Element el) {
        NodeList paramsList = el.getChildNodes();
        EJBeanReference ref = new EJBeanReference();
        String nextElTag = null;
        String value = null;
        Element refEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                refEl = (Element)paramsList.item(i);
                nextElTag = refEl.getNodeName();
                if (nextElTag.equals("ejb-ref-name")) {
                    value = this.getTextValue(refEl);
                    ref.setReferenceName(value);
                } else if (nextElTag.equals("ejb-ref-type")) {
                    value = this.getTextValue(refEl);
                    if (value != null) {
                        if (value.equalsIgnoreCase("Entity")) {
                            ref.setType(1);
                        } else {
                            ref.setType(0);
                        }
                    } else {
                        ref.setType(0);
                    }
                } else if (nextElTag.equals("home")) {
                    value = this.getTextValue(refEl);
                    ref.setHomeInterfaceName(value);
                } else if (nextElTag.equals("remote")) {
                    value = this.getTextValue(refEl);
                    ref.setRemoteInterfaceName(value);
                } else if (nextElTag.equals("ejb-link")) {
                    value = this.getTextValue(refEl);
                    ref.setReferenceEjbLink(value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(refEl);
                    ref.setReferenceDescription(value);
                }
            }
            ++i;
        }
        return ref;
    }

    protected EJBeanLocalReference initEJBLocalRefs(Element el) {
        Element nextEl = null;
        String nextElTag = null;
        String value = null;
        NodeList list = el.getChildNodes();
        EJBeanLocalReference ref = new EJBeanLocalReference();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                nextEl = (Element)list.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("ejb-ref-name")) {
                    ref.setReferenceName(this.getTextValue(nextEl));
                } else if (nextElTag.equals("ejb-ref-type")) {
                    value = this.getTextValue(nextEl);
                    if (value != null) {
                        if (value.equals("Entity")) {
                            ref.setType(1);
                        } else {
                            ref.setType(0);
                        }
                    } else {
                        ref.setType(0);
                    }
                } else if (nextElTag.equals("local-home")) {
                    ref.setLocalHomeInterfaceName(this.getTextValue(nextEl));
                } else if (nextElTag.equals("local")) {
                    ref.setLocalInterfaceName(this.getTextValue(nextEl));
                } else if (nextElTag.equals("ejb-link")) {
                    ref.setReferenceEjbLink(this.getTextValue(nextEl));
                } else if (nextElTag.equals("description")) {
                    ref.setReferenceDescription(this.getTextValue(nextEl));
                }
            }
            ++i;
        }
        return ref;
    }

    protected String getTextValue(Element element) {
        if (element != null) {
            Node node = null;
            String obj = null;
            String value = null;
            NodeList list = element.getChildNodes();
            if (list != null && list.getLength() != 0) {
                int i = 0;
                while (i < list.getLength()) {
                    node = list.item(i);
                    if (!(node != null && node.getNodeType() == 8 || node == null || node.getNodeType() != 3 && node.getNodeType() != 4)) {
                        obj = node.getNodeValue();
                        if (obj == null) {
                            return null;
                        }
                        value = obj;
                        if (value.trim().equals("")) {
                            return null;
                        }
                        return value.trim();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private Element getFirstElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            ++i;
        }
        return null;
    }

    private Element getLastElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = list.getLength() - 1;
        while (i >= 0) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            --i;
        }
        return null;
    }

    protected FilterDescriptor initFilter(Element el) {
        NodeList paramsList = el.getChildNodes();
        Object[] valuesC = null;
        Vector<ContextParam> initParam = new Vector<ContextParam>();
        FilterDescriptor filter = new FilterDescriptor();
        String nextElTag = null;
        String value = null;
        Element filterEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                filterEl = (Element)paramsList.item(i);
                nextElTag = filterEl.getNodeName();
                if (nextElTag.equals("filter-name")) {
                    value = this.getTextValue(filterEl);
                    filter.setName(value);
                } else if (nextElTag.equals("display-name")) {
                    value = this.getTextValue(filterEl);
                    filter.setDisplayName(value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(filterEl);
                    filter.setDescription(value);
                } else if (nextElTag.equals("filter-class")) {
                    value = this.getTextValue(filterEl);
                    filter.setFilterClass(value);
                } else if (nextElTag.equals("icon")) {
                    this.initIcons(filter, filterEl);
                } else if (nextElTag.equals("init-param")) {
                    initParam.addElement(this.initParams(filterEl));
                }
            }
            ++i;
        }
        if (initParam.size() > 0) {
            valuesC = new ContextParam[initParam.size()];
            initParam.copyInto(valuesC);
        }
        filter.setInitParams((ContextParam[])valuesC);
        return filter;
    }

    protected FilterMapping initFilterMapping(Element el) {
        FilterMapping filterMap = new FilterMapping();
        String nextElTag = null;
        String value = null;
        Element filterEl = null;
        NodeList paramsList = el.getChildNodes();
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                filterEl = (Element)paramsList.item(i);
                nextElTag = filterEl.getNodeName();
                if (nextElTag.equals("filter-name")) {
                    value = this.getTextValue(filterEl);
                    filterMap.setFilterName(value);
                } else if (nextElTag.equals("url-pattern")) {
                    filterMap.setType(1);
                    value = this.getTextValue(filterEl);
                    filterMap.setURLPattern(value);
                } else if (nextElTag.equals("servlet-name")) {
                    filterMap.setType(0);
                    value = this.getTextValue(filterEl);
                    filterMap.setServletName(value);
                }
            }
            ++i;
        }
        return filterMap;
    }

    protected String initListener(Element el) {
        String nextElTag = null;
        String value = null;
        Element filterEl = null;
        NodeList paramsList = el.getChildNodes();
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1 && (nextElTag = (filterEl = (Element)paramsList.item(i)).getNodeName()).equals("listener-class")) {
                value = this.getTextValue(filterEl);
                return value;
            }
            ++i;
        }
        return null;
    }

    protected void loadFilters(Element el, FilterDescriptor[] filterDescriptors) {
        if (filterDescriptors != null) {
            Element mappingEl = null;
            int i = 0;
            while (i < filterDescriptors.length) {
                if (filterDescriptors[i] != null) {
                    mappingEl = this.mainDocument.createElement("filter");
                    if (filterDescriptors[i].getSmallIcon() != null || filterDescriptors[i].getLargeIcon() != null) {
                        Element tempElement = this.mainDocument.createElement("icon");
                        if (filterDescriptors[i].getSmallIcon() != null) {
                            this.load(tempElement, filterDescriptors[i].getSmallIcon().getFileName(), "small-icon");
                        }
                        if (filterDescriptors[i].getLargeIcon() != null) {
                            this.load(tempElement, filterDescriptors[i].getLargeIcon().getFileName(), "large-icon");
                        }
                        mappingEl.appendChild(tempElement);
                    }
                    this.load(mappingEl, filterDescriptors[i].getName(), "filter-name");
                    this.load(mappingEl, filterDescriptors[i].getDisplayName(), "display-name");
                    this.load(mappingEl, filterDescriptors[i].getDescription(), "description");
                    this.load(mappingEl, filterDescriptors[i].getFilterClass(), "filter-class");
                    this.loadContextParams(mappingEl, filterDescriptors[i].getInitParams(), "init-param");
                    el.appendChild(mappingEl);
                }
                ++i;
            }
        }
    }

    protected void loadFilterMappings(Element el, FilterMapping[] fMappings) {
        if (fMappings != null) {
            Element mappingEl = null;
            int i = 0;
            while (i < fMappings.length) {
                mappingEl = this.mainDocument.createElement("filter-mapping");
                if (fMappings[i] != null) {
                    this.load(mappingEl, fMappings[i].getFilterName(), "filter-name");
                    if (fMappings[i].getType() == 1) {
                        this.load(mappingEl, fMappings[i].getURLPattern(), "url-pattern");
                    } else if (fMappings[i].getType() == 0) {
                        this.load(mappingEl, fMappings[i].getServletName(), "servlet-name");
                    }
                    el.appendChild(mappingEl);
                }
                ++i;
            }
        }
    }

    protected void loadListeners(Element el, String[] listeners) {
        if (listeners != null) {
            Element mappingEl = null;
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] != null) {
                    mappingEl = this.mainDocument.createElement("listener");
                    this.load(mappingEl, listeners[i], "listener-class");
                    el.appendChild(mappingEl);
                }
                ++i;
            }
        }
    }

    protected void initIcons(Object descr, Element iconEl) {
        Element el = null;
        String tag = null;
        String value = null;
        NodeList list = iconEl.getChildNodes();
        SerializableFile smallIcon = null;
        SerializableFile largeIcon = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                tag = el.getNodeName();
                if (tag.equals("small-icon")) {
                    value = this.getTextValue(el);
                    if (value != null) {
                        smallIcon = this.rootPath == null ? new SerializableFile(value) : new SerializableFile(this.rootPath + value);
                    }
                } else if (tag.equals("large-icon") && (value = this.getTextValue(el)) != null) {
                    largeIcon = this.rootPath == null ? new SerializableFile(value) : new SerializableFile(this.rootPath + value);
                }
            }
            ++i;
        }
        if (descr instanceof WebDeploymentDescriptor) {
            ((WebDeploymentDescriptor)descr).setSmallIcon(smallIcon);
            ((WebDeploymentDescriptor)descr).setLargeIcon(largeIcon);
        } else if (descr instanceof ServletDescriptor) {
            ((ServletDescriptor)descr).setSmallIcon(smallIcon);
            ((ServletDescriptor)descr).setLargeIcon(largeIcon);
        } else if (descr instanceof FilterDescriptor) {
            ((FilterDescriptor)descr).setSmallIcon(smallIcon);
            ((FilterDescriptor)descr).setLargeIcon(largeIcon);
        }
    }

    protected RunAsIdentity initRunAs(Element element, String name) {
        Element tempEl = null;
        String tag = null;
        NodeList list = element.getChildNodes();
        RunAsIdentity runAs = new RunAsIdentity(name);
        runAs.setComponentType(2);
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                tempEl = (Element)list.item(i);
                tag = tempEl.getNodeName();
                if (tag.equals("description")) {
                    runAs.setDescription(this.getTextValue(tempEl));
                } else if (tag.equals("role-name")) {
                    String value = this.getTextValue(tempEl);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"role-name", "run-as"});
                    }
                    runAs.setSecurityRoleName(value);
                }
            }
            ++i;
        }
        return runAs;
    }

    public String getIllegalArgumentException() {
        return this.illegalArgumentException;
    }
}

