/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.xml;

import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EnvironmentXmlUtil {
    private String illegalArgumentException = "";

    public void loadEnvEntr(Document mainDocument, Element parent, EnvironmentEntry[] envEntr) {
        if (envEntr == null || envEntr.length == 0) {
            return;
        }
        Element envEntryEl = null;
        int i = 0;
        while (i < envEntr.length) {
            if (envEntr[i] != null) {
                if (envEntr[i].getEntryName() == null || envEntr[i].getEntryName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_016 Obligatory field  env-entry-name is missing.", envEntr[i].getEntryName());
                } else if (envEntr[i].getEntryType() == null || !this.checkEntryType(envEntr[i].getEntryType())) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_017 Wrong falue for env-entry-type. Type: \"{0}\"", envEntr[i].getEntryType());
                } else {
                    envEntryEl = mainDocument.createElement("env-entry");
                    if (envEntr[i].getEntryDescription() != null && !envEntr[i].getEntryDescription().trim().equals("")) {
                        this.load(mainDocument, envEntryEl, envEntr[i].getEntryDescription(), "description");
                    }
                    this.load(mainDocument, envEntryEl, envEntr[i].getEntryName(), "env-entry-name");
                    this.load(mainDocument, envEntryEl, envEntr[i].getEntryType(), "env-entry-type");
                    if (envEntr[i].getEntryValue() != null && !envEntr[i].getEntryValue().toString().trim().equals("")) {
                        this.load(mainDocument, envEntryEl, envEntr[i].getEntryValue().toString(), "env-entry-value");
                    }
                    parent.appendChild(envEntryEl);
                }
            }
            ++i;
        }
    }

    private boolean checkEntryType(String type) {
        if (type.equals("java.lang.Double")) {
            return true;
        }
        if (type.equals("java.lang.Integer")) {
            return true;
        }
        if (type.equals("java.lang.Boolean")) {
            return true;
        }
        if (type.equals("java.lang.Float")) {
            return true;
        }
        if (type.equals("java.lang.String")) {
            return true;
        }
        if (type.equals("java.lang.Character")) {
            return true;
        }
        if (type.equals("java.lang.Byte")) {
            return true;
        }
        if (type.equals("java.lang.Short")) {
            return true;
        }
        return type.equals("java.lang.Long");
    }

    public void loadEjbRefs(Document mainDocument, Element parent, EJBeanReference[] ejbRefs) {
        if (ejbRefs == null || ejbRefs.length == 0) {
            return;
        }
        int i = 0;
        while (i < ejbRefs.length) {
            if (ejbRefs[i] != null) {
                if (ejbRefs[i].getReferenceName() == null || ejbRefs[i].getReferenceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_018 Ejb-ref-name for ejb-ref is missing.", ejbRefs[i].getReferenceName());
                } else if (ejbRefs[i].getHomeInterfaceName() == null || ejbRefs[i].getHomeInterfaceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_019 Home iterface for ejb references is missing.", ejbRefs[i].getHomeInterfaceName());
                } else if (ejbRefs[i].getRemoteInterfaceName() == null || ejbRefs[i].getRemoteInterfaceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_020 Remote iterface for ejb references is missing.", ejbRefs[i].getRemoteInterfaceName());
                } else {
                    Element ejbRefsEl = mainDocument.createElement("ejb-ref");
                    if (ejbRefs[i].getReferenceDescription() != null && !ejbRefs[i].getReferenceDescription().trim().equals("")) {
                        this.load(mainDocument, ejbRefsEl, ejbRefs[i].getReferenceDescription(), "description");
                    }
                    this.load(mainDocument, ejbRefsEl, ejbRefs[i].getReferenceName(), "ejb-ref-name");
                    String type = ejbRefs[i].getType() == 1 ? "Entity" : "Session";
                    this.load(mainDocument, ejbRefsEl, type, "ejb-ref-type");
                    this.load(mainDocument, ejbRefsEl, ejbRefs[i].getHomeInterfaceName(), "home");
                    this.load(mainDocument, ejbRefsEl, ejbRefs[i].getRemoteInterfaceName(), "remote");
                    if (ejbRefs[i].getReferenceEjbLink() != null && !ejbRefs[i].getReferenceEjbLink().trim().equals("")) {
                        this.load(mainDocument, ejbRefsEl, ejbRefs[i].getReferenceEjbLink(), "ejb-link");
                    }
                    parent.appendChild(ejbRefsEl);
                }
            }
            ++i;
        }
    }

    public void loadEjbLocalRefs(Document mainDocument, Element parent, EJBeanLocalReference[] ejbLocalRefs) {
        if (ejbLocalRefs == null) {
            return;
        }
        int i = 0;
        while (i < ejbLocalRefs.length) {
            if (ejbLocalRefs[i] != null) {
                if (ejbLocalRefs[i].getReferenceName() == null || ejbLocalRefs[i].getReferenceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_021 Ejb-ref-name for ejb local references is missing.", ejbLocalRefs[i].getReferenceName());
                } else if (ejbLocalRefs[i].getLocalHomeInterfaceName() == null || ejbLocalRefs[i].getLocalHomeInterfaceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_022 Home iterface for ejb local references is missing.", ejbLocalRefs[i].getLocalHomeInterfaceName());
                } else if (ejbLocalRefs[i].getLocalInterfaceName() == null || ejbLocalRefs[i].getLocalInterfaceName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_023 Local iterface for ejb local references is missing.", ejbLocalRefs[i].getLocalInterfaceName());
                } else {
                    Element localRefsEl = mainDocument.createElement("ejb-local-ref");
                    if (ejbLocalRefs[i].getReferenceDescription() != null && !ejbLocalRefs[i].getReferenceDescription().trim().equals("")) {
                        this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getReferenceDescription(), "description");
                    }
                    this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getReferenceName(), "ejb-ref-name");
                    String type = ejbLocalRefs[i].getType() == 1 ? "Entity" : "Session";
                    this.load(mainDocument, localRefsEl, type, "ejb-ref-type");
                    this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getLocalHomeInterfaceName(), "local-home");
                    this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getLocalInterfaceName(), "local");
                    if (ejbLocalRefs[i].getReferenceEjbLink() != null && !ejbLocalRefs[i].getReferenceEjbLink().trim().equals("")) {
                        this.load(mainDocument, localRefsEl, ejbLocalRefs[i].getReferenceEjbLink(), "ejb-link");
                    }
                    parent.appendChild(localRefsEl);
                }
            }
            ++i;
        }
    }

    public void loadSecurityRoleRefs(Document mainDocument, Element parent, SecurityRoleReference[] secRoleRefs) {
        Element secRoleRefsEl = null;
        if (secRoleRefs == null || secRoleRefs.length == 0) {
            return;
        }
        int i = 0;
        while (i < secRoleRefs.length) {
            if (secRoleRefs[i] != null) {
                if (secRoleRefs[i].getRoleName() == null || secRoleRefs[i].getRoleName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_024 Role name for security role references is missing.", secRoleRefs[i].getRoleName());
                } else {
                    secRoleRefsEl = mainDocument.createElement("security-role-ref");
                    if (secRoleRefs[i].getDescription() != null && !secRoleRefs[i].getDescription().trim().equals("")) {
                        this.load(mainDocument, secRoleRefsEl, secRoleRefs[i].getDescription(), "description");
                    }
                    this.load(mainDocument, secRoleRefsEl, secRoleRefs[i].getRoleName(), "role-name");
                    if (secRoleRefs[i].getRoleLink() != null && secRoleRefs[i].getRoleLink().getRoleName() != null && !secRoleRefs[i].getRoleLink().getRoleName().trim().equals("")) {
                        this.load(mainDocument, secRoleRefsEl, secRoleRefs[i].getRoleLink().getRoleName(), "role-link");
                    }
                    parent.appendChild(secRoleRefsEl);
                }
            }
            ++i;
        }
    }

    public void loadResourceEnvRefs(Document mainDocument, Element parent, ResourceEnvReference[] resEnvRefs) {
        if (resEnvRefs == null) {
            return;
        }
        int i = 0;
        while (i < resEnvRefs.length) {
            if (resEnvRefs[i] != null) {
                if (resEnvRefs[i].getName() == null || resEnvRefs[i].getName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_025 Missing resource environment reference name.", resEnvRefs[i].getName());
                } else if (resEnvRefs[i].getType() == null || resEnvRefs[i].getType().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_026 Missing resource environment reference type.", resEnvRefs[i].getType());
                } else {
                    Element resEnvRefsEl = mainDocument.createElement("resource-env-ref");
                    if (resEnvRefs[i].getDescription() != null && !resEnvRefs[i].getDescription().trim().equals("")) {
                        this.load(mainDocument, resEnvRefsEl, resEnvRefs[i].getDescription(), "description");
                    }
                    this.load(mainDocument, resEnvRefsEl, resEnvRefs[i].getName(), "resource-env-ref-name");
                    this.load(mainDocument, resEnvRefsEl, resEnvRefs[i].getType(), "resource-env-ref-type");
                    parent.appendChild(resEnvRefsEl);
                }
            }
            ++i;
        }
    }

    public void loadResourceRefs(Document mainDocument, Element parent, ResourceReference[] resRefs) {
        if (resRefs == null) {
            return;
        }
        int i = 0;
        while (i < resRefs.length) {
            block13: {
                block15: {
                    block14: {
                        if (resRefs[i] == null) break block13;
                        if (resRefs[i].getResourceName() != null && !resRefs[i].getResourceName().trim().equals("")) break block14;
                        this.illegalArgumentException = this.updateIllegalArgumentException("ID_027 Missing resource reference name.", resRefs[i].getResourceName());
                        break block13;
                    }
                    if (resRefs[i].getResourceType() != null && !resRefs[i].getResourceType().trim().equals("")) break block15;
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_028 Missing resource reference type.", resRefs[i].getResourceType());
                    break block13;
                }
                switch (resRefs[i].getResourceAuthorization()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        this.illegalArgumentException = this.updateIllegalArgumentException("ID_029 Wrong value for resource authorization in resource reference.\n Must be one of the falowign: ResourceReference.BEAN_AUTHORIZATION, ResourceReference.SERVLET_AUTHORIZATION,\nResourceReference.CONTAINER_AUTHORIZATION, ResourceReference.APPLICATION_AUTHORIZATION ", null);
                        break block13;
                    }
                }
                Element resRefsEl = mainDocument.createElement("resource-ref");
                if (resRefs[i].getResourceDescription() != null && !resRefs[i].getResourceDescription().trim().equals("")) {
                    this.load(mainDocument, resRefsEl, resRefs[i].getResourceDescription(), "description");
                }
                this.load(mainDocument, resRefsEl, resRefs[i].getResourceName(), "res-ref-name");
                this.load(mainDocument, resRefsEl, resRefs[i].getResourceType(), "res-type");
                boolean resourceAuthorization = false;
                String authStr = null;
                switch (resRefs[i].getResourceAuthorization()) {
                    case 1: {
                        authStr = "Application";
                        break;
                    }
                    case 2: {
                        authStr = "Container";
                        break;
                    }
                    case 3: {
                        authStr = "Application";
                    }
                }
                this.load(mainDocument, resRefsEl, authStr, "res-auth");
                String shareable = resRefs[i].getResourceSharingScope() == 0 ? "Shareable" : "Unshareable";
                this.load(mainDocument, resRefsEl, shareable, "res-sharing-scope");
                parent.appendChild(resRefsEl);
            }
            ++i;
        }
    }

    public void loadSecurityRoles(Document mainDocument, Element parent, SecurityRoles[] secRoles) {
        Element secRolesEl = null;
        if (secRoles == null || secRoles.length == 0) {
            return;
        }
        int i = 0;
        while (i < secRoles.length) {
            if (secRoles[i] != null) {
                if (secRoles[i].getRoleName() == null || secRoles[i].getRoleName().trim().equals("")) {
                    this.illegalArgumentException = this.updateIllegalArgumentException("ID_029 Wrong value for resource authorization in resource reference.\n Must be one of the falowign: ResourceReference.BEAN_AUTHORIZATION, ResourceReference.SERVLET_AUTHORIZATION,\nResourceReference.CONTAINER_AUTHORIZATION, ResourceReference.APPLICATION_AUTHORIZATION ", secRoles[i].getRoleName());
                } else {
                    secRolesEl = mainDocument.createElement("security-role");
                    if (secRoles[i].getDescription() != null && !secRoles[i].getDescription().trim().equals("")) {
                        this.load(mainDocument, secRolesEl, secRoles[i].getDescription(), "description");
                    }
                    this.load(mainDocument, secRolesEl, secRoles[i].getRoleName(), "role-name");
                    parent.appendChild(secRolesEl);
                }
            }
            ++i;
        }
    }

    private Element load(Document mainDocument, Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = mainDocument.createElement(tagName);
        Text textNode = mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private String updateIllegalArgumentException(String message, String error) {
        if (error == null) {
            error = "null";
        } else if (error.trim().equals("")) {
            error = "empty string";
        }
        if (message != null && message.length() != 0) {
            return this.illegalArgumentException + ";\n   " + message + ": " + error;
        }
        return this.illegalArgumentException;
    }

    public String getErrors() {
        this.clear();
        return this.illegalArgumentException == null ? null : this.illegalArgumentException + ".";
    }

    public void resetErrors() {
        this.illegalArgumentException = "";
    }

    public void addError(String newError) {
        if (newError != null && newError.length() != 0) {
            this.illegalArgumentException = this.illegalArgumentException + newError;
        }
    }

    private void clear() {
        if (this.illegalArgumentException != null && this.illegalArgumentException.length() != 0) {
            if (this.illegalArgumentException.startsWith(";")) {
                this.illegalArgumentException = this.illegalArgumentException.substring(1, this.illegalArgumentException.length());
            }
        } else {
            this.illegalArgumentException = null;
        }
    }
}

