/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.jar;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.jar.DependenceJarUtils;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.xml.AdditionalWebDescrDocument;
import com.sap.engine.services.servlets_jsp.descriptor.xml.WebDescriptorDocument;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIOException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import org.w3c.dom.Document;

public class MakeWar
extends DependenceJarUtils {
    WebDeploymentDescriptor wDescriptor = null;
    String mappingXml = null;
    boolean isSimple = true;

    public MakeWar() {
    }

    public MakeWar(WebDeploymentDescriptor descriptor) {
        this.wDescriptor = descriptor;
    }

    public void setDescriptor(WebDeploymentDescriptor descriptor) {
        this.wDescriptor = descriptor;
    }

    public void writeAdditionalEntries(JarOutputStream zip) throws IOException {
        block19: {
            StandardDOMWriter writer = new StandardDOMWriter();
            WebDescriptorDocument doc = new WebDescriptorDocument();
            AdditionalWebDescrDocument addDoc = new AdditionalWebDescrDocument();
            Document document = null;
            byte[] buffer = null;
            JarEntry zEntry = null;
            CRC32 crc = null;
            if (this.wDescriptor != null) {
                document = doc.loadDocumentFromDescriptor(this.wDescriptor);
                String tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_application_client.xml";
                File tmpFile = new File(tmpFileName);
                if (this.isSimple) {
                    writer.write(document, tmpFileName, "<!DOCTYPE web-app PUBLIC '-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN' 'http://java.sun.com/dtd/web-app_2_3.dtd'>", "UTF-8");
                } else {
                    writer.write(document, tmpFileName, "<!DOCTYPE web-app PUBLIC '-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN' 'http://java.sun.com/dtd/web-app_2_3.dtd'>", "UTF-8");
                }
                zEntry = new JarEntry("WEB-INF/web.xml");
                buffer = this.getBytes(new FileInputStream(tmpFileName));
                if (buffer != null) {
                    zEntry.setMethod(0);
                    zEntry.setSize(buffer.length);
                    crc = new CRC32();
                    crc.update(buffer);
                    zEntry.setCrc(crc.getValue());
                    zip.putNextEntry(zEntry);
                    zip.write(buffer, 0, buffer.length);
                    zip.closeEntry();
                    tmpFile.delete();
                    this.addDirEntries(zip, zEntry.getName());
                }
                document = addDoc.loadDocumentFromDescriptor(this.wDescriptor);
                if (addDoc.needsLoad()) {
                    tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_application_client_add.xml";
                    tmpFile = new File(tmpFileName);
                    writer.write(document, tmpFileName, "<!DOCTYPE web-j2ee-engine SYSTEM 'web-j2ee-engine.dtd'>", "UTF-8");
                    zEntry = new JarEntry("WEB-INF/web-j2ee-engine.xml");
                    buffer = this.getBytes(new FileInputStream(tmpFileName));
                    if (buffer != null) {
                        zEntry.setMethod(0);
                        zEntry.setSize(buffer.length);
                        crc = new CRC32();
                        crc.update(buffer);
                        zEntry.setCrc(crc.getValue());
                        zip.putNextEntry(zEntry);
                        zip.write(buffer, 0, buffer.length);
                        zip.closeEntry();
                        tmpFile.delete();
                        this.addDirEntries(zip, zEntry.getName());
                    }
                }
            }
            if (this.hasManifest(((JarUtils)this).infoObjects)) break block19;
            try {
                zEntry = new JarEntry("META-INF/MANIFEST.MF");
                zEntry.setSize(0L);
                crc = new CRC32();
                buffer = new byte[]{};
                crc.update(buffer);
                zEntry.setCrc(crc.getValue());
                zip.putNextEntry(zEntry);
                zip.write(buffer, 0, buffer.length);
                zip.closeEntry();
            }
            catch (ZipException ze) {
                throw new WebIOException("servlet_jsp_0249", ze);
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }
    }

    public void makeJar(String jarName, Vector infos) throws IOException {
        this.makeJarFromFiles(jarName, infos);
    }

    protected void proccessWebClasses(Vector infoes) {
        if (infoes == null) {
            return;
        }
        InfoObject info = null;
        String name = null;
        int i = 0;
        while (i < infoes.size()) {
            info = (InfoObject)infoes.elementAt(i);
            name = info.getEntryName();
            if (name.endsWith(".class")) {
                if (!info.getFilePath().endsWith(".war") && !info.getFilePath().endsWith(".jar")) {
                    if (!name.startsWith("WEB-INF/classes") && !name.startsWith("/WEB-INF/classes")) {
                        info.entryName = name = "WEB-INF/classes/" + name;
                        infoes.setElementAt(info, i);
                    }
                } else if (this.containsInServlets(name)) {
                    name = "WEB-INF/classes/" + name;
                }
            }
            ++i;
        }
    }

    private boolean containsInServlets(String className) {
        ServletDescriptor[] servlets = this.wDescriptor.getServlets();
        if (servlets != null) {
            String[] servletClasses = new String[servlets.length];
            int i = 0;
            while (i < servlets.length) {
                servletClasses[i] = servlets[i].getServletClass();
                if (servletClasses[i] != null) {
                    className.replace('/', '.');
                    if (servletClasses[i].equalsIgnoreCase(className)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes(InputStream in) throws IOException {
        int c;
        if (in == null) {
            return null;
        }
        byte[] buff = null;
        ByteArrayOutputStream b = null;
        b = in.available() > 1 ? new ByteArrayOutputStream(in.available()) : new ByteArrayOutputStream();
        BufferedInputStream bin = new BufferedInputStream(in);
        while ((c = bin.read()) != -1) {
            void var3_5;
            b.write((int)var3_5);
        }
        b.flush();
        b.close();
        bin.close();
        buff = b.toByteArray();
        in.close();
        return buff;
    }

    public void switchSimple(boolean flag) {
        this.isSimple = flag;
    }
}

