/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListValues;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ResponseStatusPanel;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class ResponseStatusPanelLogical
extends ResponseStatusPanel {
    private boolean isRemoving = false;
    private HashMapIntObject responseStatus = null;
    private ContextParam[] codes = null;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;
    private static Category category = EditorViewManager.category;
    private static Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$descriptor$gui$ResponseStatusPanelLogical == null ? (class$com$sap$engine$services$servlets_jsp$descriptor$gui$ResponseStatusPanelLogical = ResponseStatusPanelLogical.class$("com.sap.engine.services.servlets_jsp.descriptor.gui.ResponseStatusPanelLogical")) : class$com$sap$engine$services$servlets_jsp$descriptor$gui$ResponseStatusPanelLogical));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$descriptor$gui$ResponseStatusPanelLogical;

    public ResponseStatusPanelLogical(Frame frame, HashMapIntObject responseCodes) {
        this.setFrame(frame);
        this.init(this.madeFrom);
        this.setResponseCodes(responseCodes);
    }

    public ResponseStatusPanelLogical() {
        this(null, null);
    }

    private void initList(ContextParam[] values) {
        this.model.clear();
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.model.addElement(new ListValues(values[i], 1));
                ++i;
            }
        }
    }

    private void addCode(String code, String description) {
        if (code == null || code.equals("")) {
            return;
        }
        int codeNumber = 0;
        try {
            codeNumber = Integer.parseInt(code);
        }
        catch (NumberFormatException nfe) {
            category.logThrowableT(400, currentLocation, "Value for Code field is not correct!", (Throwable)nfe);
            JOptionPane.showMessageDialog(this.mainFrame, "Value for Code field is not correct!\n Please, type an Integer value.", "Warning", 2);
            return;
        }
        if (codeNumber < 101 || codeNumber > 999) {
            JOptionPane.showMessageDialog(this.mainFrame, "Incorect code (" + code + ") for response status.\n" + "Please, specify an integer between 100 and 999!", "Warning", 2);
            return;
        }
        if (codeNumber > 199 && codeNumber < 207 || codeNumber > 299 && codeNumber < 308 || codeNumber > 399 && codeNumber < 416 || codeNumber > 499 && codeNumber < 506) {
            JOptionPane.showMessageDialog(this.mainFrame, "Value (" + code + ") is not permitted for response status code.", "Warning", 2);
            return;
        }
        if (description == null || description.equals("")) {
            return;
        }
        ListValues listValue = null;
        ContextParam response = null;
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            response = listValue.getContextParam();
            if (!code.equals(response.getParamName())) continue;
            if (description.equals(response.getDescription())) {
                this.responseList.clearSelection();
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Response Code <" + code + "> already exists.\n Would you like to save the changes and modify this Response Code?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyCode(listValue, description);
            }
            this.responseList.clearSelection();
            this.clearFields();
            return;
        }
        ContextParam temp = new ContextParam();
        temp.setParamName(code);
        temp.setDescription(description);
        this.model.addElement(new ListValues(temp, 1));
        this.responseList.clearSelection();
        this.clearFields();
    }

    private void modifyCode(ListValues response, String description) {
        if (response == null) {
            return;
        }
        if (!response.getContextParam().getParamName().equals(this.codeTextField.getText())) {
            JOptionPane.showMessageDialog(this.mainFrame, "Value of response status code could not be modified.\nYou can remove this item and add a new one instead.", "Warning", 2);
            return;
        }
        response.getContextParam().setDescription(description);
        this.responseList.clearSelection();
        this.clearFields();
    }

    private void removeCode(ListValues response) {
        if (response == null) {
            return;
        }
        this.model.removeElement(response);
    }

    public void setResponseCodes(HashMapIntObject responseCodes) {
        this.responseStatus = responseCodes;
        this.clearFields();
        if (responseCodes == null || responseCodes.size() == 0) {
            this.codes = null;
        } else {
            int[] keys = responseCodes.getAllKeys();
            this.codes = new ContextParam[keys.length];
            int i = 0;
            while (i < keys.length) {
                this.codes[i] = new ContextParam();
                this.codes[i].setParamName(String.valueOf(keys[i]));
                this.codes[i].setDescription((String)responseCodes.get(keys[i]));
                ++i;
            }
        }
        this.initList(this.codes);
    }

    public HashMapIntObject getResponseCodes() {
        this.responseStatus = new HashMapIntObject();
        if (this.codes != null) {
            String code = null;
            String description = null;
            int i = 0;
            while (i < this.codes.length) {
                if (this.codes[i] != null) {
                    code = this.codes[i].getParamName();
                    description = this.codes[i].getDescription();
                    if (code != null && description != null) {
                        this.responseStatus.put(Integer.parseInt(code), (Object)description);
                    }
                }
                ++i;
            }
        }
        return this.responseStatus;
    }

    private void showProp(ListValues response) {
        if (response == null || response.getContextParam() == null || response.getContextParam().getParamName() == null || response.getContextParam().getParamName().equals("")) {
            return;
        }
        ContextParam code = response.getContextParam();
        try {
            Integer.parseInt(code.getParamName());
        }
        catch (NumberFormatException nfe) {
            category.logThrowableT(400, currentLocation, "Value for Code field is not correct!", (Throwable)nfe);
            return;
        }
        this.codeTextField.setText(code.getParamName());
        this.descriptionTextField.setText(code.getDescription());
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = -1;
        if (this.isRemoving) {
            return;
        }
        if (!this.model.isEmpty()) {
            this.checkPanel();
            this.clearFields();
            if (!this.responseList.isSelectionEmpty()) {
                selected = this.responseList.getSelectedIndex();
                this.showProp((ListValues)this.model.get(selected));
                this.modifyButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        }
    }

    private void checkPanel() {
        String code = null;
        String description = null;
        if (!this.codeTextField.getText().trim().equals("")) {
            code = this.codeTextField.getText().trim();
        }
        if (!this.descriptionTextField.getText().trim().equals("")) {
            description = this.descriptionTextField.getText().trim();
        }
        if (code == null || description == null) {
            return;
        }
        ListValues listValue = null;
        ContextParam response = null;
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            response = listValue.getContextParam();
            if (!code.equals(response.getParamName())) continue;
            if (description.equals(response.getDescription())) {
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Information for Response Code <" + code + "> was changed.\n Would you like to save the changes and modify this Response Code?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyCode(listValue, description);
            }
            this.clearFields();
            return;
        }
        int codeNumber = 0;
        try {
            codeNumber = Integer.parseInt(code);
        }
        catch (NumberFormatException nfe) {
            category.logThrowableT(400, currentLocation, "Value (" + code + ") is not permitted for response status code.", (Throwable)nfe);
            JOptionPane.showMessageDialog(this.mainFrame, "Value (" + code + ") is not permitted for response status code.", "Warning", 2);
        }
        if ((codeNumber > 100 && codeNumber < 200 || codeNumber > 206 && codeNumber < 300 || codeNumber > 307 && codeNumber < 400 || codeNumber > 415 && codeNumber < 500 || codeNumber > 505 && codeNumber < 1000) && (answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Response Code?", "Warning", 0, 2)) == 0) {
            this.addCode(code, description);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String code = null;
        String description = null;
        String cmd = e.getActionCommand();
        this.isRemoving = false;
        if (!this.codeTextField.getText().trim().equals("")) {
            code = this.codeTextField.getText().trim();
        }
        if (!this.descriptionTextField.getText().trim().equals("")) {
            description = this.descriptionTextField.getText().trim();
        }
        if (cmd.equals("ADD_CMD")) {
            this.addCode(code, description);
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyCode((ListValues)this.responseList.getSelectedValue(), description);
        } else if (cmd.equals("REMOVE_CMD")) {
            this.isRemoving = true;
            this.removeCode((ListValues)this.responseList.getSelectedValue());
            this.clearFields();
            this.isRemoving = false;
        } else if (cmd.equals("CLEAR_CMD")) {
            this.responseList.clearSelection();
            this.clearFields();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    private void processDocumentEvent() {
        String code = this.codeTextField.getText().trim();
        String description = this.descriptionTextField.getText().trim();
        if (code.equals("") && description.equals("") && this.responseList.isSelectionEmpty()) {
            this.clearButton.setEnabled(false);
        } else {
            this.clearButton.setEnabled(true);
        }
        if (!code.equals("") && !description.equals("")) {
            this.addButton.setEnabled(true);
            if (this.responseList.isSelectionEmpty()) {
                this.modifyButton.setEnabled(false);
            } else {
                this.modifyButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.model.clear();
        this.responseStatus = null;
        this.codes = null;
        this.clearFields();
    }

    public int isCorrect() {
        if (this.model.isEmpty()) {
            return 0;
        }
        ContextParam response = null;
        String temp = null;
        int code = 0;
        int i = 0;
        while (i < this.model.size()) {
            block7: {
                response = ((ListValues)this.model.get(i)).getContextParam();
                temp = response.getParamName();
                if (temp != null && !temp.equals("")) {
                    try {
                        code = Integer.parseInt(temp);
                    }
                    catch (NumberFormatException nfe) {
                        break block7;
                    }
                    if (code < 101 || code > 999) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Incorect code (" + code + ") for response status.\n" + "Please, specify an integer between 100 and 999!", "Warning", 2);
                        this.codeTextField.setText("");
                        return 2;
                    }
                    if (code > 199 && code < 207 || code > 299 && code < 308 || code > 399 && code < 416 || code > 499 && code < 506) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Value (" + code + ") is not permitted for response status code.", "Warning", 2);
                        this.codeTextField.setText("");
                        return 2;
                    }
                }
            }
            ++i;
        }
        return 0;
    }

    public void commitChange() {
        ContextParam response = null;
        int code = 0;
        this.codes = new ContextParam[this.model.size()];
        int i = 0;
        while (i < this.model.size()) {
            block5: {
                response = ((ListValues)this.model.get(i)).getContextParam();
                if (response != null && response.getParamName() != null && !response.getParamName().equals("")) {
                    try {
                        code = Integer.parseInt(response.getParamName());
                    }
                    catch (NumberFormatException nfe) {
                        break block5;
                    }
                    if (!(code < 101 || code > 199 && code < 207 || code > 299 && code < 308 || code > 399 && code < 416 || code > 499 && code < 506 || code > 999)) {
                        this.codes[i] = response;
                    }
                }
            }
            ++i;
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

