/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.servlets_jsp.descriptor.FormLoginConfig;
import com.sap.engine.services.servlets_jsp.descriptor.LoginConfig;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class LoginConfigurationPanel
extends BasicPanelView
implements ActionListener {
    public static final String[] authMethods = new String[]{"", "BASIC", "DIGEST", "FORM", "CLIENT_CERT"};
    public static final String SELECT_CMD = "SELECT_CMD";
    JPanel loginPanel = new JPanel();
    GridBagLayout gridBagLayout = new GridBagLayout();
    Border border1;
    TitledBorder titledBorder1;
    JLabel authorizationLabel = new JLabel();
    JLabel nameLabel = new JLabel();
    JTextField nameTextField = new JTextField();
    JLabel loginLabel = new JLabel();
    JLabel errorLabel = new JLabel();
    JComboBox authorizationComboBox = new JComboBox<String>(authMethods);
    JTextField loginTextField = new JTextField();
    JTextField errorTextField = new JTextField();
    JPanel inputPanel = new JPanel();
    JLabel typeLabel = new JLabel();
    JLabel valueLabel = new JLabel();
    JLabel locationLabel = new JLabel();
    JTextField valueTextField = new JTextField();
    JTextField locationTextField = new JTextField();
    WebDeploymentDescriptor www = null;
    private ApplicationInformationProvider appProvider;
    int madeFromConstant;
    private static Category category = EditorViewManager.category;
    private static Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$descriptor$gui$LoginConfigurationPanel == null ? (class$com$sap$engine$services$servlets_jsp$descriptor$gui$LoginConfigurationPanel = LoginConfigurationPanel.class$("com.sap.engine.services.servlets_jsp.descriptor.gui.LoginConfigurationPanel")) : class$com$sap$engine$services$servlets_jsp$descriptor$gui$LoginConfigurationPanel));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$descriptor$gui$LoginConfigurationPanel;

    public LoginConfigurationPanel() {
        try {
            this.init();
            this.initFields();
        }
        catch (Exception ex) {
            category.logThrowableT(500, currentLocation, "Login Configuration panel cannot be created!", (Throwable)ex);
        }
    }

    public LoginConfigurationPanel(int madeFrom) {
        this.madeFromConstant = madeFrom;
        try {
            this.init();
            this.initFields();
        }
        catch (Exception ex) {
            category.logThrowableT(500, currentLocation, "Login Configuration panel cannot be created!", (Throwable)ex);
        }
        if (this.madeFromConstant == 5) {
            this.nameTextField.setEnabled(false);
            this.loginTextField.setEnabled(false);
            this.errorTextField.setEnabled(false);
            this.authorizationComboBox.setEnabled(false);
            this.valueTextField.setEnabled(false);
            this.locationTextField.setEnabled(false);
        }
    }

    public LoginConfigurationPanel(WebDeploymentDescriptor _www) {
        this.www = _www;
        try {
            this.init();
            this.initFields();
        }
        catch (Exception ex) {
            category.logThrowableT(500, currentLocation, "Login Configuration panel cannot be created!", (Throwable)ex);
        }
    }

    private void init() throws Exception {
        ((Container)((Object)this)).setLayout(this.gridBagLayout);
        ((JComponent)((Object)this)).setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), GuiSettings.getResourceString((String)"LoginConfig_border", (String)"Login Configuration")));
        this.authorizationLabel.setText("Authentication Method:");
        this.nameLabel.setText("Realm Name:");
        this.loginLabel.setText("Login Page:");
        this.errorLabel.setText("Error Page:");
        this.typeLabel.setText("Type:");
        this.authorizationComboBox.addActionListener(this);
        this.authorizationComboBox.setActionCommand(SELECT_CMD);
        ((Container)((Object)this)).add(this.authorizationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)((Object)this)).add(this.nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)((Object)this)).add(this.nameTextField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)((Object)this)).add(this.loginLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)((Object)this)).add(this.errorLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)((Object)this)).add(this.authorizationComboBox, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)((Object)this)).add(this.loginTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)((Object)this)).add(this.errorTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initFields() {
        LoginConfig config = null;
        FormLoginConfig formConfig = null;
        if (this.www != null) {
            if (this.www.getLoginConfig() != null) {
                config = this.www.getLoginConfig();
                this.authorizationComboBox.setSelectedItem(config.getAuthMethod());
                this.nameTextField.setText(config.getRealmName());
                formConfig = config.getFormLogin();
                if (formConfig != null) {
                    this.loginTextField.setText(formConfig.getLoginPage());
                    this.errorTextField.setText(formConfig.getErrorPage());
                }
            } else {
                this.authorizationComboBox.setSelectedIndex(0);
                this.nameTextField.setText("");
                this.loginTextField.setText("");
                this.errorTextField.setText("");
            }
        }
    }

    public LoginConfig getLoginConfig() {
        LoginConfig config = new LoginConfig();
        FormLoginConfig formConfig = null;
        boolean mustBeNull = true;
        if (this.nameTextField.getText() != null) {
            String realm = this.nameTextField.getText();
            if (realm != null && realm.trim().equals("")) {
                realm = null;
            }
            config.setRealmName(realm);
            mustBeNull = false;
        }
        if (this.authorizationComboBox.getSelectedIndex() >= 0) {
            String authr = authMethods[this.authorizationComboBox.getSelectedIndex()];
            if (authr != null && authr.trim().equals("")) {
                return null;
            }
            config.setAuthMethod(authr);
            mustBeNull = false;
        }
        if (!this.loginTextField.getText().trim().equals("") && !this.errorTextField.getText().trim().equals("")) {
            formConfig = new FormLoginConfig(this.loginTextField.getText().trim(), this.errorTextField.getText().trim());
            mustBeNull = false;
        } else if (this.www.getLoginConfig() != null && this.www.getLoginConfig().getFormLogin() != null) {
            formConfig = new FormLoginConfig(this.loginTextField.getText().trim(), this.errorTextField.getText().trim());
            mustBeNull = false;
        }
        config.setFormLogin(formConfig);
        if (mustBeNull) {
            return null;
        }
        return config;
    }

    public void commitChange() {
        if (this.www != null) {
            this.www.setLoginConfig(this.getLoginConfig());
        } else {
            this.www = new WebDeploymentDescriptor();
            this.www.setLoginConfig(this.getLoginConfig());
        }
    }

    public void commitChanges(WebDeploymentDescriptor www) {
        if (www != null) {
            www.setLoginConfig(this.getLoginConfig());
        } else {
            www = new WebDeploymentDescriptor();
            www.setLoginConfig(this.getLoginConfig());
        }
    }

    public int isCorrect() {
        return 0;
    }

    public void init(int _madeFromConstant) {
    }

    public void setDescriptor(WebDeploymentDescriptor descr) {
        this.www = descr;
        this.initFields();
    }

    public void clear() {
        this.authorizationComboBox.setSelectedIndex(0);
        this.nameTextField.setText("");
        this.errorTextField.setText("");
        this.loginTextField.setText("");
    }

    public void setLoader(ClassLoader loader) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(SELECT_CMD)) {
            this.selectAuthorization();
        }
    }

    private void selectAuthorization() {
        if (this.authorizationComboBox.getSelectedItem() == null) {
            this.nameTextField.setEnabled(false);
            this.nameTextField.setText("");
            this.loginTextField.setEnabled(false);
            this.loginTextField.setText("");
            this.errorTextField.setEnabled(false);
            this.errorTextField.setText("");
            return;
        }
        if (((String)this.authorizationComboBox.getSelectedItem()).equals("BASIC") || ((String)this.authorizationComboBox.getSelectedItem()).equals("DIGEST")) {
            this.nameTextField.setEnabled(true);
            this.nameTextField.setText("");
            this.loginTextField.setEnabled(false);
            this.loginTextField.setText("");
            this.errorTextField.setEnabled(false);
            this.errorTextField.setText("");
        } else if (((String)this.authorizationComboBox.getSelectedItem()).equals("CLIENT_CERT") || ((String)this.authorizationComboBox.getSelectedItem()).equals("CLIENT-CERT")) {
            this.nameTextField.setEnabled(false);
            this.nameTextField.setText("");
            this.loginTextField.setEnabled(false);
            this.loginTextField.setText("");
            this.errorTextField.setEnabled(false);
            this.errorTextField.setText("");
        } else if (((String)this.authorizationComboBox.getSelectedItem()).equals("FORM")) {
            this.nameTextField.setEnabled(false);
            this.nameTextField.setText("");
            this.loginTextField.setEnabled(true);
            this.loginTextField.setText("");
            this.errorTextField.setEnabled(true);
            this.errorTextField.setText("");
        } else {
            this.nameTextField.setEnabled(false);
            this.nameTextField.setText("");
            this.loginTextField.setEnabled(false);
            this.loginTextField.setText("");
            this.errorTextField.setEnabled(false);
            this.errorTextField.setText("");
        }
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

