/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.services.deploy.gui.common.ImageHolder;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListValues;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ListRenderer
extends JLabel
implements ListCellRenderer {
    public static final byte WELCOME_PAGE = 1;
    public static final byte URL_PATTERN = 2;
    public static final byte HTTP_METHOD = 3;
    public static final byte DOMAIN = 4;
    private byte type = 0;
    private Icon servlet;
    private Icon initParam;
    private Icon servletMapping;
    private Icon mimeMapping;
    private Icon tagLib;
    private Icon error;
    private Icon webResource;
    private Icon secConstr;
    private Icon roleName;
    private Icon login;
    private Icon welcomePage;
    private Icon urlPattern;
    private Icon httpMethod;
    private Icon domain;
    private Icon cookie_app;
    private Icon cookie_session;

    public ListRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof ListValues) && !(value instanceof String)) {
            return this;
        }
        if (value instanceof String) {
            switch (this.type) {
                case 1: {
                    this.setIcon(this.welcomePage);
                    break;
                }
                case 2: {
                    this.setIcon(this.urlPattern);
                    break;
                }
                case 3: {
                    this.setIcon(this.httpMethod);
                    break;
                }
                case 4: {
                    this.setIcon(this.domain);
                    break;
                }
                default: {
                    this.setIcon(this.servlet);
                    break;
                }
            }
        } else {
            ListValues info = (ListValues)value;
            switch (info.getType()) {
                case 0: {
                    this.setIcon(this.servlet);
                    break;
                }
                case 1: {
                    this.setIcon(this.initParam);
                    break;
                }
                case 2: {
                    this.setIcon(this.servletMapping);
                    break;
                }
                case 3: {
                    this.setIcon(this.mimeMapping);
                    break;
                }
                case 4: {
                    this.setIcon(this.tagLib);
                    break;
                }
                case 5: {
                    this.setIcon(this.error);
                    break;
                }
                case 6: {
                    this.setIcon(this.secConstr);
                    break;
                }
                case 7: {
                    this.setIcon(this.webResource);
                    break;
                }
                case 8: {
                    this.setIcon(this.roleName);
                    break;
                }
                case 12: {
                    this.setIcon(this.login);
                    break;
                }
                case 13: {
                    this.setIcon(this.cookie_app);
                    break;
                }
                case 14: {
                    this.setIcon(this.cookie_session);
                    break;
                }
                default: {
                    this.setIcon(this.servlet);
                }
            }
        }
        this.setText(value.toString());
        this.setBackground(isSelected ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(isSelected ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    private void initImages() {
        this.servlet = ImageHolder.aServletDescr;
        this.initParam = ImageHolder.anInitParam;
        this.servletMapping = ImageHolder.aServletMap;
        this.mimeMapping = ImageHolder.aMIMEMap;
        this.tagLib = ImageHolder.aTagIcon;
        this.error = ImageHolder.anErrorIcon;
        this.secConstr = ImageHolder.aSecConstrIcon;
        this.webResource = ImageHolder.aWebResourceIcon;
        this.roleName = ImageHolder.aRoleNameIcon;
        this.login = ImageHolder.login;
        this.welcomePage = ImageHolder.welcomePage;
        this.urlPattern = ImageHolder.urlPattern;
        this.httpMethod = ImageHolder.httpMethod;
        this.domain = ImageHolder.domain;
        this.cookie_app = ImageHolder.cookieApp;
        this.cookie_session = ImageHolder.cookieSession;
    }

    public void setType(byte _type) {
        this.type = _type;
    }
}

