/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.servlets_jsp.descriptor.ErrorPage;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListRenderer;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListValues;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ErrorPanel
extends BasicPanelView
implements ListSelectionListener,
ActionListener,
DocumentListener {
    public static final String ADD_CMD = "ADD_CMD";
    public static final String MODIFY_CMD = "MODIFY_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    public static final String CLEAR_CMD = "CLEAR_CMD";
    public static final String[] types = new String[]{"error-code", "exception-type"};
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane theSplitPane = new JSplitPane();
    JScrollPane scrollPane = new JScrollPane();
    JPanel inputPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    DefaultListModel components = new DefaultListModel();
    JList theList = new JList(this.components);
    TitledBorder titledBorder1;
    JPanel buttonsPanel = new JPanel();
    JButton addButton = new JButton();
    JButton modifyButton = new JButton();
    JButton removeButton = new JButton();
    JButton clearButton = new JButton();
    JLabel typeLabel = new JLabel();
    JLabel valueLabel = new JLabel();
    JLabel locationLabel = new JLabel();
    JTextField valueTextField = new JTextField();
    JTextField locationTextField = new JTextField();
    JComboBox typeComboBox = new JComboBox<String>(types);
    int lastSelected = -1;
    private boolean selectWithMouse = true;
    private boolean setText = false;
    private int constant = 2;
    private ApplicationInformationProvider appProvider;
    private ErrorReportObject errors = new ErrorReportObject();
    private static Category category = EditorViewManager.category;
    private static Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$descriptor$gui$ErrorPanel == null ? (class$com$sap$engine$services$servlets_jsp$descriptor$gui$ErrorPanel = ErrorPanel.class$("com.sap.engine.services.servlets_jsp.descriptor.gui.ErrorPanel")) : class$com$sap$engine$services$servlets_jsp$descriptor$gui$ErrorPanel));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$descriptor$gui$ErrorPanel;

    public ErrorPanel(int madeFromConstant, Frame frame) {
        try {
            this.constant = madeFromConstant;
            this.mainFrame = frame;
            this.checkEnable();
            this.jbInit();
        }
        catch (Exception ex) {
            category.logThrowableT(500, currentLocation, "Error panel cannot be created!", (Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(), "Error Pages");
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.inputPanel.setLayout(this.gridBagLayout1);
        this.scrollPane.setBorder(this.titledBorder1);
        this.locationLabel.setText("Location:");
        this.typeLabel.setText("Type:");
        this.valueLabel.setText("Value:");
        this.addButton.setText("Add");
        this.addButton.setActionCommand(ADD_CMD);
        this.addButton.addActionListener(this);
        this.modifyButton.setText("Modify");
        this.modifyButton.setActionCommand(MODIFY_CMD);
        this.modifyButton.addActionListener(this);
        this.removeButton.setText("Remove");
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.addActionListener(this);
        this.clearButton.setText("Clear");
        this.clearButton.setActionCommand(CLEAR_CMD);
        this.clearButton.addActionListener(this);
        ((Container)((Object)this)).add(this.theSplitPane, "Center");
        this.theSplitPane.add((Component)this.scrollPane, "left");
        this.scrollPane.getViewport().add((Component)this.theList, null);
        this.theSplitPane.add((Component)this.inputPanel, "right");
        this.locationTextField.getDocument().addDocumentListener(this);
        this.inputPanel.add((Component)this.locationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.typeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.valueLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.locationTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.typeComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.valueTextField, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonsPanel.add((Component)this.addButton, null);
        this.buttonsPanel.add((Component)this.modifyButton, null);
        this.buttonsPanel.add((Component)this.removeButton, null);
        this.buttonsPanel.add((Component)this.clearButton, null);
        this.theSplitPane.setDividerLocation(200);
        this.theList.setCellRenderer(new ListRenderer());
        this.theList.addListSelectionListener(this);
        this.theList.setSelectionMode(0);
        this.addButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
    }

    public void setEnabled(boolean flag) {
        this.addButton.setEnabled(flag);
        this.modifyButton.setEnabled(flag);
        this.removeButton.setEnabled(flag);
        this.clearButton.setEnabled(flag);
    }

    public void initList(String[] names) {
        ListValues value = null;
        if (this.components.size() > 0) {
            this.components.removeAllElements();
        }
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                value = new ListValues(names[i], 5);
                this.components.addElement(value);
                ++i;
            }
        }
    }

    public void initList1(Vector values) {
        this.lastSelected = -1;
        if (values != null) {
            if (this.components.size() > 0) {
                this.components.removeAllElements();
            }
            int i = 0;
            while (i < values.size()) {
                this.components.addElement(values.elementAt(i));
                ++i;
            }
        }
    }

    public Vector getListData() {
        Vector data = new Vector();
        int i = 0;
        while (i < this.components.size()) {
            data.addElement(this.components.elementAt(i));
            ++i;
        }
        return data;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(ADD_CMD)) {
            this.addButtonAction();
            this.clear();
        } else if (cmd.equals(MODIFY_CMD)) {
            this.modifyButtonAction();
            this.clear();
        } else if (cmd.equals(REMOVE_CMD)) {
            this.removeButtonAction();
            this.clear();
        } else if (cmd.equals(CLEAR_CMD)) {
            this.clearButtonAction();
        }
    }

    private void addButtonAction() {
        ListValues value = null;
        ErrorPage error = null;
        int type = this.typeComboBox.getSelectedIndex();
        String paramValue = this.valueTextField.getText().trim();
        String paramName = this.locationTextField.getText().trim();
        if (paramName == null || paramName.equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "You can't add an empty error page location.");
            return;
        }
        if (paramValue == null || paramValue.equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "You can't add an empty error page value.");
            return;
        }
        if (!paramName.startsWith("/")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Each error page location must start with a slash (/). It will be added automatically.");
            paramName = "/" + paramName;
        }
        if (!this.theList.isSelectionEmpty()) {
            value = (ListValues)this.theList.getSelectedValue();
            this.lastSelected = -1;
            this.theList.clearSelection();
        } else {
            value = null;
        }
        if (value != null && paramName.equals(value.getName())) {
            error = value.getErrorPage();
            if (type == ErrorPage.errorCode) {
                try {
                    error.setValue(new Integer(paramValue));
                }
                catch (NumberFormatException exc) {
                    JOptionPane.showMessageDialog(this.mainFrame, "The error code value must be a number.");
                    category.logThrowableT(500, currentLocation, "The error code value: " + paramValue + ", must be a number.", (Throwable)exc);
                    return;
                }
            } else {
                error.setValue(paramValue);
            }
            error.setType(type);
            value.setErrorPage(error);
            return;
        }
        if (!this.nameExists(this.components, paramName)) {
            error = new ErrorPage();
            if (type == ErrorPage.errorCode) {
                try {
                    error.setValue(new Integer(paramValue));
                }
                catch (NumberFormatException exc) {
                    JOptionPane.showMessageDialog(this.mainFrame, "The error code value must be a number.");
                    category.logThrowableT(500, currentLocation, "The error code value: " + paramValue + ", must be a number.", (Throwable)exc);
                    return;
                }
            } else {
                error.setValue(paramValue);
            }
            error.setType(type);
            error.setLocation(paramName);
            value = new ListValues(paramName, 5);
            value.setErrorPage(error);
            this.components.addElement(value);
        } else {
            int answer = JOptionPane.showConfirmDialog(this.mainFrame, " This entry already exists  \nDo you want to replace it ?", " Warning ", 0);
            if (answer == 0) {
                int i = 0;
                while (i < this.components.size()) {
                    value = (ListValues)this.components.elementAt(i);
                    if (value.getName().trim().equals(paramName)) {
                        error = value.getErrorPage();
                        if (type == ErrorPage.errorCode) {
                            try {
                                error.setValue(new Integer(paramValue));
                            }
                            catch (NumberFormatException exc) {
                                JOptionPane.showMessageDialog(this.mainFrame, "The error code value must be a number.");
                                return;
                            }
                        } else {
                            error.setValue(paramValue);
                        }
                        error.setType(type);
                        value.setErrorPage(error);
                    }
                    ++i;
                }
            } else {
                return;
            }
        }
    }

    private boolean nameExists(DefaultListModel values, String name) {
        if (values.size() > 0) {
            int i = 0;
            if (i < values.size()) {
                return name.equals(((ListValues)values.elementAt(i)).getName());
            }
        } else {
            return false;
        }
        return false;
    }

    private void removeButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            this.components.removeElementAt(index);
            this.lastSelected = -1;
            this.theList.clearSelection();
            this.removeButton.setEnabled(false);
        }
    }

    private void clearButtonAction() {
        this.clear();
    }

    private void modifyButtonAction() {
        this.addButtonAction();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.checkEnable();
        if (this.constant == 2 || this.constant == 3 || this.constant == 4 || this.constant == 5) {
            this.modifyButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.removeButton.setEnabled(false);
        } else {
            this.modifyButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
        if (!this.selectWithMouse) {
            if (this.theList.getSelectedValue() != null) {
                this.lastSelected = this.theList.getSelectedIndex();
                this.viewValues(this.lastSelected);
            } else {
                this.lastSelected = -1;
                this.clear();
            }
            return;
        }
        if (!this.theList.isSelectionEmpty()) {
            if (this.lastSelected == -1) {
                this.viewValues(this.theList.getSelectedIndex());
            } else {
                this.setValues(this.lastSelected);
                this.viewValues(this.theList.getSelectedIndex());
            }
            this.lastSelected = this.theList.getSelectedIndex();
        } else if (this.lastSelected != -1) {
            this.lastSelected = -1;
            this.clear();
        }
    }

    public void viewValues(int index) {
        ListValues value = null;
        ErrorPage page = null;
        if (!this.theList.isSelectionEmpty() && (page = (value = (ListValues)this.components.elementAt(index)).getErrorPage()) != null) {
            this.typeComboBox.setSelectedIndex(page.getType());
            this.valueTextField.setText(page.getValue().toString());
            if (this.selectWithMouse) {
                this.setText = true;
                this.locationTextField.setText(page.getLocation());
                this.setText = false;
            }
        }
    }

    private void setValues(int lastSelectedIndex) {
        ListValues value = (ListValues)this.components.elementAt(lastSelectedIndex);
        ErrorPage error = value.getErrorPage();
        ErrorPage newError = null;
        if (error != null) {
            newError = new ErrorPage();
            int type = this.typeComboBox.getSelectedIndex();
            String paramName = this.locationTextField.getText();
            String paramValue = this.valueTextField.getText();
            if (type == ErrorPage.errorCode) {
                try {
                    newError.setValue(new Integer(paramValue));
                }
                catch (NumberFormatException exc) {
                    if (paramValue != null && !paramValue.trim().equals("")) {
                        JOptionPane.showMessageDialog(this.mainFrame, "The error code value must be a number.");
                    }
                    category.logThrowableT(500, currentLocation, "The error code value: " + paramValue + ", must be a number.", (Throwable)exc);
                    return;
                }
            } else {
                newError.setValue(paramValue);
            }
            newError.setType(type);
            newError.setLocation(paramName);
            if (!error.equals(newError)) {
                Object[] options = new Object[]{GuiSettings.getResourceString((String)"YesOption", (String)"Yes"), GuiSettings.getResourceString((String)"NoOption", (String)"No")};
                int result = JOptionPane.showOptionDialog(this.mainFrame, GuiSettings.getResourceString((String)"TagLibMsg", (String)"The error page") + " " + error.getLocation() + " " + GuiSettings.getResourceString((String)"CommitChangesMsg", (String)"has changed. Do you want to commit these changes?"), "Warning", -1, 2, null, options, options[0]);
                if (result == 0) {
                    value.setErrorPage(newError);
                }
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    private void checkDisabled() {
        String entryName = this.locationTextField.getText();
        if (entryName.equals("")) {
            this.clear();
            this.checkEnable();
            return;
        }
        if (!entryName.trim().equals("")) {
            this.checkEnable();
        } else {
            this.checkEnable();
        }
        if (!entryName.startsWith("/")) {
            entryName = "/" + entryName;
        }
        this.selectWithMouse = false;
        Vector currentValues = new Vector();
        ListModel model = this.theList.getModel();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(model.getElementAt(i));
            ++i;
        }
        boolean toAdd = true;
        this.theList.clearSelection();
        int i2 = 0;
        while (i2 < currentValues.size()) {
            if (entryName.equals(((ListValues)currentValues.elementAt(i2)).getErrorPage().getLocation())) {
                toAdd = false;
                this.theList.setSelectedValue(currentValues.elementAt(i2), true);
                break;
            }
            ++i2;
        }
        if (entryName.trim().length() != 0) {
            if (toAdd) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(true);
                this.clearButton.setEnabled(true);
                if (this.constant != 2 && this.constant != 3 && this.constant != 4 && this.constant != 5) {
                    this.removeButton.setEnabled(true);
                }
            }
        } else {
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.selectWithMouse = true;
    }

    private void checkEnable() {
        if (this.constant == 1 || this.constant == 5) {
            this.locationTextField.setEnabled(true);
            if (this.locationTextField.getText() != null && this.locationTextField.getText().trim().length() != 0) {
                this.valueTextField.setEnabled(true);
                this.typeComboBox.setEnabled(true);
            } else {
                this.valueTextField.setEnabled(false);
                this.typeComboBox.setEnabled(false);
            }
        } else if (this.constant == 2) {
            this.locationTextField.setEnabled(false);
            if (this.locationTextField.getText() != null && this.locationTextField.getText().trim().length() != 0) {
                this.valueTextField.setEnabled(true);
                this.typeComboBox.setEnabled(true);
            } else {
                this.valueTextField.setEnabled(false);
                this.typeComboBox.setEnabled(false);
            }
        } else if (this.constant == 3 || this.constant == 4) {
            this.locationTextField.setEnabled(false);
            this.typeComboBox.setEnabled(false);
            if (this.locationTextField.getText() != null && this.locationTextField.getText().trim().length() != 0) {
                this.valueTextField.setEnabled(true);
            } else {
                this.valueTextField.setEnabled(false);
            }
        }
    }

    public void init(int madeFromConstant) {
        this.constant = madeFromConstant;
    }

    public void clear() {
        this.typeComboBox.setSelectedIndex(0);
        this.valueTextField.setText("");
        if (this.selectWithMouse) {
            this.setText = true;
            this.locationTextField.setText("");
            this.setText = false;
        }
        if (!this.theList.isSelectionEmpty()) {
            this.theList.clearSelection();
        }
        this.addButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.checkEnable();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return this.errors;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

