/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.servlets_jsp.descriptor.CookieConfig;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.gui.CookieConfigPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CookieConfigPanelLogical
extends CookieConfigPanel {
    private CookieConfig[] cookies = null;
    private Vector cookiesV = new Vector();
    private CookieConfig cookie;
    private ApplicationInformationProvider appProvider;
    private WebDeploymentDescriptor descriptor = null;
    boolean setText;

    public CookieConfigPanelLogical(Frame mainFrame, int constant) {
        this(mainFrame, constant, null);
    }

    public CookieConfigPanelLogical(Frame mainFrame, int constant, WebDeploymentDescriptor descr) {
        this.mainFrame = mainFrame;
        this.constant = constant;
        this.disableFields();
        this.setDescriptor(descr);
    }

    private void disableFields() {
        if (this.constant == 3 || this.constant == 4 || this.constant == 5) {
            this.aCookiePathComboBox.setEnabled(true);
            this.aCookieDomainComboBox.setEnabled(true);
            this.aMaxAgeTextField.setEnabled(true);
        } else {
            this.aCookiePathComboBox.setEnabled(false);
            this.aCookieDomainComboBox.setEnabled(false);
            this.aMaxAgeTextField.setEnabled(false);
        }
    }

    public void setDescriptor(WebDeploymentDescriptor wd) {
        this.descriptor = wd;
        this.clear();
        if (wd != null) {
            this.cookies = wd.getCookieConfig();
            if (this.cookies != null) {
                int i = 0;
                while (i < this.cookies.length) {
                    if (this.cookies[i].getType().equalsIgnoreCase("APPLICATION")) {
                        this.applicationBOX.setSelected(true);
                        this.aCookieDomainComboBox.setSelectedItem(this.cookies[i].getDomain());
                        this.aCookiePathComboBox.setSelectedItem(this.cookies[i].getPath());
                        this.aMaxAgeTextField.setText(this.cookies[i].getMaxAge() + "");
                    } else if (this.cookies[i].getType().equalsIgnoreCase("SESSION")) {
                        this.sessionBOX.setSelected(true);
                        this.sCookieDomainComboBox.setSelectedItem(this.cookies[i].getDomain());
                        this.sCookiePathComboBox.setSelectedItem(this.cookies[i].getPath());
                        this.sMaxAgeTextField.setText(this.cookies[i].getMaxAge() + "");
                    }
                    ++i;
                }
            }
        }
    }

    public void clear() {
        this.sessionBOX.setSelected(false);
        this.sCookieDomainComboBox.setSelectedItem("");
        this.sCookiePathComboBox.setSelectedItem("");
        this.sMaxAgeTextField.setText("");
        this.sCookieDomainComboBox.setEnabled(false);
        this.sCookiePathComboBox.setEnabled(false);
        this.sMaxAgeTextField.setEnabled(false);
        this.applicationBOX.setSelected(false);
        this.aCookieDomainComboBox.setSelectedItem("");
        this.aCookiePathComboBox.setSelectedItem("");
        this.aMaxAgeTextField.setText("");
        this.aCookieDomainComboBox.setEnabled(false);
        this.aCookiePathComboBox.setEnabled(false);
        this.aMaxAgeTextField.setEnabled(false);
    }

    public void commitChange() {
        this.cookiesV = new Vector();
        if (this.applicationBOX.isSelected()) {
            this.cookie = new CookieConfig("APPLICATION", (String)this.aCookiePathComboBox.getSelectedItem(), (String)this.aCookieDomainComboBox.getSelectedItem(), this.getApplicationMaxAge());
            this.cookiesV.addElement(this.cookie);
        }
        if (this.sessionBOX.isSelected()) {
            this.cookie = new CookieConfig("SESSION", (String)this.sCookiePathComboBox.getSelectedItem(), (String)this.sCookieDomainComboBox.getSelectedItem(), this.getSessionMaxAge());
            this.cookiesV.addElement(this.cookie);
        }
        this.cookies = new CookieConfig[this.cookiesV.size()];
        this.cookiesV.copyInto(this.cookies);
        this.descriptor.setCookieConfig(this.cookies);
    }

    public int isCorrect() {
        return 0;
    }

    public void init(int madeFromConstant) {
        this.constant = madeFromConstant;
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    private int getApplicationMaxAge() {
        int result = -1;
        try {
            result = Integer.parseInt(this.aMaxAgeTextField.getText());
        }
        catch (Exception e) {
            JOptionPane.showConfirmDialog(this.mainFrame, GuiSettings.getResourceString((String)"ReplaceReferenceMessage", (String)"This is not correct integer value: ") + this.aMaxAgeTextField.getText() + "\nWill be set default max age: -1", "Warning", -1, 2);
            this.aMaxAgeTextField.setText("-1");
        }
        return result;
    }

    private int getSessionMaxAge() {
        int result = -1;
        try {
            result = Integer.parseInt(this.sMaxAgeTextField.getText());
        }
        catch (Exception e) {
            JOptionPane.showConfirmDialog(this.mainFrame, GuiSettings.getResourceString((String)"ReplaceReferenceMessage", (String)"This is not correct integer value: ") + this.sMaxAgeTextField.getText() + "\nWill be set default max age: -1", "Warning", -1, 2);
            this.sMaxAgeTextField.setText("-1");
        }
        return result;
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.sessionBOX) {
            if (this.sessionBOX.isSelected()) {
                this.setSessionTypeEnable();
            } else {
                this.setSessionTypeDisable();
            }
        } else if (source == this.applicationBOX) {
            if (this.applicationBOX.isSelected()) {
                this.setApplicationTypeEnable();
            } else {
                this.setApplicationTypeDisable();
            }
        }
    }

    private void setSessionTypeEnable() {
        this.sCookieDomainComboBox.setSelectedIndex(0);
        this.sCookiePathComboBox.setSelectedIndex(0);
        this.sMaxAgeTextField.setText("");
        this.sCookieDomainComboBox.setEnabled(true);
        this.sCookiePathComboBox.setEnabled(true);
        this.sMaxAgeTextField.setEnabled(true);
    }

    private void setSessionTypeDisable() {
        this.sCookieDomainComboBox.setSelectedItem("");
        this.sCookiePathComboBox.setSelectedItem("");
        this.sMaxAgeTextField.setText("");
        this.sCookieDomainComboBox.setEnabled(false);
        this.sCookiePathComboBox.setEnabled(false);
        this.sMaxAgeTextField.setEnabled(false);
    }

    private void setApplicationTypeEnable() {
        this.aCookieDomainComboBox.setSelectedIndex(0);
        this.aCookiePathComboBox.setSelectedIndex(0);
        this.aMaxAgeTextField.setText("");
        this.aCookieDomainComboBox.setEnabled(true);
        this.aCookiePathComboBox.setEnabled(true);
        this.aMaxAgeTextField.setEnabled(true);
    }

    private void setApplicationTypeDisable() {
        this.aCookieDomainComboBox.setSelectedItem("");
        this.aCookiePathComboBox.setSelectedItem("");
        this.aMaxAgeTextField.setText("");
        this.aCookieDomainComboBox.setEnabled(false);
        this.aCookiePathComboBox.setEnabled(false);
        this.aMaxAgeTextField.setEnabled(false);
    }
}

