/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.servlets_jsp.descriptor.AuthenticationDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.CookieConfig;
import com.sap.engine.services.servlets_jsp.descriptor.ErrorPage;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.FilterMapping;
import com.sap.engine.services.servlets_jsp.descriptor.ListenerDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.LoginConfig;
import com.sap.engine.services.servlets_jsp.descriptor.MIMEMapping;
import com.sap.engine.services.servlets_jsp.descriptor.SecurityConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletMapping;
import com.sap.engine.services.servlets_jsp.descriptor.TagLib;
import com.sap.engine.services.servlets_jsp.descriptor.WebResourceCollection;
import com.sap.engine.services.servlets_jsp.descriptor.xml.WebDescriptorDocument;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWrongDescriptorException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WebDeploymentDescriptor
extends ArchiveDescriptor
implements Serializable {
    static final long serialVersionUID = 7492845723354656051L;
    public static final String DEFAULT_GET_REQUEST_URL_MODE = "REQUEST-DISPATCHER";
    public static final String GET_REQUEST_URL_MODE_CLIENT = "CLIENT";
    protected boolean distributable = false;
    protected ContextParam[] contextParam = null;
    protected ServletDescriptor[] servletDescriptors = null;
    protected ServletMapping[] servletMapping = null;
    protected int sessionTimeout = 30;
    protected MIMEMapping[] mimeMapping = null;
    protected String[] welcomeFileList = null;
    protected ErrorPage[] errorPage = null;
    protected TagLib[] tagLib = null;
    protected ResourceReference[] resReferences = null;
    protected SecurityConstraints[] secConstraints = null;
    protected LoginConfig login = null;
    protected SecurityRoles[] secRoles = null;
    protected EnvironmentEntry[] entries = null;
    protected EJBeanReference[] ejbRefs = null;
    protected FilterMapping[] filterMappings = null;
    protected FilterDescriptor[] filters = null;
    protected ListenerDescriptor[] listeners = null;
    protected EJBeanLocalReference[] ejbLocalRefs = null;
    protected ResourceEnvReference[] resEnvRefs = null;
    protected ComponentReference[] compRefs = null;
    private HashMapIntObject responseStatus = null;
    private String failOverMessage = null;
    private int failOverMessageTimeout = -1;
    private boolean failOverEnable = false;
    private AuthenticationDescriptor authentication = null;
    private boolean urlSessionTracking = false;
    private String[] domains = null;
    private int maxSessions = -1;
    protected CookieConfig[] cookieConfig = null;
    private String getRequestURLMode = "REQUEST-DISPATCHER";

    public void setName(String name) {
        this.displayName = name;
    }

    public String getName() {
        return this.displayName;
    }

    public void addServlet(String name, String className, ContextParam[] initParams) {
        ServletDescriptor servDes = new ServletDescriptor();
        servDes.setServletName(name);
        servDes.setServletClass(className);
        servDes.setInitParams(initParams);
        this.addServlet(servDes);
    }

    public void addJspFile(String name, String jspFile, ContextParam[] initParams) {
        ServletDescriptor servDes = new ServletDescriptor();
        servDes.setServletName(name);
        servDes.setJspFile(jspFile);
        servDes.setInitParams(initParams);
        this.addServlet(servDes);
    }

    public void addServlet(ServletDescriptor servDesc) {
        if (servDesc == null) {
            return;
        }
        if (this.servletDescriptors == null || this.servletDescriptors.length == 0) {
            this.servletDescriptors = new ServletDescriptor[1];
            this.servletDescriptors[0] = servDesc;
        } else {
            if (servDesc.getName() != null) {
                int i = 0;
                while (i < this.servletDescriptors.length) {
                    if (servDesc.getName().equals(this.servletDescriptors[i].getName())) {
                        this.servletDescriptors[i] = servDesc;
                        return;
                    }
                    ++i;
                }
            }
            ServletDescriptor[] sDescriptors = new ServletDescriptor[this.servletDescriptors.length + 1];
            System.arraycopy(this.servletDescriptors, 0, sDescriptors, 0, this.servletDescriptors.length);
            sDescriptors[this.servletDescriptors.length] = servDesc;
            this.servletDescriptors = sDescriptors;
        }
    }

    public void removeServlet(String name) {
        if (name == null) {
            return;
        }
        if (this.servletDescriptors == null || this.servletDescriptors.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.servletDescriptors.length) {
            if (name.equals(this.servletDescriptors[i].getServletName())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            ServletDescriptor[] newServlets = new ServletDescriptor[this.servletDescriptors.length - 1];
            System.arraycopy(this.servletDescriptors, 0, newServlets, 0, index);
            System.arraycopy(this.servletDescriptors, index + 1, newServlets, index, this.servletDescriptors.length - 1 - index);
            this.servletDescriptors = newServlets;
        }
    }

    public ServletDescriptor[] getServlets() {
        return this.servletDescriptors;
    }

    public void setServlets(ServletDescriptor[] servlets) {
        this.servletDescriptors = servlets;
    }

    public void setWelcomeFileList(String[] files) {
        this.welcomeFileList = files;
    }

    public String[] getWelcomeFileList() {
        return this.welcomeFileList;
    }

    public void setErrorPage(ErrorPage[] errorPages) {
        this.errorPage = errorPages;
    }

    public ErrorPage[] getErrorPage() {
        return this.errorPage;
    }

    public void addErrorPage(ErrorPage ePage) {
        if (ePage == null) {
            return;
        }
        if (this.errorPage == null || this.errorPage.length == 0) {
            this.errorPage = new ErrorPage[1];
            this.errorPage[0] = ePage;
        } else {
            int i = 0;
            while (i < this.errorPage.length) {
                if (ePage.equals(this.errorPage[i])) {
                    return;
                }
                ++i;
            }
            ErrorPage[] errors = new ErrorPage[this.errorPage.length + 1];
            System.arraycopy(this.errorPage, 0, errors, 0, this.errorPage.length);
            errors[this.errorPage.length] = ePage;
            this.errorPage = errors;
        }
    }

    public void removeErrorPage(ErrorPage ePage) {
        if (ePage == null) {
            return;
        }
        if (this.errorPage == null || this.errorPage.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.errorPage.length) {
            if (ePage.equals(this.errorPage[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            ErrorPage[] newErrors = new ErrorPage[this.errorPage.length - 1];
            System.arraycopy(this.errorPage, 0, newErrors, 0, index);
            System.arraycopy(this.errorPage, index + 1, newErrors, index, this.errorPage.length - 1 - index);
            this.errorPage = newErrors;
        }
    }

    public void setSessionTimeout(int timeout) {
        this.sessionTimeout = timeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setServletMapping(ServletMapping[] servMapping) {
        this.servletMapping = servMapping;
    }

    public ServletMapping[] getServletMapping() {
        return this.servletMapping;
    }

    public void addServletMapping(ServletMapping servMapping) {
        if (servMapping == null) {
            return;
        }
        if (this.servletMapping == null || this.servletMapping.length == 0) {
            this.servletMapping = new ServletMapping[1];
            this.servletMapping[0] = servMapping;
        } else {
            int i = 0;
            while (i < this.servletMapping.length) {
                if (servMapping.equals(this.servletMapping[i])) {
                    return;
                }
                ++i;
            }
            ServletMapping[] sMapping = new ServletMapping[this.servletMapping.length + 1];
            System.arraycopy(this.servletMapping, 0, sMapping, 0, this.servletMapping.length);
            sMapping[this.servletMapping.length] = servMapping;
            this.servletMapping = sMapping;
        }
    }

    public void setMIMEMapping(MIMEMapping[] mime) {
        this.mimeMapping = mime;
    }

    public MIMEMapping[] getMIMEMapping() {
        return this.mimeMapping;
    }

    public void addMIMEMapping(MIMEMapping mime) {
        if (mime == null) {
            return;
        }
        if (this.mimeMapping == null || this.mimeMapping.length == 0) {
            this.mimeMapping = new MIMEMapping[1];
            this.mimeMapping[0] = mime;
        } else {
            int i = 0;
            while (i < this.mimeMapping.length) {
                if (mime.equals(this.mimeMapping[i])) {
                    return;
                }
                ++i;
            }
            MIMEMapping[] mappings = new MIMEMapping[this.mimeMapping.length + 1];
            System.arraycopy(this.mimeMapping, 0, mappings, 0, this.mimeMapping.length);
            mappings[this.mimeMapping.length] = mime;
            this.mimeMapping = mappings;
        }
    }

    public void removeMIMEMapping(String extension) {
        if (extension == null) {
            return;
        }
        if (this.mimeMapping == null || this.mimeMapping.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.mimeMapping.length) {
            if (extension.equals(this.mimeMapping[i].getExtension())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            MIMEMapping[] newMapping = new MIMEMapping[this.mimeMapping.length - 1];
            System.arraycopy(this.mimeMapping, 0, newMapping, 0, index);
            System.arraycopy(this.mimeMapping, index + 1, newMapping, index, this.mimeMapping.length - 1 - index);
            this.mimeMapping = newMapping;
        }
    }

    public void setContextParams(ContextParam[] contParams) {
        this.contextParam = contParams;
    }

    public ContextParam[] getContextParams() {
        return this.contextParam;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(ContextParam[] params, ContextParam contParam) {
        if (params == null) return false;
        if (contParam == null) return false;
        int i = 0;
        while (i < params.length) {
            if (!contParam.equals((Object)params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addContextParam(ContextParam param) {
        if (param == null) {
            return;
        }
        if (this.contextParam == null || this.contextParam.length == 0) {
            this.contextParam = new ContextParam[1];
            this.contextParam[0] = param;
        } else {
            String name = param.getParamName();
            if (name != null) {
                int i = 0;
                while (i < this.contextParam.length) {
                    if (this.contextParam[i] != null && name.equals(this.contextParam[i].getParamName())) {
                        return;
                    }
                    ++i;
                }
            }
            ContextParam[] context = new ContextParam[this.contextParam.length + 1];
            System.arraycopy(this.contextParam, 0, context, 0, this.contextParam.length);
            context[this.contextParam.length] = param;
            this.contextParam = context;
        }
    }

    public void removeContextParam(String name) {
        if (name == null) {
            return;
        }
        if (this.contextParam == null || this.contextParam.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.contextParam.length) {
            if (name.equals(this.contextParam[i].getParamName())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            ContextParam[] newParams = new ContextParam[this.contextParam.length - 1];
            System.arraycopy(this.contextParam, 0, newParams, 0, index);
            System.arraycopy(this.contextParam, index + 1, newParams, index, this.contextParam.length - 1 - index);
            this.contextParam = newParams;
        }
    }

    public void setSmallIcon(String smIcon) {
        this.smallIcon = new SerializableFile(smIcon);
    }

    public void setLargeIcon(String lIcon) {
        this.largeIcon = new SerializableFile(lIcon);
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distrib) {
        this.distributable = distrib;
    }

    public TagLib[] getTagLib() {
        return this.tagLib;
    }

    public void setTagLib(TagLib[] tagLib1) {
        this.tagLib = tagLib1;
    }

    public void addTagLib(TagLib tLib) {
        if (tLib == null) {
            return;
        }
        if (this.tagLib == null || this.tagLib.length == 0) {
            this.tagLib = new TagLib[1];
            this.tagLib[0] = tLib;
        } else {
            int i = 0;
            while (i < this.tagLib.length) {
                if (tLib.equals(this.tagLib[i])) {
                    return;
                }
                ++i;
            }
            TagLib[] newTags = new TagLib[this.tagLib.length + 1];
            System.arraycopy(this.tagLib, 0, newTags, 0, this.tagLib.length);
            newTags[this.tagLib.length] = tLib;
            this.tagLib = newTags;
        }
    }

    public void removeTagLib(String uri) {
        if (uri == null) {
            return;
        }
        if (this.tagLib == null || this.tagLib.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.tagLib.length) {
            if (uri.equals(this.tagLib[i].getUri())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            TagLib[] newTag = new TagLib[this.tagLib.length - 1];
            System.arraycopy(this.tagLib, 0, newTag, 0, index);
            System.arraycopy(this.tagLib, index + 1, newTag, index, this.tagLib.length - 1 - index);
            this.tagLib = newTag;
        }
    }

    public ResourceReference[] getResReferences() {
        return this.resReferences;
    }

    public void addResReference(ResourceReference resReference) {
        if (resReference == null) {
            return;
        }
        if (this.resReferences == null || this.resReferences.length == 0) {
            this.resReferences = new ResourceReference[1];
            this.resReferences[0] = resReference;
        } else {
            int i = 0;
            while (i < this.resReferences.length) {
                if (resReference.equals((Object)this.resReferences[i])) {
                    return;
                }
                ++i;
            }
            ResourceReference[] newReferences = new ResourceReference[this.resReferences.length + 1];
            System.arraycopy(this.resReferences, 0, newReferences, 0, this.resReferences.length);
            newReferences[this.resReferences.length] = resReference;
            this.resReferences = newReferences;
        }
    }

    public void addResEnvReference(ResourceEnvReference resEnvReference) {
        if (resEnvReference == null) {
            return;
        }
        if (this.resEnvRefs == null || this.resEnvRefs.length == 0) {
            this.resEnvRefs = new ResourceEnvReference[1];
            this.resEnvRefs[0] = resEnvReference;
        } else {
            int i = 0;
            while (i < this.resEnvRefs.length) {
                if (resEnvReference.equals((Object)this.resEnvRefs[i])) {
                    return;
                }
                ++i;
            }
            ResourceEnvReference[] newReferences = new ResourceEnvReference[this.resEnvRefs.length + 1];
            System.arraycopy(this.resEnvRefs, 0, newReferences, 0, this.resEnvRefs.length);
            newReferences[this.resEnvRefs.length] = resEnvReference;
            this.resEnvRefs = newReferences;
        }
    }

    public void setResReference(ResourceReference[] reference) {
        this.resReferences = reference;
    }

    public void removeTagLib(ResourceReference resReference) {
        if (resReference == null) {
            return;
        }
        if (this.resReferences == null || this.resReferences.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.resReferences.length) {
            if (resReference.equals((Object)this.resReferences[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            ResourceReference[] newReferences = new ResourceReference[this.resReferences.length - 1];
            System.arraycopy(this.resReferences, 0, newReferences, 0, index);
            System.arraycopy(this.resReferences, index + 1, newReferences, index, this.resReferences.length - 1 - index);
            this.resReferences = newReferences;
        }
    }

    public SecurityConstraints[] getSecConstraints() {
        return this.secConstraints;
    }

    public void setSecConstraints(SecurityConstraints[] secConstr) {
        this.secConstraints = secConstr;
    }

    public void addSecConstraint(SecurityConstraints constraints) {
        if (constraints == null) {
            return;
        }
        if (this.secConstraints == null || this.secConstraints.length == 0) {
            this.secConstraints = new SecurityConstraints[1];
            this.secConstraints[0] = constraints;
        } else {
            int i = 0;
            while (i < this.secConstraints.length) {
                if (constraints.equals(this.secConstraints[i])) {
                    return;
                }
                ++i;
            }
            SecurityConstraints[] newConstraints = new SecurityConstraints[this.secConstraints.length + 1];
            System.arraycopy(this.secConstraints, 0, newConstraints, 0, this.secConstraints.length);
            newConstraints[this.secConstraints.length] = constraints;
            this.secConstraints = newConstraints;
        }
    }

    public void removeSecConstraint(SecurityConstraints constraint) {
        if (constraint == null) {
            return;
        }
        if (this.secConstraints == null || this.secConstraints.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.secConstraints.length) {
            if (constraint.equals(this.secConstraints[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            SecurityConstraints[] newConstraints = new SecurityConstraints[this.secConstraints.length - 1];
            System.arraycopy(this.secConstraints, 0, newConstraints, 0, index);
            System.arraycopy(this.secConstraints, index + 1, newConstraints, index, this.secConstraints.length - 1 - index);
            this.secConstraints = newConstraints;
        }
    }

    public LoginConfig getLoginConfig() {
        return this.login;
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        this.login = loginConfig;
    }

    public SecurityRoles[] getSecRoles() {
        return this.secRoles;
    }

    public void setSecRoles(SecurityRoles[] secRoles1) {
        this.secRoles = secRoles1;
    }

    public void addSecRole(SecurityRoles role) {
        if (role == null) {
            return;
        }
        if (this.secRoles == null || this.secRoles.length == 0) {
            this.secRoles = new SecurityRoles[1];
            this.secRoles[0] = role;
        } else {
            int i = 0;
            while (i < this.secRoles.length) {
                if (role.equals((Object)this.secRoles[i])) {
                    return;
                }
                ++i;
            }
            SecurityRoles[] newRoles = new SecurityRoles[this.secRoles.length + 1];
            System.arraycopy(this.secRoles, 0, newRoles, 0, this.secRoles.length);
            newRoles[this.secRoles.length] = role;
            this.secRoles = newRoles;
        }
    }

    public void removeSecRole(SecurityRoles sRole) {
        if (sRole == null) {
            return;
        }
        if (this.secRoles == null || this.secRoles.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.secRoles.length) {
            if (sRole.equals((Object)this.secRoles[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            SecurityRoles[] newRoles = new SecurityRoles[this.secRoles.length - 1];
            System.arraycopy(this.secRoles, 0, newRoles, 0, index);
            System.arraycopy(this.secRoles, index + 1, newRoles, index, this.secRoles.length - 1 - index);
            this.secRoles = newRoles;
        }
    }

    public EnvironmentEntry[] getEnvEntries() {
        return this.entries;
    }

    public void setEnvEntries(EnvironmentEntry[] envEntries) {
        this.entries = envEntries;
    }

    public void addEnvEntry(EnvironmentEntry entry) {
        if (entry == null) {
            return;
        }
        if (this.entries == null || this.entries.length == 0) {
            this.entries = new EnvironmentEntry[1];
            this.entries[0] = entry;
        } else {
            int i = 0;
            while (i < this.entries.length) {
                if (entry.equals((Object)this.entries[i])) {
                    return;
                }
                ++i;
            }
            EnvironmentEntry[] newEntries = new EnvironmentEntry[this.entries.length + 1];
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
            newEntries[this.entries.length] = entry;
            this.entries = newEntries;
        }
    }

    public void removeEnvEntry(EnvironmentEntry entry) {
        if (entry == null) {
            return;
        }
        if (this.entries == null || this.entries.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.entries.length) {
            if (entry.equals((Object)this.entries[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            EnvironmentEntry[] newEntries = new EnvironmentEntry[this.entries.length - 1];
            System.arraycopy(this.entries, 0, newEntries, 0, index);
            System.arraycopy(this.entries, index + 1, newEntries, index, this.entries.length - 1 - index);
            this.entries = newEntries;
        }
    }

    public void addEjbRef(EJBeanReference ejbRef) {
        if (ejbRef == null) {
            return;
        }
        if (this.ejbRefs == null || this.ejbRefs.length == 0) {
            this.ejbRefs = new EJBeanReference[1];
            this.ejbRefs[0] = ejbRef;
        } else {
            int i = 0;
            while (i < this.ejbRefs.length) {
                if (ejbRef.equals((Object)this.ejbRefs[i])) {
                    return;
                }
                ++i;
            }
            EJBeanReference[] newRefs = new EJBeanReference[this.ejbRefs.length + 1];
            System.arraycopy(this.ejbRefs, 0, newRefs, 0, this.ejbRefs.length);
            newRefs[this.ejbRefs.length] = ejbRef;
            this.ejbRefs = newRefs;
        }
    }

    public void addEjbLocalRef(EJBeanLocalReference ejbLocalRef) {
        if (ejbLocalRef == null) {
            return;
        }
        if (this.ejbLocalRefs == null || this.ejbLocalRefs.length == 0) {
            this.ejbLocalRefs = new EJBeanLocalReference[1];
            this.ejbLocalRefs[0] = ejbLocalRef;
        } else {
            int i = 0;
            while (i < this.ejbLocalRefs.length) {
                if (ejbLocalRef.equals((Object)this.ejbLocalRefs[i])) {
                    return;
                }
                ++i;
            }
            EJBeanLocalReference[] newRefs = new EJBeanLocalReference[this.ejbLocalRefs.length + 1];
            System.arraycopy(this.ejbLocalRefs, 0, newRefs, 0, this.ejbLocalRefs.length);
            newRefs[this.ejbLocalRefs.length] = ejbLocalRef;
            this.ejbLocalRefs = newRefs;
        }
    }

    public void removeEjbRef(EJBeanReference ejbRef) {
        if (ejbRef == null) {
            return;
        }
        if (this.ejbRefs == null || this.ejbRefs.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.ejbRefs.length) {
            if (ejbRef.equals((Object)this.ejbRefs[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            EJBeanReference[] newRefs = new EJBeanReference[this.ejbRefs.length - 1];
            System.arraycopy(this.ejbRefs, 0, newRefs, 0, index);
            System.arraycopy(this.ejbRefs, index + 1, newRefs, index, this.ejbRefs.length - 1 - index);
            this.ejbRefs = newRefs;
        }
    }

    public void removeEjbLocalRef(EJBeanLocalReference ejbLocalRef) {
        if (ejbLocalRef == null) {
            return;
        }
        if (this.ejbLocalRefs == null || this.ejbLocalRefs.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.ejbLocalRefs.length) {
            if (ejbLocalRef.equals((Object)this.ejbLocalRefs[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            EJBeanLocalReference[] newRefs = new EJBeanLocalReference[this.ejbLocalRefs.length - 1];
            System.arraycopy(this.ejbLocalRefs, 0, newRefs, 0, index);
            System.arraycopy(this.ejbLocalRefs, index + 1, newRefs, index, this.ejbLocalRefs.length - 1 - index);
            this.ejbLocalRefs = newRefs;
        }
    }

    public EJBeanReference[] getEjbRefs() {
        return this.ejbRefs;
    }

    public void setEjbRefs(EJBeanReference[] ejbRefs1) {
        this.ejbRefs = ejbRefs1;
    }

    public EJBeanLocalReference[] getEjbLocalRefs() {
        return this.ejbLocalRefs;
    }

    public void setEjbLocalRefs(EJBeanLocalReference[] ejbLocalRefs1) {
        this.ejbLocalRefs = ejbLocalRefs1;
    }

    public ResourceEnvReference[] getResEnvReferences() {
        return this.resEnvRefs;
    }

    public void setResEnvReferences(ResourceEnvReference[] resEnvReferences) {
        this.resEnvRefs = resEnvReferences;
    }

    public ComponentReference[] getServerComponentRefs() {
        return this.compRefs;
    }

    public void setServerComponentRefs(ComponentReference[] compReferences) {
        this.compRefs = compReferences;
    }

    public void addServerComponentReference(ComponentReference compReference) {
        if (compReference == null) {
            return;
        }
        if (this.compRefs == null || this.compRefs.length == 0) {
            this.compRefs = new ComponentReference[1];
            this.compRefs[0] = compReference;
        } else {
            int i = 0;
            while (i < this.compRefs.length) {
                if (compReference.equals((Object)this.compRefs[i])) {
                    return;
                }
                ++i;
            }
            ComponentReference[] newReferences = new ComponentReference[this.compRefs.length + 1];
            System.arraycopy(this.compRefs, 0, newReferences, 0, this.compRefs.length);
            newReferences[this.compRefs.length] = compReference;
            this.compRefs = newReferences;
        }
    }

    public Object clone() {
        WebDeploymentDescriptor newDescr = new WebDeploymentDescriptor();
        newDescr.description = this.description;
        newDescr.smallIcon = this.smallIcon;
        newDescr.largeIcon = this.largeIcon;
        newDescr.displayName = this.displayName;
        newDescr.distributable = this.distributable;
        newDescr.sessionTimeout = this.sessionTimeout;
        newDescr.failOverMessage = this.failOverMessage;
        newDescr.failOverMessageTimeout = this.failOverMessageTimeout;
        newDescr.failOverEnable = this.failOverEnable;
        newDescr.maxSessions = this.maxSessions;
        newDescr.getRequestURLMode = this.getRequestURLMode;
        newDescr.login = this.login != null ? (LoginConfig)this.login.clone() : null;
        if (this.contextParam != null) {
            newDescr.contextParam = new ContextParam[this.contextParam.length];
            System.arraycopy(this.contextParam, 0, newDescr.contextParam, 0, this.contextParam.length);
        }
        if (this.servletDescriptors != null) {
            newDescr.servletDescriptors = new ServletDescriptor[this.servletDescriptors.length];
            System.arraycopy(this.servletDescriptors, 0, newDescr.servletDescriptors, 0, this.servletDescriptors.length);
        }
        if (this.servletMapping != null) {
            newDescr.servletMapping = new ServletMapping[this.servletMapping.length];
            System.arraycopy(this.servletMapping, 0, newDescr.servletMapping, 0, this.servletMapping.length);
        }
        if (this.filterMappings != null) {
            newDescr.filterMappings = new FilterMapping[this.filterMappings.length];
            System.arraycopy(this.filterMappings, 0, newDescr.filterMappings, 0, this.filterMappings.length);
        }
        if (this.filters != null) {
            newDescr.filters = new FilterDescriptor[this.filters.length];
            System.arraycopy(this.filters, 0, newDescr.filters, 0, this.filters.length);
        }
        if (this.listeners != null) {
            newDescr.listeners = new ListenerDescriptor[this.listeners.length];
            System.arraycopy(this.listeners, 0, newDescr.listeners, 0, this.listeners.length);
        }
        if (this.mimeMapping != null) {
            newDescr.mimeMapping = new MIMEMapping[this.mimeMapping.length];
            System.arraycopy(this.mimeMapping, 0, newDescr.mimeMapping, 0, this.mimeMapping.length);
        }
        if (this.welcomeFileList != null) {
            newDescr.welcomeFileList = new String[this.welcomeFileList.length];
            System.arraycopy(this.welcomeFileList, 0, newDescr.welcomeFileList, 0, this.welcomeFileList.length);
        }
        if (this.errorPage != null) {
            newDescr.errorPage = new ErrorPage[this.errorPage.length];
            System.arraycopy(this.errorPage, 0, newDescr.errorPage, 0, this.errorPage.length);
        }
        if (this.tagLib != null) {
            newDescr.tagLib = new TagLib[this.tagLib.length];
            System.arraycopy(this.tagLib, 0, newDescr.tagLib, 0, this.tagLib.length);
        }
        if (this.resReferences != null) {
            newDescr.resReferences = new ResourceReference[this.resReferences.length];
            System.arraycopy(this.resReferences, 0, newDescr.resReferences, 0, this.resReferences.length);
        }
        if (this.resEnvRefs != null) {
            newDescr.resEnvRefs = new ResourceEnvReference[this.resEnvRefs.length];
            System.arraycopy(this.resEnvRefs, 0, newDescr.resEnvRefs, 0, this.resEnvRefs.length);
        }
        if (this.compRefs != null) {
            newDescr.compRefs = new ComponentReference[this.compRefs.length];
            System.arraycopy(this.compRefs, 0, newDescr.compRefs, 0, this.compRefs.length);
        }
        if (this.secConstraints != null) {
            newDescr.secConstraints = new SecurityConstraints[this.secConstraints.length];
            System.arraycopy(this.secConstraints, 0, newDescr.secConstraints, 0, this.secConstraints.length);
        }
        if (this.secRoles != null) {
            newDescr.secRoles = new SecurityRoles[this.secRoles.length];
            System.arraycopy(this.secRoles, 0, newDescr.secRoles, 0, this.secRoles.length);
        }
        if (this.entries != null) {
            newDescr.entries = new EnvironmentEntry[this.entries.length];
            System.arraycopy(this.entries, 0, newDescr.entries, 0, this.entries.length);
        }
        if (this.ejbRefs != null) {
            newDescr.ejbRefs = new EJBeanReference[this.ejbRefs.length];
            System.arraycopy(this.ejbRefs, 0, newDescr.ejbRefs, 0, this.ejbRefs.length);
        }
        if (this.ejbLocalRefs != null) {
            newDescr.ejbLocalRefs = new EJBeanLocalReference[this.ejbLocalRefs.length];
            System.arraycopy(this.ejbLocalRefs, 0, newDescr.ejbLocalRefs, 0, this.ejbLocalRefs.length);
        }
        if (this.responseStatus != null) {
            newDescr.responseStatus = (HashMapIntObject)this.responseStatus.clone();
        }
        if (this.authentication != null) {
            newDescr.authentication = (AuthenticationDescriptor)this.authentication.clone();
        }
        newDescr.urlSessionTracking = this.urlSessionTracking;
        if (this.domains != null) {
            newDescr.domains = new String[this.domains.length];
            System.arraycopy(this.domains, 0, newDescr.domains, 0, this.domains.length);
        }
        if (this.cookieConfig != null) {
            newDescr.cookieConfig = new CookieConfig[this.cookieConfig.length];
            System.arraycopy(this.cookieConfig, 0, newDescr.cookieConfig, 0, this.cookieConfig.length);
        }
        return newDescr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof WebDeploymentDescriptor)) {
            return false;
        }
        WebDeploymentDescriptor wdd = (WebDeploymentDescriptor)obj;
        int i = 0;
        int j = 0;
        int index = -1;
        if (this.smallIcon != null ? !this.smallIcon.equals((Object)wdd.smallIcon) : wdd.smallIcon != null) {
            return false;
        }
        if (this.largeIcon != null ? !this.largeIcon.equals((Object)wdd.largeIcon) : wdd.largeIcon != null) {
            return false;
        }
        if (!this.equalStrings(this.displayName, wdd.displayName)) {
            return false;
        }
        if (!this.equalStrings(this.description, wdd.description)) {
            return false;
        }
        if (!this.equalStrings(this.failOverMessage, wdd.failOverMessage)) {
            return false;
        }
        if (!this.equalStrings(this.getRequestURLMode, wdd.getRequestURLMode)) {
            return false;
        }
        if (this.distributable != wdd.distributable) {
            return false;
        }
        if (this.maxSessions != wdd.maxSessions) {
            return false;
        }
        if (this.failOverEnable != wdd.failOverEnable) {
            return false;
        }
        if (wdd.sessionTimeout != this.sessionTimeout) {
            return false;
        }
        if (wdd.failOverMessageTimeout != this.failOverMessageTimeout) {
            return false;
        }
        if (this.login != null ? !this.login.equals(wdd.login) : wdd.login != null) {
            return false;
        }
        if (this.contextParam != null) {
            if (wdd.contextParam == null) return false;
            if (this.contextParam.length != wdd.contextParam.length) return false;
            i = 0;
            while (i < this.contextParam.length) {
                index = -1;
                if (this.contextParam[i] != null) {
                    j = 0;
                    while (j < wdd.contextParam.length) {
                        if (this.contextParam[i].equals((Object)wdd.contextParam[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.contextParam != null) {
            return false;
        }
        if (this.servletDescriptors != null) {
            if (wdd.servletDescriptors == null) return false;
            if (this.servletDescriptors.length != wdd.servletDescriptors.length) return false;
            i = 0;
            while (i < this.servletDescriptors.length) {
                index = -1;
                if (this.servletDescriptors[i] != null) {
                    j = 0;
                    while (j < wdd.servletDescriptors.length) {
                        if (this.servletDescriptors[i].equals(wdd.servletDescriptors[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.servletDescriptors != null) {
            return false;
        }
        if (this.servletMapping != null) {
            if (wdd.servletMapping == null) return false;
            if (this.servletMapping.length != wdd.servletMapping.length) return false;
            i = 0;
            while (i < this.servletMapping.length) {
                index = -1;
                if (this.servletMapping[i] != null) {
                    j = 0;
                    while (j < wdd.servletMapping.length) {
                        if (this.servletMapping[i].equals(wdd.servletMapping[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.servletMapping != null) {
            return false;
        }
        if (this.mimeMapping != null) {
            if (wdd.mimeMapping == null) return false;
            if (this.mimeMapping.length != wdd.mimeMapping.length) return false;
            i = 0;
            while (i < this.mimeMapping.length) {
                index = -1;
                if (this.mimeMapping[i] != null) {
                    j = 0;
                    while (j < wdd.mimeMapping.length) {
                        if (this.mimeMapping[i].equals(wdd.mimeMapping[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.mimeMapping != null) {
            return false;
        }
        if (this.welcomeFileList != null) {
            if (wdd.welcomeFileList == null) return false;
            if (this.welcomeFileList.length != wdd.welcomeFileList.length) return false;
            i = 0;
            while (i < this.welcomeFileList.length) {
                index = -1;
                if (this.welcomeFileList[i] != null) {
                    j = 0;
                    while (j < wdd.welcomeFileList.length) {
                        if (this.welcomeFileList[i].equals(wdd.welcomeFileList[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.welcomeFileList != null) {
            return false;
        }
        if (this.errorPage != null) {
            if (wdd.errorPage == null) return false;
            if (this.errorPage.length != wdd.errorPage.length) return false;
            i = 0;
            while (i < this.errorPage.length) {
                index = -1;
                if (this.errorPage[i] != null) {
                    j = 0;
                    while (j < wdd.errorPage.length) {
                        if (this.errorPage[i].equals(wdd.errorPage[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.errorPage != null) {
            return false;
        }
        if (this.tagLib != null) {
            if (wdd.tagLib == null) return false;
            if (this.tagLib.length != wdd.tagLib.length) return false;
            i = 0;
            while (i < this.tagLib.length) {
                index = -1;
                if (this.tagLib[i] != null) {
                    j = 0;
                    while (j < wdd.tagLib.length) {
                        if (this.tagLib[i].equals(wdd.tagLib[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.tagLib != null) {
            return false;
        }
        if (this.resReferences != null) {
            if (wdd.resReferences == null) return false;
            if (this.resReferences.length != wdd.resReferences.length) return false;
            i = 0;
            while (i < this.resReferences.length) {
                index = -1;
                if (this.resReferences[i] != null) {
                    j = 0;
                    while (j < wdd.resReferences.length) {
                        if (this.resReferences[i].equals((Object)wdd.resReferences[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.resReferences != null) {
            return false;
        }
        if (this.resEnvRefs != null) {
            if (wdd.resEnvRefs == null) return false;
            if (this.resEnvRefs.length != wdd.resEnvRefs.length) return false;
            i = 0;
            while (i < this.resEnvRefs.length) {
                index = -1;
                if (this.resEnvRefs[i] != null) {
                    j = 0;
                    while (j < wdd.resEnvRefs.length) {
                        if (this.resEnvRefs[i].equals((Object)wdd.resEnvRefs[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.resEnvRefs != null) {
            return false;
        }
        if (this.secConstraints != null) {
            if (wdd.secConstraints == null) return false;
            if (this.secConstraints.length != wdd.secConstraints.length) return false;
            i = 0;
            while (i < this.secConstraints.length) {
                index = -1;
                if (this.secConstraints[i] != null) {
                    j = 0;
                    while (j < wdd.secConstraints.length) {
                        if (this.secConstraints[i].equals(wdd.secConstraints[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.secConstraints != null) {
            return false;
        }
        if (this.secRoles != null) {
            if (wdd.secRoles == null) return false;
            if (this.secRoles.length != wdd.secRoles.length) return false;
            i = 0;
            while (i < this.secRoles.length) {
                index = -1;
                if (this.secRoles[i] != null) {
                    j = 0;
                    while (j < wdd.secRoles.length) {
                        if (this.secRoles[i].equals((Object)wdd.secRoles[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.secRoles != null) {
            return false;
        }
        if (this.entries != null) {
            if (wdd.entries == null) return false;
            if (this.entries.length != wdd.entries.length) return false;
            i = 0;
            while (i < this.entries.length) {
                index = -1;
                if (this.entries[i] != null) {
                    j = 0;
                    while (j < wdd.entries.length) {
                        if (this.entries[i].equals((Object)wdd.entries[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.entries != null) {
            return false;
        }
        if (this.ejbRefs != null) {
            if (wdd.ejbRefs == null) return false;
            if (this.ejbRefs.length != wdd.ejbRefs.length) return false;
            i = 0;
            while (i < this.ejbRefs.length) {
                index = -1;
                if (this.ejbRefs[i] != null) {
                    j = 0;
                    while (j < wdd.ejbRefs.length) {
                        if (this.ejbRefs[i].equals((Object)wdd.ejbRefs[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.ejbRefs != null) {
            return false;
        }
        if (this.ejbLocalRefs != null) {
            if (wdd.ejbLocalRefs == null) return false;
            if (this.ejbLocalRefs.length != wdd.ejbLocalRefs.length) return false;
            i = 0;
            while (i < this.ejbLocalRefs.length) {
                index = -1;
                if (this.ejbLocalRefs[i] != null) {
                    j = 0;
                    while (j < wdd.ejbLocalRefs.length) {
                        if (this.ejbLocalRefs[i].equals((Object)wdd.ejbLocalRefs[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.ejbLocalRefs != null) {
            return false;
        }
        if (this.compRefs != null) {
            if (wdd.compRefs == null) return false;
            if (this.compRefs.length != wdd.compRefs.length) return false;
            i = 0;
            while (i < this.compRefs.length) {
                index = -1;
                if (this.compRefs[i] != null) {
                    j = 0;
                    while (j < wdd.compRefs.length) {
                        if (this.compRefs[i].equals((Object)wdd.compRefs[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.compRefs != null) {
            return false;
        }
        if (this.filterMappings != null) {
            if (wdd.filterMappings == null) return false;
            if (this.filterMappings.length != wdd.filterMappings.length) return false;
            i = 0;
            while (i < this.filterMappings.length) {
                index = -1;
                if (this.filterMappings[i] != null) {
                    j = 0;
                    while (j < wdd.filterMappings.length) {
                        if (this.filterMappings[i].equals(wdd.filterMappings[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.filterMappings != null) {
            return false;
        }
        if (this.filters != null) {
            if (wdd.filters == null) return false;
            if (this.filters.length != wdd.filters.length) return false;
            i = 0;
            while (i < this.filters.length) {
                index = -1;
                if (this.filters[i] != null) {
                    j = 0;
                    while (j < wdd.filters.length) {
                        if (this.filters[i].equals(wdd.filters[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.filters != null) {
            return false;
        }
        if (this.listeners != null) {
            if (wdd.listeners == null) return false;
            if (this.listeners.length != wdd.listeners.length) return false;
            i = 0;
            while (i < this.listeners.length) {
                index = -1;
                if (this.listeners[i] != null) {
                    j = 0;
                    while (j < wdd.listeners.length) {
                        if (this.listeners[i].equals(wdd.listeners[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.listeners != null) {
            return false;
        }
        if (this.responseStatus != null) {
            if (wdd.responseStatus == null) return false;
            if (this.responseStatus.size() != wdd.responseStatus.size()) return false;
            int[] keys1 = this.responseStatus.getAllKeys();
            int[] keys2 = wdd.responseStatus.getAllKeys();
            i = 0;
            while (i < keys1.length) {
                index = -1;
                j = 0;
                while (j < keys2.length) {
                    if (keys1[i] == keys2[j]) {
                        index = j;
                        if (this.equalValues(this.responseStatus.get(i), wdd.responseStatus.get(j))) break;
                        return false;
                    }
                    ++j;
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.responseStatus != null) {
            return false;
        }
        if (this.authentication != null ? !this.authentication.equals(wdd.authentication) : wdd.authentication != null) {
            return false;
        }
        if (this.urlSessionTracking != wdd.urlSessionTracking) {
            return false;
        }
        if (this.domains != null) {
            if (wdd.domains == null) return false;
            if (this.domains.length != wdd.domains.length) return false;
            i = 0;
            while (i < this.domains.length) {
                index = -1;
                if (this.domains[i] != null) {
                    j = 0;
                    while (j < wdd.domains.length) {
                        if (this.domains[i].equals(wdd.domains[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (wdd.domains != null) {
            return false;
        }
        if (this.cookieConfig != null) {
            if (wdd.cookieConfig == null) return false;
            if (this.cookieConfig.length != wdd.cookieConfig.length) return false;
            i = 0;
            while (i < this.cookieConfig.length) {
                index = -1;
                if (this.cookieConfig[i] != null) {
                    j = 0;
                    while (j < wdd.cookieConfig.length) {
                        if (this.cookieConfig[i].equals(wdd.cookieConfig[j])) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (wdd.cookieConfig == null) return true;
            return false;
        }
    }

    private boolean equalValues(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null || obj1 != null) {
            return false;
        }
        if (!(obj1 instanceof String) || !(obj2 instanceof String)) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public String saveToFile(String xmlFile) {
        StandardDOMWriter writer = new StandardDOMWriter();
        WebDescriptorDocument doc = new WebDescriptorDocument();
        Document document = null;
        document = doc.loadSimpleDocumentFromDescriptor(this);
        try {
            writer.write(document, xmlFile, "<!DOCTYPE web-app PUBLIC '-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN' 'http://java.sun.com/dtd/web-app_2_3.dtd'>", "UTF-8");
        }
        catch (IOException io) {
            return io.toString();
        }
        return doc.getIllegalArgumentException();
    }

    public Document getAsDocument() {
        WebDescriptorDocument doc = new WebDescriptorDocument();
        Document document = doc.loadSimpleDocumentFromDescriptor(this);
        return document;
    }

    public void loadFromDocument(Document document) {
        WebDescriptorDocument doc = new WebDescriptorDocument();
        WebDeploymentDescriptor webDescriptor = null;
        try {
            webDescriptor = doc.loadDescriptorFromDocument(document);
        }
        catch (WrongStructureException e) {
            throw new WebIllegalArgumentException("servlet_jsp_0254", e);
        }
        catch (WebWrongDescriptorException e) {
            throw new WebIllegalArgumentException("servlet_jsp_0254", e);
        }
        this.replaceDescriptor(webDescriptor);
    }

    public void loadFromFile(String xmlFile) {
        StandardDOMParser parser = new StandardDOMParser();
        WebDescriptorDocument doc = new WebDescriptorDocument();
        Document document = null;
        BufferedInputStream xmlStream = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(xmlFile);
        }
        catch (IOException e) {
            throw new WebIllegalArgumentException("servlet_jsp_0254", e);
        }
        xmlStream = new BufferedInputStream(fis);
        parser.setSystemId(xmlFile);
        try {
            document = parser.parse((InputStream)xmlStream);
        }
        catch (SAXException e) {
            throw new WebIllegalArgumentException("servlet_jsp_0254", e);
        }
        catch (IOException e) {
            throw new WebIllegalArgumentException("servlet_jsp_0254", e);
        }
        WebDeploymentDescriptor webDescriptor = null;
        try {
            webDescriptor = doc.loadDescriptorFromDocument(document);
        }
        catch (WrongStructureException e) {
            throw new WebIllegalArgumentException("servlet_jsp_0254", e);
        }
        catch (WebWrongDescriptorException e) {
            throw new WebIllegalArgumentException("servlet_jsp_0254", e);
        }
        this.replaceDescriptor(webDescriptor);
    }

    public Descriptor[] getDescriptors() {
        int i;
        Vector<Descriptor> temporalResult = new Vector<Descriptor>();
        if (this.filters != null) {
            i = 0;
            while (i < this.filters.length) {
                temporalResult.add(this.filters[i]);
                ++i;
            }
        }
        if (this.listeners != null) {
            i = 0;
            while (i < this.listeners.length) {
                temporalResult.add(this.listeners[i]);
                ++i;
            }
        }
        if (this.servletDescriptors != null) {
            i = 0;
            while (i < this.servletDescriptors.length) {
                temporalResult.add(this.servletDescriptors[i]);
                ++i;
            }
        }
        Object[] allDescriptors = new Descriptor[temporalResult.size()];
        temporalResult.copyInto(allDescriptors);
        return allDescriptors;
    }

    public Descriptor getDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.servletDescriptors != null && this.servletDescriptors.length > 0) {
            int i = 0;
            while (i < this.servletDescriptors.length) {
                if (name.equalsIgnoreCase(this.servletDescriptors[i].getName())) {
                    return this.servletDescriptors[i];
                }
                ++i;
            }
        }
        return null;
    }

    public void setDescriptors(Descriptor[] descrs) {
        if (descrs == null) {
            this.servletDescriptors = null;
            this.filters = null;
            this.listeners = null;
        } else {
            Vector<Descriptor> serv_d = new Vector<Descriptor>();
            Vector<Descriptor> filter_d = new Vector<Descriptor>();
            Vector<Descriptor> list_d = new Vector<Descriptor>();
            int i = 0;
            while (i < descrs.length) {
                if (descrs[i] instanceof ServletDescriptor) {
                    serv_d.add(descrs[i]);
                } else if (descrs[i] instanceof FilterDescriptor) {
                    filter_d.add(descrs[i]);
                } else if (descrs[i] instanceof ListenerDescriptor) {
                    list_d.add(descrs[i]);
                }
                ++i;
            }
            if (serv_d.size() != 0) {
                this.servletDescriptors = new ServletDescriptor[serv_d.size()];
                serv_d.copyInto(this.servletDescriptors);
            } else {
                this.servletDescriptors = null;
            }
            if (filter_d.size() != 0) {
                this.filters = new FilterDescriptor[filter_d.size()];
                filter_d.copyInto(this.filters);
            } else {
                this.filters = null;
            }
            if (list_d.size() != 0) {
                this.listeners = new ListenerDescriptor[list_d.size()];
                list_d.copyInto(this.listeners);
            } else {
                this.listeners = null;
            }
        }
    }

    protected void replaceDescriptor(WebDeploymentDescriptor web) {
        if (web != null) {
            this.smallIcon = web.getSmallIcon();
            this.largeIcon = web.getLargeIcon();
            this.displayName = web.getDisplayName();
            this.description = web.getDescription();
            this.distributable = web.getDistributable();
            this.contextParam = web.getContextParams();
            this.servletDescriptors = web.getServlets();
            this.servletMapping = web.getServletMapping();
            this.sessionTimeout = web.getSessionTimeout();
            this.mimeMapping = web.getMIMEMapping();
            this.welcomeFileList = web.getWelcomeFileList();
            this.errorPage = web.getErrorPage();
            this.tagLib = web.getTagLib();
            this.resReferences = web.getResReferences();
            this.secConstraints = web.getSecConstraints();
            this.login = web.getLoginConfig();
            this.secRoles = web.getSecRoles();
            this.entries = web.getEnvEntries();
            this.ejbRefs = web.getEjbRefs();
            this.ejbLocalRefs = web.getEjbLocalRefs();
            this.resEnvRefs = web.getResEnvReferences();
            this.compRefs = web.getServerComponentRefs();
            this.filterMappings = web.getFilterMappings();
            this.filters = web.getFilters();
            this.listeners = web.getListenersDescriptor();
            this.responseStatus = web.getResponseStatus();
            this.failOverMessage = web.getFailOverMessage();
            this.getRequestURLMode = web.getGetRequestURLMode();
            this.failOverMessageTimeout = web.getFailOverMessageTimeout();
            this.failOverEnable = web.getFailOverEnable();
            this.authentication = web.getAuthentication();
            this.urlSessionTracking = web.getURLSessionTracking();
            this.domains = web.getSecurityPolicyDomains();
            this.maxSessions = web.getMaxSessions();
            this.cookieConfig = web.getCookieConfig();
        }
    }

    public FilterDescriptor[] getFilters() {
        return this.filters;
    }

    public void setFilters(FilterDescriptor[] filters) {
        this.filters = filters;
    }

    public FilterMapping[] getFilterMappings() {
        return this.filterMappings;
    }

    public void setFilterMappings(FilterMapping[] filterMappings) {
        this.filterMappings = filterMappings;
    }

    public void addFilter(FilterDescriptor filter) {
        if (filter == null) {
            return;
        }
        if (this.filters == null || this.filters.length == 0) {
            this.filters = new FilterDescriptor[1];
            this.filters[0] = filter;
        } else {
            if (filter.getName() != null) {
                int i = 0;
                while (i < this.filters.length) {
                    if (filter.getName().equals(this.filters[i].getName())) {
                        this.filters[i] = filter;
                        return;
                    }
                    ++i;
                }
            }
            FilterDescriptor[] fDescriptors = new FilterDescriptor[this.filters.length + 1];
            System.arraycopy(this.filters, 0, fDescriptors, 0, this.filters.length);
            fDescriptors[this.filters.length] = filter;
            this.filters = fDescriptors;
        }
    }

    public void addFilterMapping(FilterMapping filter) {
        if (filter == null) {
            return;
        }
        if (this.filterMappings == null || this.filterMappings.length == 0) {
            this.filterMappings = new FilterMapping[1];
            this.filterMappings[0] = filter;
        } else {
            FilterMapping[] fDescriptors = new FilterMapping[this.filterMappings.length + 1];
            System.arraycopy(this.filterMappings, 0, fDescriptors, 0, this.filterMappings.length);
            fDescriptors[this.filterMappings.length] = filter;
            this.filterMappings = fDescriptors;
        }
    }

    public ListenerDescriptor[] getListenersDescriptor() {
        return this.listeners;
    }

    public String[] getListeners() {
        if (this.listeners != null) {
            String[] arr = new String[this.listeners.length];
            int i = 0;
            while (i < this.listeners.length) {
                if (this.listeners[i] != null) {
                    arr[i] = new String(this.listeners[i].getName());
                }
                ++i;
            }
            return arr;
        }
        return null;
    }

    public void setListeners(ListenerDescriptor[] listeners) {
        this.listeners = listeners;
    }

    public void addListener(String listener) {
        ListenerDescriptor lD = new ListenerDescriptor();
        lD.setListenerClass(listener);
        this.addListener(lD);
    }

    public void addListener(ListenerDescriptor newListener) {
        if (newListener == null) {
            return;
        }
        if (this.listeners == null || this.listeners.length == 0) {
            this.listeners = new ListenerDescriptor[1];
            this.listeners[0] = newListener;
        } else {
            int i = 0;
            while (i < this.listeners.length) {
                if (newListener.equals(this.listeners[i])) {
                    return;
                }
                ++i;
            }
            ListenerDescriptor[] newArray = new ListenerDescriptor[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, newArray, 0, this.listeners.length);
            newArray[this.listeners.length] = newListener;
            this.listeners = newArray;
        }
    }

    public void replaceNullValues() {
        int i;
        if (this.contextParam == null) {
            this.contextParam = new ContextParam[0];
        } else {
            this.replaceInContextParams();
        }
        if (this.servletDescriptors == null) {
            this.servletDescriptors = new ServletDescriptor[0];
        } else {
            i = 0;
            while (i < this.servletDescriptors.length) {
                if (this.servletDescriptors[i] != null) {
                    if (this.servletDescriptors[i].getInitParams() == null) {
                        this.servletDescriptors[i].setInitParams(new ContextParam[0]);
                    } else {
                        this.replaceInContextParams();
                    }
                    if (this.servletDescriptors[i].getRoleReferences() == null) {
                        this.servletDescriptors[i].setRoleReferences(new SecurityRoleReference[0]);
                    }
                }
                ++i;
            }
        }
        if (this.servletMapping == null) {
            this.servletMapping = new ServletMapping[0];
        }
        if (this.mimeMapping == null) {
            this.mimeMapping = new MIMEMapping[0];
        }
        if (this.welcomeFileList == null) {
            this.welcomeFileList = new String[0];
        }
        if (this.errorPage == null) {
            this.errorPage = new ErrorPage[0];
        }
        if (this.tagLib == null) {
            this.tagLib = new TagLib[0];
        }
        if (this.resReferences == null) {
            this.resReferences = new ResourceReference[0];
        }
        if (this.secConstraints == null) {
            this.secConstraints = new SecurityConstraints[0];
        } else {
            i = 0;
            while (i < this.secConstraints.length) {
                if (this.secConstraints[i] != null) {
                    if (this.secConstraints[i].getAuthConstraints() != null && this.secConstraints[i].getAuthConstraints().getRoleNames() == null) {
                        this.secConstraints[i].getAuthConstraints().setRoleName(new String[0]);
                    }
                    if (this.secConstraints[i].getWebResourceCollections() == null) {
                        this.secConstraints[i].setWebCollections(new WebResourceCollection[0]);
                    } else {
                        int j = 0;
                        while (j < this.secConstraints[i].getWebResourceCollections().length) {
                            if (this.secConstraints[i].getWebResourceCollections()[j] != null) {
                                if (this.secConstraints[i].getWebResourceCollections()[j].getHttpMethod() == null) {
                                    this.secConstraints[i].getWebResourceCollections()[j].setHttpMethod(new String[0]);
                                }
                                if (this.secConstraints[i].getWebResourceCollections()[j].getUrlPattern() == null) {
                                    this.secConstraints[i].getWebResourceCollections()[j].setUrlPattern(new String[0]);
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.secRoles == null) {
            this.secRoles = new SecurityRoles[0];
        }
        if (this.entries == null) {
            this.entries = new EnvironmentEntry[0];
        }
        if (this.ejbRefs == null) {
            this.ejbRefs = new EJBeanReference[0];
        }
        if (this.filterMappings == null) {
            this.filterMappings = new FilterMapping[0];
        }
        if (this.filters == null) {
            this.filters = new FilterDescriptor[0];
        } else {
            i = 0;
            while (i < this.filters.length) {
                if (this.filters[i] != null) {
                    if (this.filters[i].getInitParams() == null) {
                        this.filters[i].setInitParams(new ContextParam[0]);
                    } else {
                        this.replaceInContextParams();
                    }
                }
                ++i;
            }
        }
        if (this.listeners == null) {
            this.listeners = new ListenerDescriptor[0];
        }
        if (this.ejbLocalRefs == null) {
            this.ejbLocalRefs = new EJBeanLocalReference[0];
        }
        if (this.resEnvRefs == null) {
            this.resEnvRefs = new ResourceEnvReference[0];
        }
        if (this.login == null) {
            this.login = new LoginConfig();
        }
        if (this.login.getRealmName() == null) {
            this.login.setRealmName("");
        }
        if (this.cookieConfig == null) {
            this.cookieConfig = new CookieConfig[0];
        } else {
            i = 0;
            while (i < this.cookieConfig.length) {
                if (this.cookieConfig[i] != null && this.cookieConfig[i].getType() == null) {
                    this.cookieConfig[i].setType("APPLICATION");
                }
                ++i;
            }
        }
    }

    private void replaceInContextParams() {
        int i = 0;
        while (i < this.contextParam.length) {
            if (this.contextParam[i] != null) {
                if (this.contextParam[i].getParamName() == null) {
                    this.contextParam[i].setParamName("");
                }
                if (this.contextParam[i].getParamValue() == null) {
                    this.contextParam[i].setParamValue("");
                }
            }
            ++i;
        }
    }

    public HashMapIntObject getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(HashMapIntObject h) {
        this.responseStatus = h;
    }

    public void addResponseStatus(int code, String description) {
        if (this.responseStatus == null) {
            this.responseStatus = new HashMapIntObject();
        }
        this.responseStatus.put(code, (Object)description);
    }

    public void removeResponseStatus(int code) {
        if (this.responseStatus != null) {
            this.responseStatus.remove(code);
        }
    }

    public String getFailOverMessage() {
        return this.failOverMessage;
    }

    public String getGetRequestURLMode() {
        return this.getRequestURLMode;
    }

    public void setFailOverMessage(String msg) {
        this.failOverMessage = msg;
    }

    public void setGetRequestURLMode(String msg) {
        this.getRequestURLMode = msg;
    }

    public int getFailOverMessageTimeout() {
        return this.failOverMessageTimeout;
    }

    public void setFailOverMessageTimeout(int tm) {
        this.failOverMessageTimeout = tm;
    }

    public void setFailOverEnable(boolean enable) {
        this.failOverEnable = enable;
    }

    public boolean getFailOverEnable() {
        return this.failOverEnable;
    }

    public void setAuthentication(AuthenticationDescriptor auth) {
        this.authentication = auth;
    }

    public AuthenticationDescriptor getAuthentication() {
        return this.authentication;
    }

    public void setURLSessionTracking(boolean tracking) {
        this.urlSessionTracking = tracking;
    }

    public boolean getURLSessionTracking() {
        return this.urlSessionTracking;
    }

    public void setSecurityPolicyDomains(String[] policyDomains) {
        this.domains = policyDomains;
    }

    public String[] getSecurityPolicyDomains() {
        return this.domains;
    }

    public void setSecurityPolicyDomain(String domain) {
        this.domains = null;
        this.domains = new String[]{domain};
    }

    public String getSecurityPolicyDomain() {
        if (this.domains != null && this.domains.length > 0) {
            return this.domains[0];
        }
        return null;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int sessions) {
        this.maxSessions = sessions;
    }

    public void setCookieConfig(CookieConfig[] cookieConfig) {
        this.cookieConfig = cookieConfig;
    }

    public CookieConfig[] getCookieConfig() {
        return this.cookieConfig;
    }
}

