/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import java.io.Serializable;
import org.w3c.dom.Document;

public abstract class WebComponentDescriptor
implements Descriptor,
Serializable {
    static final long serialVersionUID = 5200710372353682408L;
    protected String displayName = null;
    protected String description = null;
    protected SerializableFile smallIcon = null;
    protected SerializableFile largeIcon = null;
    protected ContextParam[] initParams = null;

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public SerializableFile getSmallIcon() {
        return this.smallIcon;
    }

    public String getSmallIconName() {
        if (this.smallIcon != null) {
            return this.smallIcon.getFileName();
        }
        return null;
    }

    public void setSmallIcon(SerializableFile icon) {
        this.smallIcon = icon;
    }

    public void setSmallIcon(String icon) {
        this.smallIcon = icon == null ? null : new SerializableFile(icon);
    }

    public SerializableFile getLargeIcon() {
        return this.largeIcon;
    }

    public String getLargeIconName() {
        if (this.largeIcon != null) {
            return this.largeIcon.getFileName();
        }
        return null;
    }

    public void setLargeIcon(SerializableFile icon) {
        this.largeIcon = icon;
    }

    public void setLargeIcon(String icon) {
        this.largeIcon = icon == null ? null : new SerializableFile(icon);
    }

    public ContextParam[] getInitParams() {
        return this.initParams;
    }

    public void setInitParams(ContextParam[] params) {
        this.initParams = params;
    }

    public void addInitParam(ContextParam p) {
        if (p == null) {
            return;
        }
        if (this.initParams != null && this.initParams.length > 0) {
            ContextParam[] params = new ContextParam[this.initParams.length + 1];
            System.arraycopy(this.initParams, 0, params, 0, this.initParams.length);
            params[this.initParams.length] = p;
            this.initParams = params;
        } else {
            this.initParams = new ContextParam[1];
            this.initParams[0] = p;
        }
    }

    public void removeInitParam(ContextParam p) {
        if (this.initParams == null || p == null) {
            return;
        }
        int index = -1;
        int j = 0;
        while (j < this.initParams.length) {
            if (this.initParams[j] != null && this.initParams[j].equals((Object)p)) {
                index = j;
                break;
            }
            ++j;
        }
        if (index > -1) {
            ContextParam[] newParams = new ContextParam[this.initParams.length - 1];
            System.arraycopy(this.initParams, 0, newParams, 0, index);
            System.arraycopy(this.initParams, index + 1, newParams, index, this.initParams.length - 1 - index);
            this.initParams = newParams;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebComponentDescriptor)) {
            return false;
        }
        WebComponentDescriptor descr = (WebComponentDescriptor)obj;
        if (descr.displayName != null ? !descr.displayName.equals(this.displayName) : this.displayName != null) {
            return false;
        }
        if (descr.description != null ? !descr.description.equals(this.description) : this.description != null) {
            return false;
        }
        if (descr.smallIcon != null ? !descr.smallIcon.equals((Object)this.smallIcon) : this.smallIcon != null) {
            return false;
        }
        if (descr.largeIcon != null ? !descr.largeIcon.equals((Object)this.largeIcon) : this.largeIcon != null) {
            return false;
        }
        return EqualUtils.equalUnOrderedArrays((Object[])descr.initParams, (Object[])this.initParams);
    }

    public Object clone() throws CloneNotSupportedException {
        WebComponentDescriptor cloning = null;
        if (this instanceof FilterDescriptor) {
            cloning = new FilterDescriptor();
        } else if (this instanceof ServletDescriptor) {
            cloning = new ServletDescriptor();
        }
        cloning.displayName = this.displayName == null ? null : new String(this.displayName);
        cloning.description = this.description == null ? null : new String(this.description);
        cloning.smallIcon = this.smallIcon != null ? (SerializableFile)this.smallIcon.clone() : null;
        cloning.largeIcon = this.largeIcon != null ? (SerializableFile)this.largeIcon.clone() : null;
        if (this.initParams == null) {
            cloning.initParams = null;
        } else {
            cloning.initParams = new ContextParam[this.initParams.length];
            int i = 0;
            while (i < this.initParams.length) {
                cloning.initParams[i] = this.initParams[i] == null ? null : (ContextParam)this.initParams[i].clone();
                ++i;
            }
        }
        return cloning;
    }

    public abstract void loadFromFile(String var1, String var2);

    public abstract void loadFromDocument(Document var1, String var2);

    public abstract Document getAsDocument();

    public abstract void saveToFile(String var1);

    public abstract String getName();

    public abstract void setName(String var1);
}

