/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor;

import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.servlets_jsp.descriptor.LoginModule;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AuthenticationDescriptor
implements Serializable {
    static final long serialVersionUID = -4615415203443376394L;
    private static final String OPTIONAL = "OPTIONAL";
    private static final String REQUIRED = "REQUIRED";
    private static final String REQUISITE = "REQUISITE";
    private static final String SUFFICIENT = "SUFFICIENT";
    private String changePasswordPage = null;
    private String changePasswordErrorPage = null;
    private Vector loginModules = new Vector();
    private Document mainDocument = null;

    public void setMainDocument(Document document) {
        this.mainDocument = document;
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void loadDescriptorFromElement(Element elmnt) throws WrongStructureException, IllegalArgumentException {
        NodeList list = elmnt.getChildNodes();
        if (list != null) {
            String tag = null;
            int count = list.getLength();
            Element element = null;
            int i = 0;
            while (i < count) {
                if (list.item(i).getNodeType() == 1) {
                    element = (Element)list.item(i);
                    tag = element.getTagName();
                    if (tag.equals("login-module-stack")) {
                        this.setLoginModules(element);
                    } else if (tag.equals("password-change-config")) {
                        this.setPasswordPages(element);
                    }
                }
                ++i;
            }
        }
    }

    public Element loadElementFromDescriptor() throws ParserConfigurationException {
        Element element = null;
        Document document = null;
        if (this.mainDocument == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        } else {
            document = this.mainDocument;
        }
        element = document.createElement("login-module-configuration");
        if (this.loginModules.size() > 0) {
            this.load(document, element);
        }
        if (this.changePasswordPage != null || this.changePasswordErrorPage != null) {
            Element nextElement = document.createElement("password-change-config");
            element.appendChild(nextElement);
            if (this.changePasswordPage != null) {
                this.load(document, nextElement, this.changePasswordPage, "login-page");
            }
            if (this.changePasswordErrorPage != null) {
                this.load(document, nextElement, this.changePasswordErrorPage, "error-page");
            }
        }
        return element;
    }

    public String getChangePasswordPage() {
        return this.changePasswordPage;
    }

    public String getChangePasswordErrorPage() {
        return this.changePasswordErrorPage;
    }

    public AppConfigurationEntry[] getLoginModules() {
        AppConfigurationEntry[] entries = new AppConfigurationEntry[this.loginModules.size()];
        int i = 0;
        while (i < entries.length) {
            entries[i] = ((LoginModule)this.loginModules.elementAt(i)).toAppConfigurationEntry();
            ++i;
        }
        return entries;
    }

    public void setChangePasswordPage(String changePasswordPage) {
        this.changePasswordPage = changePasswordPage;
    }

    public void setChangePasswordErrorPage(String changePasswordErrorPage) {
        this.changePasswordErrorPage = changePasswordErrorPage;
    }

    public void setLoginModules(AppConfigurationEntry[] entries) {
        this.loginModules.clear();
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                this.loginModules.add(new LoginModule(entries[i]));
                ++i;
            }
        }
    }

    private void setLoginModules(Element elmnt) {
        NodeList list;
        if (elmnt != null && (list = elmnt.getChildNodes()) != null) {
            String tag = null;
            int count = list.getLength();
            int i = 0;
            while (i < count) {
                Element element;
                if (list.item(i).getNodeType() == 1 && (tag = (element = (Element)list.item(i)).getTagName()).equals("login-module")) {
                    this.addLoginModule(element);
                }
                ++i;
            }
        }
    }

    private void setPasswordPages(Element elmnt) {
        NodeList list;
        if (elmnt != null && (list = elmnt.getChildNodes()) != null) {
            String tag = null;
            int count = list.getLength();
            Element element = null;
            int i = 0;
            while (i < count) {
                if (list.item(i).getNodeType() == 1) {
                    element = (Element)list.item(i);
                    tag = element.getTagName();
                    if (tag.equals("login-page")) {
                        this.changePasswordPage = this.getTextValue(element);
                    } else if (tag.equals("error-page")) {
                        this.changePasswordErrorPage = this.getTextValue(element);
                    }
                }
                ++i;
            }
        }
    }

    private String getTextValue(Element element) {
        String value;
        String obj;
        Node node;
        if (!(element == null || (node = element.getFirstChild()) == null || node.getNodeType() != 3 && node.getNodeType() != 4 || (obj = node.getNodeValue()) == null || (value = obj.trim()).equals(""))) {
            return value;
        }
        return null;
    }

    private void addLoginModule(Element element) {
        NodeList nodes;
        if (element != null && (nodes = element.getChildNodes()) != null) {
            int count = nodes.getLength();
            String tag = null;
            String name = null;
            String flag = null;
            Map options = new Hashtable();
            int i = 0;
            while (i < count) {
                if (nodes.item(i).getNodeType() == 1) {
                    Element elem = (Element)nodes.item(i);
                    tag = elem.getTagName();
                    if (tag.equals("login-module-name")) {
                        name = this.getTextValue(elem);
                    } else if (tag.equals("flag")) {
                        flag = this.getTextValue(elem);
                    } else if (tag.equals("options")) {
                        options = this.getOptions(elem, options);
                    }
                }
                ++i;
            }
            if (name == null || name.length() == 0) {
                throw new WebIllegalArgumentException("servlet_jsp_0225");
            }
            if (SUFFICIENT.equalsIgnoreCase(flag)) {
                this.loginModules.add(new LoginModule(name, 3, options));
            } else if (REQUIRED.equalsIgnoreCase(flag)) {
                this.loginModules.add(new LoginModule(name, 1, options));
            } else if (REQUISITE.equalsIgnoreCase(flag)) {
                this.loginModules.add(new LoginModule(name, 2, options));
            } else if (OPTIONAL.equalsIgnoreCase(flag)) {
                this.loginModules.add(new LoginModule(name, 4, options));
            } else {
                throw new WebIllegalArgumentException("servlet_jsp_0226", new Object[]{flag, name});
            }
        }
    }

    private Map getOptions(Element element, Map options) {
        NodeList nodes;
        if (element != null && (nodes = element.getChildNodes()) != null) {
            int count = nodes.getLength();
            String tag = null;
            NodeList list = null;
            Element elem = null;
            String name = null;
            String value = null;
            int i = 0;
            while (i < count) {
                if (nodes.item(i).getNodeType() == 1 && ((Element)nodes.item(i)).getTagName().equals("option")) {
                    list = nodes.item(i).getChildNodes();
                    name = null;
                    value = null;
                    if (list != null) {
                        int j = 0;
                        while (j < list.getLength()) {
                            if (list.item(j).getNodeType() == 1) {
                                elem = (Element)list.item(j);
                                tag = elem.getTagName();
                                if (tag.equals("name")) {
                                    name = this.getTextValue(elem);
                                } else if (tag.equals("value")) {
                                    value = this.getTextValue(elem);
                                }
                            }
                            ++j;
                        }
                    }
                    if (name != null && value != null) {
                        options.put(name, value);
                    }
                }
                ++i;
            }
        }
        return options;
    }

    private void load(Document document, Element element, String value, String tagName) {
        Element nextElement = document.createElement(tagName);
        Text textNode = document.createTextNode(value);
        nextElement.appendChild(textNode);
        element.appendChild(nextElement);
    }

    private void load(Document document, Element element) {
        Element nextElement = document.createElement("login-module-stack");
        element.appendChild(nextElement);
        int size = this.loginModules.size();
        int i = 0;
        while (i < size) {
            LoginModule entry = (LoginModule)this.loginModules.elementAt(i);
            if (entry != null) {
                this.load(document, nextElement, entry.toAppConfigurationEntry());
            }
            ++i;
        }
    }

    private void load(Document document, Element element, AppConfigurationEntry entry) {
        Element nextElement = document.createElement("login-module");
        Element nameElement = document.createElement("login-module-name");
        Text nameNode = document.createTextNode(entry.getLoginModuleName());
        nameElement.appendChild(nameNode);
        nextElement.appendChild(nameElement);
        Element flagElement = document.createElement("flag");
        String flag = entry.getControlFlag().toString();
        if (flag != null && flag.length() != 0) {
            flag = flag.substring(flag.indexOf(58) + 2).toUpperCase();
        }
        Text flagNode = document.createTextNode(flag);
        flagElement.appendChild(flagNode);
        nextElement.appendChild(flagElement);
        Map<String, ?> options = entry.getOptions();
        if (options.size() > 0) {
            Element optionsElement = document.createElement("options");
            Object[] keys = options.keySet().toArray();
            String name = null;
            String value = null;
            Element optionEl = null;
            int i = 0;
            while (i < keys.length) {
                name = (String)keys[i];
                value = (String)options.get(name);
                if (!name.equals("") && !value.equals("")) {
                    optionEl = document.createElement("option");
                    this.load(document, optionEl, name, "name");
                    this.load(document, optionEl, value, "value");
                    optionsElement.appendChild(optionEl);
                }
                ++i;
            }
            nextElement.appendChild(optionsElement);
        }
        element.appendChild(nextElement);
    }

    public Object clone() {
        AuthenticationDescriptor cloning = new AuthenticationDescriptor();
        cloning.changePasswordPage = this.changePasswordPage == null ? null : new String(this.changePasswordPage);
        String string = cloning.changePasswordErrorPage = this.changePasswordErrorPage == null ? null : new String(this.changePasswordErrorPage);
        if (this.loginModules == null) {
            cloning.loginModules = null;
        } else {
            LoginModule entry = null;
            int i = 0;
            while (i < this.loginModules.size()) {
                if (this.loginModules.elementAt(i) instanceof LoginModule) {
                    entry = (LoginModule)this.loginModules.elementAt(i);
                    cloning.loginModules.add(new LoginModule(entry.getLoginModuleName(), entry.getControlFlag(), entry.getOptions()));
                }
                ++i;
            }
        }
        return cloning;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AuthenticationDescriptor)) {
            return false;
        }
        AuthenticationDescriptor auth = (AuthenticationDescriptor)obj;
        if (auth.getChangePasswordPage() != null ? !auth.getChangePasswordPage().equals(this.getChangePasswordPage()) : this.getChangePasswordPage() != null) {
            return false;
        }
        if (auth.getChangePasswordErrorPage() != null ? !auth.getChangePasswordErrorPage().equals(this.getChangePasswordErrorPage()) : this.getChangePasswordErrorPage() != null) {
            return false;
        }
        return this.equalLoginModules(this.getLoginModules(), auth.getLoginModules());
    }

    private boolean equalLoginModules(AppConfigurationEntry[] current, AppConfigurationEntry[] compared) {
        if (compared == null && current == null) {
            return true;
        }
        if (compared == null || current == null) {
            return false;
        }
        if (compared.length != current.length) {
            return false;
        }
        int i = 0;
        while (i < compared.length) {
            if (compared[i] != null && compared[i].getLoginModuleName() != null && !compared[i].getLoginModuleName().equals("") && this.findEqualModule(compared[i], current) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int findEqualModule(AppConfigurationEntry module, AppConfigurationEntry[] all) {
        int index = -1;
        String name = module.getLoginModuleName();
        int i = 0;
        while (i < all.length) {
            if (all[i] != null && name.equals(all[i].getLoginModuleName()) && all[i].getControlFlag().toString().equals(module.getControlFlag().toString()) && all[i].getOptions().equals(module.getOptions())) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }
}

