/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.xml.util.internal;

import java.io.IOException;
import java.io.InputStream;

public class XmlStream
extends InputStream {
    private long position;
    private InputStream stream;

    public XmlStream(InputStream stream) {
        this.stream = stream;
        this.position = 0L;
    }

    public long getFilePosition() {
        return this.position;
    }

    public int read() throws IOException {
        int ch = this.stream.read();
        if (ch >= 0) {
            ++this.position;
        }
        return ch;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytes = this.stream.read(b, off, len);
        if (bytes > 0) {
            this.position += (long)bytes;
        }
        return bytes;
    }

    public int read(byte[] b) throws IOException {
        int bytes = this.stream.read(b);
        if (bytes > 0) {
            this.position += (long)bytes;
        }
        return bytes;
    }

    public synchronized void reset() throws IOException {
        this.position = 0L;
        this.stream.reset();
    }

    public long skip(long n) throws IOException {
        long bytes = this.stream.skip(n);
        this.position += bytes;
        return bytes;
    }
}

