/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.xml.util.internal;

import com.tssap.editors.tag.ui.OutlinePageTreeModel;
import com.tssap.editors.tag.util.TreeNode;
import com.tssap.editors.tag.util.node.IRootTreeNode;
import com.tssap.editors.tag.util.node.impl.AttrTreeNode;
import com.tssap.editors.tag.util.node.impl.CommentTreeNode;
import com.tssap.editors.tag.util.node.impl.ElementTreeNode;
import com.tssap.editors.tag.util.node.impl.ErrorTreeNode;
import com.tssap.editors.tag.util.node.impl.ProcessingTreeNode;
import com.tssap.editors.tag.util.node.impl.RootTreeNode;
import com.tssap.editors.tag.util.node.impl.SpecialTreeNode;
import com.tssap.editors.tag.util.node.impl.TextTreeNode;
import com.tssap.editors.util.SrcLocation;
import com.tssap.editors.xml.XmlEditor;
import com.tssap.editors.xml.util.IXmlParser;
import com.tssap.editors.xml.util.IXmlParserErrorHandler;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
implements IXmlParser {
    private static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final String DECLARATION_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    private boolean throwDTDException = false;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$tssap$editors$xml$util$internal$XmlParser == null ? (class$com$tssap$editors$xml$util$internal$XmlParser = XmlParser.class$("com.tssap.editors.xml.util.internal.XmlParser")) : class$com$tssap$editors$xml$util$internal$XmlParser));
    static /* synthetic */ Class class$com$tssap$editors$xml$util$internal$XmlParser;

    public static String getSystemIdOfFile(IFile file) {
        String systemId;
        block2: {
            systemId = null;
            try {
                String sFile = file.getLocation().toOSString();
                URL url = new URL("file", "/", sFile);
                systemId = url.toString();
            }
            catch (MalformedURLException ex) {
                if (!theTracer.error()) break block2;
                theTracer.error("Error when computing system id of file", (Throwable)ex);
            }
        }
        return systemId;
    }

    public OutlinePageTreeModel parseAsTreeModel(InputStream source, IXmlParserErrorHandler errHandler, EntityResolver resolver, IFile file) {
        String systemId = null;
        String rootNodeText = null;
        if (file != null) {
            systemId = XmlParser.getSystemIdOfFile(file);
            rootNodeText = file.getName();
        }
        return this.parseAsTreeModel(source, errHandler, resolver, systemId, rootNodeText);
    }

    public OutlinePageTreeModel parseAsTreeModel(InputStream source, IXmlParserErrorHandler errHandler, IFile file) {
        String systemId = null;
        String rootNodeText = null;
        if (file != null) {
            systemId = XmlParser.getSystemIdOfFile(file);
            rootNodeText = file.getName();
        }
        return this.parseAsTreeModel(source, errHandler, null, systemId, rootNodeText);
    }

    public OutlinePageTreeModel parseAsTreeModel(InputStream source, IXmlParserErrorHandler errHandler, EntityResolver resolver, String rootNodeText, String systemId) {
        IRootTreeNode rootNode;
        InternalParserHandler handler = new InternalParserHandler();
        if (rootNodeText != null) {
            handler.setRootNodeContent(rootNodeText);
        }
        if (errHandler != null) {
            errHandler.reset();
            handler.setErrorHandler(errHandler);
        }
        if (resolver != null) {
            handler.setAlternativeResolver(resolver);
        }
        try {
            SAXParserFactoryImpl parserFactory = new SAXParserFactoryImpl();
            parserFactory.setValidating(false);
            SAXParser saxParser = parserFactory.newSAXParser();
            saxParser.setProperty(LEXICAL_HANDLER, handler);
            saxParser.setProperty(DECLARATION_HANDLER, handler);
            try {
                XMLReader xmlReader = saxParser.getXMLReader();
                handler.setXmlReader(xmlReader);
                theTracer.info("parseAsTreeModel()", "Used xmlReader class : " + xmlReader.getClass().getName());
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader.setFeature("http://xml.org/sax/features/validation", true);
                xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException sex) {
                theTracer.error("Could not set parser feauture : " + sex.getMessage(), (Throwable)sex);
            }
            try {
                if (systemId != null) {
                    saxParser.parse(source, handler, systemId);
                } else {
                    saxParser.parse(source, (DefaultHandler)handler);
                }
            }
            catch (SAXParseException sex) {
                theTracer.info("Got a parsing exception ", sex.getMessage());
            }
            rootNode = handler.getRootNode();
        }
        catch (Exception e) {
            theTracer.error("Parsing error", (Throwable)e);
            rootNode = new RootTreeNode("Parsing error = " + e.getMessage());
            rootNode.setErrorFlag();
        }
        return new OutlinePageTreeModel(rootNode);
    }

    public Document parseAsDom(InputStream source, IXmlParserErrorHandler errHandler, EntityResolver resolver, IFile file) throws SAXException {
        return this.parseAsDom(source, errHandler, resolver);
    }

    public Document parseAsDom(InputStream source, IXmlParserErrorHandler errHandler, IFile file) throws SAXException {
        return this.parseAsDom(source, errHandler, (EntityResolver)null);
    }

    public Document parseAsDom(InputStream source, IXmlParserErrorHandler errHandler, EntityResolver resolver) throws SAXException {
        Document doc = null;
        DocumentBuilderFactoryImpl domBuilderFactory = new DocumentBuilderFactoryImpl();
        if (errHandler != null) {
            domBuilderFactory.setValidating(true);
        } else {
            domBuilderFactory.setValidating(false);
        }
        domBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder domBuilder = domBuilderFactory.newDocumentBuilder();
            if (resolver != null) {
                domBuilder.setEntityResolver(resolver);
            }
            if (errHandler != null) {
                errHandler.reset();
                domBuilder.setErrorHandler(errHandler);
            }
            doc = domBuilder.parse(source);
            doc.normalize();
        }
        catch (IOException ex) {
            theTracer.error(this.getClass(), "parseAsDom", ex.getMessage(), (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            theTracer.error(this.getClass(), "parseAsDom", ex.getMessage(), (Throwable)ex);
        }
        return doc;
    }

    public String serializeDom(Document doc) throws SAXException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.serializeDom(doc, outStream);
        String retString = outStream.toString();
        return retString;
    }

    public void serializeDom(Document doc, OutputStream outStream) throws SAXException {
        OutputFormat outputFormat = new OutputFormat(doc);
        outputFormat.setPreserveEmptyAttributes(true);
        outputFormat.setPreserveSpace(true);
        XMLSerializer xmlSerializer = new XMLSerializer(outStream, outputFormat);
        try {
            xmlSerializer.serialize(doc);
        }
        catch (IOException ex) {
            theTracer.error("Cannot serialize dom", (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InternalParserHandler
    extends DefaultHandler
    implements LexicalHandler,
    DeclHandler {
        private ErrorHandler fErrorHandler = null;
        private IRootTreeNode root = null;
        private Locator locator = null;
        private String rootNodeContent = "";
        protected Stack elementStack = new Stack();
        private EntityResolver alternativeResolver;
        private XMLReader xmlReader;
        private boolean inCDataSection;
        private boolean ignoreWhitespace = false;
        private boolean putCDATAIntoText = false;
        private boolean insertComments = false;
        private TracerI theTracer = TracingManager.getTracer((String)(class$com$tssap$editors$xml$util$internal$XmlParser$InternalParserHandler == null ? (class$com$tssap$editors$xml$util$internal$XmlParser$InternalParserHandler = InternalParserHandler.class$("com.tssap.editors.xml.util.internal.XmlParser$InternalParserHandler")) : class$com$tssap$editors$xml$util$internal$XmlParser$InternalParserHandler).getName());
        static /* synthetic */ Class class$com$tssap$editors$xml$util$internal$XmlParser$InternalParserHandler;

        public IRootTreeNode getRootNode() {
            return this.root;
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.fErrorHandler = handler;
        }

        public ErrorHandler getErrorHandler() {
            return this.fErrorHandler;
        }

        public void setRootNodeContent(String content) {
            this.rootNodeContent = content;
        }

        public String getRootNodeContent() {
            return this.rootNodeContent;
        }

        public void error(SAXParseException exception) throws SAXException {
            if (this.fErrorHandler != null) {
                this.fErrorHandler.error(exception);
            }
            ErrorTreeNode node = new ErrorTreeNode(exception.getMessage());
            node.setUserObject(this.getSrcLocation());
            ((TreeNode)this.elementStack.peek()).add(node);
            if (this.root != null) {
                this.root.setErrorFlag();
            }
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            if (this.fErrorHandler != null) {
                this.fErrorHandler.fatalError(exception);
            }
            ErrorTreeNode node = new ErrorTreeNode(exception.getMessage());
            node.setUserObject(this.getSrcLocation());
            ((TreeNode)this.elementStack.peek()).add(node);
            if (this.root != null) {
                this.root.setErrorFlag();
            }
        }

        public void warning(SAXParseException exception) throws SAXException {
            if (this.fErrorHandler != null) {
                this.fErrorHandler.warning(exception);
            }
            ErrorTreeNode node = new ErrorTreeNode(exception.getMessage(), true);
            node.setUserObject(this.getSrcLocation());
            ((TreeNode)this.elementStack.peek()).add(node);
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.elementStack.pop();
        }

        public void startDocument() throws SAXException {
            if (this.getXmlReader() != null) {
                // empty if block
            }
            this.root = new RootTreeNode(this.getRootNodeContent());
            this.elementStack.clear();
            this.elementStack.push(this.root);
            this.inCDataSection = false;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.insertComments = true;
            ElementTreeNode node = new ElementTreeNode(qName);
            node.setUserObject(this.getSrcLocation());
            int i = 0;
            while (i < atts.getLength()) {
                AttrTreeNode attrib = new AttrTreeNode(atts.getQName(i), atts.getValue(i));
                attrib.setUserObject(this.getSrcLocation());
                node.insert(attrib, node.getChildCount());
                ++i;
            }
            ((TreeNode)this.elementStack.peek()).add(node);
            this.elementStack.push(node);
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.insertComments) {
                String commentString = new String(ch, start, length);
                CommentTreeNode commentNode = new CommentTreeNode(commentString);
                commentNode.setUserObject(this.getSrcLocation());
                ((TreeNode)this.elementStack.peek()).add(commentNode);
            }
        }

        public void endCDATA() throws SAXException {
            this.inCDataSection = false;
        }

        public void endDTD() throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
            if (this.putCDATAIntoText) {
                return;
            }
            this.inCDataSection = true;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            String text = systemId != null ? systemId : (publicId != null ? publicId : "");
            SpecialTreeNode node = new SpecialTreeNode("DTD (" + name + ")", text);
            node.setUserObject(this.getSrcLocation());
            ((TreeNode)this.elementStack.peek()).add(node);
            if (this.theTracer.info()) {
                this.theTracer.info("Found a DTD declaration:");
                this.theTracer.info("  publicId = " + systemId);
                this.theTracer.info("  systemId = " + systemId);
            }
            if (this.getXmlReader() != null) {
                // empty if block
            }
        }

        public void startEntity(String name) throws SAXException {
        }

        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        }

        public void elementDecl(String name, String model) throws SAXException {
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
            ProcessingTreeNode node = new ProcessingTreeNode(target, data);
            node.setUserObject(this.getSrcLocation());
            ((TreeNode)this.elementStack.peek()).add(node);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        /*
         * Unable to fully structure code
         */
        public void characters(char[] buf, int offset, int len) throws SAXException {
            block5: {
                top = (TreeNode)this.elementStack.peek();
                temp = new String(buf, offset, len).trim();
                if (temp.equals("")) {
                    return;
                }
                lastChild = null;
                if (top.getChildCount() > 0 && (obj = top.getLastChild()) instanceof TreeNode) {
                    lastChild = (TreeNode)obj;
                }
                if (this.inCDataSection) {
                    if (top instanceof TextTreeNode) {
                        txtNode = (TextTreeNode)top;
                        text = txtNode.getText();
                        text = text + temp;
                        txtNode.setText(text.trim());
                    }
                    return;
                }
                if (!(lastChild instanceof TextTreeNode)) ** GOTO lbl22
                txtNode = (TextTreeNode)lastChild;
                text = txtNode.getText();
                text = text + temp;
                txtNode.setText(text.trim());
                break block5;
lbl-1000:
                // 1 sources

                {
                    temp = temp.substring(1);
lbl22:
                    // 2 sources

                    ** while (temp.toCharArray()[0] <= ' ')
                }
lbl23:
                // 1 sources

                node = new TextTreeNode(temp);
                node.setUserObject(this.getSrcLocation());
                top.add(node);
            }
        }

        private SrcLocation getSrcLocation() {
            int lineNumber = (this.locator != null ? this.locator.getLineNumber() : 0) - 1;
            int colNumber = this.locator != null ? this.locator.getLineNumber() : 0;
            SrcLocation src = new SrcLocation(lineNumber, colNumber, lineNumber, colNumber);
            return src;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            XmlEditor.getTracer().info("Resolve entity : public ID = " + publicId + " system ID = " + systemId);
            InputSource inpSource = null;
            if (this.getAlternativeResolver() != null) {
                try {
                    inpSource = this.getAlternativeResolver().resolveEntity(publicId, systemId);
                }
                catch (IOException ex) {
                    SAXParseException parseEx = new SAXParseException("Resolver failed " + ex.getMessage(), publicId, systemId, 0, 0, ex);
                    this.error(parseEx);
                    String temporaryDtd = "<!ELEMENT root EMPTY>";
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(temporaryDtd.getBytes());
                    inpSource = new InputSource(inputStream);
                }
            } else {
                inpSource = super.resolveEntity(publicId, systemId);
            }
            return inpSource;
        }

        public EntityResolver getAlternativeResolver() {
            return this.alternativeResolver;
        }

        public void setAlternativeResolver(EntityResolver alternativeResolver) {
            this.alternativeResolver = alternativeResolver;
        }

        public XMLReader getXmlReader() {
            return this.xmlReader;
        }

        public void setXmlReader(XMLReader xmlReader) {
            this.xmlReader = xmlReader;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

