/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.xml.util;

import com.tssap.editors.xml.util.IXmlParser;
import com.tssap.editors.xml.util.IXmlParserErrorHandler;
import com.tssap.editors.xml.util.internal.XmlParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParserFactory {
    public static final int NUM_OF_PARSERS = 5;
    private static int currentParser = 0;
    private static IXmlParser[] parser = new IXmlParser[5];

    private XmlParserFactory() {
    }

    public static IXmlParser getNextParser() {
        IXmlParser locParser;
        if (++currentParser == 5) {
            currentParser = 0;
        }
        if ((locParser = parser[currentParser]) == null) {
            XmlParserFactory.parser[XmlParserFactory.currentParser] = locParser = new XmlParser();
        }
        return locParser;
    }

    public static IXmlParserErrorHandler createInterruptParsingHandler(boolean interuptOnWarning, boolean interruptOnError) {
        InnerInterruptParsingHandler interruptHandler = new InnerInterruptParsingHandler(interuptOnWarning, interruptOnError);
        return interruptHandler;
    }

    private static class InnerInterruptParsingHandler
    implements IXmlParserErrorHandler {
        private boolean interruptOnWarning;
        private boolean interruptOnError;

        public InnerInterruptParsingHandler(boolean interruptOnWarning, boolean interruptOnError) {
            this.interruptOnWarning = interruptOnWarning;
            this.interruptOnError = interruptOnError;
        }

        public void reset() {
        }

        public void warning(SAXParseException arg0) throws SAXException {
            if (this.interruptOnWarning) {
                throw arg0;
            }
        }

        public void error(SAXParseException arg0) throws SAXException {
            if (this.interruptOnError) {
                throw arg0;
            }
        }

        public void fatalError(SAXParseException arg0) throws SAXException {
            throw arg0;
        }
    }
}

