/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.xml;

import com.tssap.editors.tag.ICloseableEditor;
import com.tssap.editors.tag.basic.BasicTagEditor;
import com.tssap.editors.tag.source.TagSourceViewerConfiguration;
import com.tssap.editors.tag.ui.OutlinePage;
import com.tssap.editors.tag.ui.OutlinePageTreeModel;
import com.tssap.editors.tag.util.ElementStateListener;
import com.tssap.editors.tag.util.ITagParserController;
import com.tssap.editors.xml.IXmlEditor;
import com.tssap.editors.xml.source.XmlSourceViewerConfiguration;
import com.tssap.editors.xml.util.IXmlParser;
import com.tssap.editors.xml.util.IXmlParserErrorHandler;
import com.tssap.editors.xml.util.XmlDocumentProvider;
import com.tssap.editors.xml.util.XmlParserController;
import com.tssap.editors.xml.util.XmlParserFactory;
import com.tssap.editors.xml.util.internal.XmlParser;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlEditor
extends BasicTagEditor
implements IXmlEditor {
    private IXmlParser xmlParser;
    private IXmlParserErrorHandler xmlErrorHandler = new InnerErrorMarkerHandler();
    private IXmlParserErrorHandler xmlInterruptErrorHandler = XmlParserFactory.createInterruptParsingHandler(false, true);
    private OutlinePage xmlOutlinePage;
    private ITagParserController xmlParserController;
    private EntityResolver resolver;
    private IDocumentProvider xmlDocumentProvider;
    private static TracerI xmlTracer = TracingManager.getTracer((String)(class$com$tssap$editors$xml$XmlEditor == null ? (class$com$tssap$editors$xml$XmlEditor = XmlEditor.class$("com.tssap.editors.xml.XmlEditor")) : class$com$tssap$editors$xml$XmlEditor).getName());
    static /* synthetic */ Class class$com$tssap$editors$xml$XmlEditor;

    public XmlEditor() {
    }

    public XmlEditor(ICloseableEditor ce) {
        super(ce);
    }

    protected IXmlParser getParser() {
        if (this.xmlParser == null) {
            this.xmlParser = XmlParserFactory.getNextParser();
        }
        return this.xmlParser;
    }

    protected OutlinePageTreeModel getOutlinePageTreeModel(boolean updateTaskPane) {
        IXmlParser parser = this.getParser();
        IXmlParserErrorHandler errHandler = null;
        if (updateTaskPane) {
            errHandler = this.xmlErrorHandler;
        }
        String rootNodeText = this.getFile() != null ? this.getFile().getName() : "<FILE>";
        OutlinePageTreeModel newModel = parser.parseAsTreeModel(this.getStream(), errHandler, this.getEntityResolver(), rootNodeText, this.getSystemId());
        return newModel;
    }

    public boolean parse(boolean updOutlinePane, boolean updTaskPane) {
        OutlinePageTreeModel treeModel = this.getOutlinePageTreeModel(updTaskPane);
        if (this.getOutlinePage() != null && updOutlinePane) {
            this.getOutlinePage().updateTreeModel(treeModel);
        }
        return !treeModel.doesSourceContainError();
    }

    public boolean parse(boolean updOutlinePane, boolean updTaskPane, boolean validate) {
        if (!validate) {
            throw new IllegalArgumentException("Validation cannot be switched off anymore !");
        }
        return this.parse(updOutlinePane, updTaskPane);
    }

    public void contentReplaced(Object content) {
        this.parse(true, true);
    }

    public Document getContentAsDom() {
        IXmlParser xmlParser = this.getParser();
        Document doc = null;
        try {
            doc = xmlParser.parseAsDom(this.getStream(), null, this.getEntityResolver());
        }
        catch (SAXException ex) {
            XmlEditor.getTracer().error("getContentAsDom()", ex.getMessage(), (Throwable)ex);
        }
        return doc;
    }

    public Document getContentAsDomIfValid() {
        IXmlParser xmlParser = this.getParser();
        Document doc = null;
        try {
            doc = xmlParser.parseAsDom(this.getStream(), this.xmlInterruptErrorHandler, this.getEntityResolver());
        }
        catch (SAXException ex) {
            XmlEditor.getTracer().error("getContentAsDomIfValid()", ex.getMessage(), (Throwable)ex);
        }
        return doc;
    }

    public void setDomAsContent(Document doc, boolean suppressMakeDirty) {
        String content = "";
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.xmlParser.serializeDom(doc, outStream);
            String enc = this.getEncoding();
            content = enc != null ? outStream.toString(enc) : outStream.toString();
        }
        catch (SAXException ex1) {
            XmlEditor.getTracer().error("setDomAsContent(...)", (Throwable)ex1);
        }
        catch (UnsupportedEncodingException ex2) {
            XmlEditor.getTracer().error("setDomAsContent(...)", (Throwable)ex2);
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        document.set(content);
        this.format();
    }

    protected TagSourceViewerConfiguration getSpecificSourceViewerConfiguration() {
        return new XmlSourceViewerConfiguration(this);
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public ITagParserController getParserController() {
        if (this.xmlParserController == null) {
            this.xmlParserController = new XmlParserController();
        }
        return this.xmlParserController;
    }

    public void format() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        IContentFormatter formatter = this.getSourceViewerConfiguration().getContentFormatter(this.getSourceViewer());
        Region region = new Region(0, document.getLength());
        formatter.format(document, (IRegion)region);
    }

    public static TracerI getTracer() {
        return xmlTracer;
    }

    protected String getSystemId() {
        String systemId = null;
        if (this.getFile() != null) {
            systemId = XmlParser.getSystemIdOfFile(this.getFile());
        }
        return systemId;
    }

    public boolean isFileReadOnly() {
        boolean readOnly = false;
        IDocumentProvider documentProv = this.getDocumentProvider();
        if (documentProv instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension documentProvExt = (IDocumentProviderExtension)documentProv;
            try {
                documentProvExt.updateStateCache((Object)this.getEditorInput());
                readOnly = documentProvExt.isReadOnly((Object)this.getEditorInput());
            }
            catch (CoreException ex) {
                XmlEditor.getTracer().error("setCurrentPage(int currentPage)", ex.getMessage(), (Throwable)ex);
            }
        }
        return readOnly;
    }

    public IDocumentProvider getDocumentProvider() {
        if (this.xmlDocumentProvider == null) {
            this.xmlDocumentProvider = new XmlDocumentProvider();
            this.xmlDocumentProvider.addElementStateListener((IElementStateListener)new ElementStateListener(this));
        }
        return this.xmlDocumentProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerErrorMarkerHandler
    implements IXmlParserErrorHandler {
        private InnerErrorMarkerHandler() {
        }

        public void error(SAXParseException ex) throws SAXException {
            this.addMarker(ex, 2, false);
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            this.addMarker(ex, 2, true);
        }

        public void warning(SAXParseException ex) throws SAXException {
            this.addMarker(ex, 1, false);
        }

        public void reset() {
            try {
                IFile file = XmlEditor.this.getFile();
                if (file != null) {
                    file.deleteMarkers("com.tssap.editors.tagproblemmarker", true, 2);
                }
            }
            catch (CoreException ex) {
                XmlEditor.getTracer().error("reset()", ex.getMessage(), (Throwable)ex);
            }
        }

        private void addMarker(String message, int lineNumber, int severity, boolean fatal) {
            try {
                IFile file = XmlEditor.this.getFile();
                if (file != null) {
                    IMarker marker1 = file.createMarker("com.tssap.editors.tagproblemmarker");
                    marker1.setAttribute("message", (Object)message);
                    marker1.setAttribute("severity", severity);
                    if (lineNumber != -1) {
                        marker1.setAttribute("lineNumber", lineNumber);
                    }
                }
            }
            catch (CoreException ex) {
                XmlEditor.getTracer().error("addMarker(String message, int lineNumber, int severity, boolean fatal)", ex.getMessage(), (Throwable)ex);
            }
        }

        private void addMarker(SAXParseException e, int severity, boolean fatal) {
            this.addMarker(e.getMessage(), e.getLineNumber(), severity, fatal);
        }
    }
}

