/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.util;

import com.tssap.editors.util.ColorManager;
import com.tssap.editors.util.ITextToken;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;

public class TextToken
extends Token
implements ITextToken {
    private String key_forground;
    private String key_bold;
    private ISourceViewer sourceViewer;
    private IPropertyChangeListener listener = this;

    public TextToken(String key, final IPreferenceStore pref, ISourceViewer sourceViewer) {
        super(null);
        this.sourceViewer = sourceViewer;
        this.key_forground = key;
        this.key_bold = key + "_" + "bold";
        String value = pref.getString(this.key_forground);
        RGB fg = null;
        if (value == null || value == "") {
            fg = PreferenceConverter.COLOR_DEFAULT_DEFAULT;
        } else {
            fg = StringConverter.asRGB((String)value, null);
            if (fg == null) {
                fg = PreferenceConverter.COLOR_DEFAULT_DEFAULT;
            }
        }
        boolean bold = pref.getBoolean(this.key_bold);
        IColorManager colorMan = ColorManager.getInstance();
        this.setData(new TextAttribute(colorMan.getColor(fg), null, bold ? 1 : 0));
        pref.addPropertyChangeListener(this.listener);
        if (sourceViewer != null && sourceViewer.getTextWidget() != null) {
            sourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    pref.removePropertyChangeListener(TextToken.this.listener);
                }
            });
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getProperty();
        if (key.equals(this.key_forground)) {
            this.adaptToColorChange(evt);
        }
        if (key.equals(this.key_bold)) {
            this.adaptToStyleChange(evt);
        }
    }

    private void adaptToColorChange(PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            TextAttribute oldAttr = (TextAttribute)this.getData();
            this.setData(new TextAttribute(ColorManager.getInstance().getColor(rgb), oldAttr.getBackground(), oldAttr.getStyle()));
            if (this.sourceViewer != null) {
                this.sourceViewer.invalidateTextPresentation();
            }
        }
    }

    private void adaptToStyleChange(PropertyChangeEvent event) {
        boolean bold = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            bold = (Boolean)value;
        } else if (value instanceof String) {
            String s = (String)value;
            bold = "true".equals(s);
        }
        TextAttribute oldAttr = (TextAttribute)this.getData();
        this.setData(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), bold ? 1 : 0));
        if (this.sourceViewer != null) {
            this.sourceViewer.invalidateTextPresentation();
        }
    }
}

