/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.util;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class PreferencesUtil {
    public static final TypeDescriptor BOOLEAN = new TypeDescriptor();
    public static final TypeDescriptor DOUBLE = new TypeDescriptor();
    public static final TypeDescriptor FLOAT = new TypeDescriptor();
    public static final TypeDescriptor INT = new TypeDescriptor();
    public static final TypeDescriptor LONG = new TypeDescriptor();
    public static final TypeDescriptor STRING = new TypeDescriptor();

    public static void copyStore(IPreferenceStore origin, IPreferenceStore target, OverlayKey[] keys, boolean copyDefaults) {
        int i = 0;
        while (i < keys.length) {
            String targetValue;
            String originValue;
            String key = keys[i].getKey();
            if (copyDefaults && !(originValue = origin.getDefaultString(key)).equals(targetValue = target.getDefaultString(key))) {
                target.setDefault(key, originValue);
            }
            if (!(originValue = origin.getString(key)).equals(targetValue = target.getString(key))) {
                target.setValue(key, originValue);
            }
            ++i;
        }
    }

    public static void setToDefault(IPreferenceStore store, OverlayKey[] keys) {
        int i = 0;
        while (i < keys.length) {
            store.setToDefault(keys[i].getKey());
            ++i;
        }
    }

    public static void setDefaultProperty(IPreferenceStore store, String key, Object value) {
        PreferencesUtil.setProperty(store, key, value, true);
    }

    public static void setProperty(IPreferenceStore store, String key, Object value) {
        PreferencesUtil.setProperty(store, key, value, false);
    }

    private static void setProperty(IPreferenceStore store, String key, Object value, boolean defaultProp) {
        if (value instanceof String) {
            if (defaultProp) {
                store.setDefault(key, (String)value);
            } else {
                store.setValue(key, (String)value);
            }
        } else if (value instanceof Boolean) {
            if (defaultProp) {
                store.setDefault(key, ((Boolean)value).booleanValue());
            } else {
                store.setValue(key, ((Boolean)value).booleanValue());
            }
        } else if (value instanceof Double) {
            if (defaultProp) {
                store.setDefault(key, ((Double)value).doubleValue());
            } else {
                store.setValue(key, ((Double)value).doubleValue());
            }
        } else if (value instanceof Integer) {
            if (defaultProp) {
                store.setDefault(key, ((Integer)value).intValue());
            } else {
                store.setValue(key, ((Integer)value).intValue());
            }
        } else if (value instanceof Long) {
            if (defaultProp) {
                store.setDefault(key, ((Long)value).longValue());
            } else {
                store.setValue(key, ((Long)value).longValue());
            }
        } else if (value instanceof Float) {
            if (defaultProp) {
                store.setDefault(key, ((Float)value).floatValue());
            } else {
                store.setValue(key, ((Float)value).floatValue());
            }
        } else if (value instanceof RGB) {
            if (defaultProp) {
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)((RGB)value));
            } else {
                PreferenceConverter.setValue((IPreferenceStore)store, (String)key, (RGB)((RGB)value));
            }
        } else if (value instanceof FontData) {
            if (defaultProp) {
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (FontData)((FontData)value));
            } else {
                PreferenceConverter.setValue((IPreferenceStore)store, (String)key, (FontData)((FontData)value));
            }
        }
    }

    public static class OverlayKey {
        private TypeDescriptor fDescriptor;
        private String fKey;

        public OverlayKey(TypeDescriptor descriptor, String key) {
            this.fDescriptor = descriptor;
            this.fKey = key;
        }

        public TypeDescriptor getDescriptor() {
            return this.fDescriptor;
        }

        public String getKey() {
            return this.fKey;
        }
    }

    public static final class TypeDescriptor {
        private TypeDescriptor() {
        }
    }
}

