/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.IColorManagerExtension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements IColorManager,
IColorManagerExtension {
    protected Map fKeyTable = new HashMap(10);
    protected Map fDisplayTable = new HashMap(2);
    private static IColorManager inst;

    private void dispose(Display display) {
        Map colorTable = (Map)this.fDisplayTable.get(display);
        if (colorTable != null) {
            Iterator e = colorTable.values().iterator();
            while (e.hasNext()) {
                ((Color)e.next()).dispose();
            }
        }
    }

    public Color getColor(RGB rgb) {
        Color color;
        if (rgb == null) {
            return null;
        }
        final Display display = Display.getCurrent();
        HashMap<RGB, Color> colorTable = (HashMap<RGB, Color>)this.fDisplayTable.get(display);
        if (colorTable == null) {
            colorTable = new HashMap<RGB, Color>(10);
            this.fDisplayTable.put(display, colorTable);
            display.disposeExec(new Runnable(){

                public void run() {
                    ColorManager.this.dispose(display);
                }
            });
        }
        if ((color = (Color)colorTable.get(rgb)) == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
    }

    public Color getColor(String key) {
        if (key == null) {
            return null;
        }
        RGB rgb = (RGB)this.fKeyTable.get(key);
        return this.getColor(rgb);
    }

    public void bindColor(String key, RGB rgb) {
        Object value = this.fKeyTable.get(key);
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        this.fKeyTable.put(key, rgb);
    }

    public void unbindColor(String key) {
        this.fKeyTable.remove(key);
    }

    public static IColorManager getInstance() {
        if (inst == null) {
            inst = new ColorManager();
        }
        return inst;
    }
}

