/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.util;

import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ColorButton {
    private Point fExtent;
    private Image fImage;
    private RGB fColorValue;
    private Color fColor;
    private Button fButton;

    public ColorButton(IGridLayoutPane parent, IGridLayoutData layoutData) {
        this.fButton = parent.addPushButton("", layoutData);
        this.fExtent = this.computeImageSize((Control)this.fButton);
        this.fImage = new Image((Device)Display.getCurrent(), this.fExtent.x, this.fExtent.y);
        GC gc = new GC((Drawable)this.fImage);
        gc.setBackground(this.fButton.getBackground());
        gc.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
        gc.dispose();
        this.fButton.setImage(this.fImage);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog colorDialog = new ColorDialog(ColorButton.this.fButton.getShell());
                colorDialog.setRGB(ColorButton.this.fColorValue);
                RGB newColor = colorDialog.open();
                if (newColor != null) {
                    ColorButton.this.fColorValue = newColor;
                    ColorButton.this.updateColorImage();
                }
            }
        });
        this.fButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (ColorButton.this.fImage != null) {
                    ColorButton.this.fImage.dispose();
                    ColorButton.this.fImage = null;
                }
                if (ColorButton.this.fColor != null) {
                    ColorButton.this.fColor.dispose();
                    ColorButton.this.fColor = null;
                }
            }
        });
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void setColorValue(RGB rgb) {
        this.fColorValue = rgb;
        this.updateColorImage();
    }

    public Button getButton() {
        return this.fButton;
    }

    protected void updateColorImage() {
        Display display = this.fButton.getDisplay();
        GC gc = new GC((Drawable)this.fImage);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
        if (this.fColor != null) {
            this.fColor.dispose();
        }
        this.fColor = new Color((Device)display, this.fColorValue);
        gc.setBackground(this.fColor);
        gc.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
        gc.dispose();
        this.fButton.setImage(this.fImage);
    }

    protected Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }
}

