/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.ui;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.util.ColorButton;
import com.tssap.editors.util.PreferencesUtil;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.texteditor.WorkbenchChainedTextFontFieldEditor;

public class BasePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore fPluginPreferenceStore;
    private IPreferenceStore fTmpPreferenceStore;
    private Button fBackgroundCheckButton;
    private ColorButton fBackgroundColorEditor;
    private WorkbenchChainedTextFontFieldEditor fFontEditor;
    private static final String BOLD_EXT = "_bold";
    private static final PreferencesUtil.OverlayKey[] fKeyList = new PreferencesUtil.OverlayKey[]{new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "AbstractTextEditor.Color.Background"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault")};

    public static final PreferencesUtil.OverlayKey[] getKeyList() {
        return fKeyList;
    }

    public BasePreferencePage() {
        this.setDescription("Web Editors settings");
        this.fPluginPreferenceStore = EditorPlugin.getInstance().getPreferenceStore();
        this.fTmpPreferenceStore = EditorPlugin.getInstance().getTmpPreferenceStore();
    }

    private void addTextFontEditor(IGridLayoutPane pane, String label, String key) {
        IGridLayoutData layout = pane.createGridLayoutData(1, 1);
        layout.getGridData().horizontalSpan = 2;
        this.fFontEditor = new WorkbenchChainedTextFontFieldEditor(key, label, pane.getComposite());
        this.fFontEditor.setPreferenceName("org.eclipse.jface.textfont");
        this.fFontEditor.setChangeButtonText("C&hange...");
    }

    private void createGeneralPage(IGridLayoutPane parent) {
        IGridLayoutPane colorPane = parent.addGridLayoutPane("Color settings", 4, parent.createGridLayoutData(4, 1, true, false));
        colorPane.addTextLabel("Background");
        colorPane.addTextLabel("Color", colorPane.createGridLayoutData(4, 4, 3, 1));
        this.fBackgroundCheckButton = colorPane.addCheckBox("Use custom color", false);
        this.fBackgroundColorEditor = new ColorButton(colorPane, colorPane.createGridLayoutData(1, 1, 3, 1));
        this.fBackgroundCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean custom = BasePreferencePage.this.fBackgroundCheckButton.getSelection();
                BasePreferencePage.this.fBackgroundColorEditor.getButton().setEnabled(custom);
                BasePreferencePage.this.fTmpPreferenceStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }
        });
        this.fBackgroundColorEditor.getButton().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)BasePreferencePage.this.fTmpPreferenceStore, (String)"AbstractTextEditor.Color.Background", (RGB)BasePreferencePage.this.fBackgroundColorEditor.getColorValue());
            }
        });
    }

    protected Control createContents(Composite parent) {
        ITabbedPane pane = PaneFactory.createTabbedPane((Composite)parent);
        IGridLayoutPane colorPane = pane.addGridLayoutPaneAsTab("General", 1);
        this.createGeneralPage(colorPane);
        this.initialize();
        return pane.getComposite();
    }

    public static void initializeDefaults(IPreferenceStore store) {
        WorkbenchChainedTextFontFieldEditor.startPropagate((IPreferenceStore)store, (String)"org.eclipse.jface.textfont");
        Display display = Display.getDefault();
        Color color = display.getSystemColor(25);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background", (RGB)color.getRGB());
        store.setDefault("AbstractTextEditor.Color.Background.SystemDefault", true);
    }

    private void initialize() {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fTmpPreferenceStore, (String)"AbstractTextEditor.Color.Background");
        this.fBackgroundColorEditor.setColorValue(rgb);
        boolean default_ = this.fTmpPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.fBackgroundCheckButton.setSelection(!default_);
        this.fBackgroundColorEditor.getButton().setEnabled(!default_);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        PreferencesUtil.setToDefault(this.fTmpPreferenceStore, fKeyList);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fTmpPreferenceStore, (String)"AbstractTextEditor.Color.Background");
        this.fBackgroundColorEditor.setColorValue(rgb);
        boolean defaults = this.fTmpPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.fBackgroundCheckButton.setSelection(!defaults);
        this.fBackgroundColorEditor.getButton().setEnabled(!defaults);
        super.performDefaults();
    }

    public boolean performOk() {
        PreferencesUtil.copyStore(this.fTmpPreferenceStore, this.fPluginPreferenceStore, fKeyList, false);
        return super.performOk();
    }
}

