/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.util.state;

import com.tssap.editors.tag.util.ITagParserController;
import com.tssap.editors.tag.util.node.IAttrTreeNode;
import com.tssap.editors.tag.util.state.Container;
import com.tssap.editors.tag.util.state.ITagParserState;
import com.tssap.editors.tag.util.state.TagParserState;
import java.io.IOException;
import java.util.Vector;

public class StartTag
extends TagParserState {
    private char[] delimiters = new char[]{'>', '/'};

    public ITagParserState parse(ITagParserController controller) throws IOException {
        int nextChar = controller.readNextCharacter();
        if (nextChar != 60) {
            controller.consumeRest();
            controller.insertError("Incorrect starting character : " + nextChar);
            return Container.getFinished();
        }
        nextChar = controller.readNextCharacter();
        Vector<IAttrTreeNode> attributeNodes = new Vector<IAttrTreeNode>();
        String tagName = null;
        boolean attributeIndex = false;
        while (nextChar != -1) {
            switch (nextChar) {
                case 62: {
                    if (tagName == null) {
                        controller.consumeRest();
                        controller.insertError("Tag name cannot be null");
                        return Container.getFinished();
                    }
                    controller.openTag(tagName, attributeNodes.toArray(new IAttrTreeNode[0]));
                    return Container.getBasic();
                }
                case 63: {
                    if (tagName != null) {
                        controller.consumeRest();
                        controller.insertError("Illegal start of processing instruction ");
                        return Container.getFinished();
                    }
                    return Container.getProcInstruction();
                }
                case 33: {
                    if (tagName != null) {
                        controller.consumeRest();
                        controller.insertError("Illegal start of special tag ");
                        return Container.getFinished();
                    }
                    return Container.getSpecial();
                }
                case 47: {
                    if (tagName == null) {
                        return Container.getEndTag();
                    }
                    nextChar = controller.readNextCharacter();
                    break;
                }
                case 32: {
                    nextChar = controller.readNextCharacter();
                    break;
                }
                default: {
                    ITagParserState exceptionalState = controller.provideExceptionalState(nextChar);
                    if (exceptionalState != null) {
                        return exceptionalState;
                    }
                    if (tagName == null) {
                        tagName = controller.consumeContent(this.delimiters, true).trim();
                        nextChar = controller.getLastReadCharacter();
                        break;
                    }
                    IAttrTreeNode attributeNode = controller.consumeAttribute();
                    attributeNodes.add(attributeNode);
                    nextChar = controller.getLastReadCharacter();
                }
            }
        }
        controller.insertError("Unexpected end of file !");
        return Container.getFinished();
    }
}

