/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.util.state;

import com.tssap.editors.tag.util.ITagParserController;
import com.tssap.editors.tag.util.state.Container;
import com.tssap.editors.tag.util.state.ITagParserState;
import com.tssap.editors.tag.util.state.TagParserState;
import java.io.IOException;

public class EndTag
extends TagParserState {
    private char[] delimiters = new char[]{'>'};

    public ITagParserState parse(ITagParserController controller) throws IOException {
        int nextChar = controller.getLastReadCharacter();
        if (nextChar != 47) {
            controller.consumeRest();
            controller.insertError("Incorrect starting character : " + nextChar);
            return Container.getFinished();
        }
        nextChar = controller.readNextCharacter();
        String tagName = null;
        while (nextChar != -1) {
            switch (nextChar) {
                case 32: {
                    nextChar = controller.readNextCharacter();
                    break;
                }
                case 62: {
                    if (tagName == null) {
                        controller.consumeRest();
                        controller.insertError("Empty tag name ");
                        return Container.getFinished();
                    }
                    controller.closeTag(tagName);
                    return Container.getBasic();
                }
                default: {
                    if (tagName == null) {
                        tagName = controller.consumeContent(this.delimiters, true).trim();
                        nextChar = controller.getLastReadCharacter();
                        break;
                    }
                    if (nextChar == 32) {
                        nextChar = controller.readNextCharacter();
                        break;
                    }
                    controller.consumeRest();
                    controller.insertError("End tag not correct : " + tagName);
                    return Container.getFinished();
                }
            }
        }
        controller.insertError("Unexpected end of file !");
        return Container.getFinished();
    }
}

