/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.util.node.impl;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.tag.util.ITreeNode;
import com.tssap.editors.tag.util.TreeNode;
import com.tssap.editors.tag.util.node.IRootTreeNode;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.swt.graphics.Image;

public class RootTreeNode
extends TreeNode
implements IRootTreeNode {
    public static String PREFIX = "ROOT";
    public static String SUB_ID = "";
    public static String DEFAULT_TEXT = "<.>";
    private String rootText = DEFAULT_TEXT;
    private boolean errorFlag = false;
    private static Image rootImage;
    private static Image rootErrorImage;
    private static Image rootWarningImage;

    public RootTreeNode() {
    }

    public RootTreeNode(String newRootText) {
        this();
        this.rootText = newRootText;
    }

    protected String getPrefix() {
        return "ROOT";
    }

    protected String getSubId() {
        return this.getRootText();
    }

    public String getRootText() {
        return this.rootText;
    }

    private void setRootText(String newRootText) {
        this.rootText = newRootText;
    }

    public synchronized void clearErrorFlag() {
        this.errorFlag = false;
    }

    public synchronized boolean getErrorFlag() {
        return this.errorFlag;
    }

    public synchronized void setErrorFlag() {
        this.errorFlag = true;
    }

    public boolean containsError() {
        return this.errorFlag;
    }

    public boolean intelligentEquals(ITreeNode otherNode) {
        if (super.intelligentEquals(otherNode) && otherNode instanceof IRootTreeNode) {
            IRootTreeNode otherRootNode = (IRootTreeNode)otherNode;
            if (this.getRootText().equals(otherRootNode.getRootText()) && this.containsError() == otherRootNode.containsError()) {
                return true;
            }
        }
        return false;
    }

    public void cloneNodeWeakly(ITreeNode cloneNode) {
        if (cloneNode instanceof IRootTreeNode) {
            IRootTreeNode cloneRootNode = (IRootTreeNode)cloneNode;
            this.setRootText(cloneRootNode.getRootText());
            if (cloneRootNode.containsError()) {
                this.setErrorFlag();
            } else {
                this.clearErrorFlag();
            }
        }
    }

    public Image getNodeImage() {
        Image nodeImage = null;
        if (this.containsError()) {
            if (rootErrorImage == null) {
                rootErrorImage = SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)EditorPlugin.getInstance().getDescriptor(), (String)"tag/rootError.gif");
            }
            nodeImage = rootErrorImage;
        } else {
            if (rootImage == null) {
                rootImage = SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)EditorPlugin.getInstance().getDescriptor(), (String)"tag/root.gif");
            }
            nodeImage = rootImage;
        }
        return nodeImage;
    }

    public String getNodeText() {
        return this.getRootText();
    }
}

