/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.util.node.impl;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.tag.util.ITreeNode;
import com.tssap.editors.tag.util.TreeNode;
import com.tssap.editors.tag.util.node.IProcessingTreeNode;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.swt.graphics.Image;

public class ProcessingTreeNode
extends TreeNode
implements IProcessingTreeNode {
    private String target;
    private String information;
    private static final String DEFAULT_INFORMATION = "";
    private static Image nodeImage;

    public ProcessingTreeNode(String target) {
        this(target, DEFAULT_INFORMATION);
    }

    public ProcessingTreeNode(String target, String information) {
        this.target = target;
        this.information = information;
    }

    public String getTarget() {
        return this.target;
    }

    protected String getPrefix() {
        return "COMMENT";
    }

    protected String getSubId() {
        return this.getTarget();
    }

    public boolean intelligentEquals(ITreeNode otherNode) {
        if (super.intelligentEquals(otherNode) && otherNode instanceof IProcessingTreeNode) {
            IProcessingTreeNode node = (IProcessingTreeNode)otherNode;
            if (this.getTarget().equals(node.getTarget()) && this.getInformation().equals(node.getInformation())) {
                return true;
            }
        }
        return false;
    }

    public String getInformation() {
        return this.information;
    }

    public Image getNodeImage() {
        if (nodeImage == null) {
            nodeImage = SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)EditorPlugin.getInstance().getDescriptor(), (String)"tag/processing.gif");
        }
        return nodeImage;
    }

    public String getNodeText() {
        return this.getTarget();
    }
}

