/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.util.node.impl;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.tag.util.ITreeNode;
import com.tssap.editors.tag.util.TreeNode;
import com.tssap.editors.tag.util.node.IErrorTreeNode;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.swt.graphics.Image;

public class ErrorTreeNode
extends TreeNode
implements IErrorTreeNode {
    private String errorMessage;
    private boolean onlyWarning;
    private static Image errorImage = SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)EditorPlugin.getInstance().getDescriptor(), (String)"tag/error.gif");
    private static Image warningImage = SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)EditorPlugin.getInstance().getDescriptor(), (String)"tag/warning.gif");

    public ErrorTreeNode(String message) {
        this(message, false);
    }

    public ErrorTreeNode(String message, boolean onlyWarning) {
        this.errorMessage = message;
        this.onlyWarning = onlyWarning;
    }

    public String getText() {
        return this.errorMessage;
    }

    protected String getPrefix() {
        return "ERROR_OR_WARNING";
    }

    protected String getSubId() {
        return this.getText();
    }

    public boolean intelligentEquals(ITreeNode otherNode) {
        if (super.intelligentEquals(otherNode) && otherNode instanceof IErrorTreeNode) {
            IErrorTreeNode errorNode = (IErrorTreeNode)otherNode;
            if (this.getText().equals(errorNode.getText())) {
                return true;
            }
        }
        return false;
    }

    public Image getNodeImage() {
        if (this.isOnlyWarning()) {
            return warningImage;
        }
        return errorImage;
    }

    public String getNodeText() {
        return this.getText();
    }

    public boolean isOnlyWarning() {
        return this.onlyWarning;
    }
}

