/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.util;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.tag.TagEditor;
import com.tssap.editors.tag.ui.OutlinePageTreeModel;
import com.tssap.editors.tag.util.ITagParserController;
import com.tssap.editors.tag.util.node.IAttrTreeNode;
import com.tssap.editors.tag.util.node.IElementTreeNode;
import com.tssap.editors.tag.util.node.IRootTreeNode;
import com.tssap.editors.tag.util.node.impl.AttrTreeNode;
import com.tssap.editors.tag.util.node.impl.CommentTreeNode;
import com.tssap.editors.tag.util.node.impl.ElementTreeNode;
import com.tssap.editors.tag.util.node.impl.ErrorTreeNode;
import com.tssap.editors.tag.util.node.impl.ProcessingTreeNode;
import com.tssap.editors.tag.util.node.impl.RootTreeNode;
import com.tssap.editors.tag.util.node.impl.SectionTreeNode;
import com.tssap.editors.tag.util.node.impl.SpecialTreeNode;
import com.tssap.editors.tag.util.node.impl.TextTreeNode;
import com.tssap.editors.tag.util.state.ITagParserState;
import com.tssap.editors.util.SrcLocation;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.eclipse.jface.preference.IPreferenceStore;

public class DefaultParserController
implements ITagParserController {
    public static final boolean DEFAULT_IGNORE_CASE_FLAG = true;
    public static final boolean DEFAULT_TRIM_WS_FLAG = true;
    protected static final boolean trace = TagEditor.getTracer().info();
    private LineNumberReader reader;
    private Stack tagStack;
    private Vector stringPartitions;
    private StringBuffer inputBuffer;
    private String rootTagName;
    private boolean ignoringCase = false;
    private boolean trimmingWhitespaces = false;
    private boolean containsError;
    private Boolean splitAttributes;
    private int lastReadCharacter;
    private int numberOfReadCharacters = 0;
    private int numberOfConvertedCharacters = 0;
    private boolean parserInitialized = false;

    protected LineNumberReader getReader() {
        return this.reader;
    }

    public int readNextCharacter() throws IOException {
        LineNumberReader reader = this.getReader();
        reader.mark(1);
        int nextChar = reader.read();
        if (trace) {
            System.out.print("." + (char)nextChar);
        }
        ++this.numberOfReadCharacters;
        if (nextChar != -1 && this.isTrimmingWhitespaces() && Character.isWhitespace((char)this.getLastReadCharacter())) {
            while (Character.isWhitespace((char)nextChar)) {
                reader.mark(1);
                nextChar = reader.read();
                if (trace) {
                    System.out.print("+" + (char)nextChar);
                }
                ++this.numberOfReadCharacters;
            }
        }
        if (this.isTrimmingWhitespaces() && Character.isWhitespace((char)nextChar)) {
            nextChar = 32;
            if (trace) {
                System.out.print(">>");
            }
        }
        this.setLastReadCharacter(nextChar);
        if (nextChar != -1) {
            this.getInputBuffer().append((char)nextChar);
            ++this.numberOfConvertedCharacters;
        }
        return nextChar;
    }

    public void resetLastReadCharacter() throws IOException {
        StringBuffer inputBuffer;
        LineNumberReader reader = this.getReader();
        reader.reset();
        --this.numberOfReadCharacters;
        if (trace) {
            System.out.print("--");
        }
        if ((inputBuffer = this.getInputBuffer()).length() > 0) {
            inputBuffer.deleteCharAt(inputBuffer.length() - 1);
            --this.numberOfConvertedCharacters;
        }
    }

    public IAttrTreeNode consumeAttribute() throws IOException {
        int readChar = this.getLastReadCharacter();
        StringBuffer attributeNameBuffer = new StringBuffer("");
        StringBuffer attributeValueBuffer = new StringBuffer("");
        while (readChar != -1 && readChar != 61 && readChar != 62) {
            attributeNameBuffer.append((char)readChar);
            readChar = this.readNextCharacter();
        }
        if (readChar != 62) {
            readChar = this.readNextCharacter();
            while (readChar == 32) {
                readChar = this.readNextCharacter();
            }
            int valueDelimiter = 32;
            if (readChar == 39 || readChar == 34) {
                valueDelimiter = readChar;
                readChar = this.readNextCharacter();
            }
            while (readChar != -1 && readChar != valueDelimiter && (readChar != 62 || valueDelimiter != 32)) {
                attributeValueBuffer.append((char)readChar);
                readChar = this.readNextCharacter();
            }
            if (readChar == valueDelimiter) {
                readChar = this.readNextCharacter();
            }
        }
        String attributeName = attributeNameBuffer.toString().trim();
        String attributeValue = attributeValueBuffer.toString().trim();
        AttrTreeNode attrNode = new AttrTreeNode(attributeName, attributeValue);
        this.addLocationToNode(attrNode);
        return attrNode;
    }

    public String consumeContent(char[] delimiters, boolean includingWhitespace) throws IOException {
        String delimiterSet = new String(delimiters);
        int readChar = this.getLastReadCharacter();
        StringBuffer contentBuffer = new StringBuffer();
        while (!(readChar == -1 || delimiterSet.indexOf(readChar) >= 0 || includingWhitespace && Character.isWhitespace((char)readChar))) {
            contentBuffer.append((char)readChar);
            readChar = this.readNextCharacter();
        }
        String content = contentBuffer.toString();
        return content;
    }

    public String consumeContent(char delimiter, boolean includingWhitespace) throws IOException {
        return this.consumeContent(new char[]{delimiter}, includingWhitespace);
    }

    public String consumeContent(String delimiterString) throws IOException {
        int matchedPosition = 0;
        int readChar = this.getLastReadCharacter();
        StringBuffer contentBuffer = new StringBuffer();
        while (readChar != -1 && matchedPosition < delimiterString.length()) {
            char realChar = (char)readChar;
            contentBuffer.append((char)readChar);
            matchedPosition = realChar == delimiterString.charAt(matchedPosition) ? ++matchedPosition : 0;
            if (matchedPosition >= delimiterString.length()) continue;
            readChar = this.readNextCharacter();
        }
        String content = contentBuffer.toString();
        if (content.endsWith(delimiterString)) {
            content = content.substring(0, content.length() - delimiterString.length());
        }
        return content;
    }

    public void consumeRest() throws IOException {
        int readChar = this.getLastReadCharacter();
        while (readChar != -1) {
            readChar = this.readNextCharacter();
        }
    }

    protected Stack getTagStack() {
        if (this.tagStack == null) {
            this.tagStack = new Stack();
        }
        return this.tagStack;
    }

    protected Vector getStringPartitions() {
        if (this.stringPartitions == null) {
            this.stringPartitions = new Vector();
        }
        return this.stringPartitions;
    }

    protected StringBuffer getInputBuffer() {
        if (this.inputBuffer == null) {
            this.inputBuffer = new StringBuffer();
        }
        return this.inputBuffer;
    }

    protected String retrieveInputString() {
        String inputString = this.getInputBuffer().toString();
        this.inputBuffer = null;
        return inputString;
    }

    public void initializeController(LineNumberReader reader) {
        if (this.isParserInitialized()) {
            throw new IllegalStateException("Controller is already initialized !");
        }
        this.reader = reader;
        this.ignoringCase = true;
        this.trimmingWhitespaces = true;
        this.containsError = false;
        this.tagStack = null;
        this.inputBuffer = null;
        this.stringPartitions = null;
        this.numberOfConvertedCharacters = 0;
        this.numberOfReadCharacters = 0;
        this.lastReadCharacter = 0;
        this.setParserInitialized(true);
    }

    public OutlinePageTreeModel finalizeControllerAsTreeModel(String rootTagName) {
        this.checkInitialization();
        RootTreeNode rootNode = new RootTreeNode(rootTagName);
        if (this.containsError) {
            rootNode.setErrorFlag();
        }
        while (!this.getTagStack().empty()) {
            TagStackItem item = (TagStackItem)this.getTagStack().pop();
            rootNode.insert(item.getNode(), 0);
        }
        OutlinePageTreeModel parsedModel = new OutlinePageTreeModel(rootNode);
        this.setParserInitialized(false);
        return parsedModel;
    }

    public String finalizeControllerAsFormattedString() {
        String tabCharacter = null;
        IPreferenceStore prefStore = EditorPlugin.getInstance().getPreferenceStore();
        if (prefStore.getBoolean("tag_format_usespaces")) {
            int numOfSpaces = prefStore.getInt("tag_format_spacespertab");
            char[] spaceArray = new char[numOfSpaces];
            Arrays.fill(spaceArray, ' ');
            tabCharacter = new String(spaceArray);
        } else {
            tabCharacter = "\t";
        }
        return this.finalizeControllerAsFormattedString(tabCharacter);
    }

    public String finalizeControllerAsFormattedString(String tabCharacter) {
        this.checkInitialization();
        StringBuffer outputBuffer = new StringBuffer(this.getNumberOfConvertedCharacters());
        int initialLevel = 0;
        if (this.getStringPartitions().size() > 0) {
            PartitionVectorItem firstItem = (PartitionVectorItem)this.getStringPartitions().firstElement();
            initialLevel = firstItem.getNode().getLevel();
        }
        boolean lineNumber = false;
        String newLine = System.getProperty("line.separator", "\n");
        Enumeration vecItemEnum = this.getStringPartitions().elements();
        while (vecItemEnum.hasMoreElements()) {
            PartitionVectorItem item = (PartitionVectorItem)vecItemEnum.nextElement();
            DefaultMutableTreeNode itemNode = item.getNode();
            String itemString = item.getPartitionString();
            int level = itemNode.getLevel();
            String formatPartString = this.formatPartition(itemString, itemNode, tabCharacter, newLine, level -= initialLevel);
            outputBuffer.append(formatPartString);
        }
        outputBuffer.append(newLine);
        if (outputBuffer.substring(0, newLine.length()).equals(newLine)) {
            outputBuffer.delete(0, newLine.length());
        }
        String formattedString = outputBuffer.toString();
        this.setParserInitialized(false);
        return formattedString;
    }

    private int countOcurrences(String whole, String part) {
        int countNumber = 0;
        int position = 0;
        int partLength = part.length();
        int wholeLength = whole.length();
        while (position <= wholeLength - partLength) {
            String subString = whole.substring(position, position + partLength);
            if (subString.equals(part)) {
                position += partLength;
                ++countNumber;
                continue;
            }
            ++position;
        }
        return countNumber;
    }

    protected String formatPartition(String partitionString, DefaultMutableTreeNode partitionNode, String tabCharacters, String newLine, int depth) {
        StringBuffer workingBuffer = new StringBuffer(partitionString.length());
        if (!(partitionNode instanceof IRootTreeNode)) {
            workingBuffer.append(newLine);
        }
        int localDepth = depth;
        while (localDepth-- > 0) {
            workingBuffer.append(tabCharacters);
        }
        if (partitionNode instanceof IElementTreeNode) {
            StringBuffer partStringBuf = new StringBuffer(partitionString);
            int charPos = 0;
            while (charPos < partStringBuf.length()) {
                int nextChar;
                int lastChar;
                char currentChar = partStringBuf.charAt(charPos);
                if (Character.isWhitespace(currentChar)) {
                    currentChar = ' ';
                    partStringBuf.setCharAt(charPos, currentChar);
                }
                if (currentChar == '\"' || currentChar == '\'') {
                    char aimedEndChar = currentChar;
                    ++charPos;
                    while (charPos < partStringBuf.length() && partStringBuf.charAt(charPos) != aimedEndChar) {
                        ++charPos;
                    }
                }
                if (currentChar == ' ') {
                    lastChar = charPos > 0 ? (int)partStringBuf.charAt(charPos - 1) : 42;
                    int n = nextChar = charPos < partStringBuf.length() ? (int)partStringBuf.charAt(charPos + 1) : 42;
                    if (lastChar == 32 || lastChar == 60 || nextChar == 62) {
                        partStringBuf.deleteCharAt(charPos);
                        continue;
                    }
                    ++charPos;
                    continue;
                }
                if (currentChar == '=') {
                    int n = lastChar = charPos > 0 ? (int)partStringBuf.charAt(charPos - 1) : 42;
                    if (lastChar == 32) {
                        partStringBuf.deleteCharAt(charPos - 1);
                        --charPos;
                    }
                    int n2 = nextChar = charPos < partStringBuf.length() ? (int)partStringBuf.charAt(charPos + 1) : 42;
                    if (nextChar == 32) {
                        partStringBuf.deleteCharAt(charPos + 1);
                    }
                    ++charPos;
                    continue;
                }
                ++charPos;
            }
            IPreferenceStore prefStore = EditorPlugin.getInstance().getPreferenceStore();
            if (prefStore.getBoolean("tag_format_attrib_newline")) {
                int attDepth = depth + 1;
                String lineStart = newLine;
                while (attDepth-- > 0) {
                    lineStart = lineStart + tabCharacters;
                }
                charPos = 0;
                while (charPos < partStringBuf.length()) {
                    char currentChar = partStringBuf.charAt(charPos);
                    if (currentChar == '\"' || currentChar == '\'') {
                        char aimedEndChar = currentChar;
                        ++charPos;
                        while (charPos < partStringBuf.length() && partStringBuf.charAt(charPos) != aimedEndChar) {
                            ++charPos;
                        }
                    }
                    if (currentChar == ' ') {
                        partStringBuf.insert(charPos + 1, lineStart);
                        charPos += lineStart.length() + 1;
                        continue;
                    }
                    ++charPos;
                }
            }
            workingBuffer.append(partStringBuf.toString());
        } else {
            workingBuffer.append(partitionString);
        }
        return workingBuffer.toString();
    }

    protected void checkInitialization() throws IllegalStateException {
        if (!this.isParserInitialized()) {
            throw new IllegalStateException("Controller has not been initialized yet !");
        }
    }

    protected void addLocationToNode(DefaultMutableTreeNode treeNode) {
        int lineNumber = this.getReader().getLineNumber();
        this.addLocationToNode(treeNode, lineNumber);
    }

    protected void addLocationToNode(DefaultMutableTreeNode treeNode, int lineNumber) {
        int colNumber = 0;
        SrcLocation location = new SrcLocation(lineNumber, colNumber, lineNumber, colNumber);
        treeNode.setUserObject(location);
    }

    public DefaultMutableTreeNode openTag(String tagName, IAttrTreeNode[] attributeNodes) throws IllegalStateException {
        this.checkInitialization();
        if (trace) {
            System.out.println("\n OPEN: " + tagName + " number of atts = " + attributeNodes.length);
        }
        ElementTreeNode newNode = new ElementTreeNode(tagName);
        this.addLocationToNode(newNode);
        int n = 0;
        while (n < attributeNodes.length) {
            IAttrTreeNode attrNode = attributeNodes[n];
            newNode.add(attrNode);
            ++n;
        }
        TagStackItem newItem = new TagStackItem(tagName, newNode);
        this.getTagStack().push(newItem);
        String partition = this.retrieveInputString();
        PartitionVectorItem vecItem = new PartitionVectorItem(partition, newNode);
        this.getStringPartitions().add(vecItem);
        return newNode;
    }

    public DefaultMutableTreeNode closeTag(String tagName) throws IllegalStateException {
        this.checkInitialization();
        if (trace) {
            System.out.println("\n CLOSE: " + tagName);
        }
        DefaultMutableTreeNode foundNode = null;
        Vector<DefaultMutableTreeNode> childNodes = new Vector<DefaultMutableTreeNode>();
        while (foundNode == null && !this.getTagStack().empty()) {
            boolean isEqual;
            TagStackItem item = (TagStackItem)this.getTagStack().peek();
            String itemName = item.getName();
            boolean bl = isEqual = this.isIgnoringCase() ? itemName.equalsIgnoreCase(tagName) : itemName.equals(tagName);
            if (isEqual) {
                foundNode = item.getNode();
                continue;
            }
            childNodes.add(0, item.getNode());
            this.getTagStack().pop();
        }
        if (foundNode == null) {
            foundNode = new ElementTreeNode(tagName);
            this.addLocationToNode(foundNode);
            TagStackItem foundNodeItem = new TagStackItem(tagName, foundNode);
            this.getTagStack().push(foundNodeItem);
        }
        Enumeration childEnum = childNodes.elements();
        while (childEnum.hasMoreElements()) {
            MutableTreeNode childNode = (MutableTreeNode)childEnum.nextElement();
            foundNode.add(childNode);
        }
        String partition = this.retrieveInputString();
        PartitionVectorItem vecItem = new PartitionVectorItem(partition, foundNode);
        this.getStringPartitions().add(vecItem);
        return foundNode;
    }

    public DefaultMutableTreeNode insertError(String errorMessage) throws IllegalStateException {
        this.checkInitialization();
        if (trace) {
            System.out.println("\n ERROR: " + errorMessage);
        }
        ErrorTreeNode errorNode = new ErrorTreeNode(errorMessage);
        this.addLocationToNode(errorNode);
        TagStackItem newItem = new TagStackItem("<ERROR>", errorNode);
        this.getTagStack().push(newItem);
        String partition = this.retrieveInputString();
        PartitionVectorItem vecItem = new PartitionVectorItem(partition, errorNode);
        this.getStringPartitions().add(vecItem);
        this.setErrorFlag(true);
        return errorNode;
    }

    public DefaultMutableTreeNode insertProcessing(String procInstTarget) throws IllegalStateException {
        this.checkInitialization();
        if (trace) {
            System.out.println("\n PI: " + procInstTarget);
        }
        ProcessingTreeNode procInstNode = new ProcessingTreeNode(procInstTarget);
        this.addLocationToNode(procInstNode);
        TagStackItem newItem = new TagStackItem("<?" + procInstTarget, procInstNode);
        this.getTagStack().push(newItem);
        String partition = this.retrieveInputString();
        PartitionVectorItem vecItem = new PartitionVectorItem(partition, procInstNode);
        this.getStringPartitions().add(vecItem);
        return procInstNode;
    }

    public DefaultMutableTreeNode insertComment(String commentText) throws IllegalStateException {
        this.checkInitialization();
        if (trace) {
            System.out.println("\n COMMENT: " + commentText);
        }
        CommentTreeNode commentNode = new CommentTreeNode(commentText);
        this.addLocationToNode(commentNode);
        TagStackItem stackItem = new TagStackItem("<--", commentNode);
        this.getTagStack().push(stackItem);
        String partition = this.retrieveInputString();
        PartitionVectorItem vecItem = new PartitionVectorItem(partition, commentNode);
        this.getStringPartitions().add(vecItem);
        return commentNode;
    }

    public DefaultMutableTreeNode insertSpecial(String type, String text) throws IllegalStateException {
        this.checkInitialization();
        if (trace) {
            System.out.println("\n SPECIAL: " + type + " - " + text);
        }
        SpecialTreeNode specialNode = new SpecialTreeNode(type, text);
        this.addLocationToNode(specialNode);
        TagStackItem newItem = new TagStackItem("<[" + type, specialNode);
        this.getTagStack().push(newItem);
        String partition = this.retrieveInputString();
        PartitionVectorItem vecItem = new PartitionVectorItem(partition, specialNode);
        this.getStringPartitions().add(vecItem);
        return specialNode;
    }

    public DefaultMutableTreeNode insertText(String itext) throws IllegalStateException {
        this.checkInitialization();
        if (trace) {
            System.out.println("\n TEXT: " + itext);
        }
        TextTreeNode textNode = null;
        String newText = itext.trim();
        if (!newText.equals("")) {
            textNode = new TextTreeNode(newText);
            this.addLocationToNode(textNode);
            TagStackItem newItem = new TagStackItem("%TEXT%", textNode);
            this.getTagStack().push(newItem);
        }
        String partition = this.retrieveInputString();
        if (this.isTrimmingWhitespaces()) {
            partition = partition.trim();
        }
        if (textNode != null && !partition.equals("")) {
            PartitionVectorItem vecItem = new PartitionVectorItem(partition, textNode);
            this.getStringPartitions().add(vecItem);
        }
        return textNode;
    }

    public DefaultMutableTreeNode insertSection(String sectionText) throws IllegalStateException {
        this.checkInitialization();
        if (trace) {
            System.out.println("\n SECTION: " + sectionText);
        }
        SectionTreeNode sectionNode = null;
        if (!sectionText.equals("")) {
            sectionNode = new SectionTreeNode(sectionText);
            this.addLocationToNode(sectionNode);
            TagStackItem newItem = new TagStackItem("<SECTION>", sectionNode);
            this.getTagStack().push(newItem);
        }
        String partition = this.retrieveInputString().trim();
        if (sectionNode != null && !partition.equals("")) {
            PartitionVectorItem vecItem = new PartitionVectorItem(partition, sectionNode);
            this.getStringPartitions().add(vecItem);
        }
        return sectionNode;
    }

    public boolean isIgnoringCase() {
        return this.ignoringCase;
    }

    public void setIgnoringCase(boolean ignoreFlag) {
        this.ignoringCase = ignoreFlag;
    }

    public boolean isTrimmingWhitespaces() {
        return this.trimmingWhitespaces;
    }

    public void setTrimmingWhitespaces(boolean trimFlag) {
        this.trimmingWhitespaces = trimFlag;
    }

    public boolean isParserInitialized() {
        return this.parserInitialized;
    }

    protected void setParserInitialized(boolean parserInitialized) {
        this.parserInitialized = parserInitialized;
    }

    protected boolean isContainingError() {
        return this.containsError;
    }

    protected void setErrorFlag(boolean errorFlag) {
        this.containsError = errorFlag;
    }

    public int getLastReadCharacter() {
        return this.lastReadCharacter;
    }

    private void setLastReadCharacter(int lastReadCharacter) {
        this.lastReadCharacter = lastReadCharacter;
    }

    public int getNumberOfReadCharacters() {
        return this.numberOfReadCharacters;
    }

    public int getNumberOfConvertedCharacters() {
        return this.numberOfConvertedCharacters;
    }

    public ITagParserState provideExceptionalState(int readCharacter) {
        return null;
    }

    public boolean isSplitAttributes() {
        if (this.splitAttributes == null) {
            IPreferenceStore prefStore = EditorPlugin.getInstance().getPreferenceStore();
            this.splitAttributes = prefStore.getBoolean("tag_format_attrib_newline") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.splitAttributes;
    }

    protected class PartitionVectorItem {
        private String partitionString;
        private DefaultMutableTreeNode node;

        public PartitionVectorItem(String partitionString, DefaultMutableTreeNode node) {
            this.partitionString = partitionString;
            this.node = node;
        }

        public DefaultMutableTreeNode getNode() {
            return this.node;
        }

        public String getPartitionString() {
            return this.partitionString;
        }
    }

    protected class TagStackItem {
        private String name;
        private DefaultMutableTreeNode node;

        public TagStackItem(String name, DefaultMutableTreeNode node) {
            this.name = name.trim();
            this.node = node;
        }

        public String getName() {
            return this.name;
        }

        public DefaultMutableTreeNode getNode() {
            return this.node;
        }
    }
}

