/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.ui;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.Messages;
import com.tssap.editors.tag.TagEditor;
import com.tssap.editors.tag.preferences.IPropertyDefaults;
import com.tssap.editors.tag.ui.internal.StatusInfo;
import com.tssap.editors.tag.ui.internal.StatusUtil;
import com.tssap.editors.tag.util.DocumentProvider;
import com.tssap.editors.util.ColorButton;
import com.tssap.editors.util.PreferencesUtil;
import com.tssap.editors.xml.source.XmlSourceViewerConfiguration;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TagPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore fPluginPreferenceStore;
    private IPreferenceStore fTmpPreferenceStore;
    private Combo fTokenList;
    private ColorButton fForegroundColorEditor;
    private Button fBoldCheckBox;
    private SourceViewer fPreviewViewer;
    private final String[][] fListModel = new String[][]{{"Processing instructions", "color_processing"}, {"Default Text", "color_default"}, {"Definitions", "color_definition"}, {"Comments", "color_comment"}, {"Tags", "color_tag"}, {"Strings", "color_string"}, {"Entities", "color_entity"}};
    private Button fAttribNewline;
    private Button fUsesSpace;
    private Text fNmberTextField;
    private Text fTabWidthTextField;
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            TagPreferencePage.this.fTmpPreferenceStore.setValue((String)TagPreferencePage.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TagPreferencePage.this.numberFieldChanged((Text)e.widget);
        }
    };
    private static final String BOLD_EXT = "_bold";
    private static final PreferencesUtil.OverlayKey[] fKeyList = new PreferencesUtil.OverlayKey[]{new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "color_comment"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "color_comment_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "color_default"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "color_default_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "color_definition"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "color_definition_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "color_entity"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "color_entity_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "color_processing"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "color_processing_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "color_string"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "color_string_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "color_tag"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "color_tag_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "tag_format_attrib_newline"), new PreferencesUtil.OverlayKey(PreferencesUtil.INT, "tag_format_tabsize"), new PreferencesUtil.OverlayKey(PreferencesUtil.INT, "tag_format_spacespertab"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "tag_format_usespaces")};

    public static final PreferencesUtil.OverlayKey[] getKeyList() {
        return fKeyList;
    }

    public TagPreferencePage() {
        this.setDescription("XML/HTML Editor settings");
        this.fPluginPreferenceStore = EditorPlugin.getInstance().getPreferenceStore();
        this.fTmpPreferenceStore = EditorPlugin.getInstance().getTmpPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        ITabbedPane pane = PaneFactory.createTabbedPane((Composite)parent);
        IGridLayoutPane colorPane = pane.addGridLayoutPaneAsTab("Color", 1);
        IGridLayoutPane formatPane = pane.addGridLayoutPaneAsTab("Formatting", 1);
        this.createColorPage(colorPane);
        this.createFormatPage(formatPane);
        this.initialize();
        return pane.getComposite();
    }

    private void createColorPage(IGridLayoutPane parent) {
        IGridLayoutPane colorPane = parent.addGridLayoutPane("Color settings", 4, parent.createGridLayoutData(4, 1, true, false));
        colorPane.addTextLabel("Foreground");
        colorPane.addTextLabel("Color");
        colorPane.addTextLabel("Bold", colorPane.createGridLayoutData(1, 1, 2, 1));
        this.fTokenList = colorPane.addComboBox(new String[0], true);
        this.fForegroundColorEditor = new ColorButton(colorPane, colorPane.createGridLayoutData(1, 1, 1, 1));
        this.fBoldCheckBox = colorPane.addCheckBox("    ");
        IGridLayoutPane previewPane = parent.addGridLayoutPane("Preview", 1, parent.createGridLayoutData(4, 4, true, true));
        ISimplePane simplePane = previewPane.addSimplePane(previewPane.createGridLayoutData(4, 4, true, true));
        this.createPreviewer(simplePane.getComposite());
        this.fTokenList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TagPreferencePage.this.handleListSelection();
            }
        });
        this.fForegroundColorEditor.getButton().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = TagPreferencePage.this.fTokenList.getSelectionIndex();
                String key = TagPreferencePage.this.fListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)TagPreferencePage.this.fTmpPreferenceStore, (String)key, (RGB)TagPreferencePage.this.fForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = TagPreferencePage.this.fTokenList.getSelectionIndex();
                String key = TagPreferencePage.this.fListModel[i][1];
                TagPreferencePage.this.fTmpPreferenceStore.setValue(key + "_" + "bold", TagPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
    }

    private void createFormatPage(IGridLayoutPane parent) {
        IGridLayoutPane formatPane = parent.addGridLayoutPane("Formatting settings", 2, parent.createGridLayoutData(4, 1, true, true));
        formatPane.addTextLabel("Use spaces instead of tabs", formatPane.createGridLayoutData(1, 1, 1, 1));
        this.fUsesSpace = formatPane.addCheckBox("", this.fTmpPreferenceStore.getBoolean("tag_format_usespaces"), formatPane.createGridLayoutData(1, 1, 1, 1));
        this.fNmberTextField = this.addTextField(formatPane, "Number of spaces per tab", "tag_format_spacespertab", 5, 0, true);
        this.fTabWidthTextField = this.addTextField(formatPane, "Tab width", "tag_format_tabsize", 5, 0, true);
        this.fUsesSpace.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean custom = TagPreferencePage.this.fUsesSpace.getSelection();
                TagPreferencePage.this.fTmpPreferenceStore.setValue("tag_format_usespaces", custom);
                TagPreferencePage.this.handleFormatFields();
            }
        });
        formatPane.addTextLabel("Place each attribute on a separate line", formatPane.createGridLayoutData(1, 1, 1, 1));
        this.fAttribNewline = formatPane.addCheckBox("", this.fTmpPreferenceStore.getBoolean("tag_format_attrib_newline"), formatPane.createGridLayoutData(1, 1, 1, 1));
        this.fAttribNewline.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean custom = TagPreferencePage.this.fAttribNewline.getSelection();
                TagPreferencePage.this.fTmpPreferenceStore.setValue("tag_format_attrib_newline", custom);
            }
        });
    }

    private Control createPreviewer(Composite parent) {
        this.fPreviewViewer = new SourceViewer(parent, null, 768);
        this.fPreviewViewer.configure((SourceViewerConfiguration)new XmlSourceViewerConfiguration(this.fTmpPreferenceStore, null));
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("PreviewCode.txt");
        DocumentProvider provider = new DocumentProvider();
        IDocument document = null;
        try {
            document = provider.createDocument(content);
        }
        catch (CoreException e) {
            // empty catch block
        }
        this.fPreviewViewer.setDocument(document);
        final PreviewerPropertyChangeListener listener = new PreviewerPropertyChangeListener();
        this.fTmpPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)listener);
        this.fPreviewViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TagPreferencePage.this.fTmpPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)listener);
            }
        });
        this.initializeViewerColors((ISourceViewer)this.fPreviewViewer);
        return this.fPreviewViewer.getControl();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String loadPreviewContentFromFile(String filename) {
        String line;
        String separator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer(512);
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
        while ((line = reader.readLine()) != null) {
            void var2_5;
            buffer.append((String)var2_5);
            buffer.append(separator);
        }
        Object var8_6 = null;
        if (reader == null) return buffer.toString();
        try {
            reader.close();
            return buffer.toString();
        }
        catch (IOException e) {}
        return buffer.toString();
        {
            catch (IOException io) {
                TagEditor.getTracer().error("loadPreviewContentFromFile(String filename)", io.getMessage(), (Throwable)io);
                Object var8_7 = null;
                if (reader == null) return buffer.toString();
                try {
                    reader.close();
                    return buffer.toString();
                }
                catch (IOException e) {}
                return buffer.toString();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void handleListSelection() {
        int i = this.fTokenList.getSelectionIndex();
        String key = this.fListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fTmpPreferenceStore, (String)key);
        this.fForegroundColorEditor.setColorValue(rgb);
        boolean selected = this.fTmpPreferenceStore.getBoolean(key + "_" + "bold");
        this.fBoldCheckBox.setSelection(selected);
    }

    private void handleFormatFields() {
        boolean custom = this.fUsesSpace.getSelection();
        this.fNmberTextField.setEditable(custom);
        this.fTabWidthTextField.setEditable(false);
    }

    private Text addTextField(IGridLayoutPane pane, String label, String key, int textLimit, int indentation, boolean isNumber) {
        IGridLayoutData layout = pane.createGridLayoutData(1, 1);
        layout.getGridData().horizontalIndent = indentation;
        pane.addTextLabel(label, layout);
        layout = pane.createGridLayoutData(1, 1);
        layout.getGridData().widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        Text textControl = pane.addTextField("", false, layout);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fTmpPreferenceStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(Messages.getString("PreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(Messages.getFormattedString("PreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException e) {
                status.setError(Messages.getFormattedString("PreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    private void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = StatusUtil.getMoreSevere(s, status);
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    private void initializeViewerColors(ISourceViewer viewer) {
        StyledText styledText = viewer.getTextWidget();
        Color color = this.fTmpPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : new Color((Device)styledText.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)this.fTmpPreferenceStore, (String)"AbstractTextEditor.Color.Background"));
        styledText.setBackground(color);
    }

    public static void initializeDefaults(IPreferenceStore store) {
        String bold_ext = BOLD_EXT;
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_processing", (RGB)IPropertyDefaults.COLOR_PROCESSING_FG);
        store.setDefault("color_processing" + bold_ext, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_definition", (RGB)IPropertyDefaults.COLOR_DEFINITION_FG);
        store.setDefault("color_definition" + bold_ext, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_comment", (RGB)IPropertyDefaults.COLOR_COMMENT_FG);
        store.setDefault("color_comment" + bold_ext, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_tag", (RGB)IPropertyDefaults.COLOR_TAG_FG);
        store.setDefault("color_tag" + bold_ext, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_string", (RGB)IPropertyDefaults.COLOR_STRING_FG);
        store.setDefault("color_string" + bold_ext, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_entity", (RGB)IPropertyDefaults.COLOR_ENTITY_FG);
        store.setDefault("color_entity" + bold_ext, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_default", (RGB)IPropertyDefaults.COLOR_DEFAULT_FG);
        store.setDefault("color_default" + bold_ext, false);
        store.setDefault("tag_format_attrib_newline", true);
        store.setDefault("tag_format_tabsize", 4);
        store.setDefault("tag_format_spacespertab", 4);
        store.setDefault("tag_format_usespaces", false);
    }

    private void initialize() {
        int i = 0;
        while (i < this.fListModel.length) {
            this.fTokenList.add(this.fListModel[i][0]);
            ++i;
        }
        this.fTokenList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                TagPreferencePage.this.fTokenList.select(0);
                TagPreferencePage.this.handleListSelection();
                TagPreferencePage.this.handleFormatFields();
            }
        });
        Iterator e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            String key = (String)this.fTextFields.get(t);
            String value = this.fTmpPreferenceStore.getString(key);
            t.setText(value);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        PreferencesUtil.setToDefault(this.fTmpPreferenceStore, fKeyList);
        this.handleListSelection();
        this.fPreviewViewer.invalidateTextPresentation();
        this.fUsesSpace.setSelection(this.fTmpPreferenceStore.getBoolean("tag_format_usespaces"));
        this.fAttribNewline.setSelection(this.fTmpPreferenceStore.getBoolean("tag_format_attrib_newline"));
        this.fNmberTextField.setText(this.fTmpPreferenceStore.getString("tag_format_spacespertab"));
        this.fTabWidthTextField.setText(this.fTmpPreferenceStore.getString("tag_format_tabsize"));
        this.handleFormatFields();
    }

    public boolean performOk() {
        PreferencesUtil.copyStore(this.fTmpPreferenceStore, this.fPluginPreferenceStore, fKeyList, false);
        return super.performOk();
    }

    private class PreviewerPropertyChangeListener
    implements IPropertyChangeListener {
        private PreviewerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String p = event.getProperty();
            if (p.equals("AbstractTextEditor.Color.Background") || p.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
                TagPreferencePage.this.initializeViewerColors((ISourceViewer)TagPreferencePage.this.fPreviewViewer);
            }
            TagPreferencePage.this.fPreviewViewer.invalidateTextPresentation();
        }
    }
}

