/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.ui;

import com.tssap.editors.tag.ui.OutlinePageTreeModel;
import com.tssap.editors.tag.util.ITreeNode;
import com.tssap.editors.tag.util.TreeNode;
import com.tssap.editors.tag.util.node.IRootTreeNode;
import com.tssap.util.ui.viewer.tree.ISapTreeViewer;
import com.tssap.util.ui.viewer.tree.SapTreeLabelProvider;
import com.tssap.util.ui.viewer.tree.SapTreeViewer;
import java.util.Enumeration;
import javax.swing.tree.TreeModel;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class OutlinePage
extends ContentOutlinePage {
    private static final int DEFAULT_ROOT_LAYER = 0;
    private ISapTreeViewer outlinePageTreeViewer;
    private OutlinePageTreeModel outlinePageTreeModel;
    private static XmlNullNode nullNode = new XmlNullNode();

    public OutlinePage(OutlinePageTreeModel intitialTreeModel) {
        this.outlinePageTreeModel = intitialTreeModel;
    }

    public OutlinePageTreeModel getTreeModel() {
        return this.outlinePageTreeModel;
    }

    private void setTreeModel(OutlinePageTreeModel xmlOutlinePageTreeModel) {
        this.outlinePageTreeModel = xmlOutlinePageTreeModel;
        if (this.outlinePageTreeViewer != null) {
            this.outlinePageTreeViewer.setTreeModel((TreeModel)xmlOutlinePageTreeModel);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.outlinePageTreeViewer = SapTreeViewer.createTreeViewer((TreeViewer)this.getTreeViewer(), (TreeModel)this.getTreeModel(), (int)0, (SapTreeLabelProvider)new OutlinePageTreeLabelProvider());
        this.outlinePageTreeViewer.getTreeViewer().expandAll();
        TreeItem rootItem = this.outlinePageTreeViewer.getTree().getItems()[0];
        this.outlinePageTreeViewer.getTree().setSelection(new TreeItem[]{rootItem});
    }

    public void updateTreeModel(OutlinePageTreeModel newTreeModel) {
        IRootTreeNode newRoot;
        OutlinePageTreeModel oldTreeModel = this.getTreeModel();
        if (oldTreeModel == null) {
            this.setTreeModel(newTreeModel);
            return;
        }
        IRootTreeNode oldRoot = (IRootTreeNode)oldTreeModel.getRoot();
        if (!oldRoot.intelligentEquals(newRoot = (IRootTreeNode)newTreeModel.getRoot())) {
            oldRoot.cloneNodeWeakly(newRoot);
            oldTreeModel.nodeChanged(oldRoot);
        }
        OutlinePage.mergeTreeNodes(oldTreeModel, oldRoot, newTreeModel, newRoot);
    }

    private static void mergeTreeNodes(OutlinePageTreeModel oldModel, ITreeNode oldNode, OutlinePageTreeModel newModel, ITreeNode newNode) {
        ITreeNode[] oldNodeChilds = OutlinePage.getChilds(oldNode);
        ITreeNode[] newNodeChilds = OutlinePage.getChilds(newNode);
        int oldNodeCount = 0;
        int newNodeCount = 0;
        int delta = 0;
        ITreeNode currentOldNode = oldNodeChilds[oldNodeCount];
        ITreeNode currentNewNode = newNodeChilds[newNodeCount];
        while (!nullNode.intelligentEquals(currentOldNode) || !nullNode.intelligentEquals(currentNewNode)) {
            if (currentOldNode.intelligentEquals(currentNewNode)) {
                OutlinePage.mergeTreeNodes(oldModel, currentOldNode, newModel, currentNewNode);
                ++oldNodeCount;
                ++newNodeCount;
            } else {
                int index = OutlinePage.isContainedIn(currentOldNode, newNodeChilds, newNodeCount + 1);
                if (index > 0) {
                    int i = newNodeCount;
                    while (i < index) {
                        ITreeNode copyNode = OutlinePage.recursivelyCloneNode(newNodeChilds[i]);
                        oldModel.insertNodeInto(copyNode, oldNode, oldNodeCount + delta);
                        ++delta;
                        ++newNodeCount;
                        ++i;
                    }
                } else {
                    index = OutlinePage.isContainedIn(currentNewNode, oldNodeChilds, oldNodeCount + 1);
                    if (index > 0) {
                        int i = oldNodeCount;
                        while (i < index) {
                            oldModel.removeNodeFromParent(oldNodeChilds[i]);
                            --delta;
                            ++oldNodeCount;
                            ++i;
                        }
                    } else {
                        if (!nullNode.intelligentEquals(currentNewNode)) {
                            ITreeNode copyNode = OutlinePage.recursivelyCloneNode(currentNewNode);
                            oldModel.insertNodeInto(copyNode, oldNode, oldNodeCount + delta);
                            ++delta;
                            ++newNodeCount;
                        }
                        if (!nullNode.intelligentEquals(currentOldNode)) {
                            oldModel.removeNodeFromParent(currentOldNode);
                            --delta;
                            ++oldNodeCount;
                        }
                    }
                }
            }
            currentOldNode = oldNodeChilds[oldNodeCount];
            currentNewNode = newNodeChilds[newNodeCount];
        }
    }

    private static ITreeNode recursivelyCloneNode(ITreeNode cloneTemplate) {
        ITreeNode cloneParent = cloneTemplate.cloneNode();
        Enumeration<? extends javax.swing.tree.TreeNode> childNodeEnum = cloneTemplate.children();
        while (childNodeEnum.hasMoreElements()) {
            ITreeNode childNode = (ITreeNode)childNodeEnum.nextElement();
            ITreeNode childNodeClone = OutlinePage.recursivelyCloneNode(childNode);
            cloneParent.insert(childNodeClone, cloneParent.getChildCount());
        }
        return cloneParent;
    }

    private static ITreeNode[] getChilds(ITreeNode parent) {
        int childCount = parent.getChildCount();
        ITreeNode[] childNodes = new ITreeNode[childCount + 1];
        Enumeration<? extends javax.swing.tree.TreeNode> childEnum = parent.children();
        int enumCount = 0;
        while (childEnum.hasMoreElements()) {
            ITreeNode child = (ITreeNode)childEnum.nextElement();
            childNodes[enumCount++] = child;
        }
        childNodes[enumCount] = nullNode;
        return childNodes;
    }

    private static int isContainedIn(ITreeNode node, ITreeNode[] nodeArray, int fromIndex) {
        int i = fromIndex;
        while (i < nodeArray.length) {
            if (node.intelligentEquals(nodeArray[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class OutlinePageTreeLabelProvider
    extends SapTreeLabelProvider {
        private OutlinePageTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            Image retImage = null;
            if (element instanceof ITreeNode) {
                ITreeNode treeNode = (ITreeNode)element;
                retImage = treeNode.getNodeImage();
            }
            return retImage;
        }

        public String getText(Object element) {
            String retText = "???";
            if (element instanceof ITreeNode) {
                ITreeNode treeNode = (ITreeNode)element;
                retText = treeNode.getNodeText();
            }
            retText = retText.trim();
            return retText;
        }
    }

    private static class XmlNullNode
    extends TreeNode {
        private XmlNullNode() {
        }

        public String getPrefix() {
            return "NULL";
        }

        public String getSubId() {
            return "";
        }

        public boolean intelligentEquals(ITreeNode otherNode) {
            return otherNode instanceof XmlNullNode;
        }
    }
}

