/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.source;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.tag.ITagEditor;
import com.tssap.editors.tag.source.TagAutoIndentStrategy;
import com.tssap.editors.tag.source.TagPresentationReconciler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class TagSourceViewerConfiguration
extends SourceViewerConfiguration {
    private IPreferenceStore preferenceStore;
    private ITagEditor editor;

    public TagSourceViewerConfiguration(ITagEditor editor) {
        this(null, editor);
    }

    public TagSourceViewerConfiguration(IPreferenceStore prefs, ITagEditor editor) {
        if (prefs == null) {
            prefs = EditorPlugin.getInstance().getPreferenceStore();
        }
        this.preferenceStore = prefs;
        this.editor = editor;
    }

    public IPreferenceStore getPreferences() {
        return this.preferenceStore;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__tag_definition", "__tag_comment", "__xml_tag"};
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer sourceViewer, String contentType) {
        return new TagAutoIndentStrategy();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return new TagPresentationReconciler(this, sourceViewer);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        IPreferenceStore preferenceStore = EditorPlugin.getInstance().getPreferenceStore();
        return preferenceStore.getInt("tag_format_tabsize");
    }

    public ITagEditor getEditor() {
        return this.editor;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }
}

