/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.source;

import com.tssap.editors.tag.source.TagSourceViewerConfiguration;
import com.tssap.editors.util.TextToken;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TagPresentationReconciler
extends PresentationReconciler {
    private TagSourceViewerConfiguration sourceConfig;
    private IPreferenceStore preferences;
    private ISourceViewer sourceViewer;
    private RuleBasedScanner defaultScanner;
    private RuleBasedScanner definitionScanner;
    private RuleBasedScanner tagScanner;
    private RuleBasedScanner commentScanner;

    public TagPresentationReconciler(TagSourceViewerConfiguration config, ISourceViewer sourceViewer) {
        this.sourceConfig = config;
        this.sourceViewer = sourceViewer;
        this.preferences = config.getPreferences();
        String[] contentTypes = this.sourceConfig.getConfiguredContentTypes(null);
        int t = 0;
        while (t < contentTypes.length) {
            RuleBasedScanner scanner = this.getScannerForContentType(contentTypes[t]);
            DefaultDamagerRepairer damRep = new DefaultDamagerRepairer((ITokenScanner)scanner);
            this.setDamager((IPresentationDamager)damRep, contentTypes[t]);
            this.setRepairer((IPresentationRepairer)damRep, contentTypes[t]);
            ++t;
        }
    }

    protected RuleBasedScanner getScannerForContentType(String contentType) {
        if (contentType.equals("__tag_definition")) {
            return this.getXMLDefinitionScanner();
        }
        if (contentType.equals("__xml_tag")) {
            return this.getXMLTagScanner();
        }
        if (contentType.equals("__tag_comment")) {
            return this.getXMLCommentScanner();
        }
        return this.getXMLDefaultScanner();
    }

    private RuleBasedScanner getXMLDefaultScanner() {
        if (this.defaultScanner == null) {
            this.defaultScanner = new RuleBasedScanner();
            TextToken xml = new TextToken("color_default", this.preferences, this.sourceViewer);
            TextToken processing = new TextToken("color_processing", this.preferences, this.sourceViewer);
            TextToken entity = new TextToken("color_entity", this.preferences, this.sourceViewer);
            this.defaultScanner.setDefaultReturnToken((IToken)xml);
            IRule[] rules = new IRule[]{new MultiLineRule("<?", "?>", (IToken)processing), new SingleLineRule("&", ";", (IToken)entity), new SingleLineRule("%", ";", (IToken)entity)};
            this.defaultScanner.setRules(rules);
        }
        return this.defaultScanner;
    }

    private RuleBasedScanner getXMLDefinitionScanner() {
        if (this.definitionScanner == null) {
            this.definitionScanner = new RuleBasedScanner();
            TextToken definition = new TextToken("color_definition", this.preferences, this.sourceViewer);
            TextToken string = new TextToken("color_string", this.preferences, this.sourceViewer);
            TextToken tag = new TextToken("color_tag", this.preferences, this.sourceViewer);
            this.definitionScanner.setDefaultReturnToken((IToken)definition);
            WordRule rule = new WordRule((IWordDetector)new InnerWordDetector(), (IToken)tag);
            rule.addWord("DOCTYPE", (IToken)definition);
            rule.addWord("SYSTEM", (IToken)definition);
            rule.addWord("PUBLIC", (IToken)definition);
            rule.addWord("ENTITY", (IToken)definition);
            rule.addWord("ELEMENT", (IToken)definition);
            rule.addWord("ATTLIST", (IToken)definition);
            rule.addWord("EMPTY", (IToken)definition);
            rule.addWord("ID", (IToken)definition);
            rule.addWord("IDREF", (IToken)definition);
            rule.addWord("IDREFS", (IToken)definition);
            rule.addWord("CDATA", (IToken)definition);
            rule.addWord("PCDATA", (IToken)definition);
            rule.addWord("REQUIRED", (IToken)definition);
            rule.addWord("IMPLIED", (IToken)definition);
            IRule[] rules = new IRule[]{rule, new SingleLineRule("\"", "\"", (IToken)string, '\\'), new SingleLineRule("'", "'", (IToken)string, '\\')};
            this.definitionScanner.setRules(rules);
        }
        return this.definitionScanner;
    }

    private RuleBasedScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new RuleBasedScanner();
            TextToken tag = new TextToken("color_tag", this.preferences, this.sourceViewer);
            TextToken string = new TextToken("color_string", this.preferences, this.sourceViewer);
            this.tagScanner.setDefaultReturnToken((IToken)tag);
            IRule[] rules = new IRule[]{new SingleLineRule("\"", "\"", (IToken)string, '\\'), new SingleLineRule("'", "'", (IToken)string, '\\')};
            this.tagScanner.setRules(rules);
        }
        return this.tagScanner;
    }

    private RuleBasedScanner getXMLCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new RuleBasedScanner();
            TextToken comment = new TextToken("color_comment", this.preferences, this.sourceViewer);
            TextToken string = new TextToken("color_string", this.preferences, this.sourceViewer);
            this.commentScanner.setDefaultReturnToken((IToken)comment);
            IRule[] rules = new IRule[]{new SingleLineRule("\"", "\"", (IToken)string, '\\'), new SingleLineRule("'", "'", (IToken)string, '\\')};
            this.commentScanner.setRules(rules);
        }
        return this.commentScanner;
    }

    protected IPreferenceStore getPreferences() {
        return this.preferences;
    }

    protected TagSourceViewerConfiguration getSourceConfig() {
        return this.sourceConfig;
    }

    protected ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    private class InnerWordDetector
    implements IWordDetector {
        private InnerWordDetector() {
        }

        public boolean isWordPart(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }

        public boolean isWordStart(char ch) {
            return Character.isJavaIdentifierStart(ch);
        }
    }

    public class PropertyChange
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            String string = event.getProperty();
        }
    }
}

