/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.mpe.internal;

import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import java.net.URL;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PreviewPage {
    private OleAutomation oleAutomation;
    private OleControlSite oleControlSite;
    private Composite parentComposite;
    private URL pageUrl;

    public PreviewPage(Composite pageParent, URL pageUrl) {
        this.parentComposite = pageParent;
        this.pageUrl = pageUrl;
    }

    public void dispose() {
        if (this.getOleAutomation() != null) {
            this.getOleAutomation().dispose();
        }
        this.setOleAutomation(null);
    }

    public Control getControl() {
        ISimplePane newPane = PaneFactory.createSimplePane((Composite)this.getParentComposite());
        OleFrame webFrame = new OleFrame(newPane.getComposite(), 2048);
        OleControlSite webControlSite = new OleControlSite((Composite)webFrame, 0, "Shell.Explorer");
        this.setOleControlSite(webControlSite);
        OleAutomation webAutomation = new OleAutomation((OleClientSite)webControlSite);
        this.setOleAutomation(webAutomation);
        this.navigate(this.getPageUrl());
        return newPane.getComposite();
    }

    public void navigate(URL url) {
        this.setPageUrl(url);
        int[] rgdispid = this.getOleAutomation().getIDsOfNames(new String[]{"Navigate", "URL"});
        int dispIdMember = rgdispid[0];
        Variant[] rgvarg = new Variant[]{new Variant(url.toString())};
        int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
        this.getOleAutomation().invoke(dispIdMember, rgvarg, rgdispidNamedArgs);
        this.getOleControlSite().doVerb(-4);
    }

    public void refresh() {
        int[] rgdispid = this.getOleAutomation().getIDsOfNames(new String[]{"Refresh"});
        int dispIdMember = rgdispid[0];
        this.oleAutomation.invokeNoReply(dispIdMember);
    }

    private OleAutomation getOleAutomation() {
        return this.oleAutomation;
    }

    private URL getPageUrl() {
        return this.pageUrl;
    }

    private Composite getParentComposite() {
        return this.parentComposite;
    }

    private void setOleAutomation(OleAutomation oleAutomation) {
        this.oleAutomation = oleAutomation;
    }

    private void setPageUrl(URL pageUrl) {
        this.pageUrl = pageUrl;
    }

    private void setParentComposite(Composite parentComposite) {
        this.parentComposite = parentComposite;
    }

    private OleControlSite getOleControlSite() {
        return this.oleControlSite;
    }

    private void setOleControlSite(OleControlSite oleControlSite) {
        this.oleControlSite = oleControlSite;
    }
}

